/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.DefaultMethodFactory;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FunctionInvoker;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::VariadicInvoker"}, parent="Object")
public class VariadicInvoker
extends RubyObject {
    private final CallingConvention convention;
    private final Pointer address;
    private final FunctionInvoker functionInvoker;
    private final com.kenai.jffi.Type returnType;
    private final IRubyObject enums;
    private final boolean saveError;
    private static final Locale LOCALE = Locale.ENGLISH;

    public static RubyClass createVariadicInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("VariadicInvoker", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(VariadicInvoker.class);
        result2.defineAnnotatedConstants(VariadicInvoker.class);
        return result2;
    }

    private VariadicInvoker(Ruby runtime2, IRubyObject klazz, Pointer address2, FunctionInvoker functionInvoker, com.kenai.jffi.Type returnType, CallingConvention convention, IRubyObject enums, boolean saveError) {
        super(runtime2, (RubyClass)klazz);
        this.address = address2;
        this.functionInvoker = functionInvoker;
        this.returnType = returnType;
        this.convention = convention;
        this.enums = enums;
        this.saveError = saveError;
    }

    public final Arity getArity() {
        return Arity.OPTIONAL;
    }

    @JRubyMethod(name={"new"}, meta=true, required=4)
    public static VariadicInvoker newInstance(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        IRubyObject rbSaveErrno;
        IRubyObject rbFunction = args2[0];
        IRubyObject rbParameterTypes = args2[1];
        IRubyObject rbReturnType = args2[2];
        RubyHash options2 = (RubyHash)args2[3];
        String convention = "default";
        IRubyObject enums = null;
        boolean saveError = true;
        IRubyObject typeMap = null;
        IRubyObject rbConvention = options2.fastARef(context.runtime.newSymbol("convention"));
        if (rbConvention != null && !rbConvention.isNil()) {
            convention = rbConvention.asJavaString();
        }
        if ((rbSaveErrno = options2.fastARef(context.runtime.newSymbol("save_errno"))) != null && !rbSaveErrno.isNil()) {
            saveError = rbSaveErrno.isTrue();
        }
        if (!((enums = options2.fastARef(context.runtime.newSymbol("enums"))) == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
            throw context.runtime.newTypeError("wrong type for options[:enum] " + enums.getMetaClass().getName() + " (expected Hash or Enums)");
        }
        typeMap = options2.fastARef(context.runtime.newSymbol("type_map"));
        if (typeMap != null && !typeMap.isNil() && !(typeMap instanceof RubyHash)) {
            throw context.runtime.newTypeError("wrong type for options[:type_map] " + typeMap.getMetaClass().getName() + " (expected Hash)");
        }
        Type returnType = Util.findType(context, rbReturnType, typeMap);
        if (!(rbParameterTypes instanceof RubyArray)) {
            throw context.runtime.newTypeError("Invalid parameter array " + rbParameterTypes.getMetaClass().getName() + " (expected Array)");
        }
        if (!(rbFunction instanceof Pointer)) {
            throw context.runtime.newTypeError(rbFunction, context.runtime.getFFI().pointerClass);
        }
        Pointer address2 = (Pointer)rbFunction;
        CallingConvention callConvention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        RubyArray paramTypes = (RubyArray)rbParameterTypes;
        RubyArray fixed = RubyArray.newArray(context.runtime);
        for (int i2 = 0; i2 < paramTypes.getLength(); ++i2) {
            Type type2 = (Type)paramTypes.entry(i2);
            if (type2.getNativeType() == NativeType.VARARGS) continue;
            fixed.append(type2);
        }
        FunctionInvoker functionInvoker = DefaultMethodFactory.getFunctionInvoker(returnType);
        VariadicInvoker varInvoker = new VariadicInvoker(context.runtime, klass, address2, functionInvoker, FFIUtil.getFFIType(returnType), callConvention, enums, saveError);
        varInvoker.setInstanceVariable("@fixed", fixed);
        varInvoker.setInstanceVariable("@type_map", typeMap);
        return varInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"invoke"})
    public IRubyObject invoke(ThreadContext context, IRubyObject typesArg, IRubyObject paramsArg) {
        IRubyObject[] types = ((RubyArray)typesArg).toJavaArrayMaybeUnsafe();
        IRubyObject[] params2 = ((RubyArray)paramsArg).toJavaArrayMaybeUnsafe();
        com.kenai.jffi.Type[] ffiParamTypes = new com.kenai.jffi.Type[types.length];
        ParameterMarshaller[] marshallers = new ParameterMarshaller[types.length];
        RubyClass builtinClass = Type.getTypeClass(context.getRuntime()).getClass("Builtin");
        block8: for (int i2 = 0; i2 < types.length; ++i2) {
            Type type2 = (Type)types[i2];
            switch (NativeType.valueOf(type2)) {
                case CHAR: 
                case SHORT: 
                case INT: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.SINT32;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller((Type)builtinClass.getConstant(NativeType.INT.name().toUpperCase(LOCALE)), this.convention, this.enums);
                    continue block8;
                }
                case UCHAR: 
                case USHORT: 
                case UINT: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.UINT32;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller((Type)builtinClass.getConstant(NativeType.UINT.name().toUpperCase(LOCALE)), this.convention, this.enums);
                    continue block8;
                }
                case FLOAT: 
                case DOUBLE: {
                    ffiParamTypes[i2] = com.kenai.jffi.Type.DOUBLE;
                    marshallers[i2] = DefaultMethodFactory.getMarshaller((Type)builtinClass.getConstant(NativeType.DOUBLE.name().toUpperCase(LOCALE)), this.convention, this.enums);
                    continue block8;
                }
                default: {
                    ffiParamTypes[i2] = FFIUtil.getFFIType(type2);
                    marshallers[i2] = DefaultMethodFactory.getMarshaller((Type)types[i2], this.convention, this.enums);
                }
            }
        }
        Invocation invocation = new Invocation(context);
        Function function = new Function(this.address.getAddress(), this.returnType, ffiParamTypes, this.convention, this.saveError);
        try {
            HeapInvocationBuffer args2 = new HeapInvocationBuffer(function);
            for (int i3 = 0; i3 < marshallers.length; ++i3) {
                marshallers[i3].marshal(invocation, (InvocationBuffer)args2, params2[i3]);
            }
            IRubyObject iRubyObject = this.functionInvoker.invoke(context, function, args2);
            return iRubyObject;
        }
        finally {
            invocation.finish();
        }
    }
}

