/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.jruby.ExtensionRegistry;
import org.msgpack.jruby.Packer;
import org.msgpack.jruby.Unpacker;

@JRubyClass(name={"MessagePack::Factory"})
public class Factory
extends RubyObject {
    private static final long serialVersionUID = 8441284623445322492L;
    private final Ruby runtime;
    private final ExtensionRegistry extensionRegistry;
    private boolean hasSymbolExtType;

    public Factory(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.extensionRegistry = new ExtensionRegistry();
        this.hasSymbolExtType = false;
    }

    public ExtensionRegistry extensionRegistry() {
        return this.extensionRegistry.dup();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"packer"}, optional=1)
    public Packer packer(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Packer.newPacker(threadContext, this.extensionRegistry(), this.hasSymbolExtType, iRubyObjectArray);
    }

    @JRubyMethod(name={"unpacker"}, optional=2)
    public Unpacker unpacker(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Unpacker.newUnpacker(threadContext, this.extensionRegistry(), iRubyObjectArray);
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return RubyArray.newArray((Ruby)threadContext.runtime, (IRubyObject[])new IRubyObject[]{this.extensionRegistry.toInternalPackerRegistry(threadContext), this.extensionRegistry.toInternalUnpackerRegistry(threadContext)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"register_type"}, required=2, optional=1)
    public IRubyObject registerType(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubySymbol rubySymbol;
        RubySymbol rubySymbol2;
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        if (this.isFrozen()) {
            throw ruby.newRuntimeError("can't modify frozen Factory");
        }
        if (iRubyObjectArray.length == 2) {
            rubySymbol2 = ruby.newSymbol("to_msgpack_ext");
            rubySymbol = ruby.newSymbol("from_msgpack_ext");
        } else {
            if (iRubyObjectArray.length != 3) throw ruby.newArgumentError(String.format("wrong number of arguments (%d for 2..3)", 2 + iRubyObjectArray.length));
            if (!(iRubyObjectArray[iRubyObjectArray.length - 1] instanceof RubyHash)) throw ruby.newArgumentError(String.format("expected Hash but found %s.", iRubyObjectArray[iRubyObjectArray.length - 1].getType().getName()));
            RubyHash rubyHash = (RubyHash)iRubyObjectArray[iRubyObjectArray.length - 1];
            rubySymbol2 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("packer"));
            rubySymbol = rubyHash.fastARef((IRubyObject)ruby.newSymbol("unpacker"));
            IRubyObject iRubyObject3 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("optimized_symbols_parsing"));
            if (iRubyObject3 != null && iRubyObject3.isTrue()) {
                throw ruby.newArgumentError("JRuby implementation does not support the optimized_symbols_parsing option");
            }
        }
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        if (!(iRubyObject2 instanceof RubyModule)) {
            throw ruby.newArgumentError(String.format("expected Module/Class but found %s.", iRubyObject2.getType().getName()));
        }
        RubyModule rubyModule = (RubyModule)iRubyObject2;
        IRubyObject iRubyObject4 = ruby.getNil();
        IRubyObject iRubyObject5 = ruby.getNil();
        if (rubySymbol2 != null) {
            iRubyObject4 = rubySymbol2.callMethod(threadContext, "to_proc");
        }
        if (rubySymbol != null) {
            iRubyObject5 = rubySymbol instanceof RubyString || rubySymbol instanceof RubySymbol ? rubyModule.method(rubySymbol.callMethod(threadContext, "to_sym")) : rubySymbol.callMethod(threadContext, "method", (IRubyObject)ruby.newSymbol("call"));
        }
        this.extensionRegistry.put(rubyModule, (int)l, iRubyObject4, (IRubyObject)rubySymbol2, iRubyObject5, (IRubyObject)rubySymbol);
        if (rubyModule != ruby.getSymbol()) return ruby.getNil();
        this.hasSymbolExtType = true;
        return ruby.getNil();
    }

    static class FactoryAllocator
    implements ObjectAllocator {
        FactoryAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Factory(ruby, rubyClass);
        }
    }
}

