/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.util.Arrays;

class BcSSL3HMAC
implements TlsHMAC {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = BcSSL3HMAC.genPad((byte)54, 48);
    private static final byte[] OPAD = BcSSL3HMAC.genPad((byte)92, 48);
    private Digest digest;
    private int padLength;
    private byte[] secret;

    BcSSL3HMAC(Digest digest) {
        this.digest = digest;
        this.padLength = digest.getDigestSize() == 20 ? 40 : 48;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.secret = TlsUtils.copyOfRangeExact(byArray, n, n + n2);
        this.reset();
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] calculateMAC() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.doFinal(byArray, 0);
        return byArray;
    }

    public void calculateMAC(byte[] byArray, int n) {
        this.doFinal(byArray, n);
    }

    public int getInternalBlockSize() {
        return ((ExtendedDigest)this.digest).getByteLength();
    }

    public int getMacLength() {
        return this.digest.getDigestSize();
    }

    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(IPAD, 0, this.padLength);
    }

    private void doFinal(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(OPAD, 0, this.padLength);
        this.digest.update(byArray2, 0, byArray2.length);
        this.digest.doFinal(byArray, n);
        this.reset();
    }

    private static byte[] genPad(byte by, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill((byte[])byArray, (byte)by);
        return byArray;
    }
}

