/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.security.authorizer.AuthorizerWrapper$;
import kafka.utils.Logging;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]s!B\"E\u0011\u0003Ye!B'E\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006bB,\u0002\u0005\u0004%\t\u0001\u0017\u0005\u0007I\u0006\u0001\u000b\u0011B-\t\u000f\u0015\f!\u0019!C\u00011\"1a-\u0001Q\u0001\neCqaZ\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004i\u0003\u0001\u0006I!\u0017\u0005\bS\u0006\u0011\r\u0011\"\u0001Y\u0011\u0019Q\u0017\u0001)A\u00053\"91.\u0001b\u0001\n\u0003a\u0007B\u0002;\u0002A\u0003%Q\u000eC\u0004v\u0003\t\u0007I\u0011\u00017\t\rY\f\u0001\u0015!\u0003n\r\u00119\u0018\u0001\u0011=\t\u0013}|!Q3A\u0005\u0002\u0005\u0005\u0001BCA\b\u001f\tE\t\u0015!\u0003\u0002\u0004!Q\u0011\u0011C\b\u0003\u0016\u0004%\t!a\u0005\t\u0015\u0005mqB!E!\u0002\u0013\t)\u0002\u0003\u0004V\u001f\u0011\u0005\u0011Q\u0004\u0005\b\u0003OyA\u0011AA\u0015\u0011%\t\tdDA\u0001\n\u0003\t\u0019\u0004C\u0005\u0002:=\t\n\u0011\"\u0001\u0002<!I\u0011\u0011K\b\u0012\u0002\u0013\u0005\u00111\u000b\u0005\t\u0003/z\u0011\u0011!C!Y\"I\u0011\u0011L\b\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u00037z\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001b\u0010\u0003\u0003%\t%a\u001b\t\u0013\u0005et\"!A\u0005\u0002\u0005m\u0004\"CA@\u001f\u0005\u0005I\u0011IAA\u0011%\t\u0019iDA\u0001\n\u0003\n)\tC\u0005\u0002\b>\t\t\u0011\"\u0011\u0002\n\u001eI\u0011QR\u0001\u0002\u0002#\u0005\u0011q\u0012\u0004\to\u0006\t\t\u0011#\u0001\u0002\u0012\"1QK\tC\u0001\u0003?C\u0011\"a!#\u0003\u0003%)%!\"\t\u0013\u0005\u0005&%!A\u0005\u0002\u0006\r\u0006\"CAUE\u0005\u0005I\u0011QAV\u0011%\tiLIA\u0001\n\u0013\ty\fC\u0005\u0002H\u0006\u0011\r\u0011\"\u0001\u0002J\"A\u00111Z\u0001!\u0002\u0013\tyBB\u0004\u0002N\u0006\u0001A)a4\t\rUSC\u0011AAo\u0011\u001d\t\tO\u000bC!\u0003G4Q!\u0014#\u0001\u0005SAa!V\u0017\u0005\u0002\tu\u0002\"\u0003B![\t\u0007I\u0011\u0002B\"\u0011!\u0011)&\fQ\u0001\n\t\u0015\u0003B\u0003B,[\u0001\u0007I\u0011\u0003#\u0002\u0014!Q!\u0011L\u0017A\u0002\u0013EAIa\u0017\t\u0011\t}S\u0006)Q\u0005\u0003+AqA!\u0019.\t\u0003\u0012\u0019\u0007C\u0004\u0003\b6\"\tE!#\t\u000f\teV\u0006\"\u0001\u0003<\"9!\u0011\\\u0017\u0005B\tm\u0007b\u0002Bq[\u0011\u0005#1\u001d\u0005\b\u0005ClC\u0011\tBv\u0011\u001d\u0011y/\fC!\u0005cDqAa<.\t\u0003\u0012)\u0010C\u0004\u0003~6\"\tAa@\t\u000f\t=X\u0006\"\u0011\u0004\u0010!91\u0011C\u0017\u0005\u0002\rM\u0001bBB\u000b[\u0011%1q\u0003\u0005\b\u0007WiC\u0011BB\u0017\u0011\u0019yX\u0006\"\u0003\u0004<!91\u0011I\u0017\u0005\n\r\r\u0013aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014(BA#G\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u001dC\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003%\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002M\u00035\tAIA\nTS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'o\u0005\u0002\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A&\u0002\u0013i[WK\u001d7Qe>\u0004X#A-\u0011\u0005i\u000bgBA.`!\ta\u0016+D\u0001^\u0015\tq&*\u0001\u0004=e>|GOP\u0005\u0003AF\u000ba\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001-U\u0001\u000b5.,&\u000f\u001c)s_B\u0004\u0013a\u0006.l\u0007>tg.Z2uS>tG+[7f\u001fV$\bK]8q\u0003aQ6nQ8o]\u0016\u001cG/[8o)&lWmT;u!J|\u0007\u000fI\u0001\u00155.\u001cVm]:j_:$\u0016.\\3PkR\u0004&o\u001c9\u0002+i[7+Z:tS>tG+[7f\u001fV$\bK]8qA\u0005)\"l['bq&sg\t\\5hQR\u0014V-];fgR\u001c\u0018A\u0006.l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u001dM+\b/\u001a:Vg\u0016\u00148\u000f\u0015:paV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006!A.\u00198h\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!AY8\u0002\u001fM+\b/\u001a:Vg\u0016\u00148\u000f\u0015:pa\u0002\nq$\u00117m_^,e/\u001a:z_:,\u0017J\u001a(p\u0003\u000ed\u0017j\u001d$pk:$\u0007K]8q\u0003\u0001\nE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oIB\u0013x\u000e\u001d\u0011\u0003\u001bY+'o]5p]\u0016$\u0017i\u00197t'\u0011yq*\u001f?\u0011\u0005AS\u0018BA>R\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001U?\n\u0005y\f&\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B1dYN,\"!a\u0001\u0011\u000bi\u000b)!!\u0003\n\u0007\u0005\u001d1MA\u0002TKR\u00042\u0001TA\u0006\u0013\r\ti\u0001\u0012\u0002\u0004\u0003\u000ed\u0017!B1dYN\u0004\u0013!\u0003>l-\u0016\u00148/[8o+\t\t)\u0002E\u0002Q\u0003/I1!!\u0007R\u0005\rIe\u000e^\u0001\u000bu.4VM]:j_:\u0004CCBA\u0010\u0003G\t)\u0003E\u0002\u0002\"=i\u0011!\u0001\u0005\u0007\u007fR\u0001\r!a\u0001\t\u000f\u0005EA\u00031\u0001\u0002\u0016\u00051Q\r_5tiN,\"!a\u000b\u0011\u0007A\u000bi#C\u0002\u00020E\u0013qAQ8pY\u0016\fg.\u0001\u0003d_BLHCBA\u0010\u0003k\t9\u0004\u0003\u0005\u0000-A\u0005\t\u0019AA\u0002\u0011%\t\tB\u0006I\u0001\u0002\u0004\t)\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u\"\u0006BA\u0002\u0003\u007fY#!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017\n\u0016AC1o]>$\u0018\r^5p]&!\u0011qJA#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)F\u000b\u0003\u0002\u0016\u0005}\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0013Q\r\t\u0004!\u0006\u0005\u0014bAA2#\n\u0019\u0011I\\=\t\u0013\u0005\u001d4$!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nA1\u0011qNA;\u0003?j!!!\u001d\u000b\u0007\u0005M\u0014+\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002r\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY#! \t\u0013\u0005\u001dT$!AA\u0002\u0005}\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00035\fa!Z9vC2\u001cH\u0003BA\u0016\u0003\u0017C\u0011\"a\u001a!\u0003\u0003\u0005\r!a\u0018\u0002\u001bY+'o]5p]\u0016$\u0017i\u00197t!\r\t\tCI\n\u0005E\u0005ME\u0010\u0005\u0006\u0002\u0016\u0006m\u00151AA\u000b\u0003?i!!a&\u000b\u0007\u0005e\u0015+A\u0004sk:$\u0018.\\3\n\t\u0005u\u0015q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAH\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ty\"!*\u0002(\"1q0\na\u0001\u0003\u0007Aq!!\u0005&\u0001\u0004\t)\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0016\u0011\u0018\t\u0006!\u0006=\u00161W\u0005\u0004\u0003c\u000b&AB(qi&|g\u000eE\u0004Q\u0003k\u000b\u0019!!\u0006\n\u0007\u0005]\u0016K\u0001\u0004UkBdWM\r\u0005\n\u0003w3\u0013\u0011!a\u0001\u0003?\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0007c\u00018\u0002D&\u0019\u0011QY8\u0003\r=\u0013'.Z2u\u0003\u0019qu.Q2mgV\u0011\u0011qD\u0001\b\u001d>\f5\r\\:!\u00059\u0011\u0015m]3BkRDwN]5{KJ\u001c2AKAi!\u0011\t\u0019.!7\u000e\u0005\u0005U'bAAl\r\u0006Q\u0011-\u001e;i_JL'0\u001a:\n\t\u0005m\u0017Q\u001b\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\u0005}\u0007cAA\u0011U\u0005yAn\\4Bk\u0012LG/T3tg\u0006<W\r\u0006\u0005\u0002f\u0006-(q\u0001B\t!\r\u0001\u0016q]\u0005\u0004\u0003S\f&\u0001B+oSRDq!!<-\u0001\u0004\ty/\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u0005E(1A\u0007\u0003\u0003gTA!a6\u0002v*!\u0011q_A}\u0003\u0019\u0019XM\u001d<fe*\u0019\u0011*a?\u000b\t\u0005u\u0018q`\u0001\u0007CB\f7\r[3\u000b\u0005\t\u0005\u0011aA8sO&!!QAAz\u0005i\tU\u000f\u001e5pe&T\u0018M\u00197f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\u0011I\u0001\fa\u0001\u0005\u0017\ta!Y2uS>t\u0007\u0003BAy\u0005\u001bIAAa\u0004\u0002t\n1\u0011i\u0019;j_:DqAa\u0005-\u0001\u0004\tY#\u0001\u0006bkRDwN]5{K\u0012Ds!\u0001B\f\u0005;\u0011\t\u0003E\u0002Q\u00053I1Aa\u0007R\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0005?\t1&V:fA-\fgm[1/g\u0016\u001cWO]5us:\nW\u000f\u001e5pe&TXM\u001d\u0018BG2\fU\u000f\u001e5pe&TXM]\u0011\u0003\u0005G\t\u0011bU5oG\u0016\u0004#G\f\u001b)\u000f\u0005\u00119B!\b\u0003\"!:\u0001Aa\u0006\u0003\u001e\t\u00052cB\u0017\u0002B\n-\"\u0011\u0007\t\u0004\u0019\n5\u0012b\u0001B\u0018\t\nQ\u0011)\u001e;i_JL'0\u001a:\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQ1Aa\u000eI\u0003\u0015)H/\u001b7t\u0013\u0011\u0011YD!\u000e\u0003\u000f1{wmZ5oOR\u0011!q\b\t\u0003\u00196\nQ\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014XC\u0001B#!\r\u00119E\u000b\b\u0004\u0005\u0013\u0002a\u0002\u0002B&\u0005'rAA!\u0014\u0003R9\u0019ALa\u0014\n\u0003%K!a\u0012%\n\u0005\u00153\u0015AD1dY\u0006+H\u000f[8sSj,'\u000fI\u0001\u0011[\u0006DX\u000b\u001d3bi\u0016\u0014V\r\u001e:jKN\fA#\\1y+B$\u0017\r^3SKR\u0014\u0018.Z:`I\u0015\fH\u0003BAs\u0005;B\u0011\"a\u001a3\u0003\u0003\u0005\r!!\u0006\u0002#5\f\u00070\u00169eCR,'+\u001a;sS\u0016\u001c\b%A\u0005d_:4\u0017nZ;sKR!\u0011Q\u001dB3\u0011\u001d\u00119\u0007\u000ea\u0001\u0005S\n1B[1wC\u000e{gNZ5hgB\"!1\u000eB>!\u001d\u0011iGa\u001dZ\u0005oj!Aa\u001c\u000b\u0007\tE\u0014/\u0001\u0003vi&d\u0017\u0002\u0002B;\u0005_\u00121!T1q!\u0011\u0011IHa\u001f\r\u0001\u0011a!Q\u0010B3\u0003\u0003\u0005\tQ!\u0001\u0003\u0000\t\u0019q\fJ\u0019\u0012\t\t\u0005\u0015q\f\t\u0004!\n\r\u0015b\u0001BC#\n9aj\u001c;iS:<\u0017!C1vi\"|'/\u001b>f)!\tYCa#\u0003&\n=\u0006b\u0002BGk\u0001\u0007!qR\u0001\bg\u0016\u001c8/[8o!\u0011\u0011\tJa(\u000f\t\tM%\u0011\u0014\b\u0005\u0005\u001b\u0012)*C\u0002\u0003\u0018\"\u000bqA\\3uo>\u00148.\u0003\u0003\u0003\u001c\nu\u0015A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0004\u0005/C\u0015\u0002\u0002BQ\u0005G\u0013qaU3tg&|gN\u0003\u0003\u0003\u001c\nu\u0005b\u0002BTk\u0001\u0007!\u0011V\u0001\n_B,'/\u0019;j_:\u00042\u0001\u0014BV\u0013\r\u0011i\u000b\u0012\u0002\n\u001fB,'/\u0019;j_:DqA!-6\u0001\u0004\u0011\u0019,\u0001\u0005sKN|WO]2f!\ra%QW\u0005\u0004\u0005o#%\u0001\u0003*fg>,(oY3\u0002\u0017%\u001c8+\u001e9feV\u001bXM\u001d\u000b\u000b\u0003W\u0011iLa0\u0003B\nU\u0007b\u0002BTm\u0001\u0007!\u0011\u0016\u0005\b\u0005c3\u0004\u0019\u0001BZ\u0011\u001d\u0011\u0019M\u000ea\u0001\u0005\u000b\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\t\u001d'\u0011[\u0007\u0003\u0005\u0013T1!\u0012Bf\u0015\r9%Q\u001a\u0006\u0005\u0005\u001f\fI0\u0001\u0004d_6lwN\\\u0005\u0005\u0005'\u0014IM\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\r\t]g\u00071\u0001Z\u0003\u0011Awn\u001d;\u0002\u000f\u0005$G-Q2mgR1\u0011Q\u001dBo\u0005?Daa`\u001cA\u0002\u0005\r\u0001b\u0002BYo\u0001\u0007!1W\u0001\u000be\u0016lwN^3BG2\u001cHCBA\u0016\u0005K\u0014I\u000fC\u0004\u0003hb\u0002\r!a\u0001\u0002\u001f\u0005\u001cGn\u001d+pE\u0016\u0014V-\\8wK\u0012DqA!-9\u0001\u0004\u0011\u0019\f\u0006\u0003\u0002,\t5\bb\u0002BYs\u0001\u0007!1W\u0001\bO\u0016$\u0018i\u00197t)\u0011\t\u0019Aa=\t\u000f\tE&\b1\u0001\u00034R!!q\u001fB~!\u001dQ&\u0011 BZ\u0003\u0007I1A!\u001ed\u0011\u001d\u0011\u0019m\u000fa\u0001\u0005\u000b\fqbZ3u\u001b\u0006$8\r[5oO\u0006\u001bGn\u001d\u000b\u0007\u0003\u0007\u0019\taa\u0003\t\u000f\r\rA\b1\u0001\u0004\u0006\u0005a!/Z:pkJ\u001cW\rV=qKB\u0019Aja\u0002\n\u0007\r%AI\u0001\u0007SKN|WO]2f)f\u0004X\r\u0003\u0004\u0004\u000eq\u0002\r!W\u0001\re\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u000b\u0003\u0005o\fQa\u00197pg\u0016$\"!!:\u0002\u0015\r\u0014X-\u0019;f\u0003\u000ed7\u000f\u0006\u0003\u0002f\u000ee\u0001bBB\u000e\u007f\u0001\u00071QD\u0001\tE&tG-\u001b8hgB)!,!\u0002\u0004 A!1\u0011EB\u0014\u001b\t\u0019\u0019C\u0003\u0003\u0004&\t5\u0017aA1dY&!1\u0011FB\u0012\u0005)\t5\r\u001c\"j]\u0012LgnZ\u0001\u000bI\u0016dW\r^3BG2\u001cH\u0003BA\u0016\u0007_Aqa!\rA\u0001\u0004\u0019\u0019$A\u0004gS2$XM]:\u0011\u000bi\u000b)a!\u000e\u0011\t\r\u00052qG\u0005\u0005\u0007s\u0019\u0019C\u0001\tBG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feR!!q_B\u001f\u0011\u001d\u0019y$\u0011a\u0001\u0007k\taAZ5mi\u0016\u0014\u0018A\u0004;ie><X\t_2faRLwN\u001c\u000b\u0005\u0003K\u001c)\u0005C\u0004\u0004H\t\u0003\ra!\u0013\u0002\u0003\u0015\u0004Baa\u0013\u0004R5\u00111Q\n\u0006\u0005\u0007\u001f\u0012i-\u0001\u0004feJ|'o]\u0005\u0005\u0007'\u001aiE\u0001\u0007Ba&,\u0005pY3qi&|g\u000eK\u0004.\u0005/\u0011iB!\t")
public class SimpleAclAuthorizer
implements Authorizer,
Logging {
    private final BaseAuthorizer aclAuthorizer;
    private int maxUpdateRetries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static VersionedAcls NoAcls() {
        return SimpleAclAuthorizer$.MODULE$.NoAcls();
    }

    public static String AllowEveryoneIfNoAclIsFoundProp() {
        return SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp();
    }

    public static String SuperUsersProp() {
        return SimpleAclAuthorizer$.MODULE$.SuperUsersProp();
    }

    public static String ZkMaxInFlightRequests() {
        return SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests();
    }

    public static String ZkSessionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp();
    }

    public static String ZkConnectionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp();
    }

    public static String ZkUrlProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkUrlProp();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private BaseAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    public int maxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void maxUpdateRetries_$eq(int x$1) {
        this.maxUpdateRetries = x$1;
    }

    public void configure(Map<String, ?> javaConfigs) {
        this.aclAuthorizer().configure(javaConfigs);
    }

    @Override
    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        AuthorizableRequestContext requestContext = AuthorizerUtils$.MODULE$.sessionToRequestContext(session);
        Action action = new Action(operation.toJava(), resource.toPattern(), 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().authorize(requestContext, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    public boolean isSuperUser(Operation operation, Resource resource, KafkaPrincipal principal, String host) {
        return this.aclAuthorizer().isSuperUser(principal);
    }

    @Override
    public void addAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        if (acls != null && acls.nonEmpty()) {
            scala.collection.immutable.Set bindings = (scala.collection.immutable.Set)acls.map((Function1 & Serializable & scala.Serializable)acl -> AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, (Acl)acl), Set$.MODULE$.canBuildFrom());
            this.createAcls((scala.collection.immutable.Set<AclBinding>)bindings);
        }
    }

    @Override
    public boolean removeAcls(scala.collection.immutable.Set<Acl> aclsTobeRemoved, Resource resource) {
        scala.collection.immutable.Set filters = (scala.collection.immutable.Set)aclsTobeRemoved.map((Function1 & Serializable & scala.Serializable)acl -> new AclBindingFilter(resource.toPattern().toFilter(), AuthorizerWrapper$.MODULE$.convertToAccessControlEntry((Acl)acl).toFilter()), Set$.MODULE$.canBuildFrom());
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)filters);
    }

    @Override
    public boolean removeAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filter}))));
    }

    @Override
    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return (scala.collection.immutable.Set)this.acls(filter).getOrElse((Object)resource, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return this.acls(filter);
    }

    public scala.collection.immutable.Set<Acl> getMatchingAcls(ResourceType resourceType, String resourceName) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toJava(), resourceName, PatternType.MATCH), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)this.acls(filter).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.immutable.Set)x$1._2(), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        return this.acls(AclBindingFilter.ANY);
    }

    @Override
    public void close() {
        this.aclAuthorizer().close();
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> bindings) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        ((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().createAcls(null, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (AclCreateResult)x$2.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$createAcls$2(this, result);
            return BoxedUnit.UNIT;
        });
    }

    private boolean deleteAcls(scala.collection.immutable.Set<AclBindingFilter> filters) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls(null, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$deleteAcls$2(this, result);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)results.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$4.aclBindingDeleteResults()).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$deleteAcls$5(result);
            return BoxedUnit.UNIT;
        });
        return results.exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$deleteAcls$7(r)));
    }

    private scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> acls(AclBindingFilter filter) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(filter)).asScala()).foreach((Function1 & Serializable & scala.Serializable)binding -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$acls$1(result, binding)));
        return result.mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toSet()).toMap(Predef$.MODULE$.$conforms());
    }

    private void throwException(ApiException e) {
        if (e.getCause() != null) {
            throw e.getCause();
        }
        throw e;
    }

    public static final /* synthetic */ void $anonfun$createAcls$2(SimpleAclAuthorizer $this, AclCreateResult result) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception()));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ApiException apiException = (ApiException)((Object)foreach_this.get());
            $this.throwException(apiException);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$2(SimpleAclAuthorizer $this, AclDeleteResult result) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception()));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ApiException apiException = (ApiException)((Object)foreach_this.get());
            $this.throwException(apiException);
            return;
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$deleteAcls$6(ApiException e) {
        throw e;
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$5(AclDeleteResult.AclBindingDeleteResult result) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception()));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            throw SimpleAclAuthorizer.$anonfun$deleteAcls$6((ApiException)((Object)foreach_this.get()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$8(AclDeleteResult.AclBindingDeleteResult d) {
        return !d.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$7(AclDeleteResult r) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(r.aclBindingDeleteResults()).asScala()).exists((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$deleteAcls$8(d)));
    }

    public static final /* synthetic */ boolean $anonfun$acls$1(scala.collection.mutable.Map result$1, AclBinding binding) {
        Resource resource = AuthorizerWrapper$.MODULE$.convertToResource(binding.pattern());
        Acl acl = AuthorizerWrapper$.MODULE$.convertToAcl(binding.entry());
        return ((SetLike)result$1.getOrElseUpdate((Object)resource, (Function0 & Serializable & scala.Serializable)() -> (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$))).add((Object)acl);
    }

    public SimpleAclAuthorizer() {
        Logging.$init$(this);
        this.aclAuthorizer = new BaseAuthorizer();
        this.maxUpdateRetries = 10;
    }

    public static final /* synthetic */ Object $anonfun$createAcls$3$adapted(SimpleAclAuthorizer $this, ApiException e) {
        $this.throwException(e);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$deleteAcls$3$adapted(SimpleAclAuthorizer $this, ApiException e) {
        $this.throwException(e);
        return BoxedUnit.UNIT;
    }

    public static class BaseAuthorizer
    extends AclAuthorizer {
        @Override
        public void logAuditMessage(AuthorizableRequestContext requestContext, Action action, boolean authorized) {
            KafkaPrincipal principal = requestContext.principal();
            String host = requestContext.clientAddress().getHostAddress();
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            Resource resource = AuthorizerWrapper$.MODULE$.convertToResource(action.resourcePattern());
            if (authorized) {
                if (this.authorizerLogger().underlying().isDebugEnabled()) {
                    this.authorizerLogger().underlying().debug(BaseAuthorizer.logMessage$1(authorized, principal, operation, host, resource));
                    return;
                }
            } else if (this.authorizerLogger().underlying().isInfoEnabled()) {
                this.authorizerLogger().underlying().info(BaseAuthorizer.logMessage$1(authorized, principal, operation, host, resource));
            }
        }

        private static final String logMessage$1(boolean authorized$1, KafkaPrincipal principal$1, Operation operation$1, String host$1, Resource resource$1) {
            String authResult = authorized$1 ? "Allowed" : "Denied";
            return new StringBuilder(57).append("Principal = ").append(principal$1).append(" is ").append(authResult).append(" Operation = ").append(operation$1).append(" from host = ").append(host$1).append(" on resource = ").append(resource$1).toString();
        }
    }

    public static class VersionedAcls
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Set<Acl> acls;
        private final int zkVersion;

        public scala.collection.immutable.Set<Acl> acls() {
            return this.acls;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public boolean exists() {
            return this.zkVersion() != ZkVersion$.MODULE$.UnknownVersion();
        }

        public VersionedAcls copy(scala.collection.immutable.Set<Acl> acls, int zkVersion) {
            return new VersionedAcls(acls, zkVersion);
        }

        public scala.collection.immutable.Set<Acl> copy$default$1() {
            return this.acls();
        }

        public int copy$default$2() {
            return this.zkVersion();
        }

        public String productPrefix() {
            return "VersionedAcls";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.acls();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.zkVersion());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof VersionedAcls;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash(this.acls())), (int)this.zkVersion()), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof VersionedAcls)) return false;
            boolean bl = true;
            if (!bl) return false;
            VersionedAcls versionedAcls = (VersionedAcls)x$1;
            scala.collection.immutable.Set<Acl> set = this.acls();
            scala.collection.immutable.Set<Acl> set2 = versionedAcls.acls();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.zkVersion() != versionedAcls.zkVersion()) return false;
            if (!versionedAcls.canEqual(this)) return false;
            return true;
        }

        public VersionedAcls(scala.collection.immutable.Set<Acl> acls, int zkVersion) {
            this.acls = acls;
            this.zkVersion = zkVersion;
            Product.$init$((Product)this);
        }
    }
}

