/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.MissingConverterException;
import org.logstash.RubyUtil;
import org.logstash.Timestamp;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class Valuefier {
    public static final Converter IDENTITY = input -> input;
    private static final Converter FLOAT_CONVERTER = input -> RubyUtil.RUBY.newFloat(((Number)input).doubleValue());
    private static final Converter LONG_CONVERTER = input -> RubyUtil.RUBY.newFixnum(((Number)input).longValue());
    private static final Converter JAVAPROXY_CONVERTER = input -> {
        Object obj = JavaUtil.unwrapJavaObject((IRubyObject)((JavaProxy)input));
        if (obj instanceof IRubyObject[]) {
            return ConvertedList.newFromRubyArray((IRubyObject[])obj);
        }
        try {
            return Valuefier.convert(obj);
        }
        catch (IllegalArgumentException e) {
            Class<?> cls = obj.getClass();
            throw new IllegalArgumentException(String.format("Missing Valuefier handling for full class name=%s, simple name=%s, wrapped object=%s", cls.getName(), cls.getSimpleName(), obj.getClass().getName()), e);
        }
    };
    private static final Map<Class<?>, Converter> CONVERTER_MAP = Valuefier.initConverters();

    private Valuefier() {
    }

    public static Object convert(Object o) {
        if (o == null) {
            return RubyUtil.RUBY.getNil();
        }
        Class<?> cls = o.getClass();
        Converter converter = CONVERTER_MAP.get(cls);
        if (converter != null) {
            return converter.convert(o);
        }
        return Valuefier.fallbackConvert(o, cls);
    }

    private static Object fallbackConvert(Object o, Class<?> cls) {
        for (Map.Entry<Class<?>, Converter> entry : CONVERTER_MAP.entrySet()) {
            if (!entry.getKey().isAssignableFrom(cls)) continue;
            Converter found = entry.getValue();
            CONVERTER_MAP.put(cls, found);
            return found.convert(o);
        }
        throw new MissingConverterException(cls);
    }

    private static Map<Class<?>, Converter> initConverters() {
        ConcurrentHashMap converters = new ConcurrentHashMap(50, 0.2f, 1);
        converters.put(RubyString.class, IDENTITY);
        converters.put(RubyNil.class, IDENTITY);
        converters.put(RubySymbol.class, IDENTITY);
        converters.put(RubyFixnum.class, IDENTITY);
        converters.put(JrubyTimestampExtLibrary.RubyTimestamp.class, IDENTITY);
        converters.put(RubyFloat.class, IDENTITY);
        converters.put(ConvertedMap.class, IDENTITY);
        converters.put(ConvertedList.class, IDENTITY);
        converters.put(RubyBoolean.class, IDENTITY);
        converters.put(RubyBignum.class, IDENTITY);
        converters.put(RubyBigDecimal.class, IDENTITY);
        converters.put(String.class, input -> RubyUtil.RUBY.newString((String)input));
        converters.put(Float.class, FLOAT_CONVERTER);
        converters.put(Double.class, FLOAT_CONVERTER);
        converters.put(BigInteger.class, value -> RubyBignum.newBignum((Ruby)RubyUtil.RUBY, (BigInteger)((BigInteger)value)));
        converters.put(BigDecimal.class, value -> new RubyBigDecimal(RubyUtil.RUBY, (BigDecimal)value));
        converters.put(Long.class, LONG_CONVERTER);
        converters.put(Integer.class, LONG_CONVERTER);
        converters.put(Short.class, LONG_CONVERTER);
        converters.put(Byte.class, LONG_CONVERTER);
        converters.put(Boolean.class, input -> RubyUtil.RUBY.newBoolean(((Boolean)input).booleanValue()));
        converters.put(Timestamp.class, input -> JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(RubyUtil.RUBY, (Timestamp)input));
        converters.put(RubyTime.class, input -> JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(RubyUtil.RUBY, new Timestamp(((RubyTime)input).toInstant())));
        converters.put(DateTime.class, input -> JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(RubyUtil.RUBY, new Timestamp((DateTime)input)));
        converters.put(Date.class, input -> JrubyTimestampExtLibrary.RubyTimestamp.newRubyTimestamp(RubyUtil.RUBY, new Timestamp((Date)input)));
        converters.put(RubyHash.class, input -> ConvertedMap.newFromRubyHash((RubyHash)input));
        converters.put(Map.class, input -> ConvertedMap.newFromMap((Map)input));
        converters.put(List.class, input -> ConvertedList.newFromList((List)input));
        converters.put(ArrayJavaProxy.class, JAVAPROXY_CONVERTER);
        converters.put(ConcreteJavaProxy.class, JAVAPROXY_CONVERTER);
        converters.put(MapJavaProxy.class, input -> ConvertedMap.newFromMap((Map)((MapJavaProxy)input).getObject()));
        converters.put(RubyArray.class, input -> ConvertedList.newFromRubyArray((RubyArray)input));
        return converters;
    }

    public static interface Converter {
        public Object convert(Object var1);
    }
}

