/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestisk";
        final String metaValue_ar = "arabisk";
        final String metaValue_bo = "tibetansk";
        final String metaValue_el = "gresk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ja = "japansk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_lo = "laotisk";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_my = "burmesisk";
        final String metaValue_su = "sundanesisk";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_arc = "arameisk";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_cop = "koptisk";
        final String metaValue_got = "gotisk";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "gammelpersisk";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_saz = "saurashtra";
        final String metaValue_ssy = "saho";
        final String metaValue_uga = "ugaritisk";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f8lnsk" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesisk" },
            { "Zsym", "symboler" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "tai tham tham-tall" },
            { "egl", "emiliansk" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "gniva- og njivadialekt" },
            { "xmf", "mingrelsk" },
            { "egy", "gammelegyptisk" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotongansk" },
            { "tet", "tetum" },
            { "%%BARLA", "barlaventa-dialektgruppen av kappverdiansk" },
            { "AD", "Andorra" },
            { "AE", "De forente arabiske emirater" },
            { "nl_BE", "flamsk" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "glk", "gileki" },
            { "AI", "Anguilla" },
            { "key.tz", "tidssone" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "inskripsjonsparthisk" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "\u00d8sterrike" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "mye", "myene" },
            { "AZ", "Aserbajdsjan" },
            { "%%AREVELA", "\u00f8st-armensk" },
            { "BA", "Bosnia-Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuansk" },
            { "BD", "Bangladesh" },
            { "kum", "kumykisk" },
            { "BE", "Belgia" },
            { "gmh", "mellomh\u00f8ytysk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzia" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibisk Nederland" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8ya" },
            { "BW", "Botswana" },
            { "BY", "Hviterussland" },
            { "BZ", "Belize" },
            { "Visp", "synlig tale" },
            { "type.ca.persian", "persisk kalender" },
            { "type.nu.hebr", "hebraiske tall" },
            { "CA", "Canada" },
            { "CC", "Kokos\u00f8yene" },
            { "mzn", "mazandarani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Den sentralafrikanske republikk" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Sveits" },
            { "CI", "Elfenbenskysten" },
            { "CK", "Cook\u00f8yene" },
            { "CL", "Chile" },
            { "Kthi", "kaithisk" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8ya" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kapp Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas\u00f8ya" },
            { "CY", "Kypros" },
            { "type.nu.bali", "baliske tall" },
            { "CZ", "Tsjekkia" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "pau cin hau" },
            { "vls", "vestflamsk" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "DE", "Tyskland" },
            { "goh", "gammelh\u00f8ytysk" },
            { "ace", "achinesisk" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "goansk konkani" },
            { "type.nu.deva", "devanagari-sifre" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "punktskrift" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "sm\u00e5 armenske tall" },
            { "DO", "Den dominikanske republikk" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-frankisk" },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "Takr", "takri" },
            { "DZ", "Algerie" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "halv bredde" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta og Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tiv" },
            { "EG", "Egypt" },
            { "EH", "Vest-Sahara" },
            { "chg", "tsjagatai" },
            { "pau", "palauisk" },
            { "chk", "chuukesisk" },
            { "chn", "chinook" },
            { "chm", "mari" },
            { "chp", "chipewiansk" },
            { "cho", "choctaw" },
            { "chr", "cherokesisk" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "EU" },
            { "elx", "elamittisk" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "EZ", "eurosonen" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "gujarati-sifre" },
            { "Inds", "indus" },
            { "ady", "adygeisk" },
            { "aeb", "tunisisk-arabisk" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8yene" },
            { "FM", "Mikronesiaf\u00f8derasjonen" },
            { "key.va", "Spr\u00e5kvariant" },
            { "FO", "F\u00e6r\u00f8yene" },
            { "Taml", "tamilsk" },
            { "FR", "Frankrike" },
            { "Kpel", metaValue_kpe },
            { "pcd", "pikardisk" },
            { "tkl", "tokelauisk" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "%%DAJNKO", "dajnkoalfabet" },
            { "type.ca.indian", "indisk nasjonalkalender" },
            { "rgn", "romagnolsk" },
            { "grc", "gammelgresk" },
            { "GA", "Gabon" },
            { "tkr", "tsakhursk" },
            { "vot", "votisk" },
            { "GB", "Storbritannia" },
            { "pcm", "nigeriansk pidginspr\u00e5k" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f8nland" },
            { "enm", "mellomengelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorial-Guinea" },
            { "GR", "Hellas" },
            { "GS", "S\u00f8r-Georgia og S\u00f8r-Sandwich\u00f8yene" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "pennsylvaniatysk" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "ny tai lue" },
            { "GY", "Guyana" },
            { "ckb", "kurdisk (sorani)" },
            { "zxx", "uten spr\u00e5klig innhold" },
            { "Jurc", "jurchen" },
            { "tly", "talysj" },
            { "pdt", "plautdietsch" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong S.A.R. Kina" },
            { "HM", "Heard- og McDonald\u00f8yene" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsertysk" },
            { "type.ca.islamic-umalqura", "islamsk kalender (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "rif", "riff" },
            { "tmh", "tamasjek" },
            { "IC", "Kanari\u00f8yene" },
            { "nan", "minnan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "type.nu.kali", "kayah li-tall" },
            { "IE", "Irland" },
            { "nap", "napolitansk" },
            { "%%NDYUKA", "ndyuka-dialekt" },
            { "naq", "nama" },
            { "type.nu.sora", "sora sompeng-tall" },
            { "zza", "zazaisk" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabataeansk" },
            { "IM", "Man" },
            { "IN", "India" },
            { "type.co.eor", "sorteringsrekkef\u00f8lge for flerspr\u00e5klige europeiske dokumenter" },
            { "IO", "Det britiske territoriet i Indiahavet" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "Zmth", "matematisk notasjon" },
            { "type.nu.thai", "thailandske sifre" },
            { "vro", "s\u00f8restisk" },
            { "guc", "wayuu" },
            { "%%POSIX", "dataspr\u00e5k" },
            { "type.nu.beng", "bengalske sifre" },
            { "pfl", "palatintysk" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamsk kalender" },
            { "JM", "Jamaica" },
            { "Beng", "bengalsk" },
            { "%%EKAVSK", "serbisk med ekavisk uttale" },
            { "JO", "Jordan" },
            { "gur", "frafra" },
            { "JP", "Japan" },
            { "%%1606NICT", "nyere mellomfransk til 1606" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "kociewie" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasa-tongansk" },
            { "type.nu.knda", "kannada-sifre" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "type.co.phonetic", "Fonetisk sorteringsrekkef\u00f8lge" },
            { "izh", "ingrisk" },
            { "type.ca.buddhist", "buddhistisk kalender" },
            { "KE", "Kenya" },
            { "419", "Latin-Amerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodsja" },
            { "KI", "Kiribati" },
            { "KM", "Komorene" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts og Nevis" },
            { "Zinh", "nedarvet" },
            { "KP", "Nord-Korea" },
            { "KR", "S\u00f8r-Korea" },
            { "Plrd", "pollard-fonetisk" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f8yene" },
            { "KZ", "Kasakhstan" },
            { "Cyrl", "kyrillisk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "kirkeslavisk kyrillisk" },
            { "gwi", "gwichin" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "nedertysk" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadisk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "sentralyupik" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libya" },
            { "lad", "ladinsk" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "%%LAUKIKA", "laukika" },
            { "lah", "lahnda" },
            { "Mahj", "mahajani" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f8yene" },
            { "ale", "aleutisk" },
            { "type.nu.vaii", "vai-sifre" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao S.A.R. Kina" },
            { "aln", "gegisk-albansk" },
            { "MP", "Nord-Marianene" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "kapiz" },
            { "type.m0.ungegn", "UNGEGN-translitterasjon" },
            { "MU", "Mauritius" },
            { "alt", "s\u00f8raltaisk" },
            { "MV", "Maldivene" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "japansk kalender" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "Phli", "inskripsjonspahlavi" },
            { "NA", "Namibia" },
            { "202", "Afrika s\u00f8r for Sahara" },
            { "type.ca.hebrew", "hebraisk kalender" },
            { "type.co.dictionary", "ordlistesortering" },
            { "NC", "Ny-Caledonia" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "harmonisert revidert ortografi" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f8ya" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Nederland" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakonisk" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "New Zealand" },
            { "Merc", "meroitisk kursiv" },
            { "rom", "romani" },
            { "Mero", "meroitisk" },
            { "crh", "krimtatarisk" },
            { "ang", "gammelengelsk" },
            { "OM", "Oman" },
            { "%%PETR1708", "PETR1708" },
            { "anp", "angika" },
            { "crs", "seselwa" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamsk kalender (tabell, sivil)" },
            { "csb", "kasjubisk" },
            { "PE", "Peru" },
            { "ttt", "muslimsk tat" },
            { "PF", "Fransk Polynesia" },
            { "PG", "Papua Ny-Guinea" },
            { "PH", "Filippinene" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Det palestinske omr\u00e5det" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "sm\u00e5 greske tall" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk standard engelsk" },
            { "jam", "jamaicansk kreolengelsk" },
            { "pms", "piemontesisk" },
            { "niu", "niueansk" },
            { "QO", "Ytre Oseania" },
            { "ext", "ekstremaduransk" },
            { "lez", "lesgisk" },
            { "%%FONUPA", "det uraliske fonetiske alfabet (UPA)" },
            { "type.nu.takr", "takri-tall" },
            { "tvl", "tuvalsk" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "sotavento-dialektgruppen av kappverdiansk" },
            { "001", "verden" },
            { "002", "Afrika" },
            { "njo", "ao naga" },
            { "003", "Nord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00f8r-Amerika" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontisk" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "%%SURSILV", "sursilvan" },
            { "RO", "Romania" },
            { "Qaaw", "qaaw" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "Qaax", "qaax" },
            { "Qaau", "qaau" },
            { "RU", "Russland" },
            { "Qaav", "qaav" },
            { "Qaas", "qaas" },
            { "RW", "Rwanda" },
            { "Qaat", "qaat" },
            { "Qaaq", "qaaq" },
            { "Qaar", "qaar" },
            { "type.nu.talu", "ny tai lue-tall" },
            { "Qaba", "qaba" },
            { "%%METELKO", "Metelko-alfabet" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeisk" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi-Arabia" },
            { "pon", "ponapisk" },
            { "Mand", "mandaisk" },
            { "Qaay", "qaay" },
            { "SB", "Salomon\u00f8yene" },
            { "twq", "tasawaq" },
            { "Qaaz", "qaaz" },
            { "011", "Vest-Afrika" },
            { "SC", "Seychellene" },
            { "Qabh", "qabh" },
            { "SD", "Sudan" },
            { "Qabi", "qabi" },
            { "013", "Mellom-Amerika" },
            { "SE", "Sverige" },
            { "Qabf", "qafb" },
            { "arc", metaValue_arc },
            { "014", "\u00d8st-Afrika" },
            { "Loma", "loma" },
            { "Qabg", "qabg" },
            { "015", "Nord-Afrika" },
            { "SG", "Singapore" },
            { "Qabd", "qabd" },
            { "SH", "St. Helena" },
            { "Qabe", "qabe" },
            { "type.lb.strict", "streng linjeskiftstil" },
            { "017", "Sentral-Afrika" },
            { "SI", "Slovenia" },
            { "Qabb", "qabb" },
            { "018", "S\u00f8rlige Afrika" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "Qabc", "qabc" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "Bamu", "bamum" },
            { "Qabp", "qabp" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "Qabq", "qabq" },
            { "SM", "San Marino" },
            { "Qabn", "qabn" },
            { "SN", "Senegal" },
            { "Qabo", "qabo" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "Qabl", "qabl" },
            { "Qabm", "qabm" },
            { "arp", "arapaho" },
            { "Qabj", "qabj" },
            { "type.nu.taml", "tamilske tall" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "Qabk", "qabk" },
            { "SS", "S\u00f8r-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "arq", "algerisk arabisk" },
            { "SV", "El Salvador" },
            { "ars", "najdi-arabisk" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "arz", "egyptisk arabisk" },
            { "ary", "marokkansk-arabisk" },
            { "yap", "yapesisk" },
            { "rtm", "rotumansk" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "amerikansk m\u00e5lesystem" },
            { "021", "Nordlige Amerika" },
            { "TC", "Turks- og Caicos\u00f8yene" },
            { "yav", "yangben" },
            { "TD", "Tsjad" },
            { "Qaag", "qaag" },
            { "Qaah", "qaah" },
            { "TF", "De franske s\u00f8rterritorier" },
            { "ase", "amerikansk tegnspr\u00e5k" },
            { "Qaae", "qaae" },
            { "TG", "Togo" },
            { "Qaaf", "qaaf" },
            { "TH", "Thailand" },
            { "Qaac", "qaac" },
            { "Qaad", "qaad" },
            { "TJ", "Tadsjikistan" },
            { "Qaaa", "qaaa" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "Qaab", "qaab" },
            { "TL", "\u00d8st-Timor" },
            { "ybb", "yemba" },
            { "Qaao", "qaao" },
            { "type.co.searchjl", "S\u00f8k etter f\u00f8rste konsonant i hangul" },
            { "TM", "Turkmenistan" },
            { "Qaap", "qaap" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "Qaam", "qaam" },
            { "TO", "Tonga" },
            { "Qaan", "qaan" },
            { "%%NULIK", "moderne volap\u00fck" },
            { "Qaak", "qaak" },
            { "Qaal", "qaal" },
            { "TR", "Tyrkia" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturisk" },
            { "rue", "rusinsk" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ukjent skrift" },
            { "Sind", "khudawadi" },
            { "UA", "Ukraina" },
            { "lij", "ligurisk" },
            { "rup", "aromansk" },
            { "030", "\u00d8st-Asia" },
            { "tyv", "tuvinsk" },
            { "sw_CD", "kongolesisk swahili" },
            { "034", "S\u00f8r-Asia" },
            { "hai", "haida" },
            { "035", "S\u00f8r\u00f8st-Asia" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "pinyinsortering" },
            { "039", "S\u00f8r-Europa" },
            { "Sinh", "sinhala" },
            { "UM", "USAs ytre \u00f8yer" },
            { "liv", "livisk" },
            { "UN", "FN" },
            { "US", "USA" },
            { "haw", "hawaiisk" },
            { "Qabx", "qabx" },
            { "%%1959ACAD", "akademisk" },
            { "Qabv", "qabv" },
            { "type.co.gb2312han", "forenklet kinesisk sortering - GB2312" },
            { "Qabw", "qabw" },
            { "UY", "Uruguay" },
            { "prg", "pr\u00f8yssisk" },
            { "Qabt", "qabt" },
            { "UZ", "Usbekistan" },
            { "Qabu", "qabu" },
            { "tzm", "sentralmarokkansk tamazight" },
            { "Qabr", "qabr" },
            { "type.co.stroke", "streksortering" },
            { "Qabs", "qabs" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "gammelproven\u00e7alsk" },
            { "VC", "St. Vincent og Grenadinene" },
            { "VE", "Venezuela" },
            { "VG", "De britiske jomfru\u00f8yene" },
            { "VI", "De amerikanske jomfru\u00f8yene" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogaisk" },
            { "rwk", "rwa" },
            { "non", "gammelnorsk" },
            { "053", "Australasia" },
            { "%%AREVMDA", "vest-armensk" },
            { "054", "Melanesia" },
            { "WF", "Wallis og Futuna" },
            { "type.co.traditional", "tradisjonell sortering" },
            { "057", "Mikronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "Finansielle tall" },
            { "avk", "kotava" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "type.co.compat", "forrige sorteringsrekkef\u00f8lge (for kompatibilitet)" },
            { "wae", "walsertysk" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "type.nu.mtei", "meetei mayek-tall" },
            { "wal", "wolaytta" },
            { "was", "washo" },
            { "war", "waray-waray" },
            { "awa", "avadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "standard ortografi" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "brahmiske tall" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "spr\u00e5k uten skrift" },
            { "Olck", "ol-chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "blissymbol" },
            { "YE", "Jemen" },
            { "nqo", "n\u02bcko" },
            { "type.co.standard", "standard sorteringsrekkef\u00f8lge" },
            { "lmo", "lombardisk" },
            { "fan", "fang" },
            { "%%BALANKA", "balankadialekten av anii" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%SUTSILV", "sutsilvan" },
            { "fat", "fanti" },
            { "Sgnw", "tegnskrift" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "cham-tall" },
            { "ZA", "S\u00f8r-Afrika" },
            { "type.nu.sund", "sundanese-tall" },
            { "type.lb.loose", "l\u00f8s linjeskiftstil" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "georgiske tall" },
            { "type.co.zhuyin", "zhuyin-sortering" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ukjent omr\u00e5de" },
            { "Runr", "runer" },
            { "type.ms.metric", "metrisk system" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "lol", "mongo" },
            { "nso", "nord-sotho" },
            { "type.nu.telu", "telugu-sifre" },
            { "lou", "louisianakreolsk" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba" },
            { "jmc", "machame" },
            { "hif", "fijiansk hindi" },
            { "type.nu.hansfin", "forenklede kinesiske finanstall" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "utvidede arabisk-indiske sifre" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "sifre med full bredde" },
            { "hit", "hettittisk" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "maya-hieroglyfer" },
            { "lrc", "nord-luri" },
            { "type.co.emoji", "emoji-sorteringsrekkef\u00f8lge" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newari" },
            { "udm", "udmurtisk" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "islamsk kalender (Saudi-Arabia, observasjon)" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "romertall" },
            { "sah", "sakha" },
            { "type.nu.shrd", "sharada-tall" },
            { "ltg", "latgallisk" },
            { "sam", "samaritansk arameisk" },
            { "Aghb", "kaukasus-albansk" },
            { "%%SCOUSE", "scouse dialekt" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "j\u00f8depersisk" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.native", "Spr\u00e5kspesifikke sifre" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "biscayan" },
            { "type.d0.fwidth", "full bredde" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "baluchi" },
            { "den", "slavey" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "tornedalsfinsk" },
            { "luy", "luhya" },
            { "bar", "bairisk" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "jrb", "j\u00f8dearabisk" },
            { "nzi", "nzima" },
            { "sco", "skotsk" },
            { "scn", "siciliansk" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "bbc", "batak toba" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "chakma-tall" },
            { "bbj", "ghomala" },
            { "am", "amharisk" },
            { "Arab", metaValue_ar },
            { "an", "aragonsk" },
            { "%%SOLBA", "stolvizza- og solbicadialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "japanske stavelsesskrifter" },
            { "as", "assamesisk" },
            { "sdc", "sassaresisk sardisk" },
            { "Lina", "line\u00e6r A" },
            { "av", "avarisk" },
            { "Linb", "line\u00e6r B" },
            { "sdh", "s\u00f8rkurdisk" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "oseacco- og osojanedialekt" },
            { "%%UNIFON", "Unifon fonetisk alfabet" },
            { "ba", "basjkirsk" },
            { "type.co.unihan", "radikal-strek-sortering" },
            { "be", "hviterussisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "type.nu.java", "java-tall" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "laotiske sifre" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko" },
            { "sel", "selkupisk" },
            { "ca", "katalansk" },
            { "ses", "koyraboro senni" },
            { "ce", "tsjetsjensk" },
            { "ch", "chamorro" },
            { "%%REVISED", "revidert ortografi" },
            { "co", "korsikansk" },
            { "Orya", "oriya" },
            { "cr", "cree" },
            { "cs", "tsjekkisk" },
            { "cu", "kirkeslavisk" },
            { "yrl", "nheengatu" },
            { "cv", "tsjuvasjisk" },
            { "cy", "walisisk" },
            { "type.nu.ethi", "etiopiske tall" },
            { "Yiii", "yi" },
            { "da", "dansk" },
            { "de", "tysk" },
            { "type.cf.standard", "standard valutaformat" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "jut", "jysk" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "gammelirsk" },
            { "type.nu.mong", "mongolske tall" },
            { "dv", "divehi" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "lzh", "klassisk kinesisk" },
            { "Lisu", "fraser" },
            { "dje", "zarma" },
            { "sgs", "samogitisk" },
            { "type.nu.grek", "greske tall" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "normal linjeskiftstil" },
            { "ro_MD", "moldovsk" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "lazisk" },
            { "type.co.big5han", "tradisjonell kinesisk sortering - Big 5" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "Hanb", "hanb" },
            { "eu", "baskisk" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritansk" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00f8ysorbisk" },
            { "Hani", "han" },
            { "%%ULSTER", "ulster" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persisk" },
            { "Hans", "forenklet" },
            { "type.nu.latn", "vestlige sifre" },
            { "Hant", "tradisjonell" },
            { "ff", "fulfulde" },
            { "shu", "tsjadisk arabisk" },
            { "hsn", "xiang" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fon", "fon" },
            { "bgn", "vestbalutsji" },
            { "yue", "kantonesisk" },
            { "fo", "f\u00e6r\u00f8ysk" },
            { "type.m0.bgn", "USBGN-translitterasjon" },
            { "umb", "umbundu" },
            { "fr", "fransk" },
            { "sid", "sidamo" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk-g\u00e6lisk" },
            { "gl", "galisisk" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "ukjent spr\u00e5k" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "islamsk kalender (tabell, astronomisk)" },
            { "gv", "mansk" },
            { "type.nu.osma", "osmanya-tall" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "cajunfransk" },
            { "%%FONIPA", "det internasjonale fonetiske alfabet (IPA)" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesisk" },
            { "type.nu.tibt", "tibetanske sifre" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan-yi" },
            { "frm", "mellomfransk" },
            { "%%RUMGR", "RUMGR" },
            { "ik", "inupiak" },
            { "fro", "gammelfransk" },
            { "frp", "arpitansk" },
            { "io", "ido" },
            { "frs", "\u00f8stfrisisk" },
            { "bjn", "banjar" },
            { "frr", "nordfrisisk" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "sli", "lavschlesisk" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "gammels\u00f8rarabisk" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "type.nu.lepc", "lepecha-tall" },
            { "bkm", "kom" },
            { "sma", "s\u00f8rsamisk" },
            { "jv", metaValue_jv },
            { "Shaw", "shavisk" },
            { "%%BAUDDHA", "bauddha" },
            { "mad", "maduresisk" },
            { "smj", "lulesamisk" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "enaresamisk" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "skoltesamisk" },
            { "man", "mandingo" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kasjmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "kornisk" },
            { "ky", "kirgisisk" },
            { "snk", "soninke" },
            { "Mult", "multani" },
            { "la", "latin" },
            { "Hatr", "hatransk armensk" },
            { "lb", "luxemburgsk" },
            { "type.nu.mlym", "malayalam-sifre" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgsk" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friuliansk" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "britisk m\u00e5lesystem" },
            { "type.nu.lana", "thai tham hora-tall" },
            { "lt", "litauisk" },
            { "lu", "luba-katanga" },
            { "lv", "latvisk" },
            { "sog", "sogdisk" },
            { "mg", "gassisk" },
            { "mh", "marshallesisk" },
            { "type.co.ducet", "standard Unicode-sorteringsrekkef\u00f8lge" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayisk" },
            { "mt", "maltesisk" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksja" },
            { "mde", "maba" },
            { "Armi", metaValue_arc },
            { "dsb", "lavsorbisk" },
            { "na", "nauru" },
            { "type.co.search", "generelt s\u00f8k" },
            { "nb", "norsk bokm\u00e5l" },
            { "nd", "nord-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederlandsk" },
            { "nn", "norsk nynorsk" },
            { "no", "norsk" },
            { "nr", "s\u00f8r-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakisk" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabylsk" },
            { "%%POLYTON", "polytonisk rettskriving" },
            { "oc", "oksitansk" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "tidlig moderne engelsk" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "armenske tall" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "sentraldusun" },
            { "or", "odia" },
            { "Modi", "modi" },
            { "os", "ossetisk" },
            { "%%ALALC97", "ALA-LC-romanisering, 1997-utgaven" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardisk" },
            { "mfe", "mauritisk-kreolsk" },
            { "srn", "sranan" },
            { "pa", "panjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "resia med Lipovaz-dialekt" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polsk" },
            { "dum", "mellomnederlandsk" },
            { "type.nu.saur", "sarushatra-tall" },
            { "type.ca.dangi", "dangisk kalender" },
            { "%%VALLADER", "vallader" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "mga", "mellomirsk" },
            { "key.co", "sorteringsrekkef\u00f8lge" },
            { "%%BOHORIC", "bohorisk alfabet" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "valutaformat" },
            { "type.nu.nkoo", "n\u2019ko-tall" },
            { "bra", "braj" },
            { "key.ca", "kalender" },
            { "%%JAUER", "jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiransk" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24-timers system (0\u201323)" },
            { "type.hc.h24", "24-timers system (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "brahui" },
            { "type.nu.mymr", "burmesiske sifre" },
            { "qu", "quechua" },
            { "zap", "zapotekisk" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "vaidika" },
            { "stq", "saterfrisisk" },
            { "Ethi", "etiopisk" },
            { "%%JYUTPING", "jyutping" },
            { "type.hc.h12", "12-timers system (1\u201312)" },
            { "type.hc.h11", "12-timers system (0\u201311)" },
            { "rm", "retoromansk" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumensk" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "odia-sifre" },
            { "type.nu.hanidec", "kinesiske desimaltall" },
            { "ru", "russisk" },
            { "bss", "akose" },
            { "rw", "kinyarwanda" },
            { "zbl", "blissymboler" },
            { "kea", "kappverdisk" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "Dupl", "duployan stenografi" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "harmonisert ortografi" },
            { "sc", "sardisk" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "ken", "kenyang" },
            { "si", "singalesisk" },
            { "sux", "sumerisk" },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "Gran", "gammeltamilsk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "type.nu.arab", "arabisk-indiske sifre" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "type.cf.account", "valutaformat for regnskapsf\u00f8ring" },
            { "Java", metaValue_jv },
            { "st", "s\u00f8r-sotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonedialekt" },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "tradisjonelle kinesiske finanstall" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamil" },
            { "142", "Asia" },
            { "bua", "burjatisk" },
            { "143", "Sentral-Asia" },
            { "te", metaValue_te },
            { "145", "Vest-Asia" },
            { "tg", "tadsjikisk" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "setswana" },
            { "to", "tongansk" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanske tall" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "swb", "komorisk" },
            { "Cakm", "chakma" },
            { "tt", "tatarisk" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitisk" },
            { "%%BISKE", "san giorgio- og biladialekt" },
            { "150", "Europa" },
            { "151", "\u00d8st-Europa" },
            { "154", "Nord-Europa" },
            { "dzg", "dazaga" },
            { "155", "Vest-Europa" },
            { "ug", "uigurisk" },
            { "Kore", metaValue_ko },
            { "Ital", "gammelitalisk" },
            { "kgp", "kaingang" },
            { "Zyyy", "felles" },
            { "uk", "ukrainsk" },
            { "zea", "zeeuws" },
            { "type.ca.coptic", "koptisk kalender" },
            { "ur", "urdu" },
            { "%%1994", "standardisert resisk ortografi" },
            { "xal", "kalmukkisk" },
            { "zen", "zenaga" },
            { "uz", "usbekisk" },
            { "kha", "khasi" },
            { "%%1996", "tysk ortografi fra 1996" },
            { "nds_NL", "nedersaksisk" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "minguo-kalender" },
            { "vi", "vietnamesisk" },
            { "kho", "khotanesisk" },
            { "khq", "koyra chiini" },
            { "key.hc", "timesyklus (12 eller 24)" },
            { "%%TARASK", "taraskievica-ortografi" },
            { "vo", "volapyk" },
            { "khw", "khowar" },
            { "syc", "klassisk syrisk" },
            { "Osma", "osmanya" },
            { "quc", "k\u2019iche\u2019" },
            { "qug", "kichwa (Chimborazo-h\u00f8ylandet)" },
            { "gaa", "ga" },
            { "wa", "vallonsk" },
            { "gag", "gagausisk" },
            { "syr", "syriakisk" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmancki" },
            { "Lydi", "lydisk" },
            { "Xsux", "sumersk-akkadisk kileskrift" },
            { "wo", "wolof" },
            { "zgh", "standard marrokansk tamazight" },
            { "ar_001", "moderne standardarabisk" },
            { "Cans", "felles kanadiske urspr\u00e5ksstavelser" },
            { "%%FONXSAMP", "fonxsamp" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "mandsju" },
            { "Latf", "frakturlatinsk" },
            { "szl", "schlesisk" },
            { "Hluw", "anatoliske hieroglyfer" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinsk" },
            { "Latg", "g\u00e6lisk latinsk" },
            { "type.nu.hans", "forenklede kinesiske tall" },
            { "type.nu.hant", "tradisjonelle kinesiske tall" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "sm\u00e5 romertall" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "Lyci", "lykisk" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "zoroastrisk dari" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "eldre nyfransk" },
            { "yi", "jiddisk" },
            { "mos", "mossi" },
            { "Syrc", "syrisk" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "type.nu.traditional", "Tradisjonelle tall" },
            { "Syrj", "vestlig syriakisk" },
            { "ota", "ottomansk tyrkisk" },
            { "Syre", "estrangelosyriakisk" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "karisk" },
            { "kln", "kalenjin" },
            { "zh", "kinesisk" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "gammelpermisk" },
            { "key.lb", "linjeskiftstil" },
            { "zu", "zulu" },
            { "type.co.phonebook", "telefonkatalogsortering" },
            { "%%MONOTON", "monotonisk rettskriving" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanske finanstall" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "mrj", "vestmarisk" },
            { "Syrn", "\u00f8stlig syriakisk" },
            { "type.nu.mymrshan", "myanmar shan-tall" },
            { "Elba", "elbasisk" },
            { "Narb", "gammelnordarabisk" },
            { "type.nu.olck", "ol chiki-tall" },
            { "type.co.reformed", "reformert sortering" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "%%ITIHASA", "itihasa" },
            { "Palm", "palmyrensk" },
            { "ebu", "kiembu" },
            { "Egyp", "egyptiske hieroglyfer" },
            { "Geok", "georgisk khutsuri" },
            { "zh_Hans", "forenklet kinesisk" },
            { "koi", "komipermjakisk" },
            { "Hung", "gammelungarsk" },
            { "kok", "konkani" },
            { "%%1901", "tradisjonell tysk ortografi" },
            { "kos", "kosraeansk" },
            { "vec", "venetiansk" },
            { "type.nu.limb", "limbu-tall" },
            { "zh_Hant", "tradisjonell kinesisk" },
            { "Sund", metaValue_su },
            { "vep", "vepsisk" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "khmer-sifre" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensiansk" },
            { "Cprt", "kypriotisk" },
            { "%%BAKU1926", "samlet tyrkisk-latinsk alfabet" },
            { "%%IJEKAVSK", "serbisk med ijekavisk uttale" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhi-sifre" },
            { "mul", "flere spr\u00e5k" },
            { "%%PUTER", "PUTER" },
            { "cad", "caddo" },
            { "key.ms", "m\u00e5lesystem" },
            { "mus", "creek" },
            { "Glag", "glagolittisk" },
            { "gil", "kiribatisk" },
            { "%%KKCOR", "felles ortografi" },
            { "Cher", "cherokee" },
            { "car", "karibisk" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "tamilske sifre" },
            { "krc", "karatsjajbalkarsk" },
            { "inh", "ingusjisk" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karelsk" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "tall" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
