/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.PolicyTree;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.Trust;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.util.SafePropertyAccessor;

public class StoreContext {
    private static final Integer ZERO = 0;
    private final Store store;
    X509AuxCertificate cert;
    List<X509AuxCertificate> untrusted;
    List<X509CRL> crls;
    private VerifyParameter verifyParameter;
    private List<Object> extraData;
    private List<X509AuxCertificate> otherContext;
    Store.VerifyFunction verify;
    Store.VerifyCallbackFunction verifyCallback;
    Store.GetIssuerFunction getIssuer;
    Store.CheckIssuedFunction checkIssued;
    Store.CheckRevocationFunction checkRevocation;
    Store.GetCRLFunction getCRL;
    Store.CheckCRLFunction checkCRL;
    Store.CertificateCRLFunction certificateCRL;
    CheckPolicyFunction checkPolicy;
    Store.CleanupFunction cleanup;
    Store.LookupCerts lookup_certs;
    public boolean isValid;
    private int num_untrusted;
    private ArrayList<X509AuxCertificate> chain;
    private PolicyTree tree;
    private int explicit_policy;
    int error;
    int error_depth;
    X509AuxCertificate current_cert;
    X509AuxCertificate current_issuer;
    X509CRL current_crl;
    private StoreContext parent;
    private static final boolean VERIFY_LEGACY;
    private static final short S_DOUNTRUSTED = 1;
    private static final short S_DOTRUSTED = 2;
    private static final short S_DOALTERNATE = 4;
    private static final Set<String> CRITICAL_EXTENSIONS;
    static final Store.GetIssuerFunction getFirstIssuer;
    static final Store.GetIssuerFunction getIssuerStack;
    static final Store.CheckIssuedFunction check_issued;
    static final Store.CheckIssuedFunction check_issued_legacy;
    static final Store.VerifyCallbackFunction nullCallback;
    @Deprecated
    static final Store.VerifyFunction internalVerify;
    static final Store.CheckRevocationFunction check_revocation;
    static final Store.GetCRLFunction defaultGetCRL;
    static final Store.CheckCRLFunction check_crl;
    static final Store.CheckCRLFunction check_crl_legacy;
    static final Store.CertificateCRLFunction defaultCertificateCRL;
    static final CheckPolicyFunction check_policy;

    public StoreContext(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }

    public void setDepth(int depth) {
        this.verifyParameter.setDepth(depth);
    }

    public void setApplicationData(Object data) {
        this.setExtraData(0, data);
    }

    public Object getApplicationData() {
        return this.getExtraData(0);
    }

    int getFirstIssuer(X509AuxCertificate[] _issuer, X509AuxCertificate x) throws Exception {
        X509AuxCertificate x509;
        X509Object pobj;
        X509AuxCertificate issuer2;
        int ok;
        Name xn = new Name(x.getIssuerX500Principal());
        X509Object[] s_obj = new X509Object[1];
        int n = ok = this.store == null ? 0 : this.getBySubject(1, xn, s_obj);
        if (ok != 1) {
            if (ok == -1) {
                X509Error.addError(106);
                return -1;
            }
            if (ok != 0) {
                return -1;
            }
            return 0;
        }
        X509Object obj = s_obj[0];
        if (this.checkIssued.call(this, x, ((Certificate)obj).cert) != 0 && this.x509_check_cert_time(issuer2 = ((Certificate)obj).cert, -1)) {
            _issuer[0] = issuer2;
            return 1;
        }
        List<X509Object> objects = this.store.getObjects();
        int idx = X509Object.indexBySubject(objects, 1, xn);
        if (idx == -1) {
            return 0;
        }
        int ret = 0;
        for (int i2 = idx; i2 < objects.size() && (pobj = objects.get(i2)).type() == 1 && xn.equalTo((x509 = ((Certificate)pobj).cert).getSubjectX500Principal()); ++i2) {
            if (this.checkIssued.call(this, x, x509) == 0) continue;
            _issuer[0] = x509;
            ret = 1;
            if (this.x509_check_cert_time(x509, -1)) break;
        }
        return ret;
    }

    private int getValidIssuers(X509AuxCertificate x, List<X509AuxCertificate> _issuers) throws Exception {
        List<X509Object> objects;
        int idx;
        X509AuxCertificate issuer2;
        int ok;
        Name xn = new Name(x.getIssuerX500Principal());
        X509Object[] s_obj = new X509Object[1];
        int n = ok = this.store == null ? 0 : this.getBySubject(1, xn, s_obj);
        if (ok != 1) {
            if (ok == -1) {
                X509Error.addError(106);
                return -1;
            }
            if (ok != 0) {
                return -1;
            }
            return 0;
        }
        int ret = 0;
        X509Object obj = s_obj[0];
        if (this.checkIssued.call(this, x, ((Certificate)obj).cert) != 0 && this.x509_check_cert_time(issuer2 = ((Certificate)obj).cert, -1)) {
            _issuers.add(issuer2);
            ret = 1;
        }
        if ((idx = X509Object.indexBySubject(objects = this.store.getObjects(), 1, xn)) == -1) {
            return ret;
        }
        for (int i2 = idx; i2 < objects.size(); ++i2) {
            X509AuxCertificate x509;
            X509Object pobj = objects.get(i2);
            if (pobj.type() != 1 || !xn.equalTo((x509 = ((Certificate)pobj).cert).getSubjectX500Principal()) || this.checkIssued.call(this, x, x509) == 0 || !this.x509_check_cert_time(x509, -1)) continue;
            _issuers.add(x509);
            ret = 1;
        }
        return ret;
    }

    public static List<X509AuxCertificate> ensureAux(Collection<X509Certificate> input) {
        if (input == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> out = new ArrayList<X509AuxCertificate>(input.size());
        for (X509Certificate cert2 : input) {
            out.add(StoreContext.ensureAux(cert2));
        }
        return out;
    }

    public static List<X509AuxCertificate> ensureAux(X509Certificate[] input) {
        if (input == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> out = new ArrayList<X509AuxCertificate>(input.length);
        for (X509Certificate cert2 : input) {
            out.add(StoreContext.ensureAux(cert2));
        }
        return out;
    }

    public static X509AuxCertificate ensureAux(X509Certificate input) {
        if (input == null) {
            return null;
        }
        if (input instanceof X509AuxCertificate) {
            return (X509AuxCertificate)input;
        }
        return new X509AuxCertificate(input);
    }

    public int init(X509AuxCertificate cert2, List<X509AuxCertificate> untrusted_chain) {
        int idx;
        Purpose xp;
        this.cert = cert2;
        this.untrusted = untrusted_chain;
        this.crls = null;
        this.num_untrusted = 0;
        this.otherContext = null;
        this.isValid = false;
        this.chain = null;
        this.error = 0;
        this.explicit_policy = 0;
        this.error_depth = 0;
        this.current_cert = null;
        this.current_issuer = null;
        this.current_crl = null;
        this.tree = null;
        this.parent = null;
        this.cleanup = this.store != null ? this.store.cleanup : null;
        this.checkIssued = VERIFY_LEGACY ? check_issued_legacy : check_issued;
        this.getIssuer = getFirstIssuer;
        this.verifyCallback = nullCallback;
        this.verify = null;
        this.checkRevocation = check_revocation;
        this.getCRL = defaultGetCRL;
        this.checkCRL = check_crl_legacy;
        this.certificateCRL = defaultCertificateCRL;
        if (this.store != null) {
            if (this.store.checkIssued != null) {
                this.checkIssued = this.store.checkIssued;
            }
            if (this.store.getIssuer != null) {
                this.getIssuer = this.store.getIssuer;
            }
            if (this.store.verifyCallback != null) {
                this.verifyCallback = this.store.verifyCallback;
            }
            if (this.store.verify != null) {
                this.verify = this.store.verify;
            }
            if (this.store.checkRevocation != null) {
                this.checkRevocation = this.store.checkRevocation;
            }
            if (this.store.getCRL != null) {
                this.getCRL = this.store.getCRL;
            }
            if (this.store.checkCRL != null) {
                this.checkCRL = this.store.checkCRL;
            }
            if (this.store.certificateCRL != null) {
                this.certificateCRL = this.store.certificateCRL;
            }
        }
        this.lookup_certs = this.store != null && this.store.lookup_certs != null ? this.store.lookup_certs : new Store.LookupCerts(){

            @Override
            public List<X509AuxCertificate> call(StoreContext ctx, Name name2) throws Exception {
                return ctx.get1_certs(name2);
            }
        };
        this.checkPolicy = check_policy;
        this.verifyParameter = new VerifyParameter();
        if (this.store != null) {
            this.verifyParameter.inherit(this.store.verifyParameter);
        } else {
            this.verifyParameter.inheritFlags |= 0x11L;
        }
        this.verifyParameter.inherit(VerifyParameter.lookup("default"));
        if (this.verifyParameter.trust == 0 && (xp = Purpose.getFirst(idx = Purpose.getByID(this.verifyParameter.purpose))) != null) {
            this.verifyParameter.trust = xp.trust;
        }
        return 1;
    }

    public void trustedStack(List<X509AuxCertificate> sk) {
        this.otherContext = sk;
        this.getIssuer = getIssuerStack;
    }

    public void cleanup() throws Exception {
        if (this.cleanup != null) {
            this.cleanup.call(this);
        }
        this.verifyParameter = null;
        this.tree = null;
        this.chain = null;
        this.extraData = null;
    }

    public List<Object> getExtraData() {
        if (this.extraData != null) {
            return this.extraData;
        }
        ArrayList<Object> extraData = new ArrayList<Object>(8);
        extraData.add(null);
        extraData.add(null);
        extraData.add(null);
        extraData.add(null);
        extraData.add(null);
        extraData.add(null);
        this.extraData = extraData;
        return this.extraData;
    }

    public int setExtraData(int idx, Object data) {
        this.getExtraData().set(idx, data);
        return 1;
    }

    public Object getExtraData(int idx) {
        return this.getExtraData().get(idx);
    }

    public int getError() {
        return this.error;
    }

    public void setError(int s2) {
        this.error = s2;
    }

    public int getErrorDepth() {
        return this.error_depth;
    }

    public X509AuxCertificate getCurrentCertificate() {
        return this.current_cert;
    }

    public X509CRL getCurrentCRL() {
        return this.current_crl;
    }

    public List<X509AuxCertificate> getChain() {
        return this.chain;
    }

    public List<X509AuxCertificate> getFirstChain() {
        if (this.chain == null) {
            return null;
        }
        return new ArrayList<X509AuxCertificate>(this.chain);
    }

    public void setCertificate(X509AuxCertificate x) {
        this.cert = x;
    }

    public void setCertificate(X509Certificate x) {
        this.cert = StoreContext.ensureAux(x);
    }

    public void setChain(List<X509Certificate> chain2) {
        this.untrusted = StoreContext.ensureAux(chain2);
    }

    public void setChain(X509Certificate[] sk) {
        this.untrusted = StoreContext.ensureAux(sk);
    }

    public void setCRLs(List<X509CRL> sk) {
        this.crls = sk;
    }

    public int setPurpose(int purpose) {
        return this.purposeInherit(0, purpose, 0);
    }

    public int setTrust(int trust) {
        return this.purposeInherit(0, 0, trust);
    }

    private int purposeInherit(int def_purpose, int purpose, int trust) {
        int idx;
        if (purpose == 0) {
            purpose = def_purpose;
        }
        if (purpose != 0) {
            idx = Purpose.getByID(purpose);
            if (idx == -1) {
                X509Error.addError(121);
                return 0;
            }
            Purpose ptmp = Purpose.getFirst(idx);
            if (ptmp.trust == 0) {
                idx = Purpose.getByID(def_purpose);
                if (idx == -1) {
                    X509Error.addError(121);
                    return 0;
                }
                ptmp = Purpose.getFirst(idx);
            }
            if (trust == 0) {
                trust = ptmp.trust;
            }
        }
        if (trust != 0 && (idx = Trust.getByID(trust)) == -1) {
            X509Error.addError(120);
            return 0;
        }
        if (purpose != 0 && this.getParam().purpose == 0) {
            this.getParam().purpose = purpose;
        }
        if (trust != 0 && this.getParam().trust == 0) {
            this.getParam().trust = trust;
        }
        return 1;
    }

    public void setFlags(long flags) {
        this.verifyParameter.setFlags(flags);
    }

    public void setTime(long flags, Date t) {
        this.verifyParameter.setTime(t);
    }

    public void setVerifyCallback(Store.VerifyCallbackFunction verifyCallback) {
        this.verifyCallback = verifyCallback;
    }

    PolicyTree getPolicyTree() {
        return this.tree;
    }

    public int getExplicitPolicy() {
        return this.explicit_policy;
    }

    public VerifyParameter getParam() {
        return this.verifyParameter;
    }

    public void setParam(VerifyParameter param) {
        this.verifyParameter = param;
    }

    public void setDefault(String name2) {
        VerifyParameter p = VerifyParameter.lookup(name2);
        if (p == null) {
            return;
        }
        this.verifyParameter.inherit(p);
    }

    public int getBySubject(int type, Name name2, X509Object[] ret) throws Exception {
        Store store = this.store;
        if (store == null) {
            return 0;
        }
        X509Object tmp = X509Object.retrieveBySubject(store.getObjects(), type, name2);
        if (tmp == null || type == 2) {
            for (Lookup lu : store.getCertificateMethods()) {
                X509Object[] stmp;
                int j = lu.bySubject(type, name2, stmp = new X509Object[1]);
                if (j == 0) continue;
                tmp = stmp[0];
                break;
            }
            if (tmp == null) {
                return 0;
            }
        }
        ret[0] = tmp;
        return 1;
    }

    List<X509AuxCertificate> get1_certs(Name nm) throws Exception {
        if (this.store == null) {
            return null;
        }
        List<X509AuxCertificate> sk = this.matchCachedCertObjectsFromStore(nm);
        if (sk.isEmpty()) {
            boolean found = false;
            for (Lookup lu : this.store.getCertificateMethods()) {
                X509Object[] stmp;
                if (lu.bySubject(1, nm, stmp = new X509Object[1]) == 0) continue;
                found = true;
            }
            if (!found) {
                return sk;
            }
        }
        sk = this.matchCachedCertObjectsFromStore(nm);
        return sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int get_issuer(X509AuxCertificate[] issuer2, X509AuxCertificate cert2) throws Exception {
        int ok;
        ArrayList<X509AuxCertificate> saved_chain = this.chain;
        this.chain = null;
        try {
            ok = this.getIssuer.call(this, issuer2, cert2);
        }
        finally {
            this.chain = saved_chain;
        }
        return ok;
    }

    private List<X509AuxCertificate> matchCachedCertObjectsFromStore(Name name2) {
        ArrayList<X509AuxCertificate> sk = new ArrayList<X509AuxCertificate>();
        for (X509Object obj : this.store.getObjects()) {
            if (obj.type() != 1 || !obj.isName(name2)) continue;
            sk.add(((Certificate)obj).cert);
        }
        return sk;
    }

    public int verifyCertificate() throws Exception {
        if (this.cert == null) {
            X509Error.addError(105);
            this.error = 69;
            return -1;
        }
        if (this.chain != null) {
            X509Error.addError(66);
            this.error = 69;
            return -1;
        }
        this.chain = new ArrayList(8);
        this.chain.add(this.cert);
        this.num_untrusted = 1;
        int ret = this.verifyChain();
        if (ret <= 0 && this.error == 0) {
            this.error = 1;
        }
        return ret;
    }

    private int verifyChain() throws Exception {
        if (VERIFY_LEGACY) {
            return this.verify_chain_legacy();
        }
        return this.verify_chain();
    }

    int verify_chain_legacy() throws Exception {
        int ok;
        int ok2;
        X509AuxCertificate[] p_xtmp;
        int num;
        X509AuxCertificate xtmp = null;
        X509AuxCertificate chain_ss = null;
        boolean bad_chain = false;
        LinkedList<X509AuxCertificate> sktmp = this.untrusted != null ? new LinkedList<X509AuxCertificate>(this.untrusted) : null;
        X509AuxCertificate x = this.chain.get(num - 1);
        int depth = this.verifyParameter.depth;
        for (num = this.chain.size(); depth >= num && this.checkIssued.call(this, x, x) == 0 && sktmp != null && (xtmp = this.findIssuer(sktmp, x, true)) != null; ++num) {
            this.chain.add(xtmp);
            sktmp.remove(xtmp);
            ++this.num_untrusted;
            x = xtmp;
        }
        int i2 = this.chain.size();
        x = this.chain.get(i2 - 1);
        if (this.checkIssued.call(this, x, x) != 0) {
            if (this.chain.size() == 1) {
                p_xtmp = new X509AuxCertificate[]{xtmp};
                ok2 = this.getIssuer.call(this, p_xtmp, x);
                xtmp = p_xtmp[0];
                if (ok2 <= 0 || !x.equals(xtmp)) {
                    this.error = 18;
                    this.current_cert = x;
                    this.error_depth = i2 - 1;
                    bad_chain = true;
                    ok2 = this.verifyCallback.call(this, ZERO);
                    if (ok2 == 0) {
                        return ok2;
                    }
                } else {
                    x = xtmp;
                    this.chain.set(i2 - 1, x);
                    this.num_untrusted = 0;
                }
            } else {
                chain_ss = this.chain.remove(this.chain.size() - 1);
                --this.num_untrusted;
                x = this.chain.get(--num - 1);
            }
        }
        while (depth >= num && this.checkIssued.call(this, x, x) == 0) {
            p_xtmp = new X509AuxCertificate[]{xtmp};
            ok2 = this.getIssuer.call(this, p_xtmp, x);
            xtmp = p_xtmp[0];
            if (ok2 < 0) {
                return ok2;
            }
            if (ok2 == 0) break;
            x = xtmp;
            this.chain.add(x);
            ++num;
        }
        if (this.checkIssued.call(this, x, x) == 0) {
            if (chain_ss == null || this.checkIssued.call(this, x, chain_ss) == 0) {
                this.error = this.num_untrusted >= num ? 20 : 2;
                this.current_cert = x;
            } else {
                this.chain.add(chain_ss);
                this.num_untrusted = ++num;
                this.current_cert = chain_ss;
                this.error = 19;
            }
            this.error_depth = num - 1;
            bad_chain = true;
            int ok3 = this.verifyCallback.call(this, ZERO);
            if (ok3 == 0) {
                return ok3;
            }
        }
        if ((ok = this.checkChainExtensions()) == 0) {
            return ok;
        }
        if (this.verifyParameter.trust > 0) {
            ok = this.checkTrust();
        }
        if (ok == 0) {
            return ok;
        }
        ok = this.checkRevocation.call(this);
        if (ok == 0) {
            return ok;
        }
        ok = this.verify != null ? this.verify.call(this) : internalVerify.call(this);
        if (ok == 0) {
            return ok;
        }
        if (!bad_chain && (this.verifyParameter.flags & 0x80L) != 0L) {
            ok = this.checkPolicy.call(this);
        }
        return ok;
    }

    int verify_chain() throws Exception {
        int ok = this.build_chain();
        if (ok == 0 || (ok = this.check_chain_extensions()) != 0) {
            // empty if block
        }
        if (ok == 0 || (ok = this.checkRevocation.call(this)) == 0) {
            return ok;
        }
        int n = ok = this.verify != null ? this.verify.call(this) : this.internal_verify();
        if (ok == 0) {
            return ok;
        }
        if ((this.getParam().flags & 0x80L) != 0L) {
            ok = this.checkPolicy.call(this);
        }
        return ok;
    }

    int build_chain() throws Exception {
        int search;
        int num = this.chain.size();
        X509AuxCertificate cert2 = this.chain.get(num - 1);
        boolean ss = this.cert_self_signed(cert2);
        boolean may_trusted = false;
        boolean may_alternate = false;
        int trust = 3;
        int alt_untrusted = 0;
        assert (num == 1 && this.num_untrusted == num);
        int n = search = this.untrusted != null ? 1 : 0;
        if (search == 0 || (this.getParam().flags & 0x8000L) != 0L) {
            search = (short)(search | 2);
        } else if ((this.getParam().flags & 0x100000L) == 0L) {
            may_alternate = true;
        }
        may_trusted = true;
        LinkedList<X509AuxCertificate> sktmp = this.untrusted != null ? new LinkedList<X509AuxCertificate>(this.untrusted) : null;
        int depth = this.getParam().depth;
        if (depth > 0x3FFFFFFF) {
            depth = 0x3FFFFFFF;
        }
        ++depth;
        block7: while (search != 0) {
            X509AuxCertificate x;
            X509AuxCertificate xtmp = null;
            if ((search & 2) != 0) {
                int i2 = num = this.chain.size();
                if ((search & 4) != 0) {
                    i2 = alt_untrusted;
                }
                x = this.chain.get(i2 - 1);
                X509AuxCertificate[] p_xtmp = new X509AuxCertificate[]{xtmp};
                int ok = depth < num ? 0 : this.getIssuer.call(this, p_xtmp, x);
                xtmp = p_xtmp[0];
                if (ok < 0) {
                    trust = 2;
                    this.error = 70;
                    search = 0;
                    continue;
                }
                if (ok > 0) {
                    if ((search & 4) != 0) {
                        if (num <= i2 || i2 <= 0 || ss) {
                            OpenSSL.debug(this + " assert failure (num > i && i > 0 && ss == false)");
                            X509Error.addError(68);
                            trust = 2;
                            this.error = 1;
                            search = 0;
                            continue;
                        }
                        search = (short)(search & 0xFFFFFFFB);
                        while (num > i2) {
                            this.chain.remove(this.chain.size() - 1);
                            --num;
                        }
                        this.num_untrusted = num;
                    }
                    if (!ss) {
                        x = xtmp;
                        this.chain.add(x);
                        ss = this.cert_self_signed(x);
                    } else if (num == this.num_untrusted) {
                        if (!x.equals(xtmp)) {
                            ok = 0;
                        } else {
                            this.num_untrusted = --num;
                            x = xtmp;
                            this.chain.set(num, x);
                        }
                    }
                    if (ok != 0) {
                        if (this.num_untrusted > num) {
                            OpenSSL.debug(this + " assert failure (num_untrusted <= num)");
                            X509Error.addError(68);
                            trust = 2;
                            this.error = 1;
                            search = 0;
                            continue;
                        }
                        search = (short)(search & 0xFFFFFFFE);
                        trust = this.check_trust(num);
                        switch (trust) {
                            case 1: 
                            case 2: {
                                search = 0;
                                continue block7;
                            }
                        }
                        if (!ss) continue;
                    }
                }
                if ((search & 1) == 0) {
                    if ((search & 4) != 0 && --alt_untrusted > 0) continue;
                    if (!may_alternate || (search & 4) != 0 || this.num_untrusted < 2) break;
                    search = (short)(search | 4);
                    alt_untrusted = this.num_untrusted - 1;
                    ss = false;
                }
            }
            if ((search & 1) == 0) continue;
            num = this.chain.size();
            if (num != this.num_untrusted) {
                OpenSSL.debug(this + " assert failure (num == num_untrusted)");
                X509Error.addError(68);
                trust = 2;
                this.error = 1;
                search = 0;
                continue;
            }
            x = this.chain.get(num - 1);
            X509AuxCertificate x509AuxCertificate = xtmp = ss || depth < num ? null : this.find_issuer(sktmp, x);
            if (xtmp == null) {
                search = (short)(search & 0xFFFFFFFE);
                if (!may_trusted) continue;
                search = (short)(search | 2);
                continue;
            }
            sktmp.remove(xtmp);
            this.chain.add(xtmp);
            x = xtmp;
            ++this.num_untrusted;
            ss = this.cert_self_signed(xtmp);
            trust = 3;
        }
        if ((num = this.chain.size()) <= depth && trust == 3 && num == this.num_untrusted) {
            trust = this.check_trust(num);
        }
        switch (trust) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        num = this.chain.size();
        if (num > depth) {
            return this.verify_cb_cert(null, num - 1, 22);
        }
        if (ss && num == 1) {
            return this.verify_cb_cert(null, num - 1, 18);
        }
        if (ss) {
            return this.verify_cb_cert(null, num - 1, 19);
        }
        if (this.num_untrusted < num) {
            return this.verify_cb_cert(null, num - 1, 2);
        }
        return this.verify_cb_cert(null, num - 1, 20);
    }

    @Deprecated
    private X509AuxCertificate findIssuer(List<X509AuxCertificate> certs, X509AuxCertificate cert2, boolean check_time) throws Exception {
        for (X509AuxCertificate issuer2 : certs) {
            if (this.checkIssued.call(this, cert2, issuer2) == 0 || check_time && !this.x509_check_cert_time(issuer2, -1)) continue;
            return issuer2;
        }
        return null;
    }

    private X509AuxCertificate find_issuer(List<X509AuxCertificate> sk, X509AuxCertificate x) throws Exception {
        X509AuxCertificate rv = null;
        for (X509AuxCertificate issuer2 : sk) {
            if (this.checkIssued.call(this, x, issuer2) != 0 && this.x509_check_cert_time(rv = issuer2, -1)) break;
        }
        return rv;
    }

    private static boolean supportsCriticalExtension(String oid2) {
        return CRITICAL_EXTENSIONS.contains(oid2);
    }

    private static boolean unhandledCritical(X509Extension ext2) {
        Set<String> criticalOIDs = ext2.getCriticalExtensionOIDs();
        if (criticalOIDs == null || criticalOIDs.size() == 0) {
            return false;
        }
        for (String oid2 : criticalOIDs) {
            if (StoreContext.supportsCriticalExtension(oid2)) continue;
            return true;
        }
        return false;
    }

    public int checkChainExtensions() throws Exception {
        int proxy_path_length = 0;
        boolean allow_proxy_certs = (this.verifyParameter.flags & 0x40L) != 0L;
        int must_be_ca = -1;
        try {
            String allowProxyCerts = System.getenv("OPENSSL_ALLOW_PROXY_CERTS");
            if (allowProxyCerts != null && !"false".equalsIgnoreCase(allowProxyCerts)) {
                allow_proxy_certs = true;
            }
        }
        catch (SecurityException allowProxyCerts) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.num_untrusted; ++i2) {
            int ok;
            X509AuxCertificate x = this.chain.get(i2);
            if ((this.verifyParameter.flags & 0x10L) == 0L && StoreContext.unhandledCritical(x)) {
                this.error = 34;
                this.error_depth = i2;
                this.current_cert = x;
                ok = this.verifyCallback.call(this, ZERO);
                if (ok == 0) {
                    return ok;
                }
            }
            if (!allow_proxy_certs && x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                this.error = 40;
                this.error_depth = i2;
                this.current_cert = x;
                ok = this.verifyCallback.call(this, ZERO);
                if (ok == 0) {
                    return ok;
                }
            }
            int ret = Purpose.checkCA(x);
            switch (must_be_ca) {
                case -1: {
                    if ((this.verifyParameter.flags & 0x20L) != 0L && ret != 1 && ret != 0) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 0: {
                    if (ret != 0) {
                        ret = 0;
                        this.error = 37;
                        break;
                    }
                    ret = 1;
                    break;
                }
                default: {
                    if (ret == 0 || (this.verifyParameter.flags & 0x20L) != 0L && ret != 1) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                }
            }
            if (ret == 0) {
                this.error_depth = i2;
                this.current_cert = x;
                ok = this.verifyCallback.call(this, ZERO);
                if (ok == 0) {
                    return ok;
                }
            }
            if (this.verifyParameter.purpose > 0 && ((ret = Purpose.checkPurpose(x, this.verifyParameter.purpose, must_be_ca > 0 ? 1 : 0)) == 0 || (this.verifyParameter.flags & 0x20L) != 0L && ret != 1)) {
                this.error = 26;
                this.error_depth = i2;
                this.current_cert = x;
                ok = this.verifyCallback.call(this, ZERO);
                if (ok == 0) {
                    return ok;
                }
            }
            if (i2 > 1 && x.getBasicConstraints() != -1 && x.getBasicConstraints() != Integer.MAX_VALUE && i2 > x.getBasicConstraints() + proxy_path_length + 1) {
                this.error = 25;
                this.error_depth = i2;
                this.current_cert = x;
                ok = this.verifyCallback.call(this, ZERO);
                if (ok == 0) {
                    return ok;
                }
            }
            if (x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                int pcpathlen;
                ASN1Sequence pci = (ASN1Sequence)new ASN1InputStream(x.getExtensionValue("1.3.6.1.5.5.7.1.14")).readObject();
                if (pci.size() > 0 && pci.getObjectAt(0) instanceof ASN1Integer && i2 > (pcpathlen = ((ASN1Integer)pci.getObjectAt(0)).getValue().intValue())) {
                    this.error = 38;
                    this.error_depth = i2;
                    this.current_cert = x;
                    ok = this.verifyCallback.call(this, ZERO);
                    if (ok == 0) {
                        return ok;
                    }
                }
                ++proxy_path_length;
                must_be_ca = 0;
                continue;
            }
            must_be_ca = 1;
        }
        return 1;
    }

    private int check_purpose(X509AuxCertificate x, int purpose, int depth, byte must_be_ca) throws Exception {
        int tr_ok = 3;
        if (depth < this.num_untrusted || purpose == this.getParam().purpose) {
            // empty if block
        }
        block0 : switch (tr_ok) {
            case 1: {
                return 1;
            }
            case 2: {
                break;
            }
            default: {
                switch (Purpose.checkPurpose(x, this.getParam().purpose, must_be_ca > 0 ? 1 : 0)) {
                    case 1: {
                        return 1;
                    }
                    case 0: {
                        break block0;
                    }
                }
                if ((this.getParam().flags & 0x20L) != 0L) break;
                return 1;
            }
        }
        return this.verify_cb_cert(x, depth, 26);
    }

    private int check_chain_extensions() throws Exception {
        int purpose;
        boolean allow_proxy_certs;
        int plen = 0;
        int proxy_path_length = 0;
        int num = this.chain.size();
        byte must_be_ca = -1;
        if (this.parent != null) {
            allow_proxy_certs = false;
            purpose = 6;
        } else {
            allow_proxy_certs = (this.getParam().flags & 0x40L) != 0L;
            purpose = this.getParam().purpose;
        }
        for (int i2 = 0; i2 < num; ++i2) {
            byte[] ex_proxyCertInfo;
            X509AuxCertificate x = this.chain.get(i2);
            if ((this.getParam().flags & 0x10L) == 0L && StoreContext.unhandledCritical(x) && this.verify_cb_cert(x, i2, 34) == 0) {
                return 0;
            }
            if (!allow_proxy_certs && (x.getExFlags() & 0x400) != 0 && this.verify_cb_cert(x, i2, 40) == 0) {
                return 0;
            }
            int ret = Purpose.checkCA(x);
            switch (must_be_ca) {
                case -1: {
                    if ((this.getParam().flags & 0x20L) != 0L && ret != 1 && ret != 0) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 0: {
                    if (ret != 0) {
                        ret = 0;
                        this.error = 37;
                        break;
                    }
                    ret = 1;
                    break;
                }
                default: {
                    if (ret == 0 || (i2 + 1 < num || (this.getParam().flags & 0x20L) != 0L) && ret != 1) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                }
            }
            if (ret == 0 && this.verify_cb_cert(x, i2, 0) == 0) {
                return 0;
            }
            if (purpose > 0 && this.check_purpose(x, purpose, i2, must_be_ca) == 0) {
                return 0;
            }
            int ex_pathlen = x.getBasicConstraints();
            if (i2 > 1 && (x.getExFlags() & 0x20) == 0 && ex_pathlen != Integer.MAX_VALUE && ex_pathlen != -1 && plen > ex_pathlen + proxy_path_length + 1 && this.verify_cb_cert(x, i2, 25) == 0) {
                return 0;
            }
            if ((x.getExFlags() & 0x20) == 0) {
                ++plen;
            }
            if ((ex_proxyCertInfo = x.getExtensionValue("1.3.6.1.5.5.7.1.14")) != null) {
                int ex_pcpathlen;
                ASN1Sequence pci = (ASN1Sequence)new ASN1InputStream(ex_proxyCertInfo).readObject();
                if (pci.size() > 0 && pci.getObjectAt(0) instanceof ASN1Integer && (ex_pcpathlen = ((ASN1Integer)pci.getObjectAt(0)).getValue().intValue()) != -1) {
                    if (proxy_path_length > ex_pcpathlen && this.verify_cb_cert(x, i2, 38) == 0) {
                        return 0;
                    }
                    proxy_path_length = ex_pcpathlen;
                }
                ++proxy_path_length;
                must_be_ca = 0;
                continue;
            }
            must_be_ca = 1;
        }
        return 1;
    }

    private boolean cert_self_signed(X509AuxCertificate x) throws CertificateException, IOException {
        return (x.getExFlags() & 0x20) != 0;
    }

    @Deprecated
    private int checkTrust() throws Exception {
        int i2 = this.chain.size() - 1;
        X509AuxCertificate x = this.chain.get(i2);
        int ok = Trust.checkTrust(x, this.verifyParameter.trust, 0);
        if (ok == 1) {
            return 1;
        }
        this.error_depth = 1;
        this.current_cert = x;
        this.error = ok == 2 ? 28 : 27;
        return this.verifyCallback.call(this, ZERO);
    }

    private int check_trust(int num_untrusted) throws Exception {
        int trust;
        X509AuxCertificate x;
        int i2;
        int num = this.chain.size();
        for (i2 = num_untrusted; i2 < num; ++i2) {
            x = this.chain.get(i2);
            trust = Trust.checkTrust(x, this.getParam().trust, 0);
            if (trust == 1) {
                return 1;
            }
            if (trust != 2) continue;
            return this.check_trust_rejected(x, i2);
        }
        if (num_untrusted < num) {
            if ((this.getParam().flags & 0x80000L) != 0L) {
                return 1;
            }
            return 3;
        }
        if (num_untrusted == num && (this.getParam().flags & 0x80000L) != 0L) {
            i2 = 0;
            x = this.chain.get(i2);
            X509AuxCertificate mx = this.lookup_cert_match(x);
            if (mx == null) {
                return 3;
            }
            trust = Trust.checkTrust(mx, this.getParam().trust, 0);
            if (trust == 2) {
                return this.check_trust_rejected(x, i2);
            }
            this.chain.set(0, mx);
            this.num_untrusted = 0;
            return 1;
        }
        return 3;
    }

    private int check_trust_rejected(X509AuxCertificate x, int i2) throws Exception {
        if (this.verify_cb_cert(x, i2, 28) == 0) {
            return 2;
        }
        return 3;
    }

    boolean x509_check_cert_time(X509AuxCertificate x, int depth) throws Exception {
        Date pTime;
        if ((this.getParam().flags & 2L) != 0L) {
            pTime = this.getParam().checkTime;
        } else {
            if ((this.getParam().flags & 0x200000L) != 0L) {
                return true;
            }
            pTime = Calendar.getInstance().getTime();
        }
        int i2 = x.getNotBefore().compareTo(pTime);
        if (i2 >= 0 && depth < 0) {
            return false;
        }
        if (i2 == 0 && this.verify_cb_cert(x, depth, 13) == 0) {
            return false;
        }
        if (i2 > 0 && this.verify_cb_cert(x, depth, 9) == 0) {
            return false;
        }
        i2 = x.getNotAfter().compareTo(pTime);
        if (i2 <= 0 && depth < 0) {
            return false;
        }
        if (i2 == 0 && this.verify_cb_cert(x, depth, 14) == 0) {
            return false;
        }
        return i2 >= 0 || this.verify_cb_cert(x, depth, 10) != 0;
    }

    public int checkCertificate() throws Exception {
        X509AuxCertificate x;
        X509CRL[] crl2 = new X509CRL[1];
        int cnum = this.error_depth;
        this.current_cert = x = this.chain.get(cnum);
        this.current_issuer = null;
        if (x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
            return 1;
        }
        int ok = this.getCRL.call(this, crl2, x);
        if (ok == 0) {
            this.error = 3;
            ok = this.verifyCallback.call(this, ZERO);
            this.current_crl = null;
            return ok;
        }
        this.current_crl = crl2[0];
        ok = this.checkCRL.call(this, crl2[0]);
        if (ok == 0) {
            this.current_crl = null;
            return ok;
        }
        ok = this.certificateCRL.call(this, crl2[0], x);
        this.current_crl = null;
        return ok;
    }

    private boolean check_crl_time(X509CRL crl2, boolean notify) throws Exception {
        Date pTime;
        if (notify) {
            this.current_crl = crl2;
        }
        if ((this.getParam().flags & 2L) != 0L) {
            pTime = this.getParam().checkTime;
        } else {
            if ((this.getParam().flags & 0x200000L) != 0L) {
                return true;
            }
            pTime = Calendar.getInstance().getTime();
        }
        int i2 = crl2.getThisUpdate().compareTo(pTime);
        if (i2 == 0) {
            if (!notify) {
                return false;
            }
            if (this.verify_cb_crl(15) == 0) {
                return false;
            }
        }
        if (i2 > 0) {
            if (!notify) {
                return false;
            }
            if (this.verify_cb_crl(11) == 0) {
                return false;
            }
        }
        if (crl2.getNextUpdate() != null) {
            i2 = crl2.getNextUpdate().compareTo(pTime);
            if (i2 == 0) {
                if (!notify) {
                    return false;
                }
                if (this.verify_cb_crl(16) == 0) {
                    return false;
                }
            }
            if (i2 < 0) {
                if (!notify) {
                    return false;
                }
                if (this.verify_cb_crl(12) == 0) {
                    return false;
                }
            }
        }
        if (notify) {
            this.current_crl = null;
        }
        return true;
    }

    @Deprecated
    private int checkCRLTime(X509CRL crl2, int notify) throws Exception {
        this.current_crl = crl2;
        Date pTime = (this.getParam().flags & 2L) != 0L ? this.getParam().checkTime : Calendar.getInstance().getTime();
        if (!crl2.getThisUpdate().before(pTime)) {
            this.error = 11;
            if (notify == 0 || this.verifyCallback.call(this, ZERO) == 0) {
                return 0;
            }
        }
        if (crl2.getNextUpdate() != null && !crl2.getNextUpdate().after(pTime)) {
            this.error = 12;
            if (notify == 0 || this.verifyCallback.call(this, ZERO) == 0) {
                return 0;
            }
        }
        this.current_crl = null;
        return 1;
    }

    public int getCRLStack(X509CRL[] pcrl, Name name2, List<X509CRL> crls2) throws Exception {
        X509CRL bestCrl = null;
        if (crls2 != null) {
            for (X509CRL crl2 : crls2) {
                if (!name2.equalTo(crl2.getIssuerX500Principal())) continue;
                if (this.checkCRLTime(crl2, 0) != 0) {
                    pcrl[0] = crl2;
                    return 1;
                }
                bestCrl = crl2;
            }
        }
        if (bestCrl != null) {
            pcrl[0] = bestCrl;
        }
        return 0;
    }

    private X509AuxCertificate lookup_cert_match(X509AuxCertificate x) throws Exception {
        List<X509AuxCertificate> certs = this.lookup_certs.call(this, new Name(x.getSubjectX500Principal()));
        if (certs == null) {
            return null;
        }
        for (X509AuxCertificate xtmp : certs) {
            if (!xtmp.equals(x)) continue;
            return xtmp;
        }
        return null;
    }

    private int verify_cb_cert(X509AuxCertificate x, int depth, int err) throws Exception {
        this.error_depth = depth;
        X509AuxCertificate x509AuxCertificate = this.current_cert = x != null ? x : this.chain.get(depth);
        if (err != 0) {
            this.error = err;
        }
        return this.verifyCallback.call(this, 0);
    }

    private int verify_cb_crl(int err) throws Exception {
        this.error = err;
        return this.verifyCallback.call(this, 0);
    }

    private int internal_verify() throws Exception {
        X509AuxCertificate xs;
        int n = this.chain.size() - 1;
        X509AuxCertificate xi = this.chain.get(n);
        if (this.checkIssued.call(this, xi, xi) != 0) {
            xs = xi;
        } else {
            if ((this.getParam().flags & 0x80000L) != 0L) {
                xs = xi;
                if (!StoreContext.internal_verify_check_cert(this, xi, xs, n)) {
                    return 0;
                }
                if (--n >= 0) {
                    xi = xs;
                }
            }
            if (n <= 0) {
                return this.verify_cb_cert(xi, 0, 21);
            }
            this.error_depth = --n;
            xs = this.chain.get(n);
        }
        while (n >= 0) {
            PublicKey pkey;
            if ((xs != xi || (this.getParam().flags & 0x4000L) != 0L) && ((pkey = xi.getPublicKey()) == null ? this.verify_cb_cert(xi, xi != xs ? n + 1 : n, 6) == 0 : !StoreContext.X509_verify(xs, pkey) && this.verify_cb_cert(xs, n, 7) == 0)) {
                return 0;
            }
            if (!StoreContext.internal_verify_check_cert(this, xi, xs, n)) {
                return 0;
            }
            if (--n < 0) continue;
            xi = xs;
            xs = this.chain.get(n);
        }
        return 1;
    }

    private static boolean internal_verify_check_cert(StoreContext ctx, X509AuxCertificate xi, X509AuxCertificate xs, int n) throws Exception {
        if (!ctx.x509_check_cert_time(xs, n)) {
            return false;
        }
        ctx.current_issuer = xi;
        ctx.current_cert = xs;
        ctx.error_depth = n;
        return ctx.verifyCallback.call(ctx, 1) != 0;
    }

    private static boolean X509_verify(X509AuxCertificate xs, PublicKey pkey) {
        if (xs.verified) {
            return true;
        }
        try {
            xs.verify(pkey);
        }
        catch (Exception e) {
            return false;
        }
        xs.verified = true;
        return true;
    }

    private int check_crl(X509CRL crl2) throws Exception {
        block12: {
            X509AuxCertificate issuer2;
            int cnum = this.error_depth;
            int chnum = this.chain.size() - 1;
            if (this.current_issuer != null) {
                issuer2 = this.current_issuer;
            } else if (cnum < chnum) {
                issuer2 = this.chain.get(cnum + 1);
            } else {
                issuer2 = this.chain.get(chnum);
                if (this.checkIssued.call(this, issuer2, issuer2) == 0 && this.verify_cb_crl(33) == 0) {
                    return 0;
                }
            }
            if (issuer2 == null) {
                return 1;
            }
            if (issuer2.getKeyUsage() != null && !issuer2.getKeyUsage()[6] && this.verify_cb_crl(35) == 0) {
                return 0;
            }
            if (!this.check_crl_time(crl2, true)) {
                return 0;
            }
            PublicKey ikey = issuer2.getPublicKey();
            if (ikey == null && this.verify_cb_crl(6) == 0) {
                return 0;
            }
            if (ikey != null) {
                try {
                    SecurityHelper.verify(crl2, ikey);
                }
                catch (GeneralSecurityException ex) {
                    if (this.verify_cb_crl(8) != 0) break block12;
                    return 0;
                }
            }
        }
        return 1;
    }

    static {
        String verify2 = SafePropertyAccessor.getProperty((String)"jruby.openssl.x509.store.verify");
        VERIFY_LEGACY = "legacy".equals(verify2);
        CRITICAL_EXTENSIONS = new HashSet<String>(8);
        CRITICAL_EXTENSIONS.add("2.16.840.1.113730.1.1");
        CRITICAL_EXTENSIONS.add("2.5.29.15");
        CRITICAL_EXTENSIONS.add("2.5.29.17");
        CRITICAL_EXTENSIONS.add("2.5.29.19");
        CRITICAL_EXTENSIONS.add("2.5.29.37");
        CRITICAL_EXTENSIONS.add("1.3.6.1.5.5.7.1.14");
        getFirstIssuer = new Store.GetIssuerFunction(){

            @Override
            public int call(StoreContext context2, X509AuxCertificate[] issuer2, X509AuxCertificate cert2) throws Exception {
                return context2.getFirstIssuer(issuer2, cert2);
            }
        };
        getIssuerStack = new Store.GetIssuerFunction(){

            @Override
            public int call(StoreContext context2, X509AuxCertificate[] issuer2, X509AuxCertificate x) throws Exception {
                issuer2[0] = context2.findIssuer(context2.otherContext, x, false);
                if (issuer2[0] != null) {
                    return 1;
                }
                return 0;
            }
        };
        check_issued = new Store.CheckIssuedFunction(){

            @Override
            public int call(StoreContext ctx, X509AuxCertificate x, X509AuxCertificate issuer2) throws Exception {
                if (x.equals(issuer2)) {
                    return ctx.cert_self_signed(x) ? 1 : 0;
                }
                int ret = X509Utils.checkIfIssuedBy(issuer2, x);
                if (ret == 0 && ctx.cert_self_signed(x) && ctx.chain.size() == 1) {
                    return 1;
                }
                return ret == 0 ? 1 : 0;
            }
        };
        check_issued_legacy = new Store.CheckIssuedFunction(){

            @Override
            public int call(StoreContext context2, X509AuxCertificate cert2, X509AuxCertificate issuer2) throws Exception {
                int ret = X509Utils.checkIfIssuedBy(issuer2, cert2);
                if (ret == 0) {
                    return 1;
                }
                if ((((StoreContext)context2).verifyParameter.flags & 0L) == 0L) {
                    return 0;
                }
                context2.error = ret;
                context2.current_cert = cert2;
                context2.current_issuer = issuer2;
                return context2.verifyCallback.call(context2, ZERO);
            }
        };
        nullCallback = new Store.VerifyCallbackFunction(){

            @Override
            public int call(StoreContext context2, Integer outcome) {
                return outcome;
            }
        };
        internalVerify = new Store.VerifyFunction(){

            @Override
            public int call(StoreContext context2) throws Exception {
                int ok;
                Store.VerifyCallbackFunction verifyCallback = context2.verifyCallback;
                int n = context2.chain.size();
                context2.error_depth = n - 1;
                X509AuxCertificate xi = (X509AuxCertificate)context2.chain.get(--n);
                X509AuxCertificate xs = null;
                if (context2.checkIssued.call(context2, xi, xi) != 0) {
                    xs = xi;
                } else {
                    if (n <= 0) {
                        context2.error = 21;
                        context2.current_cert = xi;
                        int ok2 = verifyCallback.call(context2, ZERO);
                        return ok2;
                    }
                    context2.error_depth = --n;
                    xs = (X509AuxCertificate)context2.chain.get(n);
                }
                while (n >= 0) {
                    context2.error_depth = n;
                    if (!StoreContext.X509_verify(xs, xi.getPublicKey())) {
                        context2.error = 7;
                        context2.current_cert = xs;
                        ok = verifyCallback.call(context2, ZERO);
                        if (ok == 0) {
                            return ok;
                        }
                    }
                    if (!StoreContext.internal_verify_check_cert(context2, xi, xs, n)) {
                        return 0;
                    }
                    if (--n < 0) continue;
                    xi = xs;
                    xs = (X509AuxCertificate)context2.chain.get(n);
                }
                ok = 1;
                return ok;
            }
        };
        check_revocation = new Store.CheckRevocationFunction(){

            @Override
            public int call(StoreContext ctx) throws Exception {
                int last;
                if ((ctx.getParam().flags & 4L) == 0L) {
                    return 1;
                }
                if ((ctx.getParam().flags & 8L) != 0L) {
                    last = ctx.chain.size() - 1;
                } else {
                    if (ctx.parent != null) {
                        return 1;
                    }
                    last = 0;
                }
                int i2 = 0;
                while (i2 <= last) {
                    ctx.error_depth = i2++;
                    int ok = ctx.checkCertificate();
                    if (ok != 0) continue;
                    return 0;
                }
                return 1;
            }
        };
        defaultGetCRL = new Store.GetCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL[] crls2, X509AuxCertificate x) throws Exception {
                X509CRL[] crl2 = new X509CRL[1];
                Name name2 = new Name(x.getIssuerX500Principal());
                int ok = context2.getCRLStack(crl2, name2, context2.crls);
                if (ok != 0) {
                    crls2[0] = crl2[0];
                    return 1;
                }
                X509Object[] xobj = new X509Object[1];
                ok = context2.getBySubject(2, name2, xobj);
                if (ok == 0) {
                    if (crl2[0] != null) {
                        crls2[0] = crl2[0];
                        return 1;
                    }
                    return 0;
                }
                crls2[0] = (X509CRL)((CRL)xobj[0]).crl;
                return 1;
            }
        };
        check_crl = new Store.CheckCRLFunction(){

            @Override
            public int call(StoreContext ctx, X509CRL crl2) throws Exception {
                return ctx.check_crl(crl2);
            }
        };
        check_crl_legacy = new Store.CheckCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL crl2) throws Exception {
                block13: {
                    int ok;
                    X509AuxCertificate issuer2;
                    int errorDepth = context2.error_depth;
                    int lastInChain = context2.chain.size() - 1;
                    if (errorDepth < lastInChain) {
                        issuer2 = (X509AuxCertificate)context2.chain.get(errorDepth + 1);
                    } else {
                        issuer2 = (X509AuxCertificate)context2.chain.get(lastInChain);
                        if (context2.checkIssued.call(context2, issuer2, issuer2) == 0) {
                            context2.error = 33;
                            ok = context2.verifyCallback.call(context2, ZERO);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                    }
                    if (issuer2 != null) {
                        PublicKey ikey;
                        if (issuer2.getKeyUsage() != null && !issuer2.getKeyUsage()[6]) {
                            context2.error = 35;
                            ok = context2.verifyCallback.call(context2, ZERO);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                        if ((ikey = issuer2.getPublicKey()) == null) {
                            context2.error = 6;
                            ok = context2.verifyCallback.call(context2, ZERO);
                            if (ok == 0) {
                                return ok;
                            }
                        } else {
                            try {
                                SecurityHelper.verify(crl2, ikey);
                            }
                            catch (GeneralSecurityException ex) {
                                context2.error = 8;
                                ok = context2.verifyCallback.call(context2, ZERO);
                                if (ok != 0) break block13;
                                return ok;
                            }
                        }
                    }
                }
                if (!context2.check_crl_time(crl2, true)) {
                    return 0;
                }
                return 1;
            }
        };
        defaultCertificateCRL = new Store.CertificateCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL crl2, X509AuxCertificate x) throws Exception {
                int ok;
                if (crl2.getRevokedCertificate(x.getSerialNumber()) != null) {
                    context2.error = 23;
                    ok = context2.verifyCallback.call(context2, ZERO);
                    if (ok == 0) {
                        return 0;
                    }
                }
                if ((((StoreContext)context2).verifyParameter.flags & 0x10L) != 0L) {
                    return 1;
                }
                if (crl2.getCriticalExtensionOIDs() != null && crl2.getCriticalExtensionOIDs().size() > 0) {
                    context2.error = 36;
                    ok = context2.verifyCallback.call(context2, ZERO);
                    if (ok == 0) {
                        return 0;
                    }
                }
                return 1;
            }
        };
        check_policy = new CheckPolicyFunction(){

            @Override
            public int call(StoreContext context2) throws Exception {
                return 1;
            }
        };
    }

    static interface CheckPolicyFunction
    extends Function1<StoreContext> {
    }
}

