/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.internals.NokogiriHelpers;
import org.cyberneko.dtd.DTDConfiguration;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::ElementContent"})
public class XmlElementContent
extends RubyObject {
    protected String element_name = null;
    protected String name;
    protected Type type;
    protected Occur occur;
    protected IRubyObject left;
    protected IRubyObject right;

    public XmlElementContent(Ruby ruby, RubyClass rubyClass, XmlDocument xmlDocument, Node node) {
        this(ruby, rubyClass, xmlDocument, new NodeIter(node));
        this.element_name = ((Element)node).getAttribute("ename");
        if (!this.left.isNil()) {
            XmlElementContent xmlElementContent = (XmlElementContent)this.left;
            if (this.type == Type.SEQ && this.occur == Occur.ONCE && xmlElementContent.type == Type.ELEMENT && this.right.isNil()) {
                this.name = xmlElementContent.name;
                this.type = xmlElementContent.type;
                this.occur = xmlElementContent.occur;
                this.left = this.right;
            }
        }
    }

    public XmlElementContent(Ruby ruby, XmlDocument xmlDocument, Node node) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::ElementContent"), xmlDocument, node);
    }

    public XmlElementContent(Ruby ruby, RubyClass rubyClass, XmlDocument xmlDocument, NodeIter nodeIter) {
        super(ruby, rubyClass);
        this.setInstanceVariable("@document", (IRubyObject)xmlDocument);
        this.name = null;
        this.type = Type.SEQ;
        this.occur = Occur.ONCE;
        this.left = ruby.getNil();
        this.right = ruby.getNil();
        this.apply(ruby, rubyClass, xmlDocument, nodeIter);
    }

    protected XmlElementContent(Ruby ruby, RubyClass rubyClass, Type type, XmlDocument xmlDocument, NodeIter nodeIter, XmlElementContent xmlElementContent) {
        super(ruby, rubyClass);
        this.setInstanceVariable("@document", (IRubyObject)xmlDocument);
        this.name = null;
        this.type = type;
        this.occur = Occur.ONCE;
        this.left = xmlElementContent;
        this.right = ruby.getNil();
        switch (type) {
            case SEQ: 
            case OR: {
                this.applyGroup(ruby, rubyClass, xmlDocument, nodeIter);
            }
        }
    }

    protected void apply(Ruby ruby, RubyClass rubyClass, XmlDocument xmlDocument, NodeIter nodeIter) {
        if (nodeIter.isNull()) {
            return;
        }
        Element element = (Element)nodeIter.current();
        if (XmlElementContent.isGroup(element) && nodeIter.hasChildren()) {
            nodeIter.firstChild();
            this.applyGroup(ruby, rubyClass, xmlDocument, nodeIter);
            nodeIter.parent();
        } else if (XmlElementContent.isElement(element)) {
            this.name = element.getAttribute("name");
            this.type = Type.ELEMENT;
        }
        nodeIter.nextSibling();
        if (nodeIter.isNull()) {
            return;
        }
        if (XmlElementContent.isOccurrence(nodeIter.current())) {
            this.setOccur(((Element)nodeIter.current()).getAttribute("type"));
            nodeIter.nextSibling();
        }
    }

    protected void applyGroup(Ruby ruby, RubyClass rubyClass, XmlDocument xmlDocument, NodeIter nodeIter) {
        if (nodeIter.isNull()) {
            return;
        }
        if (this.left.isNil()) {
            this.left = new XmlElementContent(ruby, rubyClass, xmlDocument, nodeIter);
            if (nodeIter.isNull()) {
                return;
            }
            if (XmlElementContent.isSeparator(nodeIter.current())) {
                this.setType(((Element)nodeIter.current()).getAttribute("type"));
                nodeIter.nextSibling();
            }
        }
        if (nodeIter.isNull()) {
            return;
        }
        this.right = new XmlElementContent(ruby, rubyClass, xmlDocument, nodeIter);
        if (nodeIter.isNull()) {
            return;
        }
        if (XmlElementContent.isSeparator(nodeIter.current())) {
            nodeIter.nextSibling();
        }
        if (nodeIter.isNull()) {
            return;
        }
        this.right = new XmlElementContent(ruby, rubyClass, this.type, xmlDocument, nodeIter, (XmlElementContent)this.right);
    }

    protected void setType(String string) {
        if ("|".equals(string)) {
            this.type = Type.OR;
        } else if (",".equals(string)) {
            this.type = Type.SEQ;
        }
    }

    protected void setOccur(String string) {
        if ("*".equals(string)) {
            this.occur = Occur.MULT;
        } else if ("+".equals(string)) {
            this.occur = Occur.PLUS;
        }
    }

    public static boolean isGroup(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_GROUP);
    }

    public static boolean isElement(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_ELEMENT);
    }

    public static boolean isSeparator(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_SEPARATOR);
    }

    public static boolean isOccurrence(Node node) {
        return XmlDtd.nameEquals(node, DTDConfiguration.E_OCCURRENCE);
    }

    public IRubyObject element_name(ThreadContext threadContext) {
        return NokogiriHelpers.nonEmptyStringOrNil(threadContext.getRuntime(), this.element_name);
    }

    @JRubyMethod
    public IRubyObject prefix(ThreadContext threadContext) {
        return NokogiriHelpers.nonEmptyStringOrNil(threadContext.getRuntime(), NokogiriHelpers.getPrefix(this.name));
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext threadContext) {
        return NokogiriHelpers.nonEmptyStringOrNil(threadContext.getRuntime(), NokogiriHelpers.getLocalPart(this.name));
    }

    @JRubyMethod
    public IRubyObject type(ThreadContext threadContext) {
        return this.type.value(threadContext.getRuntime());
    }

    @JRubyMethod
    public IRubyObject occur(ThreadContext threadContext) {
        return this.occur.value(threadContext.getRuntime());
    }

    @JRubyMethod
    public IRubyObject c1(ThreadContext threadContext) {
        return this.left;
    }

    @JRubyMethod
    public IRubyObject c2(ThreadContext threadContext) {
        return this.right;
    }

    protected static class NodeIter {
        protected Node pre = null;
        protected Node cur;

        public NodeIter(Node node) {
            this.cur = node.getFirstChild();
        }

        public Node current() {
            return this.cur;
        }

        public boolean isNull() {
            return this.cur == null;
        }

        public boolean hasChildren() {
            return this.cur != null && this.cur.hasChildNodes();
        }

        public Node firstChild() {
            if (this.cur == null) {
                throw new RuntimeException("no children");
            }
            Node node = this.cur.getFirstChild();
            if (node == null) {
                throw new RuntimeException("no children");
            }
            this.cur = node;
            return this.cur;
        }

        public Node nextSibling() {
            if (this.cur == null) {
                throw new RuntimeException("no next sibling");
            }
            Node node = this.cur.getNextSibling();
            if (node == null) {
                this.pre = this.cur;
                this.cur = null;
            } else {
                this.cur = node;
            }
            return this.cur;
        }

        public Node parent() {
            Node node;
            if (this.cur == null) {
                this.cur = this.pre;
            }
            if ((node = this.cur.getParentNode()) == null) {
                throw new RuntimeException("no parent");
            }
            this.cur = node;
            return this.cur;
        }
    }

    public static enum Type {
        PCDATA(1),
        ELEMENT(2),
        SEQ(3),
        OR(4);

        private final int value;

        private Type(int n2) {
            this.value = n2;
        }

        public IRubyObject value(Ruby ruby) {
            return ruby.newFixnum(this.value);
        }
    }

    public static enum Occur {
        ONCE(1),
        OPT(2),
        MULT(3),
        PLUS(4);

        private final int value;

        private Occur(int n2) {
            this.value = n2;
        }

        public IRubyObject value(Ruby ruby) {
            return ruby.newFixnum(this.value);
        }
    }
}

