/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.expression;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.CompiledPipeline;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.expression.BinaryBooleanExpression;
import org.logstash.config.ir.expression.Expression;
import org.logstash.config.ir.expression.RegexValueExpression;
import org.logstash.config.ir.expression.UnaryBooleanExpression;
import org.logstash.config.ir.expression.ValueExpression;
import org.logstash.plugins.ConfigVariableExpander;

public class ExpressionSubstitution {
    public static Expression substituteBoolExpression(ConfigVariableExpander cve, Expression expression) {
        try {
            if (expression instanceof BinaryBooleanExpression) {
                BinaryBooleanExpression binaryBoolExp = (BinaryBooleanExpression)expression;
                Expression substitutedLeftExp = ExpressionSubstitution.substituteBoolExpression(cve, binaryBoolExp.getLeft());
                Expression substitutedRightExp = ExpressionSubstitution.substituteBoolExpression(cve, binaryBoolExp.getRight());
                if (substitutedLeftExp != binaryBoolExp.getLeft() || substitutedRightExp != binaryBoolExp.getRight()) {
                    Constructor<?> constructor = binaryBoolExp.getClass().getConstructor(SourceWithMetadata.class, Expression.class, Expression.class);
                    return (Expression)constructor.newInstance(binaryBoolExp.getSourceWithMetadata(), substitutedLeftExp, substitutedRightExp);
                }
            } else if (expression instanceof UnaryBooleanExpression) {
                UnaryBooleanExpression unaryBoolExp = (UnaryBooleanExpression)expression;
                Expression substitutedExp = ExpressionSubstitution.substituteBoolExpression(cve, unaryBoolExp.getExpression());
                if (substitutedExp != unaryBoolExp.getExpression()) {
                    Constructor<?> constructor = unaryBoolExp.getClass().getConstructor(SourceWithMetadata.class, Expression.class);
                    return (Expression)constructor.newInstance(unaryBoolExp.getSourceWithMetadata(), substitutedExp);
                }
            } else if (expression instanceof ValueExpression && !(expression instanceof RegexValueExpression) && ((ValueExpression)expression).get() != null) {
                String key = "placeholder";
                ImmutableMap args = ImmutableMap.of((Object)"placeholder", (Object)((ValueExpression)expression).get());
                Map<String, Object> substitutedArgs = CompiledPipeline.expandConfigVariables(cve, (Map<String, Object>)args);
                return new ValueExpression(expression.getSourceWithMetadata(), substitutedArgs.get("placeholder"));
            }
            return expression;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | InvalidIRException e) {
            throw new IllegalStateException("Unable to instantiate substituted condition expression", e);
        }
    }
}

