/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import org.snmp4j.AbstractTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class CommunityTarget
extends AbstractTarget {
    static final long serialVersionUID = 147443821594052003L;

    public CommunityTarget() {
        this.setVersion(0);
        this.setSecurityLevel(1);
        this.setSecurityModel(1);
    }

    public CommunityTarget(Address address, OctetString community) {
        super(address, community);
        this.setVersion(0);
        this.setSecurityLevel(1);
        this.setSecurityModel(1);
    }

    public OctetString getCommunity() {
        return this.getSecurityName();
    }

    public void setCommunity(OctetString community) {
        if (community == null) {
            throw new IllegalArgumentException("Community must not be null");
        }
        this.setSecurityName(community);
    }

    @Override
    public int getSecurityModel() {
        switch (this.getVersion()) {
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    @Override
    public void setSecurityLevel(int securityLevel) {
        if (securityLevel != 1) {
            throw new IllegalArgumentException("CommunityTarget only supports SecurityLevel.NOAUTH_NOPRIV");
        }
        super.setSecurityLevel(securityLevel);
    }

    @Override
    public void setSecurityModel(int securityModel) {
        switch (securityModel) {
            case 1: {
                super.setSecurityModel(securityModel);
                super.setVersion(0);
                break;
            }
            case 2: {
                super.setSecurityModel(securityModel);
                super.setVersion(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("To set security model for a CommunityTarget, use setVersion");
            }
        }
    }

    @Override
    public String toString() {
        return "CommunityTarget[" + this.toStringAbstractTarget() + ']';
    }
}

