/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.Serializable;
import org.snmp4j.CertifiedIdentity;
import org.snmp4j.SecureTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TlsAddress;

public class CertifiedTarget
extends SecureTarget
implements CertifiedIdentity,
Serializable {
    private static final long serialVersionUID = 1L;
    private OctetString serverFingerprint;
    private OctetString clientFingerprint;

    public CertifiedTarget(OctetString identity) {
        super(new TlsAddress(), identity);
    }

    public CertifiedTarget(Address address, OctetString identity, OctetString serverFingerprint, OctetString clientFingerprint) {
        super(address, identity);
        this.serverFingerprint = serverFingerprint;
        this.clientFingerprint = clientFingerprint;
    }

    @Override
    public OctetString getServerFingerprint() {
        return this.serverFingerprint;
    }

    @Override
    public OctetString getClientFingerprint() {
        return this.clientFingerprint;
    }

    @Override
    public OctetString getIdentity() {
        return super.getSecurityName();
    }

    @Override
    public String toString() {
        return "CertifiedTarget[" + this.toStringAbstractTarget() + ", serverFingerprint=" + this.serverFingerprint + ", clientFingerprint=" + this.clientFingerprint + ']';
    }
}

