/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph.algorithms;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.graph.Edge;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.Vertex;

public class GraphDiff {
    public static DiffResult diff(Graph left, Graph right) {
        List<Edge> removedEdges = left.edges().filter(e -> !right.hasEquivalentEdge((Edge)e)).collect(Collectors.toList());
        List<Vertex> removedVertices = left.vertices().filter(v -> !right.hasEquivalentVertex((Vertex)v)).collect(Collectors.toList());
        List<Edge> addedEdges = right.edges().filter(e -> !left.hasEquivalentEdge((Edge)e)).collect(Collectors.toList());
        List<Vertex> addedVertices = right.vertices().filter(v -> !left.hasEquivalentVertex((Vertex)v)).collect(Collectors.toList());
        return new DiffResult(removedEdges, addedEdges, removedVertices, addedVertices);
    }

    public static class DiffResult {
        private final List<Vertex> removedVertices;
        private final List<Vertex> addedVertices;
        private final Collection<Edge> removedEdges;
        private final Collection<Edge> addedEdges;

        public Collection<Edge> getRemovedEdges() {
            return this.removedEdges;
        }

        public Collection<Edge> getAddedEdges() {
            return this.addedEdges;
        }

        public Collection<Vertex> getRemovedVertices() {
            return this.removedVertices;
        }

        public Collection<Vertex> getAddedVertices() {
            return this.addedVertices;
        }

        public DiffResult(Collection<Edge> removedEdges, Collection<Edge> addedEdges, List<Vertex> removedVertices, List<Vertex> addedVertices) {
            this.removedEdges = removedEdges;
            this.addedEdges = addedEdges;
            this.removedVertices = removedVertices;
            this.addedVertices = addedVertices;
        }

        public String summary() {
            String template = "(-%d,+%d Edges | -%d,+%d Vertices)";
            return String.format(template, this.removedEdges.size(), this.addedEdges.size(), this.removedVertices.size(), this.addedVertices.size());
        }

        public boolean hasSameEdges() {
            return this.addedEdges.isEmpty() && this.removedEdges.isEmpty();
        }

        public boolean hasSameVertices() {
            return this.addedVertices.isEmpty() && this.removedVertices.isEmpty();
        }

        public boolean isIdentical() {
            return this.hasSameEdges() && this.hasSameVertices();
        }

        public String toString() {
            if (this.isIdentical()) {
                return "Identical Graphs";
            }
            StringBuilder output = new StringBuilder();
            output.append(this.summary());
            if (!this.hasSameEdges()) {
                output.append("\n");
                output.append(DiffResult.detailedDiffFor("Edges", this.removedEdges, this.addedEdges));
            }
            if (!this.hasSameVertices()) {
                output.append("\n");
                output.append(DiffResult.detailedDiffFor("Vertices", this.removedVertices, this.addedVertices));
            }
            output.append("\n");
            return output.toString();
        }

        private static String detailedDiffFor(String name, Collection<? extends SourceComponent> removed, Collection<? extends SourceComponent> added) {
            return name + " GraphDiff: \n--------------------------\n" + Stream.concat(removed.stream().map(c -> '-' + c.toString()), added.stream().map(c -> '+' + c.toString())).map(Object::toString).collect(Collectors.joining("\n")) + "\n--------------------------";
        }
    }
}

