/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import java.util.EnumSet;
import java.util.Set;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class RubyWarnings
implements IRubyWarnings,
WarnCallback {
    private final Ruby runtime;
    private final Set<IRubyWarnings.ID> oncelers = EnumSet.allOf(IRubyWarnings.ID.class);

    public RubyWarnings(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public static RubyModule createWarningModule(Ruby runtime2) {
        RubyModule warning = runtime2.defineModule("Warning");
        warning.defineAnnotatedMethods(RubyWarnings.class);
        warning.extend_object(warning);
        return warning;
    }

    @Override
    public void warn(String message2) {
        this.warn(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public Ruby getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isVerbose() {
        return this.runtime.isVerbose();
    }

    @Override
    @Deprecated
    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.warn(id2, position.getFile(), position.getLine(), message2);
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(':').append(lineNumber + 1).append(": ");
        buffer.append("warning: ").append(message2).append('\n');
        RubyString errorString = this.runtime.newString(buffer.toString());
        RubyWarnings.writeWarningDyncall(this.runtime.getCurrentContext(), errorString);
    }

    public static void writeWarningDyncall(ThreadContext context, RubyString errorString) {
        RubyModule warning = context.runtime.getWarning();
        RubyWarnings.sites((ThreadContext)context).warn.call(context, (IRubyObject)warning, (IRubyObject)warning, (IRubyObject)errorString);
    }

    public static void writeWarningToError(ThreadContext context, RubyString errorString) {
        Ruby runtime2 = context.runtime;
        IRubyObject errorStream = runtime2.getGlobalVariables().get("$stderr");
        RubyModule warning = runtime2.getWarning();
        RubyWarnings.sites((ThreadContext)context).write.call(context, (IRubyObject)warning, errorStream, (IRubyObject)errorString);
    }

    @Override
    public void warn(IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        RubyStackTraceElement stack = this.runtime.getCurrentContext().getSingleBacktrace();
        if (stack == null) {
            file2 = "(unknown)";
            line = 0;
        } else {
            file2 = stack.getFileName();
            line = stack.getLineNumber();
        }
        this.warn(id2, file2, line - 1, message2);
    }

    public void warn(String filename2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(filename2).append(": ").append(message2).append('\n');
        RubyString errorString = this.runtime.newString(buffer.toString());
        RubyWarnings.writeWarningDyncall(this.runtime.getCurrentContext(), errorString);
    }

    public void warnOnce(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        if (this.oncelers.contains((Object)id2)) {
            return;
        }
        this.oncelers.add(id2);
        this.warn(id2, message2);
    }

    public void warning(String message2) {
        if (!this.isVerbose()) {
            return;
        }
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        this.warning(IRubyWarnings.ID.MISCELLANEOUS, message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String message2) {
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        RubyWarnings.writeWarning(this.runtime, id2, message2);
    }

    private static void writeWarning(Ruby runtime2, IRubyWarnings.ID id2, String message2) {
        int line;
        String file2;
        RubyStackTraceElement stack = runtime2.getCurrentContext().getSingleBacktrace();
        if (stack == null) {
            file2 = "(unknown)";
            line = -1;
        } else {
            file2 = stack.getFileName();
            line = stack.getLineNumber();
        }
        runtime2.getWarnings().warning(id2, file2, line, message2);
    }

    @Override
    @Deprecated
    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2) {
        this.warning(id2, position.getFile(), position.getLine(), message2);
    }

    @Override
    public void warning(IRubyWarnings.ID id2, String fileName, int lineNumber, String message2) {
        if (!this.runtime.warningsEnabled() || !this.runtime.isVerbose()) {
            return;
        }
        this.warn(id2, fileName, lineNumber, message2);
    }

    @JRubyMethod
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.warningsEnabled()) {
            return context.nil;
        }
        TypeConverter.checkType(context, arg2, runtime2.getString());
        RubyString str = (RubyString)arg2;
        if (!str.getEncoding().isAsciiCompatible()) {
            throw runtime2.newEncodingCompatibilityError("ASCII incompatible encoding: " + str.getEncoding());
        }
        RubyWarnings.writeWarningToError(runtime2.getCurrentContext(), str);
        return context.nil;
    }

    private static JavaSites.WarningSites sites(ThreadContext context) {
        return context.sites.Warning;
    }

    @Override
    @Deprecated
    public void warn(IRubyWarnings.ID id2, String fileName, String message2) {
        if (!this.runtime.warningsEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append(fileName).append(' ');
        buffer.append("warning: ").append(message2).append('\n');
        IRubyObject errorStream = this.runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(this.runtime.getCurrentContext(), "write", this.runtime.newString(buffer.toString()));
    }
}

