/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.security.cert.X509Certificate;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class TlsX509CertifiedTarget
extends CertifiedTarget {
    private static final long serialVersionUID = -1980959130605037036L;
    private TlsTmSecurityCallback<X509Certificate> tlsTmSecurityCallback;

    public TlsX509CertifiedTarget(Address address, OctetString identity, OctetString serverFingerprint, OctetString clientFingerprint, TlsTmSecurityCallback<X509Certificate> tlsTmSecurityCallback) {
        super(address, identity, serverFingerprint, clientFingerprint);
        this.tlsTmSecurityCallback = tlsTmSecurityCallback;
    }

    public TlsTmSecurityCallback<X509Certificate> getTlsTmSecurityCallback() {
        return this.tlsTmSecurityCallback;
    }

    @Override
    public Target duplicate() {
        TlsX509CertifiedTarget copy = new TlsX509CertifiedTarget(this.getAddress(), this.getIdentity(), this.getServerFingerprint(), this.getClientFingerprint(), this.tlsTmSecurityCallback);
        copy.setRetries(this.getRetries());
        copy.setTimeout(this.getTimeout());
        copy.setMaxSizeRequestPDU(this.getMaxSizeRequestPDU());
        copy.setPreferredTransports(this.getPreferredTransports());
        copy.setVersion(this.getVersion());
        copy.setSecurityLevel(this.getSecurityLevel());
        copy.setSecurityModel(this.getSecurityModel());
        return copy;
    }
}

