/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.binding.ClassInitializer;
import org.jruby.javasupport.binding.InterfaceInitializer;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class Initializer {
    static final Logger LOG = LoggerFactory.getLogger(Initializer.class);
    protected final Ruby runtime;
    protected final JavaSupport javaSupport;
    protected final Class javaClass;
    @Deprecated
    public static final ClassValue<Method[]> DECLARED_METHODS = MethodGatherer.DECLARED_METHODS;

    public Initializer(Ruby runtime2, Class javaClass) {
        this.runtime = runtime2;
        this.javaSupport = runtime2.getJavaSupport();
        this.javaClass = javaClass;
    }

    public static RubyModule setupProxyClass(Ruby runtime2, Class<?> javaClass, RubyClass proxy2) {
        Initializer.setJavaClassFor(javaClass, proxy2);
        proxy2.setReifiedClass(javaClass);
        if (javaClass.isArray()) {
            Initializer.flagAsJavaProxy(proxy2);
            return proxy2;
        }
        if (javaClass.isPrimitive()) {
            RubyClass proxySingleton = proxy2.getSingletonClass();
            proxySingleton.undefineMethod("new");
            if (javaClass == Void.TYPE) {
                proxySingleton.undefineMethod("[]");
                proxySingleton.undefineMethod("new_array");
            }
            Initializer.flagAsJavaProxy(proxy2);
            return proxy2;
        }
        proxy2 = new ClassInitializer(runtime2, javaClass).initialize(proxy2);
        Initializer.flagAsJavaProxy(proxy2);
        return proxy2;
    }

    public static RubyModule setupProxyModule(Ruby runtime2, Class<?> javaClass, RubyModule proxy2) {
        Initializer.setJavaClassFor(javaClass, proxy2);
        assert (javaClass.isInterface());
        proxy2 = new InterfaceInitializer(runtime2, javaClass).initialize(proxy2);
        Initializer.flagAsJavaProxy(proxy2);
        return proxy2;
    }

    private static void flagAsJavaProxy(RubyModule proxy2) {
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
    }

    private static void setJavaClassFor(Class<?> javaClass, RubyModule proxy2) {
        proxy2.setInstanceVariable("@java_class", proxy2.getRuntime().getJavaSupport().getJavaClassFromCache(javaClass));
        proxy2.dataWrapStruct(javaClass);
    }

    public abstract RubyModule initialize(RubyModule var1);
}

