/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.ConnectionHandler;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketImpl;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnectionHandler
extends ConnectionHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(WebSocketConnectionHandler.class);

    public WebSocketConnectionHandler(AmqpConnection amqpConnection) {
        super(amqpConnection, StringUtil.getRandomString("WS"));
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        String hostName = event.getConnection().getHostname();
        WebSocketImpl webSocket = new WebSocketImpl();
        webSocket.configure(hostName, "/$servicebus/websocket", "", 0, "AMQPWSB10", null, null);
        transport.addTransportLayer((TransportLayer)webSocket);
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("addWebsocketHandshake: hostname[" + hostName + "]");
        }
        super.addTransportLayers(event, transport);
    }

    @Override
    protected int getProtocolPort() {
        return 443;
    }

    @Override
    protected int getMaxFrameSize() {
        return 4096;
    }
}

