/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;

public class EncryptionManager {
    private transient Agent agent_;
    private static final byte[] modulusBytes__ = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private static final BigInteger modulus__ = new BigInteger(1, modulusBytes__);
    private static final byte[] baseBytes__ = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private static final BigInteger base__ = new BigInteger(1, baseBytes__);
    private static final int exponential_length__ = 255;
    private DHParameterSpec paramSpec_;
    private KeyPairGenerator keyPairGenerator_;
    private KeyPair keyPair_;
    private KeyAgreement keyAgreement_;
    private byte[] token_;
    private byte[] secKey_;
    private SecretKeyFactory secretKeyFactory_ = null;
    private String providerName;
    private Provider provider;
    private MessageDigest messageDigest = null;
    private SecureRandom secureRandom = null;
    private static final int SECMEC_USRSSBPWD_SEED_LEN = 8;
    private static final byte[] SECMEC_USRSSBPWD_PWDSEQS = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
    private static final String SHA_1_PRNG_ALGORITHM = "SHA1PRNG";
    public static final String SHA_1_DIGEST_ALGORITHM = "SHA-1";
    private static final char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public EncryptionManager(Agent agent) throws SqlException {
        this.agent_ = agent;
        try {
            Provider[] providerArray = Security.getProviders("KeyAgreement.DH");
            if (providerArray == null) {
                throw new NoSuchProviderException();
            }
            this.provider = providerArray[0];
            this.providerName = this.provider.getName();
            this.paramSpec_ = new DHParameterSpec(modulus__, base__, 255);
            this.keyPairGenerator_ = KeyPairGenerator.getInstance("DH", this.providerName);
            this.keyPairGenerator_.initialize(this.paramSpec_);
            this.keyPair_ = this.keyPairGenerator_.generateKeyPair();
            this.keyAgreement_ = KeyAgreement.getInstance("DH", this.providerName);
            this.keyAgreement_.init(this.keyPair_.getPrivate());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), generalSecurityException, new Object[0]);
        }
    }

    public EncryptionManager(Agent agent, String string) throws SqlException {
        this.agent_ = agent;
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.secureRandom = SecureRandom.getInstance(SHA_1_PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), noSuchAlgorithmException, new Object[0]);
        }
    }

    public byte[] obtainPublicKey() {
        BigInteger bigInteger = ((DHPublicKey)this.keyPair_.getPublic()).getY();
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 33 && byArray[0] == 0) {
            byte[] byArray2 = new byte[32];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = byArray[i + 1];
            }
            return byArray2;
        }
        if (byArray.length < 32) {
            int n;
            byte[] byArray3 = new byte[32];
            for (n = 0; n < 32 - byArray.length; ++n) {
                byArray3[n] = 0;
            }
            for (int i = n; i < byArray3.length; ++i) {
                byArray3[i] = byArray[i - n];
            }
            return byArray3;
        }
        return byArray;
    }

    private byte[] calculateEncryptionToken(int n, byte[] byArray) {
        byte[] byArray2;
        block5: {
            block4: {
                byArray2 = new byte[8];
                if (n != 7) break block4;
                if (byArray.length < 8) {
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    for (int i = byArray.length; i < 8; ++i) {
                        byArray2[i] = 0;
                    }
                } else {
                    System.arraycopy(byArray, 0, byArray2, 0, 8);
                }
                break block5;
            }
            if (n != 9) break block5;
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = byArray[i + 12];
            }
        }
        return byArray2;
    }

    private void keyParityCheck(byte[] byArray) throws SqlException {
        if (byArray.length != 8) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ105.S"), 8, byArray.length);
        }
        for (int i = 0; i < 8; ++i) {
            byte by = byArray[i];
            int n = 1;
            for (int j = 0; j < 8; ++j) {
                if (by < 0) {
                    n = 1 - n;
                }
                by = (byte)(by << 1);
            }
            if (n != true) continue;
            if ((byArray[i] & 1) != 0) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] & 0xFE);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] | 1);
        }
    }

    private byte[] generatePrivateKey(byte[] byArray) throws SqlException {
        try {
            int n;
            int n2;
            KeyFactory keyFactory = KeyFactory.getInstance("DH", this.provider);
            BigInteger bigInteger = new BigInteger(1, byArray);
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, modulus__, base__);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            this.keyAgreement_.doPhase(publicKey, true);
            byte[] byArray2 = this.keyAgreement_.generateSecret();
            byte[] byArray3 = new byte[32];
            if (byArray2.length == 33 && byArray2[0] == 0) {
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    byArray3[n2] = byArray2[n2 + 1];
                }
            }
            if (byArray2.length < 32) {
                for (n2 = 0; n2 < 32 - byArray2.length; ++n2) {
                    byArray3[n2] = 0;
                }
                for (n = n2; n < byArray2.length; ++n) {
                    byArray3[n] = byArray2[n - n2];
                }
            }
            byte[] byArray4 = new byte[8];
            if (byArray2.length == 32) {
                for (n = 0; n < 8; ++n) {
                    byArray4[n] = byArray2[n + 12];
                }
            } else if (byArray2.length == 33 || byArray2.length < 32) {
                for (n = 0; n < 8; ++n) {
                    byArray4[n] = byArray3[n + 12];
                }
            } else {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ104.S"), byArray2.length);
            }
            this.keyParityCheck(byArray4);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), generalSecurityException, new Object[0]);
        }
    }

    public byte[] encryptData(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SqlException {
        byte[] byArray4 = null;
        Object object = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(n, byArray2);
        }
        try {
            Object object2;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(byArray3);
                object = object2 = new SecretKeySpec(this.secKey_, "DES");
            } else {
                object2 = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                object = this.secretKeyFactory_.generateSecret((KeySpec)object2);
            }
            object2 = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.token_);
            ((Cipher)object2).init(1, (Key)object, ivParameterSpec);
            byArray4 = ((Cipher)object2).doFinal(byArray);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ106.S"), new Object[0]);
        }
        catch (BadPaddingException badPaddingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ107.S"), new Object[0]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ108.S"), new Object[0]);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), generalSecurityException, new Object[0]);
        }
        return byArray4;
    }

    public byte[] decryptData(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SqlException {
        byte[] byArray4 = null;
        Object object = null;
        if (this.token_ == null) {
            this.token_ = this.calculateEncryptionToken(n, byArray2);
        }
        try {
            Object object2;
            if (this.secKey_ == null) {
                this.secKey_ = this.generatePrivateKey(byArray3);
                object = object2 = new SecretKeySpec(this.secKey_, "DES");
            } else {
                object2 = new DESKeySpec(this.secKey_);
                if (this.secretKeyFactory_ == null) {
                    this.secretKeyFactory_ = SecretKeyFactory.getInstance("DES", this.providerName);
                }
                object = this.secretKeyFactory_.generateSecret((KeySpec)object2);
            }
            object2 = Cipher.getInstance("DES/CBC/PKCS5Padding", this.providerName);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.token_);
            ((Cipher)object2).init(2, (Key)object, ivParameterSpec);
            byArray4 = ((Cipher)object2).doFinal(byArray);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ106.S"), new Object[0]);
        }
        catch (BadPaddingException badPaddingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ107.S"), new Object[0]);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ108.S"), new Object[0]);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ112.S"), generalSecurityException, new Object[0]);
        }
        return byArray4;
    }

    public void resetSecurityKeys() {
        this.token_ = null;
        this.secKey_ = null;
    }

    public byte[] generateSeed() {
        byte[] byArray = new byte[8];
        this.secureRandom.setSeed(this.secureRandom.generateSeed(8));
        this.secureRandom.nextBytes(byArray);
        return byArray;
    }

    public byte[] substitutePassword(String string, String string2, byte[] byArray, byte[] byArray2) throws SqlException {
        String string3 = "3b60";
        this.messageDigest.reset();
        this.messageDigest.update(this.toHexByte(string2, 0, string2.length()));
        byte[] byArray3 = this.messageDigest.digest();
        String string4 = string3 + this.toHexString(byArray3, 0, byArray3.length);
        byte[] byArray4 = this.toHexByte(string, 0, string.length());
        this.messageDigest.update(byArray4);
        this.messageDigest.update(this.toHexByte(string4, 0, string4.length()));
        byte[] byArray5 = this.messageDigest.digest();
        this.messageDigest.update(byArray5);
        this.messageDigest.update(byArray2);
        this.messageDigest.update(byArray);
        this.messageDigest.update(byArray4);
        this.messageDigest.update(SECMEC_USRSSBPWD_PWDSEQS);
        byte[] byArray6 = this.messageDigest.digest();
        return byArray6;
    }

    private String toHexString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = (byArray[i] & 0xF0) >>> 4;
            int n5 = byArray[i] & 0xF;
            stringBuilder.append(hex_table[n4]);
            stringBuilder.append(hex_table[n5]);
        }
        return stringBuilder.toString();
    }

    private byte[] toHexByte(String string, int n, int n2) {
        byte[] byArray = new byte[(n2 - n) * 2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            int n4 = (c & 0xF0) >>> 4;
            int n5 = c & 0xF;
            byArray[i] = (byte)n4;
            byArray[i + 1] = (byte)n5;
        }
        return byArray;
    }
}

