/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.input;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.DLQEntry;
import org.logstash.Timestamp;
import org.logstash.ackedqueue.Queueable;
import org.logstash.common.io.DeadLetterQueueReader;

public class DeadLetterQueueInputPlugin {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueInputPlugin.class);
    private static final char VERSION = '1';
    private final Path queuePath;
    private final boolean commitOffsets;
    private final Path sinceDbPath;
    private final AtomicBoolean open;
    private final AtomicBoolean readerHasState;
    private final Timestamp targetTimestamp;
    private volatile DeadLetterQueueReader queueReader;

    public DeadLetterQueueInputPlugin(Path path, boolean commitOffsets, Path sinceDbPath, Timestamp targetTimestamp) {
        this.queuePath = path;
        this.commitOffsets = commitOffsets;
        this.open = new AtomicBoolean(true);
        this.sinceDbPath = sinceDbPath;
        this.targetTimestamp = targetTimestamp;
        this.readerHasState = new AtomicBoolean(false);
    }

    private synchronized DeadLetterQueueReader lazyInitQueueReader() throws IOException {
        if (this.queueReader == null) {
            File queueDir = this.queuePath.toFile();
            if (!queueDir.exists()) {
                logger.warn("DLQ sub-path {} does not exist", (Object)this.queuePath);
                throw new NoSuchFileException("DLQ sub-path " + this.queuePath + " does not exist");
            }
            if (!queueDir.isDirectory()) {
                logger.warn("DLQ sub-path {} is not a directory", (Object)this.queuePath);
                throw new NotDirectoryException("DLQ sub-path " + this.queuePath + " is not a directory");
            }
            this.queueReader = new DeadLetterQueueReader(this.queuePath);
            this.setInitialReaderState(this.queueReader);
        }
        return this.queueReader;
    }

    public void register() throws IOException {
        if (this.queuePath.toFile().isDirectory()) {
            this.lazyInitQueueReader();
        }
    }

    private void setInitialReaderState(DeadLetterQueueReader queueReader) throws IOException {
        if (this.sinceDbPath != null && Files.exists(this.sinceDbPath, new LinkOption[0]) && this.targetTimestamp == null) {
            byte[] bytes = Files.readAllBytes(this.sinceDbPath);
            if (bytes.length == 0) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            char version = buffer.getChar();
            if ('1' != version) {
                throw new RuntimeException("Sincedb version:" + version + " does not match: " + '1');
            }
            int segmentPathStringLength = buffer.getInt();
            byte[] segmentPathBytes = new byte[segmentPathStringLength];
            buffer.get(segmentPathBytes);
            long offset = buffer.getLong();
            queueReader.setCurrentReaderAndPosition(Paths.get(new String(segmentPathBytes), new String[0]), offset);
            this.readerHasState.set(true);
        } else if (this.targetTimestamp != null) {
            queueReader.seekToNextEvent(this.targetTimestamp);
            this.readerHasState.set(false);
        }
    }

    public void run(Consumer<Queueable> queueConsumer) throws IOException, InterruptedException {
        DeadLetterQueueReader queueReader = this.lazyInitQueueReader();
        while (this.open.get()) {
            DLQEntry entry = queueReader.pollEntry(100L);
            if (entry == null) continue;
            this.readerHasState.set(true);
            queueConsumer.accept((Queueable)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.open.set(false);
        DeadLetterQueueReader queueReader = this.queueReader;
        CurrentSegmentAndPosition state = null;
        if (queueReader != null && this.commitOffsets && this.readerHasState.get()) {
            logger.debug("retrieving current DLQ segment and position");
            try {
                state = new CurrentSegmentAndPosition(queueReader.getCurrentSegment(), queueReader.getCurrentPosition());
            }
            catch (Exception e) {
                logger.error("failed to retrieve current DLQ segment and position", (Throwable)e);
            }
        }
        try {
            logger.debug("closing DLQ reader");
            if (queueReader != null) {
                queueReader.close();
            }
        }
        catch (Exception e) {
            logger.warn("error closing DLQ reader", (Throwable)e);
        }
        finally {
            if (state != null) {
                this.writeOffsetStateToSinceDb(state.segmentPath, state.position);
            }
        }
    }

    private void writeOffsetStateToSinceDb(Path segment, long offset) {
        logger.debug("writing DLQ offset state: {} (position: {})", (Object)segment, (Object)offset);
        String path = segment.toAbsolutePath().toString();
        ByteBuffer buffer = ByteBuffer.allocate(path.length() + 1 + 64);
        buffer.putChar('1');
        buffer.putInt(path.length());
        buffer.put(path.getBytes());
        buffer.putLong(offset);
        try {
            Files.write(this.sinceDbPath, buffer.array(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("failed to write DLQ offset state to " + this.sinceDbPath, (Throwable)e);
        }
    }

    private static class CurrentSegmentAndPosition {
        final Path segmentPath;
        final long position;

        CurrentSegmentAndPosition(Path segmentPath, long position) {
            this.segmentPath = segmentPath;
            this.position = position;
        }
    }
}

