/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.launchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JvmOptionsParser {
    private final String logstashHome;
    private static final Pattern OPTION_DEFINITION = Pattern.compile("((?<start>\\d+)(?<range>-)?(?<end>\\d+)?:)?(?<option>-.*)$");
    private static final Pattern JAVA_VERSION = Pattern.compile("^(?:1\\.)?(?<javaMajorVersion>\\d+)(?:\\.\\d+)?$");

    JvmOptionsParser(String logstashHome) {
        this.logstashHome = logstashHome;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("Expected two arguments specifying path to LOGSTASH_HOME and an optional LS_JVM_OPTS, but was " + Arrays.toString(args));
        }
        String lsJavaOpts = System.getenv("LS_JAVA_OPTS");
        JvmOptionsParser.handleJvmOptions(args, lsJavaOpts);
    }

    static void handleJvmOptions(String[] args, String lsJavaOpts) {
        JvmOptionsParser parser = new JvmOptionsParser(args[0]);
        String jvmOpts = args.length == 2 ? args[1] : null;
        try {
            Optional<Path> jvmOptions = parser.lookupJvmOptionsFile(jvmOpts);
            parser.parseAndInjectEnvironment(jvmOptions, lsJavaOpts);
        }
        catch (JvmOptionsFileParserException pex) {
            System.err.printf(Locale.ROOT, "encountered [%d] error%s parsing [%s]", pex.invalidLines().size(), pex.invalidLines().size() == 1 ? "" : "s", pex.jvmOptionsFile());
            int errorCounter = 0;
            for (Map.Entry<Integer, String> entry : pex.invalidLines().entrySet()) {
                System.err.printf(Locale.ROOT, "[%d]: encountered improperly formatted JVM option in [%s] on line number [%d]: [%s]", ++errorCounter, pex.jvmOptionsFile(), entry.getKey(), entry.getValue());
            }
        }
        catch (IOException ex) {
            System.err.println("Error accessing jvm.options file");
            System.exit(1);
        }
    }

    private Optional<Path> lookupJvmOptionsFile(String jvmOpts) {
        if (jvmOpts != null && !jvmOpts.isEmpty()) {
            return Optional.of(Paths.get(jvmOpts, new String[0]));
        }
        return Arrays.stream(new Path[]{Paths.get("/etc/logstash/jvm.options", new String[0]), Paths.get(this.logstashHome, "config/jvm.options")}).filter(p -> p.toFile().canRead()).findFirst();
    }

    private void parseAndInjectEnvironment(Optional<Path> jvmOptionsFile, String lsJavaOpts) throws IOException, JvmOptionsFileParserException {
        ArrayList<String> jvmOptionsContent = new ArrayList<String>(this.parseJvmOptions(jvmOptionsFile));
        if (lsJavaOpts != null && !lsJavaOpts.isEmpty()) {
            if (this.isDebugEnabled()) {
                System.err.println("Appending jvm options from environment LS_JAVA_OPTS");
            }
            jvmOptionsContent.add(lsJavaOpts);
        }
        System.out.println(String.join((CharSequence)" ", jvmOptionsContent));
    }

    /*
     * Exception decompiling
     */
    private List<String> parseJvmOptions(Optional<Path> jvmOptionsFile) throws IOException, JvmOptionsFileParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDebugEnabled() {
        String debug = System.getenv("DEBUG");
        if (debug == null) {
            return false;
        }
        return "1".equals(debug) || Boolean.parseBoolean(debug);
    }

    static ParseResult parse(int javaMajorVersion, BufferedReader br) throws IOException {
        ParseResult result = new ParseResult();
        int lineNumber = 0;
        while (true) {
            String line = br.readLine();
            ++lineNumber;
            if (line == null) break;
            if (line.startsWith("#") || line.matches("\\s*")) continue;
            Matcher matcher = OPTION_DEFINITION.matcher(line);
            if (matcher.matches()) {
                int upper;
                int lower;
                String start = matcher.group("start");
                String end = matcher.group("end");
                if (start == null) {
                    result.appendOption(line);
                    continue;
                }
                try {
                    lower = Integer.parseInt(start);
                }
                catch (NumberFormatException e) {
                    result.appendError(lineNumber, line);
                    continue;
                }
                if (matcher.group("range") == null) {
                    upper = lower;
                } else if (end == null) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(end);
                    }
                    catch (NumberFormatException e) {
                        result.appendError(lineNumber, line);
                        continue;
                    }
                    if (upper < lower) {
                        result.appendError(lineNumber, line);
                        continue;
                    }
                }
                if (lower > javaMajorVersion || javaMajorVersion > upper) continue;
                result.appendOption(matcher.group("option"));
                continue;
            }
            result.appendError(lineNumber, line);
        }
        return result;
    }

    private int javaMajorVersion() {
        String specVersion = System.getProperty("java.specification.version");
        Matcher specVersionMatcher = JAVA_VERSION.matcher(specVersion);
        if (!specVersionMatcher.matches()) {
            throw new IllegalStateException(String.format("Failed to extract Java major version from specification `%s`", specVersion));
        }
        return Integer.parseInt(specVersionMatcher.group("javaMajorVersion"));
    }

    static final class ParseResult {
        private final List<String> jvmOptions = new ArrayList<String>();
        private final SortedMap<Integer, String> invalidLines = new TreeMap<Integer, String>();

        ParseResult() {
        }

        void appendOption(String option) {
            this.jvmOptions.add(option);
        }

        void appendError(int lineNumber, String malformedLine) {
            this.invalidLines.put(lineNumber, malformedLine);
        }

        public boolean hasErrors() {
            return !this.invalidLines.isEmpty();
        }

        public SortedMap<Integer, String> getInvalidLines() {
            return this.invalidLines;
        }

        public List<String> getJvmOptions() {
            return this.jvmOptions;
        }
    }

    static class JvmOptionsFileParserException
    extends Exception {
        private static final long serialVersionUID = 2446165130736962758L;
        private final Path jvmOptionsFile;
        private final SortedMap<Integer, String> invalidLines;

        Path jvmOptionsFile() {
            return this.jvmOptionsFile;
        }

        SortedMap<Integer, String> invalidLines() {
            return this.invalidLines;
        }

        JvmOptionsFileParserException(Path jvmOptionsFile, SortedMap<Integer, String> invalidLines) {
            this.jvmOptionsFile = jvmOptionsFile;
            this.invalidLines = invalidLines;
        }
    }
}

