/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.logstash.LockException;

public class FileLockFactory {
    private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());
    private static final Map<FileLock, String> LOCK_MAP = Collections.synchronizedMap(new HashMap());

    private FileLockFactory() {
    }

    public static FileLock obtainLock(Path dirPath, String lockName) throws IOException {
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        Path lockPath = dirPath.resolve(lockName);
        try {
            Files.createFile(lockPath, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path realLockPath = lockPath.toRealPath(new LinkOption[0]);
        if (LOCK_HELD.add(realLockPath.toString())) {
            AbstractInterruptibleChannel channel = null;
            FileLock lock = null;
            try {
                channel = FileChannel.open(realLockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                lock = ((FileChannel)channel).tryLock();
                if (lock != null) {
                    LOCK_MAP.put(lock, realLockPath.toString());
                    FileLock fileLock = lock;
                    return fileLock;
                }
                throw new LockException("Lock held by another program on lock path: " + realLockPath);
            }
            finally {
                if (lock == null) {
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                    }
                    catch (Throwable throwable) {}
                    boolean removed = LOCK_HELD.remove(realLockPath.toString());
                    if (!removed) {
                        throw new LockException("Lock path was cleared but never marked as held: " + realLockPath);
                    }
                }
            }
        }
        throw new LockException("Lock held by this virtual machine on lock path: " + realLockPath);
    }

    public static void releaseLock(FileLock lock) throws IOException {
        String lockPath = LOCK_MAP.remove(lock);
        if (lockPath == null) {
            throw new LockException("Cannot release unobtained lock");
        }
        lock.release();
        lock.channel().close();
        Boolean removed = LOCK_HELD.remove(lockPath);
        if (!removed.booleanValue()) {
            throw new LockException("Lock path was not marked as held: " + lockPath);
        }
    }
}

