/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SchemaString {
    private String schemaType = "AVRO";
    private String schemaString;
    private List<SchemaReference> references = Collections.emptyList();
    private Integer maxId;

    public SchemaString() {
    }

    public SchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public static SchemaString fromJson(String json) throws IOException {
        return (SchemaString)JacksonMapper.INSTANCE.readValue(json, SchemaString.class);
    }

    @ApiModelProperty(value="Schema type")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @ApiModelProperty(value="Schema string identified by the ID")
    @JsonProperty(value="schema")
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="schema")
    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    @ApiModelProperty(value="Schema references")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @ApiModelProperty(value="Maximum ID")
    @JsonProperty(value="maxId")
    public Integer getMaxId() {
        return this.maxId;
    }

    @JsonProperty(value="maxId")
    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

