/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ccp extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\ud804\udd0e\ud804\udd1a\ud804\udd2a\ud804\udd20\ud804\udd22\ud804\udd28",
               "\ud804\udd1c\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd20\ud804\udd22\ud804\udd28",
               "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd0c\ud804\udd27",
               "\ud804\udd03\ud804\udd2c\ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd23\ud804\udd34",
               "\ud804\udd1f\ud804\udd2c",
               "\ud804\udd0e\ud804\udd2a\ud804\udd1a\ud804\udd34",
               "\ud804\udd0e\ud804\udd2a\ud804\udd23\ud804\udd2d",
               "\ud804\udd03\ud804\udd09\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd34",
               "\ud804\udd25\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd11\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd11\ud804\udd2c\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd1a\ud804\udd27\ud804\udd1e\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd13\ud804\udd28\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "",
            };
        final String[] metaValue_standalone_MonthNames = new String[] {
               "\ud804\udd0e\ud804\udd1a\ud804\udd2a\ud804\udd20\ud804\udd22\ud804\udd28",
               "\ud804\udd1c\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd20\ud804\udd22\ud804\udd28",
               "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd0c\ud804\udd27",
               "\ud804\udd03\ud804\udd2c\ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd23\ud804\udd34",
               "\ud804\udd1f\ud804\udd2c",
               "\ud804\udd0e\ud804\udd2a\ud804\udd1a\ud804\udd34",
               "\ud804\udd0e\ud804\udd2a\ud804\udd23\ud804\udd2d",
               "\ud804\udd03\ud804\udd09\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd34",
               "\ud804\udd25\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd11\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd11\ud804\udd2e\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd1a\ud804\udd27\ud804\udd1e\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd13\ud804\udd28\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\ud804\udd0e\ud804\udd1a\ud804\udd2a",
               "\ud804\udd1c\ud804\udd2c\ud804\udd1b\ud804\udd34",
               "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd0c\ud804\udd27",
               "\ud804\udd03\ud804\udd2c\ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd23\ud804\udd34",
               "\ud804\udd1f\ud804\udd2c",
               "\ud804\udd0e\ud804\udd2a\ud804\udd1a\ud804\udd34",
               "\ud804\udd0e\ud804\udd2a\ud804\udd23\ud804\udd2d",
               "\ud804\udd03\ud804\udd09\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd34",
               "\ud804\udd25\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd11\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd11\ud804\udd2e\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd1a\ud804\udd27\ud804\udd1e\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd13\ud804\udd28\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\ud804\udd0e",
               "\ud804\udd1c\ud804\udd2c",
               "\ud804\udd1f",
               "\ud804\udd03\ud804\udd2c",
               "\ud804\udd1f\ud804\udd2c",
               "\ud804\udd0e\ud804\udd2a\ud804\udd1a\ud804\udd34",
               "\ud804\udd0e\ud804\udd2a",
               "\ud804\udd03",
               "\ud804\udd25\ud804\udd2c",
               "\ud804\udd03\ud804\udd27",
               "\ud804\udd1a\ud804\udd27",
               "\ud804\udd13\ud804\udd28",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\ud804\udd22\ud804\udd27\ud804\udd1d\ud804\udd28\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd25\ud804\udd27\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd1f\ud804\udd27\ud804\udd01\ud804\udd09\ud804\udd27\ud804\udd23\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd1d\ud804\udd2a\ud804\udd16\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd25\ud804\udd2a\ud804\udd1b\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd25\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34",
               "\ud804\udd25\ud804\udd27\ud804\udd1a\ud804\udd28\ud804\udd1d\ud804\udd22\ud804\udd34",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\ud804\udd22\ud804\udd27\ud804\udd1d\ud804\udd28",
               "\ud804\udd25\ud804\udd27\ud804\udd1f\ud804\udd34",
               "\ud804\udd1f\ud804\udd27\ud804\udd01\ud804\udd09\ud804\udd27\ud804\udd23\ud804\udd34",
               "\ud804\udd1d\ud804\udd2a\ud804\udd16\ud804\udd34",
               "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd25\ud804\udd2a\ud804\udd1b\ud804\udd34",
               "\ud804\udd25\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd34",
               "\ud804\udd25\ud804\udd27\ud804\udd1a\ud804\udd28",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\ud804\udd22\ud804\udd27",
               "\ud804\udd25\ud804\udd27",
               "\ud804\udd1f\ud804\udd27",
               "\ud804\udd1d\ud804\udd2a",
               "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd28",
               "\ud804\udd25\ud804\udd2a",
               "\ud804\udd25\ud804\udd27",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\ud804\udd16\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd1f\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd18\ud804\udd28 \ud804\udd1b\ud804\udd33\ud804\udd06\ud804\udd18\ud804\udd33\ud804\udd20\ud804\udd2c \ud804\udd16\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd1f\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd16\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd33\ud804\udd06\ud804\udd18\ud804\udd33\ud804\udd20\ud804\udd2c \ud804\udd16\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd1f\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34",
               "\ud804\udd0c\ud804\udd33\ud804\udd06\ud804\udd2c\ud804\udd22\ud804\udd34 \ud804\udd1b\ud804\udd33\ud804\udd06\ud804\udd18\ud804\udd33\ud804\udd20\ud804\udd2c \ud804\udd16\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd1f\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34",
            };
        final String[] metaValue_standalone_QuarterAbbreviations = new String[] {
               "Q1",
               "Q2",
               "Q3",
               "Q4",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "\ud804\udd37",
               "\ud804\udd38",
               "\ud804\udd39",
               "\ud804\udd3a",
            };
        final String[] metaValue_long_Eras = new String[] {
               "\ud804\udd08\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd34\ud804\udd1b\ud804\udd2b\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd27",
               "\ud804\udd08\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd1b\ud804\udd34\ud804\udd18\ud804\udd27",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "h:mm:ss a zzzz",
               "h:mm:ss a z",
               "h:mm:ss a",
               "h:mm a",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, y G",
               "d MMMM, y G",
               "d MMM, y G",
               "d/M/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, y GGGG",
               "d MMMM, y GGGG",
               "d MMM, y GGGG",
               "d/M/y G",
            };
        final String[] metaValue_japanese_narrow_AmPmMarkers = new String[] {
               "AM",
               "PM",
            };
        final String[] metaValue_islamic_long_Eras = new String[] {
               "",
               "\ud804\udd21\ud804\udd2a\ud804\udd07\ud804\udd34",
            };
        final String metaValue_calendarname_gregorian = "\ud804\udd09\ud804\udd33\ud804\udd22\ud804\udd09\ud804\udd2e\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34";
        final String[] metaValue_cakm_NumberElements = new String[] {
               ".",
               ",",
               ";",
               "%",
               "0",
               "#",
               "-",
               "E",
               "\u2030",
               "\u221e",
               "NaN",
            };
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\ud804\udd1d\ud804\udd27\ud804\udd0f\ud804\udd27\ud804\udd22\ud804\udd34" },
            { "timezone.gmtFormat", "GMT {0}" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\ud804\udd03\ud804\udd28\ud804\udd25\ud804\udd34\ud804\udd23\ud804\udd1f\ud804\udd28\ud804\udd07\ud804\udd34-\ud804\udd25\ud804\udd28\ud804\udd1e\ud804\udd28\ud804\udd23\ud804\udd34 \ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd25\ud804\udd27\ud804\udd1b\ud804\udd27\ud804\udd1a\ud804\udd34\ud804\udd0f\ud804\udd29" },
            { "islamic.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_long_Eras },
            { "timezone.regionFormat.standard", "{0} \ud804\udd1f\ud804\udd1a\ud804\udd27\ud804\udd07\ud804\udd34 \ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd16\ud804\udd27\ud804\udd16\ud804\udd34" },
            { "DefaultNumberingSystem", "cakm" },
            { "calendarname.japanese", "\ud804\udd0e\ud804\udd1b\ud804\udd1a\ud804\udd28 \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "long.Eras", metaValue_long_Eras },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "latn.NumberElements", metaValue_cakm_NumberElements },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\ud804\udd1f\ud804\udd28\ud804\udd1a\ud804\udd28\ud804\udd16\ud804\udd34" },
            { "field.era", "\ud804\udd21\ud804\udd2a\ud804\udd07\ud804\udd34" },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\ud804\udd1f\ud804\udd27\ud804\udd26\ud804\udd27\ud804\udd22\ud804\udd27\ud804\udd1f\ud804\udd34",
                    "\ud804\udd25\ud804\udd27\ud804\udd1c\ud804\udd22\ud804\udd34",
                    "\ud804\udd22\ud804\udd27\ud804\udd1d\ud804\udd28\ud804\udd05\ud804\udd23\ud804\udd34 \ud804\udd03\ud804\udd03\ud804\udd2a\ud804\udd20\ud804\udd23\ud804\udd34",
                    "\ud804\udd22\ud804\udd27\ud804\udd1d\ud804\udd28\ud804\udd05\ud804\udd25\ud804\udd34 \ud804\udd25\ud804\udd1a\ud804\udd28",
                    "\ud804\udd0e\ud804\udd27\ud804\udd1f\ud804\udd18\ud804\udd28\ud804\udd05\ud804\udd23\ud804\udd34 \ud804\udd03\ud804\udd03\ud804\udd2a\ud804\udd20\ud804\udd23\ud804\udd34",
                    "\ud804\udd0e\ud804\udd27\ud804\udd1f\ud804\udd18\ud804\udd28\ud804\udd05\ud804\udd0c\ud804\udd34 \ud804\udd25\ud804\udd1a\ud804\udd28",
                    "\ud804\udd22\ud804\udd27\ud804\udd0e\ud804\udd27\ud804\udd1d\ud804\udd34",
                    "\ud804\udd25\ud804\udd33\ud804\udd03\ud804\udd1d\ud804\udd27\ud804\udd1a\ud804\udd34",
                    "\ud804\udd22\ud804\udd27\ud804\udd1f\ud804\udd34\ud804\udd0e\ud804\udd1a\ud804\udd34",
                    "\ud804\udd25\ud804\udd24\ud804\udd23\ud804\udd34",
                    "\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd07\ud804\udd27\ud804\udd18\ud804\udd34",
                    "\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd26\ud804\udd27\ud804\udd0e\ud804\udd34\ud804\udd0e\ud804\udd27",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "\ud804\udd1f\ud804\udd28\ud804\udd01\ud804\udd09\ud804\udd2a\ud804\udd03\ud804\udd2e \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "islamic.Eras", metaValue_islamic_long_Eras },
            { "field.month", "\ud804\udd1f\ud804\udd0f\ud804\udd34" },
            { "field.second", "\ud804\udd25\ud804\udd2c\ud804\udd09\ud804\udd2c\ud804\udd1a\ud804\udd34" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\ud804\udd37",
                    "\ud804\udd38",
                    "\ud804\udd39",
                    "\ud804\udd3a",
                    "\ud804\udd3b",
                    "\ud804\udd3c",
                    "\ud804\udd3d",
                    "\ud804\udd3e",
                    "\ud804\udd3f",
                    "\ud804\udd37\ud804\udd36",
                    "\ud804\udd37\ud804\udd37",
                    "\ud804\udd37\ud804\udd38",
                    "",
                }
            },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "#,##,##0.00\u00a4",
                    "#,##,##0%",
                }
            },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\ud804\udd03\ud804\udd28\ud804\udd25\ud804\udd34\ud804\udd23\ud804\udd1f\ud804\udd28\ud804\udd07\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "japanese.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_standalone_MonthNames },
            { "timezone.regionFormat", "{0} \ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd16\ud804\udd27" },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "islamic.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "field.zone", "\ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd16\ud804\udd27\ud804\udd22\ud804\udd34 \ud804\udd0e\ud804\udd09" },
            { "japanese.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "Eras", metaValue_long_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\ud804\udd25\ud804\udd1b\ud804\udd34\ud804\udd16\ud804\udd22\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd34" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "cakm.NumberElements", metaValue_cakm_NumberElements },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\ud804\udd25\ud804\udd1b\ud804\udd34\ud804\udd16" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0} \ud804\udd18\ud804\udd28\ud804\udd1d\ud804\udd2a\ud804\udd0c\ud804\udd34\ud804\udd0e\ud804\udd33\ud804\udd20 \ud804\udd03\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd16\ud804\udd27\ud804\udd16\ud804\udd34" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMMM, y",
                    "d MMMM, y",
                    "d MMM, y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "field.hour", "\ud804\udd0a\ud804\udd2e\ud804\udd1a\ud804\udd34\ud804\udd13" },
            { "islamic.narrow.Eras", metaValue_islamic_long_Eras },
            { "calendarname.buddhist", "\ud804\udd1d\ud804\udd2a\ud804\udd16\ud804\udd34\ud804\udd19\ud804\udd2e \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "standalone.MonthNames", metaValue_standalone_MonthNames },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
