/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestique";
        final String metaValue_ar = "arabe";
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tib\u00e9tain";
        final String metaValue_el = "grec";
        final String metaValue_he = "h\u00e9breu";
        final String metaValue_hy = "arm\u00e9nien";
        final String metaValue_ja = "japonais";
        final String metaValue_jv = "javanais";
        final String metaValue_ka = "g\u00e9orgien";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "cor\u00e9en";
        final String metaValue_la = "latin";
        final String metaValue_lo = "lao";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birman";
        final String metaValue_or = "oriya";
        final String metaValue_si = "cinghalais";
        final String metaValue_ta = "tamoul";
        final String metaValue_te = "t\u00e9lougou";
        final String metaValue_th = "tha\u00ef";
        final String metaValue_ban = "balinais";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_phn = "ph\u00e9nicien";
        final String metaValue_saz = "saurashtra";
        final String metaValue_syr = "syriaque";
        final String metaValue_uga = "ougaritique";
        final String metaValue_vai = "va\u00ef";
        final String metaValue_zbl = "symboles Bliss";
        final String metaValue_type_nu_taml = "chiffres tamouls";
        final Object[][] data = new Object[][] {
            { "ksh", "francique ripuaire" },
            { "Ogam", "ogam" },
            { "mwl", "mirandais" },
            { "Zsym", "symboles" },
            { "cch", "atsam" },
            { "mwr", "marwar\u00ee" },
            { "egl", "\u00e9milien" },
            { "mwv", "mentawa\u00ef" },
            { "Tagb", "tagbanoua" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "dialecte de Gniva / Njiva" },
            { "xmf", "mingr\u00e9lien" },
            { "egy", "\u00e9gyptien ancien" },
            { "raj", "rajasthani" },
            { "Phag", "phags pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "\u00cele de l\u2019Ascension" },
            { "rar", "rarotongien" },
            { "tet", "tetum" },
            { "AD", "Andorre" },
            { "AE", "\u00c9mirats arabes unis" },
            { "nl_BE", "flamand" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua-et-Barbuda" },
            { "type.ca.ethiopic", "calendrier \u00e9thiopien" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Fuseau horaire" },
            { "AL", "Albanie" },
            { "AM", "Arm\u00e9nie" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarctique" },
            { "AR", "Argentine" },
            { "Prti", "parthe des inscriptions" },
            { "AS", "Samoa am\u00e9ricaines" },
            { "AT", "Autriche" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "en_US", "anglais am\u00e9ricain" },
            { "AX", "\u00celes \u00c5land" },
            { "mye", "my\u00e8n\u00e8" },
            { "AZ", "Azerba\u00efdjan" },
            { "%%AREVELA", "arm\u00e9nien oriental" },
            { "BA", "Bosnie-Herz\u00e9govine" },
            { "BB", "Barbade" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "koumyk" },
            { "BE", "Belgique" },
            { "gmh", "moyen haut-allemand" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahre\u00efn" },
            { "BI", "Burundi" },
            { "BJ", "B\u00e9nin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudes" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brun\u00e9i Darussalam" },
            { "BO", "Bolivie" },
            { "BQ", "Pays-Bas carib\u00e9ens" },
            { "BR", "Br\u00e9sil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhoutan" },
            { "BV", "\u00cele Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bi\u00e9lorussie" },
            { "BZ", "Belize" },
            { "Visp", "parole visible" },
            { "type.ca.persian", "calendrier persan" },
            { "type.nu.hebr", "chiffres h\u00e9breux" },
            { "CA", "Canada" },
            { "CC", "\u00celes Cocos" },
            { "mzn", "mazand\u00e9rani" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "R\u00e9publique centrafricaine" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Suisse" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "\u00celes Cook" },
            { "CL", "Chili" },
            { "Kthi", "kaith\u00ee" },
            { "CM", "Cameroun" },
            { "CN", "Chine" },
            { "CO", "Colombie" },
            { "CP", "\u00cele Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap-Vert" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "\u00cele Christmas" },
            { "CY", "Chypre" },
            { "CZ", "Tch\u00e9quie" },
            { "eka", "\u00e9kadjouk" },
            { "vls", "flamand occidental" },
            { "DE", "Allemagne" },
            { "goh", "ancien haut allemand" },
            { "ace", "aceh" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "konkani de Goa" },
            { "type.nu.deva", "chiffres devanagaris" },
            { "DJ", "Djibouti" },
            { "DK", "Danemark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "br\u00e2hm\u00ee" },
            { "DM", "Dominique" },
            { "type.nu.armnlow", "chiffres arm\u00e9niens minuscules" },
            { "DO", "R\u00e9publique dominicaine" },
            { "gor", "gorontalo" },
            { "got", "gothique" },
            { "vmf", "franconien du Main" },
            { "Mtei", "meitei mayek" },
            { "zun", "zu\u00f1i" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Alg\u00e9rie" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "demi-chasse" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta et Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampangan" },
            { "EC", "\u00c9quateur" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonie" },
            { "tiv", "tiv" },
            { "EG", "\u00c9gypte" },
            { "EH", "Sahara occidental" },
            { "chg", "tchaghata\u00ef" },
            { "pau", "palau" },
            { "chk", "chuuk" },
            { "chn", "jargon chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "\u00c9rythr\u00e9e" },
            { "ES", "Espagne" },
            { "ET", "\u00c9thiopie" },
            { "EU", "Union europ\u00e9enne" },
            { "elx", "\u00e9lamite" },
            { "type.ca.gregorian", "calendrier gr\u00e9gorien" },
            { "EZ", "zone euro" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "chiffres goudjar\u00e2t\u00ees" },
            { "Inds", "indus" },
            { "ady", "adygh\u00e9en" },
            { "aeb", "arabe tunisien" },
            { "FI", "Finlande" },
            { "FJ", "Fidji" },
            { "FK", "\u00celes Malouines" },
            { "FM", "\u00c9tats f\u00e9d\u00e9r\u00e9s de Micron\u00e9sie" },
            { "key.va", "Variante locale" },
            { "FO", "\u00celes F\u00e9ro\u00e9" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "pcd", "picard" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "racine" },
            { "type.ca.indian", "calendrier indien" },
            { "rgn", "romagnol" },
            { "grc", "grec ancien" },
            { "GA", "Gabon" },
            { "tkr", "tsakhour" },
            { "vot", "vote" },
            { "GB", "Royaume-Uni" },
            { "pcm", "pidgin nig\u00e9rian" },
            { "GD", "Grenade" },
            { "GE", "G\u00e9orgie" },
            { "GF", "Guyane fran\u00e7aise" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "Tale", "ta\u00ef-le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenland" },
            { "enm", "moyen anglais" },
            { "GM", "Gambie" },
            { "GN", "Guin\u00e9e" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guin\u00e9e \u00e9quatoriale" },
            { "GR", "Gr\u00e8ce" },
            { "GS", "G\u00e9orgie du Sud et \u00eeles Sandwich du Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "pennsilfaanisch" },
            { "GW", "Guin\u00e9e-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "nouveau ta\u00ef-lue" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "sans contenu linguistique" },
            { "tly", "talysh" },
            { "pdt", "bas-prussien" },
            { "de_AT", "allemand autrichien" },
            { "Vaii", metaValue_vai },
            { "HK", "R.A.S. chinoise de Hong Kong" },
            { "HM", "\u00celes Heard et McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatie" },
            { "agq", "aghem" },
            { "gsw", "suisse allemand" },
            { "type.ca.islamic-umalqura", "calendrier musulman (Umm al Qura)" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongrie" },
            { "rif", "rifain" },
            { "tmh", "tamacheq" },
            { "IC", "\u00celes Canaries" },
            { "nan", "minnan" },
            { "ID", "Indon\u00e9sie" },
            { "peo", "persan ancien" },
            { "IE", "Irlande" },
            { "nap", "napolitain" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "IL", "Isra\u00ebl" },
            { "IM", "\u00cele de Man" },
            { "IN", "Inde" },
            { "type.co.eor", "r\u00e8gles de classement europ\u00e9en" },
            { "IO", "Territoire britannique de l\u2019oc\u00e9an Indien" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "Zmth", "notation math\u00e9matique" },
            { "type.nu.thai", "chiffres tha\u00efs" },
            { "vro", "v\u00f5ro" },
            { "guc", "wayuu" },
            { "%%POSIX", "informatique" },
            { "type.nu.beng", "chiffres bengalis" },
            { "pfl", "allemand palatin" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendrier musulman" },
            { "Beng", metaValue_bn },
            { "JM", "Jama\u00efque" },
            { "JO", "Jordanie" },
            { "gur", "gurenne" },
            { "JP", "Japon" },
            { "%%1606NICT", "fran\u00e7oys de 1606" },
            { "ain", "a\u00efnou" },
            { "guz", "gusii" },
            { "tog", "tonga nyasa" },
            { "type.nu.knda", "chiffres en kannada" },
            { "Kali", "kayah li" },
            { "de_CH", "allemand suisse" },
            { "type.co.phonetic", "ordre de tri phon\u00e9tique" },
            { "izh", "ingrien" },
            { "type.ca.buddhist", "calendrier bouddhiste" },
            { "KE", "Kenya" },
            { "419", "Am\u00e9rique latine" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambodge" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint-Christophe-et-Ni\u00e9v\u00e8s" },
            { "Knda", "kannara" },
            { "Zinh", "h\u00e9rit\u00e9" },
            { "fr_CA", "fran\u00e7ais canadien" },
            { "KP", "Cor\u00e9e du Nord" },
            { "KR", "Cor\u00e9e du Sud" },
            { "Plrd", "phon\u00e9tique de Pollard" },
            { "fr_CH", "fran\u00e7ais suisse" },
            { "KW", "Kowe\u00eft" },
            { "tpi", "tok pisin" },
            { "KY", "\u00celes Ca\u00efmans" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "cyrillique" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "phn", metaValue_phn },
            { "LC", "Sainte-Lucie" },
            { "Cyrs", "cyrillique (variante slavonne)" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "bas-allemand" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadien" },
            { "cop", metaValue_cop },
            { "LR", "Lib\u00e9ria" },
            { "esu", "youpik central" },
            { "LS", "Lesotho" },
            { "Phlv", "pehlevi des livres" },
            { "LT", "Lituanie" },
            { "LU", "Luxembourg" },
            { "LV", "Lettonie" },
            { "Kana", "katakana" },
            { "LY", "Libye" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "th\u00e2na" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Mont\u00e9n\u00e9gro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "\u00celes Marshall" },
            { "ale", "al\u00e9oute" },
            { "type.nu.vaii", "Chiffres en va\u00ef" },
            { "MK", "Mac\u00e9doine" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmanie)" },
            { "MN", "Mongolie" },
            { "new", "newari" },
            { "MO", "R.A.S. chinoise de Macao" },
            { "aln", "gu\u00e8gue" },
            { "MP", "\u00celes Mariannes du Nord" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malte" },
            { "cps", "capiznon" },
            { "type.m0.ungegn", "UNGEGN" },
            { "MU", "Maurice" },
            { "alt", "alta\u00ef du Sud" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexique" },
            { "type.ca.japanese", "calendrier japonais" },
            { "MY", "Malaisie" },
            { "MZ", "Mozambique" },
            { "Phli", "pehlevi des inscriptions" },
            { "NA", "Namibie" },
            { "202", "Afrique subsaharienne" },
            { "type.ca.hebrew", "calendrier h\u00e9bra\u00efque" },
            { "type.co.dictionary", "ordre du dictionnaire" },
            { "NC", "Nouvelle-Cal\u00e9donie" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "touroyo" },
            { "NE", "Niger" },
            { "NF", "\u00cele Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "trv", "taroko" },
            { "Phlp", "pehlevi des psautiers" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Pays-Bas" },
            { "NO", "Norv\u00e8ge" },
            { "NP", "N\u00e9pal" },
            { "NR", "Nauru" },
            { "tsd", "tsakonien" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nouvelle-Z\u00e9lande" },
            { "rom", "romani" },
            { "Mero", "m\u00e9ro\u00eftique" },
            { "crh", "turc de Crim\u00e9e" },
            { "ang", "ancien anglais" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "cr\u00e9ole seychellois" },
            { "Xpeo", "cun\u00e9iforme pers\u00e9politain" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "calendrier musulman (tabulaire, \u00e9poque civile)" },
            { "csb", "kachoube" },
            { "en_GB", "anglais britannique" },
            { "PE", "P\u00e9rou" },
            { "ttt", "tati caucasien" },
            { "PF", "Polyn\u00e9sie fran\u00e7aise" },
            { "PG", "Papouasie-Nouvelle-Guin\u00e9e" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Pologne" },
            { "ewo", "\u00e9wondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "\u00celes Pitcairn" },
            { "PR", "Porto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Territoires palestiniens" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "nia", "nias" },
            { "type.nu.greklow", "chiffres grecs minuscules" },
            { "PY", "Paraguay" },
            { "tum", "toumbouka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "anglais standard \u00e9cossais" },
            { "jam", "cr\u00e9ole jama\u00efcain" },
            { "pms", "pi\u00e9montais" },
            { "niu", "niu\u00e9en" },
            { "QO", "r\u00e9gions \u00e9loign\u00e9es de l\u2019Oc\u00e9anie" },
            { "ext", "estr\u00e9m\u00e8gne" },
            { "lez", "lezghien" },
            { "%%FONUPA", "alphabet phon\u00e9tique ouralique" },
            { "tvl", "tuvalu" },
            { "Tavt", "ta\u00ef vi\u00eat" },
            { "001", "Monde" },
            { "002", "Afrique" },
            { "njo", "Ao" },
            { "003", "Am\u00e9rique du Nord" },
            { "RE", "La R\u00e9union" },
            { "005", "Am\u00e9rique du Sud" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontique" },
            { "Rjng", "rejang" },
            { "009", "Oc\u00e9anie" },
            { "RO", "Roumanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Rwanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "manich\u00e9en" },
            { "Khar", "kharochth\u00ee" },
            { "SA", "Arabie saoudite" },
            { "pon", "pohnpei" },
            { "Mand", "mand\u00e9en" },
            { "SB", "\u00celes Salomon" },
            { "twq", "tasawaq" },
            { "011", "Afrique occidentale" },
            { "SC", "Seychelles" },
            { "SD", "Soudan" },
            { "013", "Am\u00e9rique centrale" },
            { "SE", "Su\u00e8de" },
            { "014", "Afrique orientale" },
            { "arc", "aram\u00e9en" },
            { "015", "Afrique septentrionale" },
            { "SG", "Singapour" },
            { "SH", "Sainte-H\u00e9l\u00e8ne" },
            { "type.lb.strict", "style de saut de ligne strict" },
            { "017", "Afrique centrale" },
            { "SI", "Slov\u00e9nie" },
            { "018", "Afrique australe" },
            { "SJ", "Svalbard et Jan Mayen" },
            { "019", "Am\u00e9riques" },
            { "SK", "Slovaquie" },
            { "SL", "Sierra Leone" },
            { "SM", "Saint-Marin" },
            { "SN", "S\u00e9n\u00e9gal" },
            { "SO", "Somalie" },
            { "arn", "mapuche" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "arapaho" },
            { "SR", "Suriname" },
            { "aro", "araona" },
            { "SS", "Soudan du Sud" },
            { "ST", "Sao Tom\u00e9-et-Principe" },
            { "arq", "arabe alg\u00e9rien" },
            { "SV", "Salvador" },
            { "ars", "arabe najdi" },
            { "SX", "Saint-Martin (partie n\u00e9erlandaise)" },
            { "SY", "Syrie" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "arz", "arabe \u00e9gyptien" },
            { "ary", "arabe marocain" },
            { "yap", "yapois" },
            { "rtm", "rotuman" },
            { "TA", "Tristan da Cunha" },
            { "asa", "assou" },
            { "type.ms.ussystem", "syst\u00e8me am\u00e9ricain" },
            { "021", "Am\u00e9rique septentrionale" },
            { "TC", "\u00celes Turques-et-Ca\u00efques" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "TF", "Terres australes fran\u00e7aises" },
            { "ase", "langue des signes am\u00e9ricaine" },
            { "TG", "Togo" },
            { "TH", "Tha\u00eflande" },
            { "TJ", "Tadjikistan" },
            { "029", "Cara\u00efbes" },
            { "TK", "Tok\u00e9laou" },
            { "TL", "Timor oriental" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "rechercher par consonne initiale en hangeul" },
            { "TM", "Turkm\u00e9nistan" },
            { "%%BOONT", "dialecte boontling" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turquie" },
            { "TT", "Trinit\u00e9-et-Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Ta\u00efwan" },
            { "ast", "asturien" },
            { "rue", "ruth\u00e8ne" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzanie" },
            { "nmg", "kwasio" },
            { "Zzzz", "\u00e9criture inconnue" },
            { "UA", "Ukraine" },
            { "lij", "ligure" },
            { "rup", "valaque" },
            { "030", "Asie orientale" },
            { "tyv", "touvain" },
            { "sw_CD", "swahili du Congo" },
            { "034", "Asie du Sud" },
            { "hai", "haida" },
            { "035", "Asie du Sud-Est" },
            { "UG", "Ouganda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "ordre pinyin" },
            { "039", "Europe m\u00e9ridionale" },
            { "Sinh", metaValue_si },
            { "UM", "\u00celes mineures \u00e9loign\u00e9es des \u00c9tats-Unis" },
            { "liv", "livonien" },
            { "UN", "Nations Unies" },
            { "US", "\u00c9tats-Unis" },
            { "haw", "hawa\u00efen" },
            { "type.co.gb2312han", "ordre chinois simplifi\u00e9 - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "prussien" },
            { "UZ", "Ouzb\u00e9kistan" },
            { "tzm", "amazighe de l\u2019Atlas central" },
            { "type.co.stroke", "ordre des traits" },
            { "nnh", "ngiemboon" },
            { "VA", "\u00c9tat de la Cit\u00e9 du Vatican" },
            { "pro", "proven\u00e7al ancien" },
            { "VC", "Saint-Vincent-et-les-Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "\u00celes Vierges britanniques" },
            { "VI", "\u00celes Vierges des \u00c9tats-Unis" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "noga\u00ef" },
            { "rwk", "rwa" },
            { "non", "vieux norrois" },
            { "053", "Australasie" },
            { "%%AREVMDA", "arm\u00e9nien occidental" },
            { "054", "M\u00e9lan\u00e9sie" },
            { "WF", "Wallis-et-Futuna" },
            { "type.co.traditional", "ordre traditionnel" },
            { "057", "r\u00e9gion micron\u00e9sienne" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "Chiffres financiers" },
            { "avk", "kotava" },
            { "type.co.compat", "ancien ordre de tri pour compatibilit\u00e9" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polyn\u00e9sie" },
            { "XK", "Kosovo" },
            { "Gujr", "goudjar\u00e2t\u00ee" },
            { "Zxxx", "non \u00e9crit" },
            { "Olck", "ol tchiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Y\u00e9men" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "ordre de tri standard" },
            { "lmo", "lombard" },
            { "fan", "fang" },
            { "%%ROZAJ", "dialecte de Resia" },
            { "fat", "fanti" },
            { "Sgnw", "\u00e9criture des signes" },
            { "YT", "Mayotte" },
            { "ZA", "Afrique du Sud" },
            { "type.lb.loose", "style de saut de ligne permissif" },
            { "Deva", "d\u00e9van\u00e2gar\u00ee" },
            { "type.nu.geor", "chiffres g\u00e9orgiens" },
            { "type.co.zhuyin", "ordre zhuyin" },
            { "Hira", "hiragana" },
            { "ZM", "Zambie" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "r\u00e9gion ind\u00e9termin\u00e9e" },
            { "Runr", "runique" },
            { "type.ms.metric", "syst\u00e8me m\u00e9trique" },
            { "type.ca.iso8601", "calendrier ISO 8601" },
            { "lol", "mongo" },
            { "nso", "sotho du Nord" },
            { "type.nu.telu", "chiffres t\u00e9lougous" },
            { "lou", "cr\u00e9ole louisianais" },
            { "loz", "lozi" },
            { "jmc", "matcham\u00e9" },
            { "hif", "hindi fidjien" },
            { "type.nu.hansfin", "chiffres financiers en chinois simplifi\u00e9" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "chiffres arabes \u00e9tendus" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "chiffres pleine chasse" },
            { "hit", "hittite" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "hi\u00e9roglyphes mayas" },
            { "lrc", "lori du Nord" },
            { "Copt", metaValue_cop },
            { "nwc", "newar\u00ee classique" },
            { "udm", "oudmourte" },
            { "Khmr", metaValue_km },
            { "Limb", "limbou" },
            { "sad", "sandawe" },
            { "type.nu.roman", "chiffres romains" },
            { "sah", "iakoute" },
            { "ltg", "latgalien" },
            { "sam", "aram\u00e9en samaritain" },
            { "%%SCOUSE", "dialecte scouse" },
            { "saq", "sambourou" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "Tfng", "tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "jud\u00e9o-persan" },
            { "type.d0.npinyin", "Num\u00e9rique" },
            { "type.nu.native", "Chiffres natifs" },
            { "sba", "ngambay" },
            { "Guru", "gourmoukh\u00ee" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "pleine chasse" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "nyn", "nyankol\u00e9" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lusha\u00ef" },
            { "bal", "baloutchi" },
            { "den", "esclave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "finnois torn\u00e9dalien" },
            { "luy", "luhya" },
            { "bar", "bavarois" },
            { "bas", "bassa" },
            { "bax", "bamoun" },
            { "jrb", "jud\u00e9o-arabe" },
            { "nzi", "nzema" },
            { "sco", "\u00e9cossais" },
            { "scn", "sicilien" },
            { "aa", "afar" },
            { "ab", "abkhaze" },
            { "bbc", "batak toba" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharique" },
            { "Arab", metaValue_ar },
            { "an", "aragonais" },
            { "%%SOLBA", "dialecte de Stolvizza / Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana ou hiragana" },
            { "as", "assamais" },
            { "sdc", "sarde sassarais" },
            { "Lina", "lin\u00e9aire A" },
            { "av", "avar" },
            { "Linb", "lin\u00e9aire B" },
            { "sdh", "kurde du Sud" },
            { "ay", "aymara" },
            { "az", "az\u00e9ri" },
            { "%%OSOJS", "dialecte d\u2019Oseacco / Osojane" },
            { "ba", "bachkir" },
            { "type.co.unihan", "ordre de tri radical-traits" },
            { "be", "bi\u00e9lorusse" },
            { "bg", "bulgare" },
            { "bi", "bichelamar" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "breton" },
            { "bs", "bosniaque" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "sei", "s\u00e9ri" },
            { "type.nu.laoo", "chiffres laotiens" },
            { "seh", "cisena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkoupe" },
            { "ca", "catalan" },
            { "ses", "koyraboro senni" },
            { "ce", "tch\u00e9tch\u00e8ne" },
            { "ch", "chamorro" },
            { "%%REVISED", "orthographe r\u00e9vis\u00e9e" },
            { "co", "corse" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tch\u00e8que" },
            { "cu", "slavon d\u2019\u00e9glise" },
            { "yrl", "nheengatou" },
            { "cv", "tchouvache" },
            { "cy", "gallois" },
            { "type.nu.ethi", "chiffres \u00e9thiopiens" },
            { "Yiii", "yi" },
            { "da", "danois" },
            { "pt_PT", "portugais europ\u00e9en" },
            { "de", "allemand" },
            { "type.cf.standard", "format de devise standard" },
            { "bej", "bedja" },
            { "din", "dinka" },
            { "jut", "jute" },
            { "Bugi", "bouguis" },
            { "bem", "bemba" },
            { "sga", "ancien irlandais" },
            { "type.nu.mong", "chiffres mongols" },
            { "dv", "maldivien" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "b\u00e9na" },
            { "type.ca.chinese", "calendrier chinois" },
            { "lzh", "chinois litt\u00e9raire" },
            { "dje", "zarma" },
            { "sgs", "samogitien" },
            { "type.nu.grek", "chiffres grecs" },
            { "ee", "\u00e9w\u00e9" },
            { "bfd", "bafut" },
            { "type.lb.normal", "style de saut de ligne normal" },
            { "ro_MD", "moldave" },
            { "el", metaValue_el },
            { "en", "anglais" },
            { "eo", "esp\u00e9ranto" },
            { "bfq", "badaga" },
            { "lzz", "laze" },
            { "type.co.big5han", "ordre chinois traditionnel - Big5" },
            { "es", "espagnol" },
            { "et", "estonien" },
            { "Hanb", "han avec bopomofo" },
            { "eu", "basque" },
            { "Buhd", "bouhide" },
            { "Hang", "hang\u00fbl" },
            { "Samr", "samaritain" },
            { "shi", "chleuh" },
            { "hsb", "haut-sorabe" },
            { "Hani", "sinogrammes" },
            { "shn", "shan" },
            { "Hano", "hanoun\u00f3o" },
            { "fa", "persan" },
            { "Hans", "simplifi\u00e9" },
            { "type.nu.latn", "chiffres occidentaux" },
            { "Hant", "traditionnel" },
            { "ff", "peul" },
            { "shu", "arabe tchadien" },
            { "hsn", "xiang" },
            { "fi", "finnois" },
            { "fj", "fidjien" },
            { "fon", "fon" },
            { "bgn", "baloutchi occidental" },
            { "yue", "cantonais" },
            { "fo", "f\u00e9ro\u00efen" },
            { "type.m0.bgn", "BGN" },
            { "umb", "oumboundou" },
            { "fr", "fran\u00e7ais" },
            { "sid", "sidamo" },
            { "fy", "frison occidental" },
            { "ga", "irlandais" },
            { "gd", "ga\u00e9lique \u00e9cossais" },
            { "gl", "galicien" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "langue ind\u00e9termin\u00e9e" },
            { "type.ca.ethiopic-amete-alem", "calendrier \u00e9thiopien Amete Alem" },
            { "gu", "goudjerati" },
            { "type.ca.islamic-tbla", "calendrier musulman (tabulaire, \u00e9poque astronomique)" },
            { "gv", "mannois" },
            { "ha", "haoussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croate" },
            { "ht", "cr\u00e9ole ha\u00eftien" },
            { "hu", "hongrois" },
            { "hy", metaValue_hy },
            { "hz", "h\u00e9r\u00e9ro" },
            { "frc", "fran\u00e7ais cadien" },
            { "%%FONIPA", "alphabet phon\u00e9tique international" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indon\u00e9sien" },
            { "type.nu.tibt", "chiffres tib\u00e9tains" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi du Sichuan" },
            { "frm", "moyen fran\u00e7ais" },
            { "ik", "inupiaq" },
            { "fro", "ancien fran\u00e7ais" },
            { "frp", "francoproven\u00e7al" },
            { "io", "ido" },
            { "frs", "frison oriental" },
            { "bjn", "banjar" },
            { "frr", "frison du Nord" },
            { "is", "islandais" },
            { "it", "italien" },
            { "iu", "inuktitut" },
            { "sli", "bas-sil\u00e9sien" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "s\u00e9layar" },
            { "bkm", "kom" },
            { "sma", "sami du Sud" },
            { "jv", metaValue_jv },
            { "Shaw", "shavien" },
            { "mad", "madourais" },
            { "smj", "sami de Lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "sami d\u2019Inari" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makassar" },
            { "wuu", "wu" },
            { "sms", "sami skolt" },
            { "man", "mandingue" },
            { "kg", "kongo" },
            { "Goth", "gotique" },
            { "ki", "kikuyu" },
            { "mas", "massa\u00ef" },
            { "kj", "kouanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandais" },
            { "km", metaValue_km },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanouri" },
            { "ks", "kashmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurde" },
            { "kv", "komi" },
            { "kw", "cornique" },
            { "ky", "kirghize" },
            { "snk", "sonink\u00e9" },
            { "la", metaValue_la },
            { "lb", "luxembourgeois" },
            { "type.nu.mlym", "chiffres malay\u00e2lams" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limbourgeois" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "frioulan" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "syst\u00e8me imp\u00e9rial" },
            { "lt", "lituanien" },
            { "lu", "luba-katanga" },
            { "lv", "letton" },
            { "sog", "sogdien" },
            { "mg", "malgache" },
            { "mh", "marshallais" },
            { "type.co.ducet", "ordre de tri Unicode par d\u00e9faut" },
            { "mi", "maori" },
            { "mk", "mac\u00e9donien" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathe" },
            { "ms", "malais" },
            { "mt", "maltais" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksa" },
            { "mde", "maba" },
            { "dsb", "bas-sorabe" },
            { "Armi", "aram\u00e9en imp\u00e9rial" },
            { "na", "nauruan" },
            { "type.co.search", "recherche g\u00e9n\u00e9rique" },
            { "nb", "norv\u00e9gien bokm\u00e5l" },
            { "nd", "nd\u00e9b\u00e9l\u00e9 du Nord" },
            { "ne", "n\u00e9palais" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "n\u00e9erlandais" },
            { "nn", "norv\u00e9gien nynorsk" },
            { "no", "norv\u00e9gien" },
            { "nr", "nd\u00e9b\u00e9l\u00e9 du Sud" },
            { "nv", "navaho" },
            { "kaa", "karakalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "%%POLYTON", "polytonique" },
            { "oc", "occitan" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mend\u00e9" },
            { "oj", "ojibwa" },
            { "mer", "m\u00e9rou" },
            { "type.nu.armn", "chiffres arm\u00e9niens" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "dusun central" },
            { "or", metaValue_or },
            { "os", "oss\u00e8te" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardin" },
            { "mfe", "cr\u00e9ole mauricien" },
            { "srn", "sranan tongo" },
            { "pa", "pendjabi" },
            { "dua", "douala" },
            { "srr", "s\u00e9r\u00e8re" },
            { "%%LIPAW", "dialecte lipovaz de Resia" },
            { "kbl", "kanembou" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polonais" },
            { "dum", "moyen n\u00e9erlandais" },
            { "type.ca.dangi", "calendrier dangi" },
            { "ps", "pachto" },
            { "pt", "portugais" },
            { "mga", "moyen irlandais" },
            { "key.co", "ordre de tri" },
            { "pt_BR", "portugais br\u00e9silien" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "format de devise" },
            { "bra", "braj" },
            { "key.ca", "calendrier" },
            { "Laoo", metaValue_lo },
            { "mgo", "m\u00e9ta\u2019" },
            { "type.hc.h23", "syst\u00e8me horaire de 24 heures (0\u201323)" },
            { "type.hc.h24", "syst\u00e8me horaire de 24 heures (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahoui" },
            { "type.nu.mymr", "chiffres birmans" },
            { "qu", "quechua" },
            { "zap", "zapot\u00e8que" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makond\u00e9" },
            { "stq", "saterlandais" },
            { "Ethi", "\u00e9thiopique" },
            { "type.hc.h12", "syst\u00e8me horaire de 12 heures (1\u201312)" },
            { "type.hc.h11", "syst\u00e8me horaire de 12 heures (0\u201311)" },
            { "rm", "romanche" },
            { "rn", "roundi" },
            { "key.cu", "devise" },
            { "ro", "roumain" },
            { "%%SAAHO", "dialecte saho" },
            { "type.nu.orya", "chiffres oriyas" },
            { "type.nu.hanidec", "nombres d\u00e9cimaux chinois" },
            { "ru", "russe" },
            { "bss", "akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "rwanda" },
            { "kea", "capverdien" },
            { "mic", "micmac" },
            { "suk", "soukouma" },
            { "en_AU", "anglais australien" },
            { "sa", "sanskrit" },
            { "sc", "sarde" },
            { "sus", "soussou" },
            { "sd", "sindhi" },
            { "se", "sami du Nord" },
            { "min", "minangkabau" },
            { "sg", "sangho" },
            { "sh", "serbo-croate" },
            { "ken", "k\u00e9nyang" },
            { "si", metaValue_si },
            { "sux", "sum\u00e9rien" },
            { "sk", "slovaque" },
            { "sl", "slov\u00e8ne" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "type.nu.arab", "chiffres arabes" },
            { "sq", "albanais" },
            { "sr", "serbe" },
            { "ListKeyTypePattern", "{0} : {1}" },
            { "ss", "swati" },
            { "type.cf.account", "format de devise comptable" },
            { "Java", metaValue_jv },
            { "st", "sotho du Sud" },
            { "su", "soundanais" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "sv", "su\u00e9dois" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "chiffres financiers en chinois traditionnel" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asie" },
            { "bua", "bouriate" },
            { "143", "Asie centrale" },
            { "te", metaValue_te },
            { "145", "Asie occidentale" },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "bug", "bugi" },
            { "kfo", "koro" },
            { "en_CA", "anglais canadien" },
            { "tk", "turkm\u00e8ne" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonguien" },
            { "bum", "boulou" },
            { "dyo", "diola-fogny" },
            { "type.nu.jpan", "chiffres japonais" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "swb", "comorien" },
            { "Cakm", "chakma" },
            { "tt", "tatar" },
            { "dyu", "dioula" },
            { "tw", "twi" },
            { "ty", "tahitien" },
            { "%%BISKE", "dialecte de San Giorgio / Bila" },
            { "150", "Europe" },
            { "151", "Europe de l\u2019Est" },
            { "154", "Europe septentrionale" },
            { "dzg", "dazaga" },
            { "155", "Europe occidentale" },
            { "ug", "ou\u00efghour" },
            { "Kore", metaValue_ko },
            { "Ital", "ancien italique" },
            { "kgp", "caingangue" },
            { "Zyyy", "commun" },
            { "uk", "ukrainien" },
            { "zea", "z\u00e9landais" },
            { "type.ca.coptic", "calendrier copte" },
            { "ur", "ourdou" },
            { "%%1994", "orthographe normalis\u00e9e de Resia" },
            { "xal", "kalmouk" },
            { "zen", "zenaga" },
            { "uz", "ouzbek" },
            { "kha", "khasi" },
            { "%%1996", "orthographe allemande de 1996" },
            { "nds_NL", "bas-saxon n\u00e9erlandais" },
            { "Sylo", "sylot\u00ee n\u00e2gr\u00ee" },
            { "ve", "venda" },
            { "type.ca.roc", "calendrier r\u00e9publicain chinois" },
            { "vi", "vietnamien" },
            { "kho", "khotanais" },
            { "khq", "koyra chiini" },
            { "key.hc", "syst\u00e8me horaire (12 ou 24 heures)" },
            { "%%TARASK", "orthographe taraskievica" },
            { "vo", "volapuk" },
            { "khw", "khowar" },
            { "syc", "syriaque classique" },
            { "Osma", "osmanais" },
            { "quc", "k\u2019iche\u2019" },
            { "qug", "quichua du Haut-Chimborazo" },
            { "gaa", "ga" },
            { "wa", "wallon" },
            { "gag", "gagaouze" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lydien" },
            { "Xsux", "cun\u00e9iforme sum\u00e9ro-akkadien" },
            { "wo", "wolof" },
            { "zgh", "amazighe standard marocain" },
            { "ar_001", "arabe standard moderne" },
            { "Cans", "syllabaire autochtone canadien unifi\u00e9" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "mandchou" },
            { "Latf", "latin (variante bris\u00e9e)" },
            { "szl", "sil\u00e9sien" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "latin (variante ga\u00e9lique)" },
            { "type.nu.hans", "chiffres en chinois simplifi\u00e9" },
            { "type.nu.hant", "chiffres en chinois traditionnel" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "chiffres romains minuscules" },
            { "byn", "blin" },
            { "Lyci", "lycien" },
            { "osa", "osage" },
            { "byv", "m\u00e9dumba" },
            { "gbz", "dari zoroastrien" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "fran\u00e7ois acad\u00e9mique de 1694" },
            { "Syrc", metaValue_syr },
            { "yi", "yiddish" },
            { "mos", "mor\u00e9" },
            { "Dsrt", "d\u00e9s\u00e9ret" },
            { "yo", "yoruba" },
            { "type.nu.traditional", "Chiffres traditionnels" },
            { "Syrj", "syriaque occidental" },
            { "ota", "turc ottoman" },
            { "Syre", "syriaque estrangh\u00e9lo" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "carien" },
            { "kln", "kalendjin" },
            { "zh", "chinois" },
            { "Bopo", "bopomofo" },
            { "Perm", "ancien permien" },
            { "key.lb", "style de saut de ligne" },
            { "zu", "zoulou" },
            { "type.co.phonebook", "ordre de l\u2019annuaire" },
            { "%%MONOTON", "monotonique" },
            { "Geor", metaValue_ka },
            { "kmb", "kimboundou" },
            { "type.nu.jpanfin", "chiffres japonais financiers" },
            { "Cham", "cham" },
            { "gez", "gu\u00e8ze" },
            { "mrj", "mari occidental" },
            { "Syrn", "syriaque oriental" },
            { "type.co.reformed", "ordre r\u00e9form\u00e9" },
            { "Tglg", "tagal" },
            { "Egyd", "d\u00e9motique \u00e9gyptien" },
            { "Egyh", "hi\u00e9ratique \u00e9gyptien" },
            { "ebu", "embou" },
            { "Egyp", "hi\u00e9roglyphes \u00e9gyptiens" },
            { "Geok", "g\u00e9orgien khoutsouri" },
            { "zh_Hans", "chinois simplifi\u00e9" },
            { "koi", "komi-permiak" },
            { "Hung", "ancien hongrois" },
            { "kok", "konkani" },
            { "%%1901", "orthographe allemande traditionnelle" },
            { "kos", "kosra\u00e9en" },
            { "vec", "v\u00e9nitien" },
            { "zh_Hant", "chinois traditionnel" },
            { "Sund", "sundanais" },
            { "vep", "vepse" },
            { "kpe", "kpell\u00e9" },
            { "type.nu.khmr", "chiffres khmers" },
            { "ilo", "ilokano" },
            { "%%VALENCIA", "valencien" },
            { "Cprt", "syllabaire chypriote" },
            { "%%BAKU1926", "alphabet latin alta\u00efque unifi\u00e9" },
            { "mua", "moundang" },
            { "type.nu.guru", "chiffres gourmoukh\u00ees" },
            { "mul", "multilingue" },
            { "cad", "caddo" },
            { "key.ms", "syst\u00e8me de mesure" },
            { "mus", "creek" },
            { "Glag", "glagolitique" },
            { "gil", "gilbertin" },
            { "Cher", metaValue_chr },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "krc", "karatcha\u00ef balkar" },
            { "inh", "ingouche" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "car\u00e9lien" },
            { "efi", "\u00e9fik" },
            { "tcy", "toulou" },
            { "key.nu", "nombres" },
            { "kru", "kouroukh" },
            { "ksb", "chambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
