/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashMap;
import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.analyses.ArithOp;
import org.jruby.ir.dataflow.analyses.CompareOp;
import org.jruby.ir.dataflow.analyses.LogicOp;

abstract class UnboxableOp {
    public final String name;
    public static Map<String, UnboxableOp> opsMap = new HashMap<String, UnboxableOp>();

    public UnboxableOp(String name2) {
        this.name = name2;
    }

    public abstract boolean acceptsArgTypes(Class var1, Class var2);

    public abstract Class getUnboxedType(Class var1, Class var2);

    public abstract Class getUnboxedResultType(Class var1);

    public abstract Operation getUnboxedOp(Class var1);

    public static void addUnboxableOp(UnboxableOp op) {
        opsMap.put(op.name, op);
    }

    static {
        UnboxableOp.addUnboxableOp(new ArithOp("+", Operation.IADD, Operation.FADD));
        UnboxableOp.addUnboxableOp(new ArithOp("-", Operation.ISUB, Operation.FSUB));
        UnboxableOp.addUnboxableOp(new ArithOp("*", Operation.IMUL, Operation.FMUL));
        UnboxableOp.addUnboxableOp(new ArithOp("/", Operation.IDIV, Operation.FDIV));
        UnboxableOp.addUnboxableOp(new LogicOp("|", Operation.IOR));
        UnboxableOp.addUnboxableOp(new LogicOp("&", Operation.IAND));
        UnboxableOp.addUnboxableOp(new LogicOp("^", Operation.IXOR));
        UnboxableOp.addUnboxableOp(new LogicOp("<<", Operation.ISHL));
        UnboxableOp.addUnboxableOp(new LogicOp(">>", Operation.ISHR));
        UnboxableOp.addUnboxableOp(new CompareOp("<", Operation.ILT, Operation.FLT));
        UnboxableOp.addUnboxableOp(new CompareOp(">", Operation.IGT, Operation.FGT));
        UnboxableOp.addUnboxableOp(new CompareOp("==", Operation.IEQ, Operation.FEQ));
        UnboxableOp.addUnboxableOp(new CompareOp("===", Operation.IEQ, Operation.FEQ));
    }
}

