/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.ParserType;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Message;
import http_parser.lolevel.TestLoaderNG;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class Requests {
    static void test_simple(String string, boolean bl) {
        HTTPParser hTTPParser = new HTTPParser(ParserType.HTTP_REQUEST);
        ByteBuffer byteBuffer = Util.buffer(string);
        boolean bl2 = false;
        int n = 0;
        try {
            hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
            bl2 = n == string.length();
            n = hTTPParser.execute(Util.SETTINGS_NULL, Util.empty());
            bl2 &= 0 == n;
        }
        catch (Throwable throwable) {
            bl2 = false;
        }
        Util.check(bl2 == bl);
    }

    static void simple_tests() {
        Requests.test_simple("hello world", false);
        Requests.test_simple("GET / HTP/1.1\r\n\r\n", false);
        Requests.test_simple("ASDF / HTTP/1.1\r\n\r\n", false);
        Requests.test_simple("PROPPATCHA / HTTP/1.1\r\n\r\n", false);
        Requests.test_simple("GETA / HTTP/1.1\r\n\r\n", false);
    }

    public static void test() {
        Util.p(Requests.class);
        Requests.simple_tests();
        List<Message> list = TestLoaderNG.load("tests.dumped");
        LinkedList<Message> linkedList = new LinkedList<Message>();
        for (Message message : list) {
            if (ParserType.HTTP_REQUEST != message.type) continue;
            linkedList.add(message);
        }
        for (Message message : linkedList) {
            Util.test_message(message);
        }
        for (int i = 0; i != linkedList.size(); ++i) {
            if (!((Message)linkedList.get((int)i)).should_keep_alive) continue;
            for (int j = 0; j != linkedList.size(); ++j) {
                if (!((Message)linkedList.get((int)j)).should_keep_alive) continue;
                for (int k = 0; k != linkedList.size(); ++k) {
                    Util.test_multiple3((Message)linkedList.get(i), (Message)linkedList.get(j), (Message)linkedList.get(k));
                }
            }
        }
    }
}

