/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import kafka.utils.Json$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GroupMetadataManager$ {
    public static GroupMetadataManager$ MODULE$;
    private final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private final BoundField OFFSET_KEY_GROUP_FIELD;
    private final BoundField OFFSET_KEY_TOPIC_FIELD;
    private final BoundField OFFSET_KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V0;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V0;
    private final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V1;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V1;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V2;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V2;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V2;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V3;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V3;
    private final BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V3;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    private final Schema GROUP_METADATA_KEY_SCHEMA;
    private final BoundField GROUP_KEY_GROUP_FIELD;
    private final String MEMBER_ID_KEY;
    private final String GROUP_INSTANCE_ID_KEY;
    private final String CLIENT_ID_KEY;
    private final String CLIENT_HOST_KEY;
    private final String REBALANCE_TIMEOUT_KEY;
    private final String SESSION_TIMEOUT_KEY;
    private final String SUBSCRIPTION_KEY;
    private final String ASSIGNMENT_KEY;
    private final Schema MEMBER_METADATA_V0;
    private final Schema MEMBER_METADATA_V1;
    private final Schema MEMBER_METADATA_V2;
    private final Schema MEMBER_METADATA_V3;
    private final String PROTOCOL_TYPE_KEY;
    private final String GENERATION_KEY;
    private final String PROTOCOL_KEY;
    private final String LEADER_KEY;
    private final String CURRENT_STATE_TIMESTAMP_KEY;
    private final String MEMBERS_KEY;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V2;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V3;
    private final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private final Schema CURRENT_GROUP_KEY_SCHEMA;

    static {
        new GroupMetadataManager$();
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return this.CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return this.OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return this.OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return this.OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return this.OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return this.OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return this.OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return this.OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V2() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V2;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V2() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V2() {
        return this.OFFSET_VALUE_METADATA_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V3() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V3;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V3() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3() {
        return this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V3() {
        return this.OFFSET_VALUE_METADATA_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return this.GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return this.GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return this.MEMBER_ID_KEY;
    }

    private String GROUP_INSTANCE_ID_KEY() {
        return this.GROUP_INSTANCE_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return this.CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return this.CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return this.REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return this.SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return this.SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return this.ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return this.MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return this.MEMBER_METADATA_V1;
    }

    private Schema MEMBER_METADATA_V2() {
        return this.MEMBER_METADATA_V2;
    }

    private Schema MEMBER_METADATA_V3() {
        return this.MEMBER_METADATA_V3;
    }

    private String PROTOCOL_TYPE_KEY() {
        return this.PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return this.GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return this.PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return this.LEADER_KEY;
    }

    private String CURRENT_STATE_TIMESTAMP_KEY() {
        return this.CURRENT_STATE_TIMESTAMP_KEY;
    }

    private String MEMBERS_KEY() {
        return this.MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V2() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V2;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V3() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V3;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return this.MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return this.OFFSET_VALUE_SCHEMAS;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return this.GROUP_VALUE_SCHEMAS;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return this.CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return this.CURRENT_GROUP_KEY_SCHEMA;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForKey(int version) {
        void var3_3;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(35).append("Unknown message key schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForOffsetValue(int version) {
        void var3_3;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(30).append("Unknown offset schema version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Schema schemaForGroupValue(int version) {
        void var3_3;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        if (!(schemaOpt instanceof Some)) {
            throw new KafkaException(new StringBuilder(31).append("Unknown group metadata version ").append(version).toString());
        }
        Schema schema = (Schema)((Some)schemaOpt).value();
        return var3_3;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, ApiVersion apiVersion) {
        void var6_9;
        Struct struct;
        int n;
        if (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) || offsetAndMetadata.expireTimestamp().nonEmpty()) {
            void var3_3;
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V1());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            Option<Object> option = offsetAndMetadata.expireTimestamp();
            if (option == null) {
                throw null;
            }
            Option<Object> getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)GroupMetadataManager$.$anonfun$offsetCommitValue$1()) : getOrElse_this.get();
            value.set(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), object);
            n = 1;
            struct = var3_3;
        } else if (apiVersion.$less(KAFKA_2_1_IV1$.MODULE$)) {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V2());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V2(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            n = 2;
            struct = value;
        } else {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V3());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3(), (Object)offsetAndMetadata.leaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V3(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            n = 3;
            struct = value;
        }
        Struct struct2 = struct;
        int version = n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + struct2.sizeOf());
        byteBuffer.putShort((short)var6_9);
        struct2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, ApiVersion apiVersion) {
        Object object;
        void map_bf;
        void var5_5;
        void orNull_ev;
        void var6_6;
        Tuple2 tuple2 = apiVersion.$less(KAFKA_0_10_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)0)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0())) : (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V1())) : (apiVersion.$less(KAFKA_2_3_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)2)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V2())) : new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)3)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V3()))));
        short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
        Struct value = (Struct)tuple2._2();
        Option<String> option = groupMetadata.protocolType();
        if (option == null) {
            throw null;
        }
        Option<String> getOrElse_this = option;
        Object object2 = getOrElse_this.isEmpty() ? GroupMetadataManager$.$anonfun$groupMetadataValue$1() : getOrElse_this.get();
        var6_6.set(this.PROTOCOL_TYPE_KEY(), object2);
        var6_6.set(this.GENERATION_KEY(), (Object)BoxesRunTime.boxToInteger((int)groupMetadata.generationId()));
        Option<String> option2 = groupMetadata.protocolName();
        Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
        if (option2 == null) {
            throw null;
        }
        Option<String> orNull_this = option2;
        Object object3 = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get();
        var6_6.set(this.PROTOCOL_KEY(), object3);
        var6_6.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        if (var5_5 >= 2) {
            var6_6.set(this.CURRENT_STATE_TIMESTAMP_KEY(), (Object)BoxesRunTime.boxToLong((long)groupMetadata.currentStateTimestampOrDefault()));
        }
        List<MemberMetadata> list = groupMetadata.allMemberMetadata();
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = arg_0 -> GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, arg_0);
        if (list == null) {
            throw null;
        }
        List<MemberMetadata> map_this = list;
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (map_this == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata), (List)Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    memberMetadata = (MemberMetadata)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)GroupMetadataManager$.$anonfun$groupMetadataValue$2((Struct)var6_6, (short)var5_5, groupMetadata, assignment, memberMetadata), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$(map_this, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        List memberArray = (List)object;
        var6_6.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + var6_6.sizeOf());
        byteBuffer.putShort((short)var5_5);
        var6_6.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Struct key = this.schemaForKey(version).read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            return new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        }
        if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            return new GroupMetadataKey(version, group);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForOffsetValue(version).read(buffer);
        if (version == 0) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
            long timestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
        }
        if (version == 1) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
            long expireTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
            if (expireTimestamp == -1L) {
                return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
            }
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
        }
        if (version == 2) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V2()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V2());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2()));
            return OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
        }
        if (version == 3) {
            long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V3()));
            int leaderEpoch = BoxesRunTime.unboxToInt((Object)value.get(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3()));
            String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V3());
            long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3()));
            Optional<Integer> leaderEpochOpt = leaderEpoch < 0 ? Optional.empty() : Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
            return OffsetAndMetadata$.MODULE$.apply(offset, leaderEpochOpt, metadata, commitTimestamp);
        }
        throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        Struct value = this.schemaForGroupValue(version).read(buffer);
        if (version >= 0 && version <= 3) {
            Long timestamp;
            int generationId = BoxesRunTime.unboxToInt((Object)value.get(this.GENERATION_KEY()));
            String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
            String protocol = (String)value.get(this.PROTOCOL_KEY());
            String leaderId = (String)value.get(this.LEADER_KEY());
            Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
            Product initialState = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)).isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$;
            switch (version) {
                default: 
            }
            Object object = version == 2 ? (value.hasField(this.CURRENT_STATE_TIMESTAMP_KEY()) ? (BoxesRunTime.equalsNumObject((Number)(timestamp = value.getLong(this.CURRENT_STATE_TIMESTAMP_KEY())), (Object)BoxesRunTime.boxToInteger((int)-1)) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(timestamp)))) : None$.MODULE$) : None$.MODULE$;
            None$ currentStateTimestamp = object;
            MemberMetadata[] members = (MemberMetadata[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)), (Function1 & Serializable & scala.Serializable)memberMetadataObj -> {
                Struct memberMetadata = (Struct)memberMetadataObj;
                String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
                None$ groupInstanceId = version >= 3 ? new Some((Object)((String)memberMetadata.get(MODULE$.GROUP_INSTANCE_ID_KEY()))) : None$.MODULE$;
                String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
                String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
                int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
                int rebalanceTimeout = version == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
                byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY())));
                MemberMetadata member = new MemberMetadata(memberId, groupId, (Option<String>)groupInstanceId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType, (List<Tuple2<String, byte[]>>)new .colon.colon((Object)new Tuple2((Object)protocol, (Object)subscription), (List)Nil$.MODULE$));
                member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY()))));
                return member;
            }, (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MemberMetadata.class)));
            return GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)initialState, generationId, protocolType, protocol, leaderId, (Option<Object>)currentStateTimestamp, (Iterable<MemberMetadata>)Predef$.MODULE$.wrapRefArray((Object[])members), time);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Tuple2<Option<String>, Option<String>> tuple2;
        if (!record.hasKey()) {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
        }
        BaseKey baseKey = this.readMessageKey(record.key());
        if (baseKey instanceof OffsetKey) {
            OffsetKey offsetKey = (OffsetKey)baseKey;
            tuple2 = this.parseOffsets(offsetKey, record.value());
        } else if (baseKey instanceof GroupMetadataKey) {
            GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
            tuple2 = this.parseGroupMetadata(groupMetadataKey, record.value());
        } else {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had an invalid key)");
        }
        return tuple2;
    }

    private Tuple2<Option<String>, Option<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
        String groupId = offsetKey.key().group();
        TopicPartition topicPartition = offsetKey.key().topicPartition();
        String keyString = new StringBuilder(32).append("offset_commit::group=").append(groupId).append(",partition=").append(topicPartition).toString();
        OffsetAndMetadata offset = this.readOffsetMessageValue(payload);
        String valueString = offset == null ? "<DELETE>" : (offset.metadata().isEmpty() ? new StringBuilder(7).append("offset=").append(offset.offset()).toString() : new StringBuilder(17).append("offset=").append(offset.offset()).append(",metadata=").append(offset.metadata()).toString());
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Option<String>, Option<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
        String string;
        String groupId = groupMetadataKey.key();
        String keyString = new StringBuilder(22).append("group_metadata::group=").append(groupId).toString();
        GroupMetadata group = this.readGroupMessageValue(groupId, payload, Time.SYSTEM);
        if (group == null) {
            string = "<DELETE>";
        } else {
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_$this3;
            void orNull_ev;
            void $minus$greater$extension_$this4;
            Object object;
            void map_bf;
            Option<String> option = group.protocolType();
            if (option == null) {
                throw null;
            }
            Option<String> getOrElse_this = option;
            Object object2 = getOrElse_this.isEmpty() ? GroupMetadataManager$.$anonfun$parseGroupMetadata$1() : getOrElse_this.get();
            String protocolType = (String)object2;
            List<MemberMetadata> list = group.allMemberMetadata();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)member -> {
                String string = protocolType;
                String string2 = "consumer";
                if (string != null && string.equals(string2)) {
                    ConsumerPartitionAssignor.Assignment partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
                    Option option = Option$.MODULE$.apply((Object)partitionAssignment.userData());
                    if (option == null) {
                        throw null;
                    }
                    Option map_this = option;
                    Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$3((ByteBuffer)map_this.get()));
                    if (object == null) {
                        throw null;
                    }
                    Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)GroupMetadataManager$.MODULE$.hex((byte[])object.get()));
                    if (object2 == null) {
                        throw null;
                    }
                    Object object3 = object2.isEmpty() ? GroupMetadataManager$.$anonfun$parseGroupMetadata$5() : object2.get();
                    String userData = (String)object3;
                    if (userData.isEmpty()) {
                        return new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString();
                    }
                    return new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString();
                }
                return new StringBuilder(1).append(member.memberId()).append("=").append(MODULE$.hex(member.assignment())).toString();
            };
            if (list == null) {
                throw null;
            }
            List<MemberMetadata> map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    MemberMetadata memberMetadata = (MemberMetadata)map_this.head();
                    .colon.colon map_t = map_h = new .colon.colon((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        memberMetadata = (MemberMetadata)map_rest.head();
                        .colon.colon map_nx = new .colon.colon((Object)GroupMetadataManager$.$anonfun$parseGroupMetadata$2(protocolType, memberMetadata), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$(map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            String assignment = ((TraversableOnce)object).mkString("{", ",", "}");
            Tuple2[] tuple2Array = new Tuple2[4];
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"protocolType");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)protocolType);
            Option<String> option2 = group.protocolName();
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (option2 == null) {
                throw null;
            }
            Option<String> orNull_this = option2;
            Object object4 = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get();
            Object object5 = Predef$.MODULE$.ArrowAssoc((Object)"protocol");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, object4);
            Integer n = BoxesRunTime.boxToInteger((int)group.generationId());
            Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"generationId");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            Object object7 = Predef$.MODULE$.ArrowAssoc((Object)"assignment");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
            string = Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        }
        String valueString = string;
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private String hex(byte[] bytes) {
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return "";
        }
        String string = "%X";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
    }

    public static final /* synthetic */ long $anonfun$offsetCommitValue$1() {
        return -1L;
    }

    public static final /* synthetic */ String $anonfun$groupMetadataValue$1() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Struct $anonfun$groupMetadataValue$2(Struct value$1, short version$1, GroupMetadata groupMetadata$1, Map assignment$1, MemberMetadata memberMetadata) {
        void orNull_ev;
        Struct memberStruct = value$1.instance(MODULE$.MEMBERS_KEY());
        memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
        memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
        memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
        memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.sessionTimeoutMs()));
        if (version$1 > 0) {
            memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.rebalanceTimeoutMs()));
        }
        if (version$1 >= 3) {
            void orNull_ev2;
            Option<String> option = memberMetadata.groupInstanceId();
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (option == null) {
                throw null;
            }
            Option<String> orNull_this = option;
            Object object = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev2) : orNull_this.get();
            memberStruct.set(MODULE$.GROUP_INSTANCE_ID_KEY(), object);
        }
        Option<String> option = groupMetadata$1.protocolName();
        Predef.$less$colon$less $less$colon$less3 = Predef$.MODULE$.$conforms();
        if (option == null) {
            throw null;
        }
        Option<String> orNull_this = option;
        Object object = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get();
        String protocol = (String)object;
        if (protocol == null) {
            throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
        }
        byte[] metadata = memberMetadata.metadata(protocol);
        memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
        byte[] memberAssignment = (byte[])assignment$1.apply((Object)memberMetadata.memberId());
        Predef$.MODULE$.assert(memberAssignment != null);
        memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
        return memberStruct;
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$1() {
        return "";
    }

    public static final /* synthetic */ byte[] $anonfun$parseGroupMetadata$3(ByteBuffer x$1) {
        return Utils.toArray((ByteBuffer)x$1);
    }

    public static final /* synthetic */ String $anonfun$parseGroupMetadata$5() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private GroupMetadataManager$() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        MODULE$ = this;
        this.CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        this.CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        this.OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
        this.OFFSET_KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        this.OFFSET_KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        this.OFFSET_KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.OFFSET_VALUE_TIMESTAMP_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64), new Field("expire_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("commit_timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("leader_epoch", (Type)Type.INT32), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("offset");
        this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("leader_epoch");
        this.OFFSET_VALUE_METADATA_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("commit_timestamp");
        this.GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING)});
        this.GROUP_KEY_GROUP_FIELD = this.GROUP_METADATA_KEY_SCHEMA().get("group");
        this.MEMBER_ID_KEY = "member_id";
        this.GROUP_INSTANCE_ID_KEY = "group_instance_id";
        this.CLIENT_ID_KEY = "client_id";
        this.CLIENT_HOST_KEY = "client_host";
        this.REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        this.SESSION_TIMEOUT_KEY = "session_timeout";
        this.SUBSCRIPTION_KEY = "subscription";
        this.ASSIGNMENT_KEY = "assignment";
        this.MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.MEMBER_METADATA_V2 = this.MEMBER_METADATA_V1();
        this.MEMBER_METADATA_V3 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.GROUP_INSTANCE_ID_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.PROTOCOL_TYPE_KEY = "protocol_type";
        this.GENERATION_KEY = "generation";
        this.PROTOCOL_KEY = "protocol";
        this.LEADER_KEY = "leader";
        this.CURRENT_STATE_TIMESTAMP_KEY = "current_state_timestamp";
        this.MEMBERS_KEY = "members";
        this.GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V0()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V1()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V2()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V3()))});
        Tuple2[] tuple2Array = new Tuple2[3];
        Schema schema = this.OFFSET_COMMIT_KEY_SCHEMA();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        Schema schema2 = this.OFFSET_COMMIT_KEY_SCHEMA();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        Schema schema3 = this.GROUP_METADATA_KEY_SCHEMA();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        this.MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Tuple2[] tuple2Array2 = new Tuple2[4];
        Schema schema4 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0();
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        Schema schema5 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1();
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Schema schema6 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2();
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Schema schema7 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3();
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        this.OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Tuple2[] tuple2Array3 = new Tuple2[4];
        Schema schema8 = this.GROUP_METADATA_VALUE_SCHEMA_V0();
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Schema schema9 = this.GROUP_METADATA_VALUE_SCHEMA_V1();
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Schema schema10 = this.GROUP_METADATA_VALUE_SCHEMA_V2();
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Schema schema11 = this.GROUP_METADATA_VALUE_SCHEMA_V3();
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3));
        this.CURRENT_OFFSET_KEY_SCHEMA = this.schemaForKey(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        this.CURRENT_GROUP_KEY_SCHEMA = this.schemaForKey(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
    }
}

