/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import co.elastic.logstash.api.Password;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class ModulesSettingArray
extends ArrayList<Map<String, Object>> {
    private static final long serialVersionUID = 4094949366274116593L;

    public ModulesSettingArray(Collection<? extends Map<String, Object>> original) {
        super(ModulesSettingArray.wrapPasswords(original));
    }

    private static Collection<Map<String, Object>> wrapPasswords(Collection<? extends Map<String, Object>> original) {
        return original.stream().map(ModulesSettingArray::wrapPasswordsInSettings).collect(Collectors.toList());
    }

    private static Map<String, Object> wrapPasswordsInSettings(Map<String, Object> settings) {
        LinkedHashMap<String, Object> acc = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            if (entry.getKey().endsWith("password") && !(entry.getValue() instanceof Password)) {
                acc.put(entry.getKey(), new Password((String)entry.getValue()));
                continue;
            }
            acc.put(entry.getKey(), entry.getValue());
        }
        return acc;
    }

    @Override
    public Map<String, Object> getFirst() {
        try {
            return (Map)this.get(0);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    @Override
    public Map<String, Object> getLast() {
        try {
            return (Map)this.get(this.size() - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }
}

