/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.execution.QueueBatch;

@JRubyClass(name={"PipelineReporter"})
public final class PipelineReporterExt
extends RubyBasicObject {
    private static final long serialVersionUID = 1L;
    private static final RubySymbol EVENTS_FILTERED_KEY = RubyUtil.RUBY.newSymbol("events_filtered");
    private static final RubySymbol EVENTS_CONSUMED_KEY = RubyUtil.RUBY.newSymbol("events_consumed");
    private static final RubySymbol INFLIGHT_COUNT_KEY = RubyUtil.RUBY.newSymbol("inflight_count");
    private static final RubySymbol WORKER_STATES_KEY = RubyUtil.RUBY.newSymbol("worker_states");
    private static final RubySymbol OUTPUT_INFO_KEY = RubyUtil.RUBY.newSymbol("output_info");
    private static final RubySymbol THREAD_INFO_KEY = RubyUtil.RUBY.newSymbol("thread_info");
    private static final RubySymbol STALLING_THREADS_INFO_KEY = RubyUtil.RUBY.newSymbol("stalling_threads_info");
    private static final RubySymbol TYPE_KEY = RubyUtil.RUBY.newSymbol("type");
    private static final RubySymbol ID_KEY = RubyUtil.RUBY.newSymbol("id");
    private static final RubySymbol STATUS_KEY = RubyUtil.RUBY.newSymbol("status");
    private static final RubySymbol ALIVE_KEY = RubyUtil.RUBY.newSymbol("alive");
    private static final RubySymbol INDEX_KEY = RubyUtil.RUBY.newSymbol("index");
    private static final RubySymbol CONCURRENCY_KEY = RubyUtil.RUBY.newSymbol("concurrency");
    private static final RubyString DEAD_STATUS = RubyUtil.RUBY.newString("dead").newFrozen();
    private IRubyObject logger;
    private IRubyObject pipeline;

    public PipelineReporterExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod
    public PipelineReporterExt initialize(ThreadContext context, IRubyObject logger, IRubyObject pipeline) {
        this.logger = logger;
        this.pipeline = pipeline;
        return this;
    }

    @JRubyMethod
    public IRubyObject pipeline() {
        return this.pipeline;
    }

    @JRubyMethod
    public IRubyObject logger() {
        return this.logger;
    }

    @JRubyMethod
    public SnapshotExt snapshot(ThreadContext context) {
        return new SnapshotExt(context.runtime, RubyUtil.PIPELINE_REPORTER_SNAPSHOT_CLASS).initialize((IRubyObject)this.toHash(context));
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash toHash(ThreadContext context) {
        RubyHash result = RubyHash.newHash((Ruby)context.runtime);
        RubyHash batchMap = (RubyHash)this.pipeline.callMethod(context, "filter_queue_client").callMethod(context, "inflight_batches");
        RubyArray workerStates = this.workerStates(context, batchMap);
        result.op_aset(context, (IRubyObject)WORKER_STATES_KEY, (IRubyObject)workerStates);
        result.op_aset(context, (IRubyObject)EVENTS_FILTERED_KEY, this.pipeline.callMethod(context, "events_filtered").callMethod(context, "sum"));
        result.op_aset(context, (IRubyObject)EVENTS_CONSUMED_KEY, this.pipeline.callMethod(context, "events_consumed").callMethod(context, "sum"));
        result.op_aset(context, (IRubyObject)OUTPUT_INFO_KEY, (IRubyObject)this.outputInfo(context));
        result.op_aset(context, (IRubyObject)THREAD_INFO_KEY, this.pipeline.callMethod(context, "plugin_threads_info"));
        result.op_aset(context, (IRubyObject)STALLING_THREADS_INFO_KEY, this.pipeline.callMethod(context, "stalling_threads_info"));
        result.op_aset(context, (IRubyObject)INFLIGHT_COUNT_KEY, (IRubyObject)context.runtime.newFixnum(PipelineReporterExt.calcInflightCount(context, workerStates)));
        return result;
    }

    private RubyArray workerStates(ThreadContext context, RubyHash batchMap) {
        RubyArray result = context.runtime.newArray();
        ((Iterable)this.pipeline.callMethod(context, "worker_threads")).forEach(thread -> {
            long nativeThreadId = ((RubyThread)thread).getNativeThread().getId();
            RubyHash hash = RubyHash.newHash((Ruby)context.runtime);
            IRubyObject status = thread.callMethod(context, "status");
            if (status.isNil()) {
                status = DEAD_STATUS;
            }
            hash.op_aset(context, (IRubyObject)STATUS_KEY, status);
            hash.op_aset(context, (IRubyObject)ALIVE_KEY, thread.callMethod(context, "alive?"));
            hash.op_aset(context, (IRubyObject)INDEX_KEY, (IRubyObject)context.runtime.newFixnum(result.size()));
            IRubyObject batch = batchMap.op_aref(context, (IRubyObject)context.runtime.newFixnum(nativeThreadId));
            hash.op_aset(context, (IRubyObject)INFLIGHT_COUNT_KEY, this.extractBatchSize(context, batch));
            result.add((Object)hash);
        });
        return result;
    }

    private IRubyObject extractBatchSize(ThreadContext context, IRubyObject batch) {
        if (!batch.isNil()) {
            if (QueueBatch.class.isAssignableFrom(batch.getJavaClass())) {
                int filteredSize = ((QueueBatch)batch.toJava(QueueBatch.class)).filteredSize();
                return this.getRuntime().newFixnum(filteredSize);
            }
            if (batch.respondsTo("size")) {
                return batch.callMethod(context, "size");
            }
        }
        return context.runtime.newFixnum(0L);
    }

    private RubyArray outputInfo(ThreadContext context) {
        RubyArray result = context.runtime.newArray();
        IRubyObject outputs = this.pipeline.callMethod(context, "outputs");
        Iterable outputIterable = outputs instanceof Iterable ? (Iterable)outputs : (Iterable)outputs.toJava(Iterable.class);
        outputIterable.forEach(output -> {
            AbstractOutputDelegatorExt delegator = (AbstractOutputDelegatorExt)((Object)output);
            RubyHash hash = RubyHash.newHash((Ruby)context.runtime);
            hash.op_aset(context, (IRubyObject)TYPE_KEY, delegator.configName(context));
            hash.op_aset(context, (IRubyObject)ID_KEY, delegator.getId());
            hash.op_aset(context, (IRubyObject)CONCURRENCY_KEY, delegator.concurrency(context));
            result.add((Object)hash);
        });
        return result;
    }

    private static int calcInflightCount(ThreadContext context, Collection<?> workerStates) {
        return workerStates.stream().mapToInt(state -> ((RubyHash)state).op_aref(context, (IRubyObject)INFLIGHT_COUNT_KEY).convertToInteger().getIntValue()).sum();
    }

    @JRubyClass(name={"Snapshot"})
    public static final class SnapshotExt
    extends RubyBasicObject {
        private static final long serialVersionUID = 1L;
        private static final RubyString INFLIGHT_COUNT_KEY = RubyUtil.RUBY.newString("inflight_count").newFrozen();
        private static final RubyString STALLING_THREADS_KEY = RubyUtil.RUBY.newString("stalling_threads_info").newFrozen();
        private static final RubyString PLUGIN_KEY = RubyUtil.RUBY.newString("plugin").newFrozen();
        private static final RubyString OTHER_KEY = RubyUtil.RUBY.newString("other").newFrozen();
        private RubyHash data;

        public SnapshotExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public SnapshotExt initialize(IRubyObject data) {
            this.data = (RubyHash)data;
            return this;
        }

        @JRubyMethod(name={"to_hash"})
        public RubyHash toHash() {
            return this.data;
        }

        @JRubyMethod(name={"to_simple_hash"})
        public RubyHash toSimpleHash(ThreadContext context) {
            RubyHash result = RubyHash.newHash((Ruby)context.runtime);
            result.op_aset(context, (IRubyObject)INFLIGHT_COUNT_KEY, this.data.op_aref(context, (IRubyObject)INFLIGHT_COUNT_KEY.intern()));
            result.op_aset(context, (IRubyObject)STALLING_THREADS_KEY, (IRubyObject)this.formatThreadsByPlugin(context));
            return result;
        }

        @JRubyMethod(name={"to_s", "to_str"})
        public RubyString toStr(ThreadContext context) {
            return (RubyString)this.toSimpleHash(context).to_s(context);
        }

        @JRubyMethod(name={"method_missing"})
        public IRubyObject methodMissing(ThreadContext context, IRubyObject method) {
            return this.data.op_aref(context, method);
        }

        @JRubyMethod(name={"respond_to_missing?"})
        public IRubyObject isRespondToMissing(ThreadContext context, IRubyObject method, IRubyObject includePrivate) {
            return context.tru;
        }

        @JRubyMethod(name={"format_threads_by_plugin"})
        public RubyHash formatThreadsByPlugin(ThreadContext context) {
            RubyHash result = RubyHash.newHash((Ruby)context.runtime);
            ((Iterable)this.data.get((Object)STALLING_THREADS_KEY.intern())).forEach(thr -> {
                RubyHash threadInfo = (RubyHash)thr;
                IRubyObject key = threadInfo.delete(context, (IRubyObject)PLUGIN_KEY, Block.NULL_BLOCK);
                if (key.isNil()) {
                    key = OTHER_KEY;
                }
                if (result.op_aref(context, key).isNil()) {
                    result.op_aset(context, key, (IRubyObject)context.runtime.newArray());
                }
                ((RubyArray)result.op_aref(context, key)).append((IRubyObject)threadInfo);
            });
            return result;
        }
    }
}

