/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CompressSpacePageOperation10_2;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public class CompressSpacePageOperation
extends PhysicalPageOperation {
    protected int newHighestPage;
    protected int num_pages_truncated;

    CompressSpacePageOperation(AllocPage allocPage, int n, int n2) throws StandardException {
        super(allocPage);
        this.newHighestPage = n;
        this.num_pages_truncated = n2;
    }

    public CompressSpacePageOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (!(this instanceof CompressSpacePageOperation10_2)) {
            objectOutput.writeInt(this.newHighestPage);
            CompressedNumber.writeInt(objectOutput, this.num_pages_truncated);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (!(this instanceof CompressSpacePageOperation10_2)) {
            this.newHighestPage = objectInput.readInt();
            this.num_pages_truncated = CompressedNumber.readInt(objectInput);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 465;
    }

    @Override
    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)this.page).compressSpace(logInstant, this.newHighestPage, this.num_pages_truncated);
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)basePage).undoCompressSpace(logInstant, this.newHighestPage, this.num_pages_truncated);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) {
    }

    @Override
    public String toString() {
        return null;
    }
}

