/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigDecimal;

class SafeDecimalParser {
    protected static final BigDecimal TWO = new BigDecimal(2);
    protected static final BigDecimal LOWER = new BigDecimal("2.22507385850720113605e-308");
    protected static final BigDecimal UPPER = new BigDecimal("2.22507385850720125958e-308");
    protected static final BigDecimal MIDDLE = LOWER.add(UPPER).divide(TWO);
    private static final Double UPPER_DOUBLE = UPPER.doubleValue();
    private static final Double LOWER_DOUBLE = LOWER.doubleValue();
    private static final String SUSPICIOUS_DIGITS = "22250738585072";

    SafeDecimalParser() {
    }

    protected static final boolean isSuspicious(String s2) {
        return SafeDecimalParser.digits(s2).indexOf(SUSPICIOUS_DIGITS) >= 0;
    }

    protected static final Double decimalValueOf(String s2) {
        Double result2 = null;
        if (s2 != null) {
            result2 = SafeDecimalParser.isSuspicious(s2) ? SafeDecimalParser.parseSafely(s2) : Double.valueOf(s2);
        }
        return result2;
    }

    protected static final double decimalValue(Number number) {
        double result2 = 0.0;
        if (number != null) {
            result2 = number instanceof BigDecimal ? SafeDecimalParser.decimalValue((BigDecimal)number) : number.doubleValue();
        }
        return result2;
    }

    protected static final double decimalValue(BigDecimal bigDecimal) {
        double result2 = 0.0;
        if (bigDecimal != null) {
            result2 = SafeDecimalParser.isDangerous(bigDecimal) ? SafeDecimalParser.decimalValueOf(bigDecimal.toString()).doubleValue() : bigDecimal.doubleValue();
        }
        return result2;
    }

    private static final Double parseSafely(String s2) {
        BigDecimal bd = new BigDecimal(s2);
        Double result2 = SafeDecimalParser.isDangerous(bd) ? (bd.compareTo(MIDDLE) >= 0 ? UPPER_DOUBLE : LOWER_DOUBLE) : Double.valueOf(s2);
        return result2;
    }

    private static final String digits(String s2) {
        char[] ca = s2.toCharArray();
        int len = ca.length;
        StringBuilder b2 = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            char c = ca[i2];
            if (c < '0' || c > '9') continue;
            b2.append(c);
        }
        return b2.toString();
    }

    private static final boolean isDangerous(BigDecimal bd) {
        return bd.compareTo(UPPER) < 0 && bd.compareTo(LOWER) > 0;
    }
}

