/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public abstract class HandshakeSniffingTransportWrapper<T1 extends TransportWrapper, T2 extends TransportWrapper>
implements TransportWrapper {
    protected final T1 _wrapper1;
    protected final T2 _wrapper2;
    private boolean _tail_closed = false;
    private boolean _head_closed = false;
    protected TransportWrapper _selectedTransportWrapper;
    private final ByteBuffer _determinationBuffer;
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    protected HandshakeSniffingTransportWrapper(T1 wrapper1, T2 wrapper2) {
        this._wrapper1 = wrapper1;
        this._wrapper2 = wrapper2;
        this._determinationBuffer = ByteBuffer.allocate(this.bufferSize());
    }

    @Override
    public int capacity() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.capacity();
        }
        if (this._tail_closed) {
            return -1;
        }
        return this._determinationBuffer.remaining();
    }

    @Override
    public int position() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.position();
        }
        if (this._tail_closed) {
            return -1;
        }
        return this._determinationBuffer.position();
    }

    @Override
    public ByteBuffer tail() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.tail();
        }
        return this._determinationBuffer;
    }

    protected abstract int bufferSize();

    protected abstract void makeDetermination(byte[] var1);

    @Override
    public void process() throws TransportException {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.process();
        } else if (this._determinationBuffer.remaining() == 0) {
            this._determinationBuffer.flip();
            byte[] bytesInput = new byte[this._determinationBuffer.remaining()];
            this._determinationBuffer.get(bytesInput);
            this.makeDetermination(bytesInput);
            this._determinationBuffer.rewind();
            this._selectedTransportWrapper.tail().put(this._determinationBuffer);
            this._selectedTransportWrapper.process();
        } else if (this._tail_closed) {
            throw new TransportException("connection aborted");
        }
    }

    @Override
    public void close_tail() {
        try {
            if (this.isDeterminationMade()) {
                this._selectedTransportWrapper.close_tail();
            }
        }
        finally {
            this._tail_closed = true;
        }
    }

    @Override
    public int pending() {
        if (this._head_closed) {
            return -1;
        }
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.pending();
        }
        return 0;
    }

    @Override
    public ByteBuffer head() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.head();
        }
        return EMPTY;
    }

    @Override
    public void pop(int bytes) {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.pop(bytes);
        } else if (bytes > 0) {
            throw new IllegalStateException("no bytes have been read");
        }
    }

    @Override
    public void close_head() {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.close_head();
        } else {
            this._head_closed = true;
        }
    }

    protected boolean isDeterminationMade() {
        return this._selectedTransportWrapper != null;
    }
}

