/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SslFactory {
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore = null;
    private String keyPassword;
    private SecurityStore truststore;
    private SSLContext sslContext;

    public SslFactory(Map<String, ?> configs) {
        this.protocol = (String)configs.get("ssl.protocol");
        if (this.protocol == null) {
            this.protocol = "TLS";
        }
        this.provider = (String)configs.get("ssl.provider");
        this.kmfAlgorithm = (String)configs.get("ssl.keymanager.algorithm");
        this.tmfAlgorithm = (String)configs.get("ssl.trustmanager.algorithm");
        try {
            this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (String)configs.get("ssl.keystore.password"), (String)configs.get("ssl.key.password"));
            this.createTruststore((String)configs.get("ssl.truststore.type"), (String)configs.get("ssl.truststore.location"), (String)configs.get("ssl.truststore.password"));
            this.sslContext = this.createSslContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing the ssl context for RestService", e);
        }
    }

    private static boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    private SSLContext createSslContext() throws GeneralSecurityException, IOException {
        if (this.truststore == null && this.keystore == null) {
            return null;
        }
        SSLContext sslContext = SslFactory.isNotBlank(this.provider) ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
        KeyManager[] keyManagers = null;
        if (this.keystore != null) {
            String kmfAlgorithm = SslFactory.isNotBlank(this.kmfAlgorithm) ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
            KeyStore ks = this.keystore.load();
            String keyPassword = this.keyPassword != null ? this.keyPassword : this.keystore.password;
            kmf.init(ks, keyPassword.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        String tmfAlgorithm = SslFactory.isNotBlank(this.tmfAlgorithm) ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        KeyStore ts = this.truststore == null ? null : this.truststore.load();
        tmf.init(ts);
        sslContext.init(keyManagers, tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    private void createKeystore(String type, String path, String password, String keyPassword) {
        if (path == null && password != null) {
            throw new RuntimeException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new RuntimeException("SSL key store is specified, but key store password is not specified.");
        }
        if (SslFactory.isNotBlank(path) && SslFactory.isNotBlank(password)) {
            this.keystore = new SecurityStore(type, path, password);
            this.keyPassword = keyPassword;
        }
    }

    private void createTruststore(String type, String path, String password) {
        if (path == null && password != null) {
            throw new RuntimeException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (SslFactory.isNotBlank(path)) {
            this.truststore = new SecurityStore(type, path, password);
        }
    }

    private static class SecurityStore {
        private final String type;
        private final String path;
        private final String password;

        private SecurityStore(String type, String path, String password) {
            this.type = type == null ? KeyStore.getDefaultType() : type;
            this.path = path;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore load() throws GeneralSecurityException, IOException {
            try (FileInputStream in = null;){
                KeyStore ks = KeyStore.getInstance(this.type);
                in = new FileInputStream(this.path);
                char[] passwordChars = this.password != null ? this.password.toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
    }
}

