/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nokogiri.Html4Document;
import nokogiri.NokogiriService;
import nokogiri.XmlComment;
import nokogiri.XmlDtd;
import nokogiri.XmlElement;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.XmlProcessingInstruction;
import nokogiri.XmlText;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import nokogiri.internals.c14n.CanonicalFilter;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.Canonicalizer;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::Document"}, parent="Nokogiri::XML::Node")
public class XmlDocument
extends XmlNode {
    private NokogiriNamespaceCache nsCache;
    public static final String DTD_RAW_DOCUMENT = "DTD_RAW_DOCUMENT";
    public static final String DTD_INTERNAL_SUBSET = "DTD_INTERNAL_SUBSET";
    public static final String DTD_EXTERNAL_SUBSET = "DTD_EXTERNAL_SUBSET";
    private static final String DOCUMENTBUILDERFACTORY_IMPLE_NAME = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final ByteList DOCUMENT = ByteList.create((CharSequence)"document");
    private static boolean substituteEntities;
    private static boolean loadExternalSubset;
    protected IRubyObject encoding;
    protected IRubyObject url;

    public XmlDocument(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass, XmlDocument.createNewDocument(ruby));
    }

    public XmlDocument(Ruby ruby, Document document) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), document);
    }

    public XmlDocument(Ruby ruby, RubyClass rubyClass, Document document) {
        super(ruby, rubyClass, document);
        this.init(ruby, document);
    }

    void init(Ruby ruby, Document document) {
        XmlDocument.stabilizeTextContent(document);
        if (document.getDocumentElement() != null) {
            XmlDocument.createAndCacheNamespaces(ruby, document.getDocumentElement());
        }
        this.setInstanceVariable("@decorators", ruby.getNil());
    }

    public final void setDocumentNode(Ruby ruby, Document document) {
        super.setNode(ruby, document);
        if (document != null) {
            this.init(ruby, document);
        } else {
            this.setInstanceVariable("@decorators", ruby.getNil());
        }
    }

    public void setEncoding(IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
    }

    public IRubyObject getEncoding() {
        return this.encoding;
    }

    protected static void stabilizeTextContent(Document document) {
        if (document.getDocumentElement() != null) {
            document.getDocumentElement().getTextContent();
        }
    }

    private static void createAndCacheNamespaces(Ruby ruby, Node node) {
        int n;
        Object object;
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                Attr attr = (Attr)node2;
                XmlDocument.stabilizeAttr(attr);
                if (!NokogiriHelpers.isNamespace(attr.getName())) continue;
                XmlNamespace.createFromAttr(ruby, attr);
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            XmlDocument.createAndCacheNamespaces(ruby, object.item(n));
        }
    }

    static void stabilizeAttr(Attr attr) {
        attr.getValue();
    }

    public XmlDocument(Ruby ruby, RubyClass rubyClass, Document document, XmlDocument xmlDocument) {
        super(ruby, rubyClass, document);
        this.nsCache = xmlDocument.getNamespaceCache();
        String string = this.nsCache.getDefault().getHref();
        this.resolveNamespaceIfNecessary(document.getDocumentElement(), string);
    }

    private void resolveNamespaceIfNecessary(Node node, String string) {
        Object object;
        if (node == null) {
            return;
        }
        String string2 = node.getPrefix();
        if (string2 == null) {
            NokogiriHelpers.renameNode(node, string, node.getNodeName());
        } else {
            object = this.getNamespaceCache().get(node, string2).getHref();
            NokogiriHelpers.renameNode(node, (String)object, node.getNodeName());
        }
        this.resolveNamespaceIfNecessary(node.getNextSibling(), string);
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            this.resolveNamespaceIfNecessary(object.item(i), string);
        }
    }

    public NokogiriNamespaceCache getNamespaceCache() {
        if (this.nsCache == null) {
            this.nsCache = new NokogiriNamespaceCache();
        }
        return this.nsCache;
    }

    public Document getDocument() {
        return (Document)this.node;
    }

    @Override
    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name == null) {
            this.name = RubyString.newStringShared((Ruby)threadContext.runtime, (ByteList)DOCUMENT);
        }
        return this.name;
    }

    public void setUrl(IRubyObject iRubyObject) {
        this.url = iRubyObject;
    }

    protected IRubyObject getUrl() {
        return this.url;
    }

    @JRubyMethod
    public IRubyObject url(ThreadContext threadContext) {
        return this.getUrl();
    }

    public static Document createNewDocument(Ruby ruby) {
        try {
            return DocumentBuilderFactoryHolder.INSTANCE.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw XmlDocument.asRuntimeError(ruby, null, parserConfigurationException);
        }
    }

    static RaiseException asRuntimeError(Ruby ruby, String string, Exception exception) {
        if (exception instanceof RaiseException) {
            return (RaiseException)exception;
        }
        string = string == null ? exception.toString() : string + '(' + exception.toString() + ')';
        RaiseException raiseException = ruby.newRuntimeError(string);
        raiseException.initCause((Throwable)exception);
        return raiseException;
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument;
        Ruby ruby = threadContext.runtime;
        try {
            Document document = XmlDocument.createNewDocument(ruby);
            xmlDocument = "Nokogiri::HTML4::Document".equals(((RubyClass)iRubyObject).getName()) ? new Html4Document(threadContext.runtime, (RubyClass)iRubyObject, document) : new XmlDocument(threadContext.runtime, (RubyClass)iRubyObject, document);
        }
        catch (Exception exception) {
            throw XmlDocument.asRuntimeError(ruby, "couldn't create document: ", exception);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return xmlDocument;
    }

    @JRubyMethod(required=1, optional=4)
    public IRubyObject create_entity(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw threadContext.runtime.newRuntimeError("Could not create entity");
        }
        String string = NokogiriHelpers.rubyStringToString(iRubyObjectArray[0]);
        Element element = this.getOwnerDocument().createElement(string);
        return XmlEntityDecl.create(threadContext, element, iRubyObjectArray);
    }

    @Override
    XmlDocument document(Ruby ruby) {
        return this;
    }

    @JRubyMethod(name={"encoding="})
    public IRubyObject encoding_set(IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
        return this;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext threadContext) {
        if (this.encoding == null || this.encoding.isNil()) {
            String string = this.getDocument().getXmlEncoding();
            this.encoding = string == null ? threadContext.nil : threadContext.runtime.newString(string);
        }
        return this.encoding.isNil() ? this.encoding : this.encoding.asString().encode(threadContext, (IRubyObject)threadContext.getRuntime().newString("UTF-8"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_external_subsets_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        loadExternalSubset = iRubyObject2.isTrue();
        return threadContext.nil;
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        xmlDomParserContext.setIOInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return xmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        xmlDomParserContext.setStringInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return xmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(name={"remove_namespaces!"})
    public IRubyObject remove_namespaces(ThreadContext threadContext) {
        this.removeNamespaceRecursively(this);
        if (this.nsCache != null) {
            this.nsCache.clear();
        }
        NokogiriHelpers.clearXpathContext(this.getNode());
        return this;
    }

    private void removeNamespaceRecursively(XmlNode xmlNode) {
        Object object;
        int n;
        Object object2;
        Node node = xmlNode.node;
        if (node.getNodeType() == 1) {
            node.setPrefix(null);
            NokogiriHelpers.renameNode(node, null, node.getLocalName());
            object2 = node.getAttributes();
            for (n = 0; n < object2.getLength(); ++n) {
                object = (Attr)object2.item(n);
                if (NokogiriHelpers.isNamespace(object.getNodeName())) {
                    ((Element)node).removeAttributeNode((Attr)object);
                    continue;
                }
                object.setPrefix(null);
                NokogiriHelpers.renameNode((Node)object, null, object.getLocalName());
            }
        }
        object2 = xmlNode.getChildren();
        for (n = 0; n < ((IRubyObject[])object2).length; ++n) {
            object = (XmlNode)object2[n];
            this.removeNamespaceRecursively((XmlNode)((Object)object));
        }
    }

    @JRubyMethod
    public IRubyObject root(ThreadContext threadContext) {
        Element element = this.getDocument().getDocumentElement();
        if (element == null) {
            return threadContext.nil;
        }
        Object object = element.getUserData("NOKOGIRI_ROOT_NODE_INVALID");
        if (object != null && ((Boolean)object).booleanValue()) {
            return threadContext.nil;
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, element);
    }

    @Override
    protected IRubyObject dup_implementation(Ruby ruby, boolean bl) {
        XmlDocument xmlDocument = (XmlDocument)super.dup_implementation(ruby, bl);
        xmlDocument.resetCache();
        return xmlDocument;
    }

    @JRubyMethod(name={"root="})
    public IRubyObject root_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == threadContext.nil) {
            this.getDocument().getDocumentElement().setUserData("NOKOGIRI_ROOT_NODE_INVALID", Boolean.TRUE, null);
            return iRubyObject;
        }
        if (!(iRubyObject instanceof XmlNode)) {
            throw threadContext.runtime.newArgumentError("expected Nokogiri::XML::Node but received " + iRubyObject.getType());
        }
        XmlNode xmlNode = XmlDocument.asXmlNode(threadContext, iRubyObject);
        IRubyObject iRubyObject2 = this.root(threadContext);
        if (iRubyObject2.isNil()) {
            Node node = this.getDocument() == xmlNode.getOwnerDocument() ? xmlNode.node : this.getDocument().importNode(xmlNode.node, true);
            this.add_child_node(threadContext, NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node));
        } else {
            Node node = XmlDocument.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject2).node;
            ((XmlNode)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node)).replace_node(threadContext, (IRubyObject)xmlNode);
        }
        return xmlNode;
    }

    @JRubyMethod
    public IRubyObject version(ThreadContext threadContext) {
        return NokogiriHelpers.stringOrNil(threadContext.runtime, this.getDocument().getXmlVersion());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject substitute_entities_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        substituteEntities = iRubyObject2.isTrue();
        return threadContext.nil;
    }

    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        Object object = (IRubyObject)this.node.getUserData(DTD_INTERNAL_SUBSET);
        if (object == null) {
            Document document = this.getDocument();
            if (document.getUserData(DTD_RAW_DOCUMENT) != null) {
                object = XmlDtd.newFromInternalSubset(threadContext.runtime, document);
            } else if (document.getDoctype() != null) {
                IRubyObject iRubyObject;
                DocumentType documentType = document.getDoctype();
                IRubyObject iRubyObject2 = iRubyObject = threadContext.nil;
                IRubyObject iRubyObject3 = iRubyObject;
                if (documentType.getName() != null) {
                    iRubyObject3 = threadContext.runtime.newString(documentType.getName());
                }
                if (documentType.getPublicId() != null) {
                    iRubyObject2 = threadContext.runtime.newString(documentType.getPublicId());
                }
                if (documentType.getSystemId() != null) {
                    iRubyObject = threadContext.runtime.newString(documentType.getSystemId());
                }
                object = XmlDtd.newEmpty(threadContext.runtime, document, iRubyObject3, iRubyObject2, iRubyObject);
            } else {
                object = threadContext.nil;
            }
            this.setInternalSubset((IRubyObject)object);
        }
        return object;
    }

    public IRubyObject createInternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.runtime, this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setInternalSubset((IRubyObject)xmlDtd);
        return xmlDtd;
    }

    protected void setInternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_INTERNAL_SUBSET, iRubyObject, null);
    }

    public IRubyObject getExternalSubset(ThreadContext threadContext) {
        IRubyObject iRubyObject = (IRubyObject)this.node.getUserData(DTD_EXTERNAL_SUBSET);
        if (iRubyObject == null) {
            return threadContext.nil;
        }
        return iRubyObject;
    }

    public IRubyObject createExternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.runtime, this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setExternalSubset((IRubyObject)xmlDtd);
        return xmlDtd;
    }

    protected void setExternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_EXTERNAL_SUBSET, iRubyObject, null);
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        Document document = this.getDocument();
        saveContextVisitor.enter(document);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XmlNode xmlNode;
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 8) {
                xmlNode = (XmlComment)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
                ((XmlComment)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 10) {
                xmlNode = (XmlDtd)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
                ((XmlDtd)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 7) {
                xmlNode = (XmlProcessingInstruction)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
                ((XmlProcessingInstruction)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s == 3) {
                xmlNode = (XmlText)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
                ((XmlText)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s != 1) continue;
            xmlNode = (XmlElement)NokogiriHelpers.getCachedNodeOrCreate(threadContext.runtime, node);
            ((XmlElement)xmlNode).accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(document);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlDocument xmlDocument = new XmlDocument(threadContext.runtime, (RubyClass)iRubyObject, (Document)iRubyObject2.toJava(Document.class));
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"initialize");
        return xmlDocument;
    }

    @Deprecated
    @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wrapJavaDocument(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return XmlDocument.wrap(threadContext, iRubyObject, iRubyObject2);
    }

    @Deprecated
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject toJavaDocument(ThreadContext threadContext) {
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)threadContext.getRuntime(), (Object)this.node);
    }

    @JRubyMethod(optional=3)
    public IRubyObject canonicalize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        int n = 0;
        String string = null;
        Boolean bl = false;
        if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil()) {
            n = RubyFixnum.fix2int((IRubyObject)iRubyObjectArray[0]);
        }
        if (iRubyObjectArray.length > 1) {
            if (!iRubyObjectArray[1].isNil() && !(iRubyObjectArray[1] instanceof List)) {
                throw threadContext.runtime.newTypeError("Expected array");
            }
            if (!iRubyObjectArray[1].isNil()) {
                string = ((RubyArray)iRubyObjectArray[1]).join(threadContext, (IRubyObject)threadContext.runtime.newString(" ")).asString().asJavaString();
            }
        }
        if (iRubyObjectArray.length > 2) {
            bl = iRubyObjectArray[2].isTrue();
        }
        String string2 = null;
        switch (n) {
            case 0: {
                if (bl.booleanValue()) {
                    string2 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
                    break;
                }
                string2 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
                break;
            }
            case 1: {
                if (bl.booleanValue()) {
                    string2 = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
                    break;
                }
                string2 = "http://www.w3.org/2001/10/xml-exc-c14n#";
                break;
            }
            case 2: {
                string2 = bl != false ? "http://www.w3.org/2006/12/xml-c14n11#WithComments" : "http://www.w3.org/2006/12/xml-c14n11";
            }
        }
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(string2);
            XmlNode xmlNode = this.getStartingNode(block);
            CanonicalFilter canonicalFilter = new CanonicalFilter(threadContext, block);
            byte[] byArray = string == null ? canonicalizer.canonicalizeSubtree(xmlNode.getNode(), canonicalFilter) : canonicalizer.canonicalizeSubtree(xmlNode.getNode(), string, canonicalFilter);
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)new ByteList(byArray, (Encoding)UTF8Encoding.INSTANCE));
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
            return threadContext.nil;
        }
    }

    private XmlNode getStartingNode(Block block) {
        IRubyObject iRubyObject;
        if (block.isGiven() && (iRubyObject = block.getBinding().getSelf()) instanceof XmlNode) {
            return (XmlNode)iRubyObject;
        }
        return this;
    }

    public void resetNamespaceCache(ThreadContext threadContext) {
        this.nsCache = new NokogiriNamespaceCache();
        XmlDocument.createAndCacheNamespaces(threadContext.runtime, this.node);
    }

    static {
        DOCUMENT.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
        substituteEntities = false;
        loadExternalSubset = false;
    }

    private static class DocumentBuilderFactoryHolder {
        static final DocumentBuilderFactory INSTANCE = DocumentBuilderFactory.newInstance("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", NokogiriService.class.getClassLoader());

        private DocumentBuilderFactoryHolder() {
        }
    }
}

