/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rud\u0001B\u0016-\u0001EB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\t\u0001BC\u0002\u0013\u00051\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003M\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u00199\b\u0001)A\u0005c\"9\u0001\u0010\u0001b\u0001\n\u0013I\bBB?\u0001A\u0003%!\u0010C\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0003A\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u00037Aq!!\n\u0001\t\u0003\t9\u0003C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u00022!A\u0011\u0011\b\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002>!A\u0011Q\t\u0001!\u0002\u0013\ty\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057BqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003\u001e\u0002!IAa(\t\u000f\t%\u0006\u0001\"\u0003\u0003,\"9!1\u001b\u0001\u0005\n\tU\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_DqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0004\u0014\u0001!\ta!\u0006\t\u000f\r]\u0001\u0001\"\u0003\u0004\u001a!91q\u0004\u0001\u0005\n\r\u0005\u0002bBB\u0015\u0001\u0011%11\u0006\u0005\b\u0007\u007f\u0001A\u0011BB!\u0011\u001d\u0019i\u0007\u0001C\u0005\u0007_\u0012A\"\u00113nS:l\u0015M\\1hKJT!!\f\u0018\u0002\rM,'O^3s\u0015\u0005y\u0013!B6bM.\f7\u0001A\n\u0005\u0001IBd\b\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003w9\nQ!\u001e;jYNL!!\u0010\u001e\u0003\u000f1{wmZ5oOB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IL\u0001\b[\u0016$(/[2t\u0013\t\u0019\u0005IA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\faaY8oM&<W#\u0001$\u0011\u0005\u001dCU\"\u0001\u0017\n\u0005%c#aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%F\u0001M!\tie+D\u0001O\u0015\t\tuJ\u0003\u0002Q#\u000611m\\7n_:T!a\f*\u000b\u0005M#\u0016AB1qC\u000eDWMC\u0001V\u0003\ry'oZ\u0005\u0003/:\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u00035iW\r^1eCR\f7)Y2iKV\t1\f\u0005\u0002H9&\u0011Q\f\f\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005A!p[\"mS\u0016tG/F\u0001b!\t\u0011W-D\u0001d\u0015\t!g&\u0001\u0002{W&\u0011am\u0019\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004\u0013A\u0002\u001fj]&$h\bF\u0003kW2lg\u000e\u0005\u0002H\u0001!)A)\u0003a\u0001\r\")\u0011)\u0003a\u0001\u0019\")\u0011,\u0003a\u00017\")q,\u0003a\u0001C\u0006qAo\u001c9jGB+(oZ1u_JLX#A9\u0011\u0007\u001d\u0013H/\u0003\u0002tY\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\t9U/\u0003\u0002wY\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)ve\u001e\fGo\u001c:zA\u0005i\u0011\rZ7j]j[7\t\\5f]R,\u0012A\u001f\t\u0003EnL!\u0001`2\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u00039\tG-\\5o5.\u001cE.[3oi\u0002\n\u0011c\u0019:fCR,Gk\u001c9jGB{G.[2z+\t\t\t\u0001E\u00034\u0003\u0007\t9!C\u0002\u0002\u0006Q\u0012aa\u00149uS>t\u0007\u0003BA\u0005\u0003#i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0007a>d\u0017nY=\u000b\u00055\n\u0016\u0002BA\n\u0003\u0017\u0011\u0011c\u0011:fCR,Gk\u001c9jGB{G.[2z\u0003I\u0019'/Z1uKR{\u0007/[2Q_2L7-\u001f\u0011\u0002#\u0005dG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0006\u0002\u0002\u001cA)1'a\u0001\u0002\u001eA!\u0011\u0011BA\u0010\u0013\u0011\t\t#a\u0003\u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0001\nbYR,'oQ8oM&<\u0007k\u001c7jGf\u0004\u0013!\u00075bg\u0012+G.Y=fIR{\u0007/[2Pa\u0016\u0014\u0018\r^5p]N,\"!!\u000b\u0011\u0007M\nY#C\u0002\u0002.Q\u0012qAQ8pY\u0016\fg.\u0001\u000beK\u001a\fW\u000f\u001c;Ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003g\u00012aMA\u001b\u0013\r\t9\u0004\u000e\u0002\u0004\u0013:$\u0018!\u00063fM\u0006,H\u000e\u001e(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014XCAA !\r\u0019\u0014\u0011I\u0005\u0004\u0003\u0007\"$!B*i_J$\u0018!\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\n\u0011\u0005\u001e:z\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fIR{\u0007/[2Pa\u0016\u0014\u0018\r^5p]N$B!a\u0013\u0002RA\u00191'!\u0014\n\u0007\u0005=CG\u0001\u0003V]&$\bbBA*/\u0001\u0007\u0011QK\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\u0005\u0004cAA.i5\u0011\u0011Q\f\u0006\u0004\u0003?\u0002\u0014A\u0002\u001fs_>$h(C\u0002\u0002dQ\na\u0001\u0015:fI\u00164\u0017\u0002BA4\u0003S\u0012aa\u0015;sS:<'bAA2i\u0005a1M]3bi\u0016$v\u000e]5dgRa\u00111JA8\u0003g\n9(!,\u0002B\"9\u0011\u0011\u000f\rA\u0002\u0005M\u0012a\u0002;j[\u0016|W\u000f\u001e\u0005\b\u0003kB\u0002\u0019AA\u0015\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011\u001d\tI\b\u0007a\u0001\u0003w\n\u0001\u0002^8De\u0016\fG/\u001a\t\t\u0003{\n\u0019)!\u0016\u0002\b6\u0011\u0011q\u0010\u0006\u0004\u0003\u0003#\u0014AC2pY2,7\r^5p]&!\u0011QQA@\u0005\ri\u0015\r\u001d\t\u0005\u0003\u0013\u000b9K\u0004\u0003\u0002\f\u0006\u0005f\u0002BAG\u0003;sA!a$\u0002\u001c:!\u0011\u0011SAM\u001d\u0011\t\u0019*a&\u000f\t\u0005m\u0013QS\u0005\u0002+&\u00111\u000bV\u0005\u0003_IK!\u0001U)\n\u0007\u0005}u*A\u0004nKN\u001c\u0018mZ3\n\t\u0005\r\u0016QU\u0001\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006T1!a(P\u0013\u0011\tI+a+\u0003\u001d\r\u0013X-\u0019;bE2,Gk\u001c9jG*!\u00111UAS\u0011\u001d\ty\u000b\u0007a\u0001\u0003c\u000b1$\u001b8dYV$WmQ8oM&<7/\u00118e\u001b\u0016$\u0018\r^1eCR\f\u0007\u0003CA?\u0003\u0007\u000b)&a-\u0011\t\u0005U\u00161\u0018\b\u0005\u0003\u0017\u000b9,\u0003\u0003\u0002:\u0006\u0015\u0016\u0001G\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rR1uC&!\u0011QXA`\u0005Q\u0019%/Z1uC\ndW\rV8qS\u000e\u0014Vm];mi*!\u0011\u0011XAS\u0011\u001d\t\u0019\r\u0007a\u0001\u0003\u000b\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u000fM\n9-a3\u0002L%\u0019\u0011\u0011\u001a\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003CA?\u0003\u0007\u000b)&!4\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#T1!a5P\u0003!\u0011X-];fgR\u001c\u0018\u0002BAl\u0003#\u0014\u0001\"\u00119j\u000bJ\u0014xN]\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\t\u0003\u0017\ni.a8\u0002j\"9\u0011\u0011O\rA\u0002\u0005M\u0002bBAq3\u0001\u0007\u00111]\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005u\u0014Q]A+\u0013\u0011\t9/a \u0003\u0007M+G\u000fC\u0004\u0002Df\u0001\r!a;\u0011\u000fM\n9-!<\u0002LAA\u0011QPAB\u0003+\ny\u000f\u0005\u0003\u0002r\u0006]XBAAz\u0015\r\t)pT\u0001\taJ|Go\\2pY&!\u0011\u0011`Az\u0005\u0019)%O]8sg\u0006\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\r\u0003\u0017\nyP!\u0001\u0003\u001a\tm!1\u0006\u0005\b\u0003cR\u0002\u0019AA\u001a\u0011\u001d\u0011\u0019A\u0007a\u0001\u0005\u000b\tQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\bCBA?\u0005\u000f\u0011Y!\u0003\u0003\u0003\n\u0005}$aA*fcB!!Q\u0002B\n\u001d\u0011\tYIa\u0004\n\t\tE\u0011QU\u0001\u001c\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N\u0014V-];fgR$\u0015\r^1\n\t\tU!q\u0003\u0002\u0016\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N$v\u000e]5d\u0015\u0011\u0011\t\"!*\t\u000f\u0005U$\u00041\u0001\u0002*!9!Q\u0004\u000eA\u0002\t}\u0011\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\u0007\t\u0015r*A\u0004oKR<xN]6\n\t\t%\"1\u0005\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0005[Q\u0002\u0019AAc\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0017a\u00043fg\u000e\u0014\u0018NY3D_:4\u0017nZ:\u0015\r\tM\"Q\nB+!!\ti(a!\u00036\t}\u0002\u0003\u0002B\u001c\u0005wi!A!\u000f\u000b\u0005\u0011{\u0015\u0002\u0002B\u001f\u0005s\u0011abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u0003B\t\u001dc\u0002BAh\u0005\u0007JAA!\u0012\u0002R\u00069B)Z:de&\u0014WmQ8oM&<7OU3ta>t7/Z\u0005\u0005\u0005\u0013\u0012YE\u0001\u0004D_:4\u0017n\u001a\u0006\u0005\u0005\u000b\n\t\u000eC\u0004\u0003Pm\u0001\rA!\u0015\u0002+I,7o\\;sG\u0016$vnQ8oM&<g*Y7fgBA\u0011QPAB\u0005k\u0011\u0019\u0006E\u00034\u0003\u0007\t\u0019\u000fC\u0004\u0003Xm\u0001\r!!\u000b\u0002\u001f%t7\r\\;eKNKhn\u001c8z[N\fA\"\u00197uKJ\u001cuN\u001c4jON$bA!\u0018\u0003`\tE\u0004\u0003CA?\u0003\u0007\u0013)$!4\t\u000f\t\u0005D\u00041\u0001\u0003d\u000591m\u001c8gS\u001e\u001c\b\u0003CA?\u0003\u0007\u0013)D!\u001a\u0011\t\t\u001d$Q\u000e\b\u0005\u0003\u001f\u0014I'\u0003\u0003\u0003l\u0005E\u0017aE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$\u0018\u0002\u0002B%\u0005_RAAa\u001b\u0002R\"9\u0011Q\u000f\u000fA\u0002\u0005%\u0012!E1mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5hgRQ!q\u000fB?\u0005\u0003\u0013\u0019Ia&\u0011\u000fM\u0012IH!\u000e\u0002N&\u0019!1\u0010\u001b\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011y(\ba\u0001\u0005k\t\u0001B]3t_V\u00148-\u001a\u0005\b\u0003kj\u0002\u0019AA\u0015\u0011\u001d\u0011))\ba\u0001\u0005\u000f\u000b1bY8oM&<\u0007K]8qgB!!\u0011\u0012BJ\u001b\t\u0011YI\u0003\u0003\u0003\u000e\n=\u0015\u0001B;uS2T!A!%\u0002\t)\fg/Y\u0005\u0005\u0005+\u0013YI\u0001\u0006Qe>\u0004XM\u001d;jKNDqA!'\u001e\u0001\u0004\u0011Y*\u0001\td_:4\u0017nZ#oiJLWm]'baBA\u0011QPAB\u0003+\n)&\u0001\nbYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cHC\u0003B<\u0005C\u0013\u0019K!*\u0003(\"9!q\u0010\u0010A\u0002\tU\u0002bBA;=\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005\u000bs\u0002\u0019\u0001BD\u0011\u001d\u0011IJ\ba\u0001\u00057\u000bA#\u00197uKJdun\u001a'fm\u0016d7i\u001c8gS\u001e\u001cH\u0003BA&\u0005[CqAa, \u0001\u0004\u0011\t,\u0001\bbYR,'oQ8oM&<w\n]:\u0011\r\tM&Q\u0018Bb\u001d\u0011\u0011)L!/\u000f\t\u0005m#qW\u0005\u0002k%\u0019!1\u0018\u001b\u0002\u000fA\f7m[1hK&!!q\u0018Ba\u0005\u0011a\u0015n\u001d;\u000b\u0007\tmF\u0007\u0005\u0003\u0003F\n=WB\u0001Bd\u0015\u0011\u0011IMa3\u0002\u000b\u0005$W.\u001b8\u000b\u0007\t5\u0017+A\u0004dY&,g\u000e^:\n\t\tE'q\u0019\u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\u0002\u0017\u001d,GO\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0005\u0005/\u0014I\u000eE\u00034\u0003\u0007\t\u0019\u0004C\u0004\u0003\u0000\u0001\u0002\rA!\u000e\u0002)Y\fG.\u001b3bi\u0016\u001cuN\u001c4jOB{G.[2z)\u0019\tYEa8\u0003b\"9!qP\u0011A\u0002\tU\u0002b\u0002BMC\u0001\u0007!1T\u0001\u0018S:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON$bA!\u0018\u0003h\n-\bb\u0002B1E\u0001\u0007!\u0011\u001e\t\t\u0003{\n\u0019I!\u000e\u00032\"9\u0011Q\u000f\u0012A\u0002\u0005%\u0012a\u0006<bY&$\u0017\r^3M_\u001edUM^3m\u0007>tg-[4t)\u0011\tYE!=\t\u000f\t=6\u00051\u0001\u00032\u0006I\u0002O]3qCJ,\u0017J\\2sK6,g\u000e^1m\u0007>tg-[4t)!\tYEa>\u0003z\nm\bb\u0002BXI\u0001\u0007!\u0011\u0017\u0005\b\u0005\u000b#\u0003\u0019\u0001BD\u0011\u001d\u0011i\u0010\na\u0001\u0005\u007f\f!bY8oM&<7*Z=t!!\ti(a!\u0002V\r\u0005\u0001\u0003BB\u0002\u0007\u001bqAa!\u0002\u0004\n9!\u0011QRB\u0004\u0013\t!u*\u0003\u0003\u0004\f\te\u0012!C\"p]\u001aLw\rR3g\u0013\u0011\u0019ya!\u0005\u0003\u0013\r{gNZ5h\u0017\u0016L(\u0002BB\u0006\u0005s\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u0017\naC]3t_V\u00148-\u001a(b[\u0016$vN\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0005\u0003g\u0019Y\u0002C\u0004\u0004\u001e\u0019\u0002\r!!\u0016\u0002\u0019I,7o\\;sG\u0016t\u0015-\\3\u0002\u001d\t\u0014xn[3s'ftwN\\=ngR!11EB\u0013!\u0019\u0011\u0019L!0\u0002V!91qE\u0014A\u0002\u0005U\u0013\u0001\u00028b[\u0016\fabY8oM&<7+\u001f8p]fl7\u000f\u0006\u0005\u0004.\rU2qGB\u001e!\u0019\u0011\u0019L!0\u00040A!!\u0011IB\u0019\u0013\u0011\u0019\u0019Da\u0013\u0003\u001b\r{gNZ5h'ftwN\\=n\u0011\u001d\u00199\u0003\u000ba\u0001\u0003+Bqa!\u000f)\u0001\u0004\u0019\u0019#\u0001\u0005ts:|g._7t\u0011\u001d\u0019i\u0004\u000ba\u0001\u0003S\t1\"[:TK:\u001c\u0018\u000e^5wK\u000612M]3bi\u0016$v\u000e]5d\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0005\u0004D\r]3qMB6)\u0019\u0019)ea\u0013\u0004NA!!\u0011IB$\u0013\u0011\u0019IEa\u0013\u0003\u0017\r{gNZ5h\u000b:$(/\u001f\u0005\b\u0007OI\u0003\u0019AA+\u0011\u001d\u0019y%\u000ba\u0001\u0007#\nQA^1mk\u0016\u00042aMB*\u0013\r\u0019)\u0006\u000e\u0002\u0004\u0003:L\bbBB-S\u0001\u000711L\u0001\nY><7i\u001c8gS\u001e\u0004Ba!\u0018\u0004d5\u00111q\f\u0006\u0004\u0007Cr\u0013a\u00017pO&!1QMB0\u0005%aunZ\"p]\u001aLw\rC\u0004\u0004j%\u0002\rAa\"\u0002\u0015Q|\u0007/[2Qe>\u00048\u000fC\u0004\u0003X%\u0002\r!!\u000b\u0002/\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ#oiJLHCBB9\u0007o\u001aY\b\u0006\u0004\u0004F\rM4Q\u000f\u0005\b\u0007OQ\u0003\u0019AA+\u0011\u001d\u0019yE\u000ba\u0001\u0007#Bqa!\u001f+\u0001\u0004\tI#A\bqKJ\u0014%o\\6fe\u000e{gNZ5h\u0011\u001d\u00119F\u000ba\u0001\u0003S\u0001")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final int defaultNumPartitions;
    private final short defaultReplicationFactor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().numDelayed() != 0;
    }

    private int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequestData.CreatableTopic> toCreate, Map<String, CreateTopicsResponseData.CreatableTopicResult> includeConfigsAndMetatadata, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Buffer metadata = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                scala.collection.mutable.HashMap hashMap;
                short resolvedReplicationFactor;
                if (this.metadataCache().contains(topic.name())) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic.name()).append("' already exists.").toString());
                }
                Properties configs = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> configs.setProperty(entry.name(), entry.value()));
                LogConfig$.MODULE$.validate(configs);
                if (!(topic.numPartitions() == -1 && topic.replicationFactor() == -1 || topic.assignments().isEmpty())) {
                    throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                }
                int resolvedNumPartitions = topic.numPartitions() == -1 ? this.defaultNumPartitions() : topic.numPartitions();
                short s = resolvedReplicationFactor = topic.replicationFactor() == -1 ? this.defaultReplicationFactor() : topic.replicationFactor();
                if (topic.assignments().isEmpty()) {
                    hashMap = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, resolvedNumPartitions, resolvedReplicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                } else {
                    scala.collection.mutable.HashMap assignments = new scala.collection.mutable.HashMap();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.assignments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        assignments.update((Object)BoxesRunTime.boxToInteger((int)x0$1.partitionIndex()), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x0$1.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(a)), Buffer$.MODULE$.canBuildFrom()));
                        return BoxedUnit.UNIT;
                    });
                    hashMap = assignments;
                }
                scala.collection.mutable.HashMap assignments = hashMap;
                this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AdminManager.$anonfun$createTopics$6(topic, (Map)assignments)));
                Option<CreateTopicPolicy> option = this.createTopicPolicy();
                if (option instanceof Some) {
                    CreateTopicPolicy policy = (CreateTopicPolicy)((Some)option).value();
                    this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    Integer numPartitions = topic.assignments().isEmpty() ? Predef$.MODULE$.int2Integer(resolvedNumPartitions) : null;
                    Short replicationFactor = topic.assignments().isEmpty() ? Predef$.MODULE$.short2Short(resolvedReplicationFactor) : null;
                    java.util.Map javaAssignments = topic.assignments().isEmpty() ? null : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        if (x0$2 != null) {
                            int k = x0$2._1$mcI$sp();
                            Seq v = (Seq)x0$2._2();
                            Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom())).asJava();
                            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(k));
                            if (Predef.ArrowAssoc$.MODULE$ == null) {
                                throw null;
                            }
                        } else {
                            throw new MatchError(null);
                        }
                        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        return tuple2;
                    }, Map$.MODULE$.canBuildFrom())).asJava();
                    HashMap javaConfigs = new HashMap();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)config -> javaConfigs.put(config.name(), config.value()));
                    policy.validate(new CreateTopicPolicy.RequestMetadata(topic.name(), numPartitions, replicationFactor, javaAssignments, javaConfigs));
                    if (!validateOnly) {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    if (validateOnly) {
                        this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    } else {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else {
                    throw new MatchError(option);
                }
                Option option2 = includeConfigsAndMetatadata.get((Object)topic.name());
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = (CreateTopicsResponseData.CreatableTopicResult)foreach_this.get();
                    AdminManager.$anonfun$createTopics$10(this, configs, (Map)assignments, creatableTopicResult);
                }
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)assignments.keySet(), ApiError.NONE);
            }
            catch (TopicExistsException e) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Topic creation failed since topic '").append(topic.name()).append("' already exists.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ConfigException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$24(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> {
                if (createTopicMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, responseCallback);
        Buffer delayedCreateKeys = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> new TopicKey(topic.name()), Iterable$.MODULE$.canBuildFrom())).toBuffer();
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            try {
                this.adminZkClient().deleteTopic((String)topic);
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$5)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT);
                }
                return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
        Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$6 -> new TopicKey((String)x$6), Set$.MODULE$.canBuildFrom())).toSeq();
        this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
    }

    public void createPartitions(int timeout, Seq<CreatePartitionsRequestData.CreatePartitionsTopic> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Seq$.MODULE$.canBuildFrom());
        Seq metadata = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)newPartition -> {
            String topic = newPartition.name();
            try {
                None$ none$;
                Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    void $minus$greater$extension_$this;
                    ReplicaAssignment assignment;
                    if (x0$1 != null) {
                        TopicPartition topicPartition = (TopicPartition)x0$1._1();
                        assignment = (ReplicaAssignment)x0$1._2();
                        if (assignment.isBeingReassigned()) {
                            throw new ReassignmentInProgressException(new StringBuilder(57).append("A partition reassignment is in progress for the topic '").append(topic).append("'.").toString());
                        }
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
                if (existingAssignment.isEmpty()) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                }
                int oldNumPartitions = existingAssignment.size();
                int newNumPartitions = newPartition.count();
                int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                if (numPartitionsIncrement < 0) {
                    throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                }
                if (numPartitionsIncrement == 0) {
                    throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                }
                Option option = Option$.MODULE$.apply((Object)newPartition.assignments());
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                if (map_this.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    java.util.List list = (java.util.List)map_this.get();
                    none$ = new Some((Object)AdminManager.$anonfun$createPartitions$4(allBrokerIds, numPartitionsIncrement, existingAssignment, list));
                }
                Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, ReplicaAssignment>)existingAssignment, allBrokers, newPartition.count(), (Option<Map<Object, Seq<Object>>>)none$, validateOnly);
                return new CreatePartitionsMetadata(topic, (Set<Object>)updatedReplicaAssignment.keySet(), ApiError.NONE);
            }
            catch (AdminOperationException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)Set$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$8(x$9)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> {
                if (createPartitionMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, callback);
        Seq delayedCreateKeys = (Seq)newPartitions.map((Function1 & Serializable & scala.Serializable)createPartitionTopic -> new TopicKey(createPartitionTopic.name()), Seq$.MODULE$.canBuildFrom());
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2;
            if (x0$12 != null) {
                ConfigResource resource = (ConfigResource)x0$12._1();
                Option configNames = (Option)x0$12._2();
                try {
                    void $minus$greater$extension_$this;
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)AdminManager.allConfigs$1(logConfig).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config2 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)this.config().dynamicConfig().currentDynamicDefaultConfigs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value);
                            Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)AdminManager.allConfigs$1(this.config()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            }, Buffer$.MODULE$.canBuildFrom());
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        } else {
                            throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource.name()).toString());
                        }
                        config = config3;
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        if (resource.name() == null || resource.name().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(resource.name()) != this.config().brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" but received ").append(resource.name()).toString());
                        }
                        Function2 & Serializable & scala.Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponse.ConfigEntry(name, value.toString(), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, false, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                        Buffer createResponseConfig$1_configEntries = (Buffer)((MapLike)Log4jController$.MODULE$.loggers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            if (x0$2 == null) {
                                throw new MatchError(null);
                            }
                            String name = (String)x0$2._1();
                            Object value = x0$2._2();
                            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                            return configEntry;
                        }, Buffer$.MODULE$.canBuildFrom());
                        config = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)config);
                }
                catch (Throwable e) {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    DescribeConfigsResponse.Config config = new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)x0$1._2();
                try {
                    Tuple2 tuple22;
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Properties configProps = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(config).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterTopicConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = resource.name();
        this.adminZkClient().validateTopicConfig(topic, configProps);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating topic ").append(topic).append(" with new configuration ").append((Object)this.config()).toString());
            this.adminZkClient().changeTopicConfig(topic, configProps);
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ConfigResource, ApiError> alterBrokerConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Option<Object> brokerId = this.getBrokerId(resource);
        boolean perBrokerConfig = brokerId.nonEmpty();
        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            if (perBrokerConfig) {
                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
            }
            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
        }
        ApiError apiError = ApiError.NONE;
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    private void alterLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AdminManager.$anonfun$alterLogLevelConfigs$1((AlterConfigOp)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private Option<Object> getBrokerId(ConfigResource resource) {
        if (resource.name() == null || resource.name().isEmpty()) {
            return None$.MODULE$;
        }
        int id = this.resourceNameToBrokerId(resource.name());
        if (id != this.config().brokerId()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource.name()).toString());
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Map<ConfigResource, ApiError> incrementalAlterConfigs(Map<ConfigResource, List<AlterConfigOp>> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<ConfigResource, ApiError> tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                List alterConfigOps = (List)x0$1._2();
                try {
                    Tuple2<ConfigResource, ApiError> tuple22;
                    Object object;
                    void map_bf;
                    scala.collection.immutable.Set duplicateKeys = ((MapLike)alterConfigOps.groupBy((Function1 & Serializable & scala.Serializable)config -> config.configEntry().name()).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size())).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$4(x$13)))).keys().toSet();
                    if (duplicateKeys.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(37).append("Error due to duplicate config keys : ").append(duplicateKeys.mkString(",")).toString());
                    }
                    CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
                    Function1 & Serializable & scala.Serializable map_f = (Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.configEntry().name(), (Object)entry.configEntry().value());
                    if (map_bf == List$.MODULE$.ReusableCBF()) {
                        if (alterConfigOps == Nil$.MODULE$) {
                            object = Nil$.MODULE$;
                        } else {
                            .colon.colon map_h;
                            .colon.colon map_t = map_h = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)alterConfigOps.head()), (List)Nil$.MODULE$);
                            for (List map_rest = (List)alterConfigOps.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                .colon.colon map_nx = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)map_rest.head()), (List)Nil$.MODULE$);
                                map_t.tl_$eq((List)map_nx);
                                map_t = map_nx;
                            }
                            object = map_h;
                        }
                    } else {
                        object = TraversableLike.map$((TraversableLike)alterConfigOps, (Function1)map_f, (CanBuildFrom)map_bf);
                    }
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)object).toMap(Predef$.MODULE$.$conforms());
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        Properties configProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), resource.name());
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, LogConfig$.MODULE$.configKeys());
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        Option<Object> brokerId = this.getBrokerId(resource);
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        Properties persistentProps = perBrokerConfig ? this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), brokerId.get().toString()) : this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default());
                        Properties configProps = this.config().dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        this.getBrokerId(resource);
                        this.validateLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        if (!validateOnly) {
                            this.alterLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        }
                        ApiError apiError = ApiError.NONE;
                        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple22 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2<ConfigResource, ApiError> tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        ApiError apiError = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2<ConfigResource, ApiError>((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else if (throwable != null) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(alterConfigOps).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                        }
                        ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)resource);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        tuple23 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2<ConfigResource, ApiError> tuple24 = tuple2;
            return tuple24;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void validateLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AdminManager.$anonfun$validateLogLevelConfigs$1((AlterConfigOp)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void prepareIncrementalConfigs(List<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AlterConfigOp alterConfigOp = (AlterConfigOp)foreach_these.head();
            AdminManager.$anonfun$prepareIncrementalConfigs$1(configProps, configKeys, alterConfigOp);
            foreach_these = (List)foreach_these.tail();
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<CreateTopicPolicy> option = this.createTopicPolicy();
            if (option == null) {
                throw null;
            }
            Option<CreateTopicPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((CreateTopicPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option<AlterConfigPolicy> option = this.alterConfigPolicy();
            if (option == null) {
                throw null;
            }
            Option<AlterConfigPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((AlterConfigPolicy)foreach_this.get()).close();
                return;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringOps(resourceName).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        if (synonyms == null) {
            throw null;
        }
        List foreach_these = synonyms;
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these = (List)foreach_these.tail();
        }
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        List foreach_these2 = synonyms;
        while (!foreach_these2.isEmpty()) {
            String string = (String)foreach_these2.head();
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these2 = (List)foreach_these2.tail();
        }
        List foreach_these3 = synonyms;
        while (!foreach_these3.isEmpty()) {
            String string = (String)foreach_these3.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these3 = (List)foreach_these3.tail();
        }
        List foreach_these4 = synonyms;
        while (!foreach_these4.isEmpty()) {
            String string = (String)foreach_these4.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, string, isSensitive, allSynonyms);
            foreach_these4 = (List)foreach_these4.tail();
        }
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        Object object;
        None$ none$;
        String string;
        Option<ConfigDef.Type> configEntryType = LogConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            void orNull_ev;
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (configEntryType == null) {
                throw null;
            }
            Object object2 = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
            string = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object2));
        }
        String valueAsString = string;
        Option option = LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string2 = (String)map_this.get();
            none$ = new Some((Object)this.configSynonyms(string2, this.brokerSynonyms(string2), isSensitive));
        }
        if (none$ == null) {
            throw null;
        }
        Object object3 = none$.isEmpty() ? List$.MODULE$.empty() : none$.get();
        Object list = object3;
        if (!topicProps.containsKey(name)) {
            object = list;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            object = (List)list.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        Object allSynonyms = object;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        Object synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    /*
     * WARNING - void declaration
     */
    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            if (value instanceof String) {
                string2 = (String)value;
            } else {
                void orNull_ev;
                Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                if (configEntryType == null) {
                    throw null;
                }
                Object object = configEntryType.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : configEntryType.get();
                string2 = ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)object));
            }
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$18)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public static final /* synthetic */ String $anonfun$createTopics$6(CreateTopicsRequestData.CreatableTopic topic$1, Map assignments$2) {
        return new StringBuilder(28).append("Assignments for topic ").append(topic$1).append(" are ").append(assignments$2).append(" ").toString();
    }

    public static final /* synthetic */ byte $anonfun$createTopics$13(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$14(DescribeConfigsResponse.ConfigEntry entry$1, byte i) {
        DescribeConfigsResponse.ConfigSource configSource = DescribeConfigsResponse.ConfigSource.forId((byte)i);
        DescribeConfigsResponse.ConfigSource configSource2 = entry$1.source();
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ byte $anonfun$createTopics$15() {
        return (byte)0;
    }

    public static final /* synthetic */ CreateTopicsResponseData.CreatableTopicResult $anonfun$createTopics$10(AdminManager $this, Properties configs$1, Map assignments$2, CreateTopicsResponseData.CreatableTopicResult result) {
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog($this.config()), configs$1);
        Function2 & Serializable & scala.Serializable createEntry = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> $this.createTopicConfigEntry(logConfig, configs$1, false, (String)x$1, x$2);
        java.util.List topicConfigs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logConfig.values()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Option option;
            DescribeConfigsResponse.ConfigEntry entry;
            String k;
            if (x0$3 != null) {
                k = (String)x0$3._1();
                Object v = x0$3._2();
                entry = (DescribeConfigsResponse.ConfigEntry)createEntry.apply((Object)k, v);
                option = ((IterableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DescribeConfigsResponse.ConfigSource.values())).indices().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$13(BoxesRunTime.unboxToInt((Object)x$3))), IndexedSeq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$14(entry, BoxesRunTime.unboxToByte((Object)i))));
                if (option == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Option getOrElse_this = option;
            Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$15()) : getOrElse_this.get();
            byte source = BoxesRunTime.unboxToByte((Object)object);
            CreateTopicsResponseData.CreatableTopicConfigs creatableTopicConfigs = new CreateTopicsResponseData.CreatableTopicConfigs().setName(k).setValue(entry.value()).setIsSensitive(entry.isSensitive()).setReadOnly(entry.isReadOnly()).setConfigSource(source);
            return creatableTopicConfigs;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        result.setConfigs(topicConfigs);
        result.setNumPartitions(assignments$2.size());
        return result.setReplicationFactor((short)((SeqLike)assignments$2.apply((Object)BoxesRunTime.boxToInteger((int)0))).size());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$24(CreatePartitionsMetadata x$4) {
        return x$4.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$5) {
        Errors errors = x$5.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createPartitions$4(Seq allBrokerIds$1, int numPartitionsIncrement$1, Map existingAssignment$1, java.util.List assignmentMap) {
        Buffer assignments = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(assignmentMap).asScala()).map((Function1 & Serializable & scala.Serializable)createPartitionAssignment -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(createPartitionAssignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds$1);
        if (unknownBrokers.nonEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
        }
        if (assignments.size() != numPartitionsIncrement$1) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(66).append("Increasing the number of partitions by ").append(numPartitionsIncrement$1).append(" ").append("but ").append(assignments.size()).append(" assignments provided.").toString());
        }
        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_$this;
            Buffer replicas;
            if (x0$2 != null) {
                replicas = (Buffer)x0$2._1();
                int index = x0$2._2$mcI$sp();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment$1.size() + index)));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$8(CreatePartitionsMetadata x$9) {
        return x$9.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$10) {
        return x$10._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$10)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            Set set;
            String configName = (String)x0$1._1();
            if (configNames$1 == null) {
                throw null;
            }
            bl = configNames$1.isEmpty() || (set = (Set)configNames$1.get()).contains((Object)configName);
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        Buffer configEntries = (Buffer)((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)))).toBuffer().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$2._1();
            Object value = x0$2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$alterLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        boolean bl;
        String loggerName = alterConfigOp.configEntry().name();
        String logLevel = alterConfigOp.configEntry().value();
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            bl = Log4jController$.MODULE$.logLevel(loggerName, logLevel);
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            bl = Log4jController$.MODULE$.unsetLogLevel(loggerName);
        } else {
            throw new IllegalArgumentException(new StringBuilder(40).append("Log level cannot be changed for OpType: ").append(alterConfigOp.opType()).toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$4(Tuple2 x$13) {
        return x$13._2$mcI$sp() > 1;
    }

    private static final void validateLoggerNameExists$1(String loggerName) {
        if (!Log4jController$.MODULE$.loggerExists(loggerName)) {
            throw new ConfigException(new StringBuilder(23).append("Logger ").append(loggerName).append(" does not exist!").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        block8: {
            AlterConfigOp.OpType opType;
            block9: {
                block11: {
                    String string;
                    String string2;
                    block10: {
                        String loggerName;
                        block7: {
                            loggerName = alterConfigOp.configEntry().name();
                            opType = alterConfigOp.opType();
                            if (!AlterConfigOp.OpType.SET.equals(opType)) break block7;
                            AdminManager.validateLoggerNameExists$1(loggerName);
                            String logLevel = alterConfigOp.configEntry().value();
                            if (!LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) {
                                String validLevelsStr = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala()).mkString(", ");
                                throw new ConfigException(new StringBuilder(90).append("Cannot set the log level of ").append(loggerName).append(" to ").append(logLevel).append(" as it is not a supported log level. ").append("Valid log levels are ").append(validLevelsStr).toString());
                            }
                            break block8;
                        }
                        if (!AlterConfigOp.OpType.DELETE.equals(opType)) break block9;
                        AdminManager.validateLoggerNameExists$1(loggerName);
                        string2 = loggerName;
                        string = Log4jController$.MODULE$.ROOT_LOGGER();
                        if (string2 != null) break block10;
                        if (string != null) {
                            return;
                        }
                        break block11;
                    }
                    if (!string2.equals(string)) break block8;
                }
                throw new InvalidRequestException(new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.APPEND).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.SUBTRACT).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            throw new MatchError((Object)opType);
        }
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ Object $anonfun$prepareIncrementalConfigs$1(Properties configProps$2, Map configKeys$1, AlterConfigOp alterConfigOp) {
        Object object;
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            object = configProps$2.remove(alterConfigOp.configEntry().name());
        } else if (AlterConfigOp.OpType.APPEND.equals(opType)) {
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            List oldValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps$2.getProperty(alterConfigOp.configEntry().name()).split(","))).toList();
            List newValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList().$colon$colon$colon(oldValueList);
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
        } else if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            List newValueList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps$2.getProperty(alterConfigOp.configEntry().name()).split(","))).toList().diff((GenSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList());
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
        } else {
            throw new MatchError((Object)opType);
        }
        return object;
    }

    public static final /* synthetic */ Buffer $anonfun$configSynonyms$1(boolean isSensitive$1, Buffer allSynonyms$1, String name$1, DescribeConfigsResponse.ConfigSource source$1, String value) {
        String configValue = isSensitive$1 ? null : value;
        return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name$1, configValue, source$1));
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        Option option = map.get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        String string = (String)map_this.get();
        new Some((Object)AdminManager.$anonfun$configSynonyms$1(isSensitive$1, allSynonyms$1, name, source, string));
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$18) {
        block3: {
            block2: {
                if (perBrokerConfig$1) break block2;
                DescribeConfigsResponse.ConfigSource configSource = x$18.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null ? !configSource.equals(configSource2) : configSource2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
        this.defaultNumPartitions = config.numPartitions();
        this.defaultReplicationFactor = Predef$.MODULE$.int2Integer(config.defaultReplicationFactor()).shortValue();
    }

    public static final /* synthetic */ Object $anonfun$alterLogLevelConfigs$1$adapted(AlterConfigOp alterConfigOp) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterLogLevelConfigs$1(alterConfigOp));
    }

    public static final /* synthetic */ Object $anonfun$validateLogLevelConfigs$1$adapted(AlterConfigOp alterConfigOp) {
        AdminManager.$anonfun$validateLogLevelConfigs$1(alterConfigOp);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$4$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$5$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$describeConfigs$4$adapted(String configName$1, Set x$11) {
        return BoxesRunTime.boxToBoolean((boolean)x$11.contains((Object)configName$1));
    }

    public static final /* synthetic */ Object $anonfun$shutdown$2$adapted(CreateTopicPolicy x$15) {
        x$15.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shutdown$4$adapted(AlterConfigPolicy x$16) {
        x$16.close();
        return BoxedUnit.UNIT;
    }
}

