/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf!\u0002\u000f\u001e\u0003\u0003\u0011\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011\r\u0003!\u0011!Q\u0001\naB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")\u0011\n\u0001C\u0001\u0015\"A1\f\u0001b\u0001\n\u0003iB\f\u0003\u0004i\u0001\u0001\u0006I!\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0019\b\u0001)A\u0005W\"9A\u000f\u0001a\u0001\n\u0013)\bb\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\u0007{\u0002\u0001\u000b\u0015\u0002$\t\u000fy\u0004!\u0019!C\u0001\u007f\"A\u0011q\u0001\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f!A\u0011\u0011\u0004\u0001!\u0002\u0013\ti\u0001C\u0004\u0002\u001c\u0001!\t!H;\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !A\u0011Q\u0005\u0001\u0005\u0002u\t9\u0003\u0003\u0005\u0002J\u0001!\t!HA&\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0019\u0001\r\u0003\t)\u0007C\u0004\u0002|\u0001!\t!! \t\u000f\u0005-\u0005\u0001\"\u0005\u0002\u000e\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003c\u0003A\u0011AAX\u0005Y\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014(B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005\rz5\u0003\u0002\u0001%UA\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017 \u0003\u0015)H/\u001b7t\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mz\u0012aB7fiJL7m]\u0005\u0003kI\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0011q\u0017-\\3\u0016\u0003a\u0002\"!\u000f!\u000f\u0005ir\u0004CA\u001e'\u001b\u0005a$BA\u001f\"\u0003\u0019a$o\\8u}%\u0011qHJ\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@M\u0005)a.Y7fA\u0005A1\r\\5f]RLE-A\u0006ok64U\r^2iKJ\u001c\bCA\u0013H\u0013\tAeEA\u0002J]R\fa\u0001P5oSRtD\u0003B&Y3j\u00032\u0001\u0014\u0001N\u001b\u0005i\u0002C\u0001(P\u0019\u0001!Q\u0001\u0015\u0001C\u0002E\u0013\u0011\u0001V\t\u0003%V\u0003\"!J*\n\u0005Q3#a\u0002(pi\"Lgn\u001a\t\u0003\u0019ZK!aV\u000f\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\")a'\u0002a\u0001q!)A)\u0002a\u0001q!)Q)\u0002a\u0001\r\u0006\u0001b-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012l\u0015\r]\u000b\u0002;B!alY3N\u001b\u0005y&B\u00011b\u0003\u001diW\u000f^1cY\u0016T!A\u0019\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002e?\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001'g\u0013\t9WD\u0001\u000bCe>\\WM]%e\u0003:$g)\u001a;dQ\u0016\u0014\u0018\nZ\u0001\u0012M\u0016$8\r[3s)\"\u0014X-\u00193NCB\u0004\u0013\u0001\u00027pG.,\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\fA\u0001\\1oO*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u0019y%M[3di\u0006)An\\2lA\u0005!b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ,\u0012AR\u0001\u0019]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:`I\u0015\fHC\u0001=|!\t)\u00130\u0003\u0002{M\t!QK\\5u\u0011\u001da8\"!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003UqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6fe\u0002\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005\u0005\u0001c\u0001'\u0002\u0004%\u0019\u0011QA\u000f\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005!A/Y4t+\t\ti\u0001E\u0004\u0002\u0010\u0005E\u0011Q\u0003\u001d\u000e\u0003\u0005L1!a\u0005b\u0005\ri\u0015\r\u001d\t\u0004Y\u0006]\u0011BA!n\u0003\u0015!\u0018mZ:!\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\rA\u0018\u0011\u0005\u0005\u0007\u0003G\u0011\u0002\u0019\u0001$\u0002\u000f9,woU5{K\u0006Qq-\u001a;GKR\u001c\u0007.\u001a:\u0015\t\u0005%\u0012q\u0006\t\u0005K\u0005-R*C\u0002\u0002.\u0019\u0012aa\u00149uS>t\u0007bBA\u0019'\u0001\u0007\u00111G\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t)$!\u0012\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\taaY8n[>t'b\u0001\u0011\u0002>)!\u0011qHA!\u0003\u0019\t\u0007/Y2iK*\u0011\u00111I\u0001\u0004_J<\u0017\u0002BA$\u0003o\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007hKR4U\r^2iKJLE\rF\u0002G\u0003\u001bBq!!\r\u0015\u0001\u0004\t\u0019$A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\bq\u0006M\u0013qKA-\u0011\u0019\t)&\u0006a\u0001\r\u0006A!M]8lKJLE\rC\u0004\u00022U\u0001\r!a\r\t\u000f\u0005mS\u00031\u0001\u0002^\u0005\u0001BO];oG\u0006$\u0018n\u001c8PM\u001a\u001cX\r\u001e\t\u0004K\u0005}\u0013bAA1M\t!Aj\u001c8h\u0003M\u0019'/Z1uK\u001a+Go\u00195feRC'/Z1e)\u0015i\u0015qMA6\u0011\u0019\tIG\u0006a\u0001\r\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\u0005\b\u0003[2\u0002\u0019AA8\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;?\u000591\r\\;ti\u0016\u0014\u0018\u0002BA=\u0003g\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogR\u0019\u00010a \t\u000f\u0005\u0005u\u00031\u0001\u0002\u0004\u0006\u0019\u0002/\u0019:uSRLwN\\!oI>3gm]3ugBA\u0011qBA\t\u0003g\t)\tE\u0002M\u0003\u000fK1!!#\u001e\u0005EIe.\u001b;jC24U\r^2i'R\fG/Z\u0001\u001dC\u0012$\u0007+\u0019:uSRLwN\\:U_\u001a+Go\u00195feRC'/Z1e)\u0015A\u0018qRAJ\u0011\u0019\t\t\n\u0007a\u0001\u001b\u0006ia-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012Dq!!&\u0019\u0001\u0004\t9*\u0001\fj]&$\u0018.\u00197PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195t!!\ty!!\u0005\u00024\u0005e\u0005c\u0001'\u0002\u001c&\u0019\u0011QT\u000f\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\u0006Q\"/Z7pm\u00164U\r^2iKJ4uN\u001d)beRLG/[8ogR\u0019\u00010a)\t\u000f\u0005\u0015\u0016\u00041\u0001\u0002(\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005=\u0011\u0011VA\u001a\u0013\r\tY+\u0019\u0002\u0004'\u0016$\u0018AG:ikR$wn\u001e8JI2,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001cH#\u0001=\u0002!\rdwn]3BY24U\r^2iKJ\u001c\b")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            Option option = this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (option == null) {
                throw null;
            }
            Option foreach_this = option;
            if (!foreach_this.isEmpty()) {
                AbstractFetcherThread abstractFetcherThread = (AbstractFetcherThread)foreach_this.get();
                abstractFetcherThread.markPartitionsForTruncation(topicPartition, truncationOffset);
            }
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, OffsetAndEpoch> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                fetcher.removePartitions((Set<TopicPartition>)partitions);
                return BoxedUnit.UNIT;
            });
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BoxedUnit boxedUnit;
                if (x$4 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$4._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$4._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$5)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$6);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ double $anonfun$new$6() {
        return 0.0;
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        Option option = this.fetcherThreadMap().values().headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5((AbstractFetcherThread)map_this.get())));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$6()) : object.get();
        double headRate = BoxesRunTime.unboxToDouble((Object)object2);
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$9() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)x0$1._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)x0$1._2();
            Map<TopicPartition, InitialFetchState> removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$1) {
                thread.shutdown();
            }
            $this.addFetcherForPartitions(removedPartitions);
            return;
        }
        throw new MatchError(null);
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$2) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            InitialFetchState brokerAndInitOffset = (InitialFetchState)x0$2._2();
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
        } else {
            throw new MatchError(null);
        }
        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return tuple2;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.sourceBroker();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                var2_10 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
            $this.addPartitionsToFetcherThread(var2_10, (Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$5._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$6) {
        if (x$6 != null) {
            ((AbstractFetcherThread)x$6._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        void $minus$greater$extension_$this;
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"clientId");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)clientId);
        this.tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionsForTruncation$1$adapted(TopicPartition topicPartition$2, long truncationOffset$1, AbstractFetcherThread thread) {
        thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$5$adapted(AbstractFetcherThread x$1) {
        return BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1));
    }
}

