/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rUsAB#G\u0011\u00031EJ\u0002\u0004O\r\"\u0005ai\u0014\u0005\u0006-\u0006!\t\u0001\u0017\u0005\u00063\u0006!\tA\u0017\u0005\u00073\u0006!\tAa<\t\re\u000bA\u0011\u0001B\u007f\u0011\u001d\u0019y!\u0001C\u0001\u0007#Aqa!\b\u0002\t\u0003\u0019y\u0002C\u0005\u0004(\u0005\u0011\r\u0011\"\u0003\u0004*!A1QG\u0001!\u0002\u0013\u0019Y\u0003C\u0004\u00048\u0005!\ta!\u000f\t\u0013\ru\u0012!%A\u0005\u0002\r}b!\u0002(G\u0001\u0019c\u0006\u0002C2\r\u0005\u000b\u0007I\u0011\u00013\t\u0011Ad!\u0011!Q\u0001\n\u0015D\u0001\"\u001d\u0007\u0003\u0002\u0004%\tA\u001d\u0005\tm2\u0011\t\u0019!C\u0001o\"AQ\u0010\u0004B\u0001B\u0003&1\u000f\u0003\u0005\u007f\u0019\t\u0005\r\u0011\"\u0001s\u0011%yHB!a\u0001\n\u0003\t\t\u0001C\u0005\u0002\u00061\u0011\t\u0011)Q\u0005g\"Q\u0011q\u0001\u0007\u0003\u0002\u0004%\t!!\u0003\t\u0015\u0005EAB!a\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\u00181\u0011\t\u0011)Q\u0005\u0003\u0017A!\"!\u0007\r\u0005\u0003\u0007I\u0011AA\u0005\u0011)\tY\u0002\u0004BA\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0003Ca!\u0011!Q!\n\u0005-\u0001BCA\u0012\u0019\t\u0005\r\u0011\"\u0001\u0002&!Q\u0011Q\u0006\u0007\u0003\u0002\u0004%\t!a\f\t\u0015\u0005MBB!A!B\u0013\t9\u0003\u0003\u0006\u000261\u0011\t\u0019!C\u0001\u0003oA!\"a\u0010\r\u0005\u0003\u0007I\u0011AA!\u0011)\t)\u0005\u0004B\u0001B\u0003&\u0011\u0011\b\u0005\u000b\u0003\u000fb!Q1A\u0005\u0002\u0005%\u0003BCA9\u0019\t\u0005\t\u0015!\u0003\u0002L!I\u00111\u000f\u0007\u0003\u0002\u0004%\tA\u001d\u0005\u000b\u0003kb!\u00111A\u0005\u0002\u0005]\u0004\"CA>\u0019\t\u0005\t\u0015)\u0003t\u0011%\t)\t\u0004BA\u0002\u0013\u0005!\u000f\u0003\u0006\u0002\b2\u0011\t\u0019!C\u0001\u0003\u0013C\u0011\"!$\r\u0005\u0003\u0005\u000b\u0015B:\t\rYcA\u0011AAI\u0011%\t9\u000b\u0004a\u0001\n\u0003\tI\u000bC\u0005\u000222\u0001\r\u0011\"\u0001\u00024\"A\u0011q\u0017\u0007!B\u0013\tY\u000b\u0003\u0006\u0002:2\u0011\r\u0011\"\u0001G\u0003wC\u0001\"!6\rA\u0003%\u0011Q\u0018\u0005\b\u0003/dA\u0011AAm\u0011\u001d\ti\u0010\u0004C\u0001\u0003\u007fDqAa\u0003\r\t\u0003\u0011i\u0001C\u0004\u0003\u00141!\tA!\u0006\t\u000f\tuA\u0002\"\u0001\u0003\u0016!9!q\u0004\u0007\u0005\u0002\t\u0005\u0002b\u0002B(\u0019\u0011\u0005!\u0011\u000b\u0005\b\u0005KbA\u0011\u0001B4\u0011\u001d\u0011I\b\u0004C\u0001\u0005wBqAa!\r\t\u0003\u0011)\tC\u0004\u0003\n2!\tA!\u0006\t\u000f\t-E\u0002\"\u0001\u0003\u000e\"9!q\u0012\u0007\u0005\n\t5\u0005b\u0002BI\u0019\u0011%!1\u0013\u0005\b\u0005[cA\u0011\u0001BX\u0011\u001d\u0011)\f\u0004C\u0005\u0005oCqAa/\r\t\u0013\u0011i\fC\u0004\u0003B2!IAa1\t\u000f\t%G\u0002\"\u0001\u0003\u000e\"9!1\u001a\u0007\u0005B\t5\u0007b\u0002Bh\u0019\u0011\u0005#\u0011\u001b\u0005\b\u0005/dA\u0011\tBm\u0003M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0015\t9\u0005*A\u0006ue\u0006t7/Y2uS>t'BA%K\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003-\u000bQa[1gW\u0006\u0004\"!T\u0001\u000e\u0003\u0019\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\"!\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017m\u0013\u0019O!:\u0003h\n%(1\u001e\t\u0003\u001b2\u00192\u0001\u0004)^!\tq\u0016-D\u0001`\u0015\t\u0001'*A\u0003vi&d7/\u0003\u0002c?\n9Aj\\4hS:<\u0017a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0016\u0003\u0015\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u00015S\u001b\u0005I'B\u00016X\u0003\u0019a$o\\8u}%\u0011ANU\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m%\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#W#A:\u0011\u0005E#\u0018BA;S\u0005\u0011auN\\4\u0002\u001dA\u0014x\u000eZ;dKJLEm\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003#fL!A\u001f*\u0003\tUs\u0017\u000e\u001e\u0005\byB\t\t\u00111\u0001t\u0003\rAH%M\u0001\faJ|G-^2fe&#\u0007%\u0001\bmCN$\bK]8ek\u000e,'/\u00133\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:JI~#S-\u001d\u000b\u0004q\u0006\r\u0001b\u0002?\u0014\u0003\u0003\u0005\ra]\u0001\u0010Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]%eA\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!a\u0003\u0011\u0007E\u000bi!C\u0002\u0002\u0010I\u0013Qa\u00155peR\f\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\rA\u0018Q\u0003\u0005\tyZ\t\t\u00111\u0001\u0002\f\u0005q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013!\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0006)B.Y:u!J|G-^2fe\u0016\u0003xn\u00195`I\u0015\fHc\u0001=\u0002 !AA0GA\u0001\u0002\u0004\tY!\u0001\nmCN$\bK]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001bXCAA\u0014!\r\t\u0016\u0011F\u0005\u0004\u0003W\u0011&aA%oi\u0006\u0001B\u000f\u001f8US6,w.\u001e;Ng~#S-\u001d\u000b\u0004q\u0006E\u0002\u0002\u0003?\u001d\u0003\u0003\u0005\r!a\n\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003\u0015\u0019H/\u0019;f+\t\tI\u0004E\u0002N\u0003wI1!!\u0010G\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR\u0019\u00010a\u0011\t\u0011q|\u0012\u0011!a\u0001\u0003s\taa\u001d;bi\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005-\u0003CBA'\u0003/\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\u001diW\u000f^1cY\u0016T1!!\u0016S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\nyEA\u0002TKR\u0004B!!\u0018\u0002n5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0004d_6lwN\u001c\u0006\u0004\u0017\u0006\u0015$\u0002BA4\u0003S\na!\u00199bG\",'BAA6\u0003\ry'oZ\u0005\u0005\u0003_\nyF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013!\u0005;y]N#\u0018M\u001d;US6,7\u000f^1na\u0006)B\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHc\u0001=\u0002z!9A\u0010JA\u0001\u0002\u0004\u0019\u0018A\u0005;y]N#\u0018M\u001d;US6,7\u000f^1na\u0002B3!JA@!\r\t\u0016\u0011Q\u0005\u0004\u0003\u0007\u0013&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002-QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B\f!\u0004\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e]0%KF$2\u0001_AF\u0011\u001dax%!AA\u0002M\fq\u0003\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e\u001d\u0011)\u0007!\ny\bF\u000b\\\u0003'\u000b)*a&\u0002\u001a\u0006m\u0015QTAP\u0003C\u000b\u0019+!*\t\u000b\rL\u0003\u0019A3\t\u000bEL\u0003\u0019A:\t\u000byL\u0003\u0019A:\t\u000f\u0005\u001d\u0011\u00061\u0001\u0002\f!9\u0011\u0011D\u0015A\u0002\u0005-\u0001bBA\u0012S\u0001\u0007\u0011q\u0005\u0005\b\u0003kI\u0003\u0019AA\u001d\u0011\u001d\t9%\u000ba\u0001\u0003\u0017B\u0001\"a\u001d*!\u0003\u0005\ra\u001d\u0005\u0007\u0003\u000bK\u0003\u0019A:\u0002\u0019A,g\u000eZ5oON#\u0018\r^3\u0016\u0005\u0005-\u0006#B)\u0002.\u0006e\u0012bAAX%\n1q\n\u001d;j_:\f\u0001\u0003]3oI&twm\u0015;bi\u0016|F%Z9\u0015\u0007a\f)\f\u0003\u0005}W\u0005\u0005\t\u0019AAV\u00035\u0001XM\u001c3j]\u001e\u001cF/\u0019;fA\u0005!An\\2l+\t\ti\f\u0005\u0003\u0002@\u0006EWBAAa\u0015\u0011\t\u0019-!2\u0002\u000b1|7m[:\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u000bG>t7-\u001e:sK:$(\u0002BAf\u0003\u001b\fA!\u001e;jY*\u0011\u0011qZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002T\u0006\u0005'!\u0004*fK:$(/\u00198u\u0019>\u001c7.A\u0003m_\u000e\\\u0007%\u0001\u0004j]2{7m[\u000b\u0005\u00037\f\t\u000f\u0006\u0003\u0002^\u0006M\b\u0003BAp\u0003Cd\u0001\u0001B\u0004\u0002d>\u0012\r!!:\u0003\u0003Q\u000bB!a:\u0002nB\u0019\u0011+!;\n\u0007\u0005-(KA\u0004O_RD\u0017N\\4\u0011\u0007E\u000by/C\u0002\u0002rJ\u00131!\u00118z\u0011!\t)p\fCA\u0002\u0005]\u0018a\u00014v]B)\u0011+!?\u0002^&\u0019\u00111 *\u0003\u0011q\u0012\u0017P\\1nKz\nQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHc\u0001=\u0003\u0002!9!1\u0001\u0019A\u0002\t\u0015\u0011A\u00039beRLG/[8ogB1!q\u0001B\u0005\u00037j!!a\u0015\n\t\u0005e\u00131K\u0001\u0010e\u0016lwN^3QCJ$\u0018\u000e^5p]R\u0019\u0001Pa\u0004\t\u000f\tE\u0011\u00071\u0001\u0002\\\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00059sKB\f'/\u001a(p)J\fgn]5u)\t\u00119\u0002E\u0002N\u00053I1Aa\u0007G\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u00023A\u0014X\r]1sK\u001a+gnY3Qe>$WoY3s\u000bB|7\r[\u0001\u001eaJ,\u0007/\u0019:f\u0013:\u001c'/Z7f]R\u0004&o\u001c3vG\u0016\u0014X\t]8dQRA!1\u0005B!\u0005\u000b\u0012Y\u0005\u0005\u0005\u0003&\t=\"Q\u0007B\f\u001d\u0011\u00119Ca\u000b\u000f\u0007!\u0014I#C\u0001T\u0013\r\u0011iCU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tDa\r\u0003\r\u0015KG\u000f[3s\u0015\r\u0011iC\u0015\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)!!1HA0\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B \u0005s\u0011a!\u0012:s_J\u001c\bb\u0002B\"i\u0001\u0007\u0011qE\u0001\u0010]\u0016<H\u000b\u001f8US6,w.\u001e;Ng\"9!q\t\u001bA\u0002\t%\u0013!F3ya\u0016\u001cG/\u001a3Qe>$WoY3s\u000bB|7\r\u001b\t\u0006#\u00065\u00161\u0002\u0005\u0007\u0005\u001b\"\u0004\u0019A:\u0002\u001fU\u0004H-\u0019;f)&lWm\u001d;b[B\f\u0011\u0004\u001d:fa\u0006\u0014X\r\u0015:pIV\u001cWM]%e%>$\u0018\r^5p]RQ!q\u0003B*\u0005/\u0012IFa\u0017\t\r\tUS\u00071\u0001t\u00035qWm\u001e)s_\u0012,8-\u001a:JI\"9!1I\u001bA\u0002\u0005\u001d\u0002B\u0002B'k\u0001\u00071\u000fC\u0004\u0003^U\u0002\rAa\u0018\u0002\u001fI,7m\u001c:e\u0019\u0006\u001cH/\u00129pG\"\u00042!\u0015B1\u0013\r\u0011\u0019G\u0015\u0002\b\u0005>|G.Z1o\u0003Q\u0001(/\u001a9be\u0016\fE\r\u001a)beRLG/[8ogR1!q\u0003B5\u0005oBqAa\u001b7\u0001\u0004\u0011i'\u0001\u000bbI\u0012,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005_\u0012)(a\u0017\u000e\u0005\tE$\u0002\u0002B:\u0003'\n\u0011\"[7nkR\f'\r\\3\n\t\u0005e#\u0011\u000f\u0005\u0007\u0005\u001b2\u0004\u0019A:\u0002)A\u0014X\r]1sK\u0006\u0013wN\u001d;Pe\u000e{W.\\5u)\u0019\u00119B! \u0003\u0002\"9!qP\u001cA\u0002\u0005e\u0012\u0001\u00038foN#\u0018\r^3\t\r\t5s\u00071\u0001t\u0003=\u0001(/\u001a9be\u0016\u001cu.\u001c9mKR,G\u0003\u0002B\f\u0005\u000fCaA!\u00149\u0001\u0004\u0019\u0018a\u00039sKB\f'/\u001a#fC\u0012\f\u0001$[:Qe>$WoY3s\u000bB|7\r[#yQ\u0006,8\u000f^3e+\t\u0011y&A\u000biCN\u0004VM\u001c3j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8\u0002'A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8\u0015%\t]!Q\u0013BL\u00053\u0013iJ!)\u0003$\n\u001d&1\u0016\u0005\b\u0005\u007fb\u0004\u0019AA\u001d\u0011\u0019\u0011)\u0006\u0010a\u0001g\"9!1\u0014\u001fA\u0002\u0005-\u0011\u0001\u00038fo\u0016\u0003xn\u00195\t\u000f\t}E\b1\u0001\u0002\f\u0005aa.Z<MCN$X\t]8dQ\"9!1\t\u001fA\u0002\u0005\u001d\u0002b\u0002BSy\u0001\u0007!QN\u0001\u0013]\u0016<Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0003*r\u0002\ra]\u0001\u0015]\u0016<H\u000b\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\t\r\t5C\b1\u0001t\u0003Q\u0019w.\u001c9mKR,GK]1og&$\u0018n\u001c8U_R\u0019\u0001P!-\t\u000f\tMV\b1\u0001\u0003\u0018\u0005yAO]1og&$X*\u001a;bI\u0006$\u0018-\u0001\nwC2LG\r\u0015:pIV\u001cWM]#q_\u000eDG\u0003\u0002B0\u0005sCqAa-?\u0001\u0004\u00119\"\u0001\fwC2LG\r\u0015:pIV\u001cWM]#q_\u000eD')^7q)\u0011\u0011yFa0\t\u000f\tMv\b1\u0001\u0003\u0018\u0005YB\u000f\u001b:poN#\u0018\r^3Ue\u0006t7/\u001b;j_:4\u0015-\u001b7ve\u0016$2\u0001\u001fBc\u0011\u001d\u00119\r\u0011a\u0001\u0005/\t!\u0003\u001e=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006Y\u0002/\u001a8eS:<GK]1og&$\u0018n\u001c8J]B\u0013xn\u001a:fgN\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002K\u00061Q-];bYN$BAa\u0018\u0003T\"9!Q[\"A\u0002\u00055\u0018\u0001\u0002;iCR\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003OA3\u0001\u0004Bo!\rq&q\\\u0005\u0004\u0005C|&!\u00048p]RD'/Z1eg\u00064W\rC\u0003d\u0007\u0001\u0007Q\rC\u0003r\u0007\u0001\u00071\u000fC\u0004\u0002\b\r\u0001\r!a\u0003\t\u000f\u0005\r2\u00011\u0001\u0002(!1!Q^\u0002A\u0002M\f\u0011\u0002^5nKN$\u0018-\u001c9\u0015\u001bm\u0013\tPa=\u0003v\n](\u0011 B~\u0011\u0015\u0019G\u00011\u0001f\u0011\u0015\tH\u00011\u0001t\u0011\u001d\t9\u0001\u0002a\u0001\u0003\u0017Aq!a\t\u0005\u0001\u0004\t9\u0003C\u0004\u00026\u0011\u0001\r!!\u000f\t\r\t5H\u00011\u0001t)EY&q`B\u0001\u0007\u0007\u0019)aa\u0002\u0004\n\r-1Q\u0002\u0005\u0006G\u0016\u0001\r!\u001a\u0005\u0006c\u0016\u0001\ra\u001d\u0005\u0006}\u0016\u0001\ra\u001d\u0005\b\u0003\u000f)\u0001\u0019AA\u0006\u0011\u001d\tI\"\u0002a\u0001\u0003\u0017Aq!a\t\u0006\u0001\u0004\t9\u0003C\u0004\u00026\u0015\u0001\r!!\u000f\t\r\t5X\u00011\u0001t\u0003-\u0011\u0017\u0010^3U_N#\u0018\r^3\u0015\t\u0005e21\u0003\u0005\b\u0007+1\u0001\u0019AB\f\u0003\u0011\u0011\u0017\u0010^3\u0011\u0007E\u001bI\"C\u0002\u0004\u001cI\u0013AAQ=uK\u0006\t\u0012n\u001d,bY&$GK]1og&$\u0018n\u001c8\u0015\r\t}3\u0011EB\u0013\u0011\u001d\u0019\u0019c\u0002a\u0001\u0003s\t\u0001b\u001c7e'R\fG/\u001a\u0005\b\u0005\u007f:\u0001\u0019AA\u001d\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\t\u0019Y\u0003E\u0004g\u0007[\tId!\r\n\u0007\r=rNA\u0002NCB\u0004RAZB\u001a\u0003sI1!!\u0017p\u0003Q1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3tA\u0005\u0001\u0012n]#q_\u000eDW\t\u001f5bkN$X\r\u001a\u000b\u0005\u0005?\u001aY\u0004C\u0004\u0002\b)\u0001\r!a\u0003\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019\tEK\u0002t\u0007\u0007Z#a!\u0012\u0011\t\r\u001d3\u0011K\u0007\u0003\u0007\u0013RAaa\u0013\u0004N\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u001f\u0012\u0016AC1o]>$\u0018\r^5p]&!11KB%\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T inLock(Function0<T> fun) {
        Object object;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), (short)(this.producerEpoch() + 1), (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(76).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already a pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        Option<TransactionState> option = this.pendingState();
        if (option == null) {
            throw null;
        }
        Option<TransactionState> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionMetadata.$anonfun$completeTransitionTo$1(this, transitMetadata);
        }
        TransactionState transactionState = toState = (TransactionState)getOrElse_this.get();
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(167).append("TransactionMetadata(").append("transactionalId=").append(this.transactionalId()).append(", ").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").append("state=").append(this.state()).append(", ").append("pendingState=").append(this.pendingState()).append(", ").append("topicPartitions=").append(this.topicPartitions()).append(", ").append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append($this).append("'s transition to ").append(transitMetadata$2).append(" failed since pendingState is not defined: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(95).append("TransactionalId ").append($this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.lock = new ReentrantLock();
    }
}

