/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.secret.SecretIdentifier;
import org.logstash.secret.store.SecretStore;

public class ConfigVariableExpander
implements AutoCloseable {
    private static String SUBSTITUTION_PLACEHOLDER_REGEX = "\\$\\{(?<name>[a-zA-Z_.][a-zA-Z0-9_.]*)(:(?<default>[^}]*))?}";
    private Pattern substitutionPattern = Pattern.compile(SUBSTITUTION_PLACEHOLDER_REGEX);
    private SecretStore secretStore;
    private EnvironmentVariableProvider envVarProvider;

    public static ConfigVariableExpander withoutSecret(EnvironmentVariableProvider envVarProvider) {
        return new ConfigVariableExpander(null, envVarProvider);
    }

    public ConfigVariableExpander(SecretStore secretStore, EnvironmentVariableProvider envVarProvider) {
        this.secretStore = secretStore;
        this.envVarProvider = envVarProvider;
    }

    public Object expand(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String variable = (String)value;
        Matcher m = this.substitutionPattern.matcher(variable);
        if (m.matches()) {
            String evValue;
            byte[] ssValue;
            String variableName = m.group("name");
            if (this.secretStore != null && (ssValue = this.secretStore.retrieveSecret(new SecretIdentifier(variableName))) != null) {
                return new String(ssValue, StandardCharsets.UTF_8);
            }
            if (this.envVarProvider != null && (evValue = this.envVarProvider.get(variableName)) != null) {
                return evValue;
            }
            String defaultValue = m.group("default");
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalStateException(String.format("Cannot evaluate `%s`. Replacement variable `%s` is not defined in a Logstash secret store or an environment entry and there is no default value given.", variable, variableName));
        }
        return variable;
    }

    @Override
    public void close() {
    }
}

