/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.plugins.PluginLookup;

public class AliasRegistry {
    private static final Logger LOGGER = LogManager.getLogger(AliasRegistry.class);
    private final Map<PluginCoordinate, String> aliases = new HashMap<PluginCoordinate, String>();
    private final Map<PluginCoordinate, String> reversedAliases = new HashMap<PluginCoordinate, String>();

    public AliasRegistry() {
        AliasYamlLoader loader = new AliasYamlLoader();
        Map<PluginCoordinate, String> defaultDefinitions = loader.loadAliasesDefinitions();
        this.configurePluginAliases(defaultDefinitions);
    }

    public AliasRegistry(Map<List<String>, String> aliasDefinitions) {
        HashMap<PluginCoordinate, String> aliases = new HashMap<PluginCoordinate, String>();
        for (Map.Entry<List<String>, String> e : aliasDefinitions.entrySet()) {
            List<String> tuple = e.getKey();
            PluginCoordinate key = this.mapTupleToCoordinate(tuple);
            aliases.put(key, e.getValue());
        }
        this.configurePluginAliases(aliases);
    }

    private PluginCoordinate mapTupleToCoordinate(List<String> tuple) {
        if (tuple.size() != 2) {
            throw new IllegalArgumentException("Expected a tuple of 2 elements, but found: " + tuple);
        }
        PluginLookup.PluginType type = PluginLookup.PluginType.valueOf(tuple.get(0).toUpperCase());
        String name = tuple.get(1);
        PluginCoordinate key = new PluginCoordinate(type, name);
        return key;
    }

    private void configurePluginAliases(Map<PluginCoordinate, String> aliases) {
        this.aliases.putAll(aliases);
        for (Map.Entry<PluginCoordinate, String> e : this.aliases.entrySet()) {
            PluginCoordinate reversedAlias = e.getKey().withName(e.getValue());
            if (this.reversedAliases.containsKey(reversedAlias)) {
                throw new IllegalStateException("Found plugin " + e.getValue() + " aliased more than one time");
            }
            this.reversedAliases.put(reversedAlias, e.getKey().name);
        }
    }

    public boolean isAlias(String type, String pluginName) {
        PluginLookup.PluginType pluginType = PluginLookup.PluginType.valueOf(type.toUpperCase());
        return this.isAlias(pluginType, pluginName);
    }

    public boolean isAlias(PluginLookup.PluginType type, String pluginName) {
        return this.aliases.containsKey(new PluginCoordinate(type, pluginName));
    }

    public String originalFromAlias(PluginLookup.PluginType type, String alias) {
        return this.aliases.get(new PluginCoordinate(type, alias));
    }

    public String originalFromAlias(String type, String alias) {
        return this.originalFromAlias(PluginLookup.PluginType.valueOf(type.toUpperCase()), alias);
    }

    public Optional<String> aliasFromOriginal(PluginLookup.PluginType type, String realPluginName) {
        return Optional.ofNullable(this.reversedAliases.get(new PluginCoordinate(type, realPluginName)));
    }

    public String resolveAlias(String type, String pluginName) {
        PluginCoordinate pluginCoord = new PluginCoordinate(PluginLookup.PluginType.valueOf(type.toUpperCase()), pluginName);
        return this.aliases.getOrDefault(pluginCoord, pluginName);
    }

    static class AliasYamlLoader {
        AliasYamlLoader() {
        }

        Map<PluginCoordinate, String> loadAliasesDefinitions(Path yamlPath) {
            FileInputStream in;
            try {
                in = new FileInputStream(yamlPath.toFile());
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Can't find aliases yml definition file in in path: " + yamlPath, (Throwable)e);
                return Collections.emptyMap();
            }
            return this.loadAliasesDefinitionsFromInputStream(in);
        }

        Map<PluginCoordinate, String> loadAliasesDefinitions() {
            String filePath = "org/logstash/plugins/plugin_aliases.yml";
            InputStream in = AliasYamlLoader.class.getClassLoader().getResourceAsStream("org/logstash/plugins/plugin_aliases.yml");
            if (in == null) {
                LOGGER.warn("Malformed yaml file in yml definition file in jar resources: {}", (Object)"org/logstash/plugins/plugin_aliases.yml");
                return Collections.emptyMap();
            }
            return this.loadAliasesDefinitionsFromInputStream(in);
        }

        private Map<PluginCoordinate, String> loadAliasesDefinitionsFromInputStream(InputStream in) {
            Map aliasedDescriptions;
            YamlWithChecksum aliasYml = YamlWithChecksum.load(in);
            String calculatedHash = aliasYml.computeHashFromContent();
            if (!calculatedHash.equals(aliasYml.checksumHash)) {
                LOGGER.warn("Bad checksum value, expected {} but found {}", (Object)calculatedHash, (Object)aliasYml.checksumHash);
                return Collections.emptyMap();
            }
            try {
                aliasedDescriptions = aliasYml.decodeYaml();
            }
            catch (IOException ioex) {
                LOGGER.error("Error decoding the yaml aliases file", (Throwable)ioex);
                return Collections.emptyMap();
            }
            HashMap<PluginCoordinate, String> defaultDefinitions = new HashMap<PluginCoordinate, String>();
            defaultDefinitions.putAll(this.extractDefinitions(PluginLookup.PluginType.INPUT, aliasedDescriptions));
            defaultDefinitions.putAll(this.extractDefinitions(PluginLookup.PluginType.CODEC, aliasedDescriptions));
            defaultDefinitions.putAll(this.extractDefinitions(PluginLookup.PluginType.FILTER, aliasedDescriptions));
            defaultDefinitions.putAll(this.extractDefinitions(PluginLookup.PluginType.OUTPUT, aliasedDescriptions));
            return defaultDefinitions;
        }

        private Map<PluginCoordinate, String> extractDefinitions(PluginLookup.PluginType pluginType, Map<String, Map<String, String>> aliasesYamlDefinitions) {
            HashMap<PluginCoordinate, String> defaultDefinitions = new HashMap<PluginCoordinate, String>();
            Map<String, String> pluginDefinitions = aliasesYamlDefinitions.get(pluginType.name().toLowerCase());
            if (pluginDefinitions == null) {
                return Collections.emptyMap();
            }
            for (Map.Entry<String, String> aliasDef : pluginDefinitions.entrySet()) {
                defaultDefinitions.put(new PluginCoordinate(pluginType, aliasDef.getKey()), aliasDef.getValue());
            }
            return defaultDefinitions;
        }
    }

    private static class YamlWithChecksum {
        final String yamlContents;
        final String checksumHash;

        private static YamlWithChecksum load(InputStream in) {
            try (Scanner scanner = new Scanner(in, StandardCharsets.UTF_8.name());){
                String header = scanner.nextLine();
                if (!header.startsWith("#CHECKSUM:")) {
                    throw new IllegalArgumentException("Bad header format, expected '#CHECKSUM: ...' but found " + header);
                }
                String extractedHash = header.substring("#CHECKSUM:".length()).trim();
                scanner.nextLine();
                StringBuilder yamlBuilder = new StringBuilder();
                scanner.useDelimiter("\\z");
                if (scanner.hasNext()) {
                    yamlBuilder.append(scanner.next());
                }
                String yamlContents = yamlBuilder.toString();
                YamlWithChecksum yamlWithChecksum = new YamlWithChecksum(yamlContents, extractedHash);
                return yamlWithChecksum;
            }
        }

        private YamlWithChecksum(String yamlContents, String checksumHash) {
            this.yamlContents = yamlContents;
            this.checksumHash = checksumHash;
        }

        private Map<String, Map<String, String>> decodeYaml() throws IOException {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            return (Map)mapper.readValue(this.yamlContents, Map.class);
        }

        private String computeHashFromContent() {
            return DigestUtils.sha256Hex((String)this.yamlContents);
        }
    }

    static final class PluginCoordinate {
        private final PluginLookup.PluginType type;
        private final String name;

        public PluginCoordinate(PluginLookup.PluginType type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginCoordinate that = (PluginCoordinate)o;
            return this.type == that.type && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name});
        }

        PluginCoordinate withName(String name) {
            return new PluginCoordinate(this.type, name);
        }

        public String toString() {
            return "PluginCoordinate{type=" + (Object)((Object)this.type) + ", name='" + this.name + "'}";
        }

        public String fullName() {
            return "logstash-" + this.type.rubyLabel().toString().toLowerCase() + "-" + this.name;
        }
    }
}

