/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.msgpack.jruby.ExtensionRegistry;
import org.msgpack.jruby.ExtensionValue;

public class Encoder {
    private static final int CACHE_LINE_SIZE = 64;
    private static final int ARRAY_HEADER_SIZE = 24;
    private final Ruby runtime;
    private final Encoding binaryEncoding;
    private final Encoding utf8Encoding;
    private final boolean compatibilityMode;
    private final ExtensionRegistry registry;
    public boolean hasSymbolExtType;
    private ByteBuffer buffer;

    public Encoder(Ruby ruby, boolean bl, ExtensionRegistry extensionRegistry, boolean bl2) {
        this.runtime = ruby;
        this.buffer = ByteBuffer.allocate(40);
        this.binaryEncoding = ruby.getEncodingService().getAscii8bitEncoding();
        this.utf8Encoding = UTF8Encoding.INSTANCE;
        this.compatibilityMode = bl;
        this.registry = extensionRegistry;
        this.hasSymbolExtType = bl2;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    private void ensureRemainingCapacity(int n) {
        if (this.buffer.remaining() < n) {
            int n2 = Math.max(this.buffer.capacity() + (this.buffer.capacity() >> 1), this.buffer.capacity() + n);
            n2 += 64 - (24 + n2) % 64;
            this.buffer = ByteBuffer.allocate(n2).put(this.buffer.array(), 0, this.buffer.position());
        }
    }

    private IRubyObject readRubyString() {
        RubyString rubyString = this.runtime.newString(new ByteList(this.buffer.array(), 0, this.buffer.position(), this.binaryEncoding, false));
        this.buffer.clear();
        return rubyString;
    }

    public IRubyObject encode(IRubyObject iRubyObject) {
        this.appendObject(iRubyObject);
        return this.readRubyString();
    }

    public IRubyObject encode(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.appendObject(iRubyObject, iRubyObject2);
        return this.readRubyString();
    }

    public IRubyObject encodeArrayHeader(int n) {
        this.appendArrayHeader(n);
        return this.readRubyString();
    }

    public IRubyObject encodeMapHeader(int n) {
        this.appendHashHeader(n);
        return this.readRubyString();
    }

    public IRubyObject encodeBinHeader(int n) {
        this.appendStringHeader(n, true);
        return this.readRubyString();
    }

    public IRubyObject encodeFloat32(RubyNumeric rubyNumeric) {
        this.appendFloat32(rubyNumeric);
        return this.readRubyString();
    }

    private void appendObject(IRubyObject iRubyObject) {
        this.appendObject(iRubyObject, null);
    }

    private void appendObject(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject == null || iRubyObject instanceof RubyNil) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)-64);
        } else if (iRubyObject instanceof RubyBoolean) {
            this.ensureRemainingCapacity(1);
            this.buffer.put(((RubyBoolean)iRubyObject).isTrue() ? (byte)-61 : -62);
        } else if (iRubyObject instanceof RubyBignum) {
            this.appendBignum((RubyBignum)iRubyObject);
        } else if (iRubyObject instanceof RubyInteger) {
            this.appendInteger((RubyInteger)iRubyObject);
        } else if (iRubyObject instanceof RubyFloat) {
            this.appendFloat((RubyFloat)iRubyObject);
        } else if (iRubyObject instanceof RubyString) {
            if (iRubyObject.getType() == this.runtime.getString() || !this.tryAppendWithExtTypeLookup(iRubyObject)) {
                this.appendString((RubyString)iRubyObject);
            }
        } else if (iRubyObject instanceof RubySymbol) {
            if (this.hasSymbolExtType) {
                this.appendOther(iRubyObject, iRubyObject2);
            } else {
                this.appendString(((RubySymbol)iRubyObject).asString());
            }
        } else if (iRubyObject instanceof RubyArray) {
            if (iRubyObject.getType() == this.runtime.getArray() || !this.tryAppendWithExtTypeLookup(iRubyObject)) {
                this.appendArray((RubyArray)iRubyObject);
            }
        } else if (iRubyObject instanceof RubyHash) {
            if (iRubyObject.getType() == this.runtime.getHash() || !this.tryAppendWithExtTypeLookup(iRubyObject)) {
                this.appendHash((RubyHash)iRubyObject);
            }
        } else if (iRubyObject instanceof ExtensionValue) {
            this.appendExtensionValue((ExtensionValue)iRubyObject);
        } else {
            this.appendOther(iRubyObject, iRubyObject2);
        }
    }

    private void appendBignum(RubyBignum rubyBignum) {
        BigInteger bigInteger = rubyBignum.getBigIntegerValue();
        if (bigInteger.compareTo(RubyBignum.LONG_MIN) < 0 || bigInteger.compareTo(RubyBignum.LONG_MAX) > 0) {
            if (bigInteger.bitLength() > 64 || bigInteger.bitLength() > 63 && bigInteger.signum() < 0) {
                throw this.runtime.newArgumentError(String.format("Cannot pack big integer: %s", bigInteger));
            }
            this.ensureRemainingCapacity(9);
            this.buffer.put(bigInteger.signum() < 0 ? (byte)-45 : -49);
            byte[] byArray = bigInteger.toByteArray();
            this.buffer.put(byArray, byArray.length - 8, 8);
        } else {
            this.appendInteger((RubyInteger)rubyBignum);
        }
    }

    private void appendInteger(RubyInteger rubyInteger) {
        long l = rubyInteger.getLongValue();
        if (l < 0L) {
            if (l < -32768L) {
                if (l < Integer.MIN_VALUE) {
                    this.ensureRemainingCapacity(9);
                    this.buffer.put((byte)-45);
                    this.buffer.putLong(l);
                } else {
                    this.ensureRemainingCapacity(5);
                    this.buffer.put((byte)-46);
                    this.buffer.putInt((int)l);
                }
            } else if (l >= -32L) {
                this.ensureRemainingCapacity(1);
                byte by = (byte)(l | 0xE0L);
                this.buffer.put(by);
            } else if (l < -128L) {
                this.ensureRemainingCapacity(3);
                this.buffer.put((byte)-47);
                this.buffer.putShort((short)l);
            } else {
                this.ensureRemainingCapacity(2);
                this.buffer.put((byte)-48);
                this.buffer.put((byte)l);
            }
        } else if (l < 65536L) {
            if (l < 128L) {
                this.ensureRemainingCapacity(1);
                this.buffer.put((byte)l);
            } else if (l < 256L) {
                this.ensureRemainingCapacity(2);
                this.buffer.put((byte)-52);
                this.buffer.put((byte)l);
            } else {
                this.ensureRemainingCapacity(3);
                this.buffer.put((byte)-51);
                this.buffer.putShort((short)l);
            }
        } else if (l < 0x100000000L) {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-50);
            this.buffer.putInt((int)l);
        } else {
            this.ensureRemainingCapacity(9);
            this.buffer.put((byte)-45);
            this.buffer.putLong(l);
        }
    }

    private void appendFloat(RubyFloat rubyFloat) {
        double d = rubyFloat.getDoubleValue();
        this.ensureRemainingCapacity(9);
        this.buffer.put((byte)-53);
        this.buffer.putDouble(d);
    }

    private void appendFloat32(RubyNumeric rubyNumeric) {
        float f = (float)rubyNumeric.getDoubleValue();
        this.ensureRemainingCapacity(5);
        this.buffer.put((byte)-54);
        this.buffer.putFloat(f);
    }

    private void appendStringHeader(int n, boolean bl) {
        if (n < 32 && !bl) {
            this.ensureRemainingCapacity(1 + n);
            this.buffer.put((byte)(n | 0xFFFFFFA0));
        } else if (n <= 255 && !this.compatibilityMode) {
            this.ensureRemainingCapacity(2 + n);
            this.buffer.put(bl ? (byte)-60 : -39);
            this.buffer.put((byte)n);
        } else if (n <= 65535) {
            this.ensureRemainingCapacity(3 + n);
            this.buffer.put(bl ? (byte)-59 : -38);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5 + n);
            this.buffer.put(bl ? (byte)-58 : -37);
            this.buffer.putInt(n);
        }
    }

    private void appendString(RubyString rubyString) {
        boolean bl;
        Encoding encoding = rubyString.getEncoding();
        boolean bl2 = bl = !this.compatibilityMode && encoding == this.binaryEncoding;
        if (encoding != this.utf8Encoding && encoding != this.binaryEncoding) {
            rubyString = (RubyString)rubyString.encode(this.runtime.getCurrentContext(), (IRubyObject)this.runtime.getEncodingService().getEncoding(this.utf8Encoding));
        }
        ByteList byteList = rubyString.getByteList();
        int n = byteList.length();
        this.appendStringHeader(n, bl);
        this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n);
    }

    private void appendArray(RubyArray<?> rubyArray) {
        this.appendArrayHeader(rubyArray);
        this.appendArrayElements(rubyArray);
    }

    private void appendArrayHeader(RubyArray<?> rubyArray) {
        this.appendArrayHeader(rubyArray.size());
    }

    private void appendArrayHeader(int n) {
        if (n < 16) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)(n | 0x90));
        } else if (n < 65536) {
            this.ensureRemainingCapacity(3);
            this.buffer.put((byte)-36);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-35);
            this.buffer.putInt(n);
        }
    }

    private void appendArrayElements(RubyArray<?> rubyArray) {
        int n = rubyArray.size();
        for (int i = 0; i < n; ++i) {
            this.appendObject(rubyArray.eltOk((long)i));
        }
    }

    private void appendHash(RubyHash rubyHash) {
        this.appendHashHeader(rubyHash);
        this.appendHashElements(rubyHash);
    }

    private void appendHashHeader(RubyHash rubyHash) {
        this.appendHashHeader(rubyHash.size());
    }

    private void appendHashHeader(int n) {
        if (n < 16) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)(n | 0x80));
        } else if (n < 65536) {
            this.ensureRemainingCapacity(3);
            this.buffer.put((byte)-34);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-33);
            this.buffer.putInt(n);
        }
    }

    private void appendHashElements(RubyHash rubyHash) {
        int n = rubyHash.size();
        HashVisitor hashVisitor = new HashVisitor(n);
        rubyHash.visitAll((RubyHash.Visitor)hashVisitor);
        if (hashVisitor.remain != 0) {
            rubyHash.getRuntime().newConcurrencyError("Hash size changed while packing");
        }
    }

    private void appendExt(int n, ByteList byteList) {
        boolean bl;
        int n2 = byteList.length();
        int n3 = 0;
        boolean bl2 = bl = n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16;
        n3 = bl ? 2 + n2 : (n2 < 256 ? 3 + n2 : (n2 < 65536 ? 4 + n2 : 6 + n2));
        this.ensureRemainingCapacity(n3);
        if (n2 == 1) {
            this.buffer.put((byte)-44);
        } else if (n2 == 2) {
            this.buffer.put((byte)-43);
        } else if (n2 == 4) {
            this.buffer.put((byte)-42);
        } else if (n2 == 8) {
            this.buffer.put((byte)-41);
        } else if (n2 == 16) {
            this.buffer.put((byte)-40);
        } else if (n2 < 256) {
            this.buffer.put((byte)-57);
            this.buffer.put((byte)n2);
        } else if (n2 < 65536) {
            this.buffer.put((byte)-56);
            this.buffer.putShort((short)n2);
        } else {
            this.buffer.put((byte)-55);
            this.buffer.putInt(n2);
        }
        this.buffer.put((byte)n);
        this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n2);
    }

    private void appendExtensionValue(ExtensionValue extensionValue) {
        long l = ((RubyFixnum)extensionValue.get_type()).getLongValue();
        if (l < -128L || l > 127L) {
            throw extensionValue.getRuntime().newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        ByteList byteList = ((RubyString)extensionValue.payload()).getByteList();
        this.appendExt((int)l, byteList);
    }

    private boolean tryAppendWithExtTypeLookup(IRubyObject iRubyObject) {
        if (this.registry != null) {
            if (iRubyObject.getType() == this.runtime.getSymbol()) {
                RubyClass rubyClass = iRubyObject.getType();
            } else {
                RubyClass rubyClass = iRubyObject.getSingletonClass();
            }
            IRubyObject[] iRubyObjectArray = this.registry.lookupPackerForObject(iRubyObject);
            if (iRubyObjectArray != null) {
                RubyString rubyString = iRubyObjectArray[0].callMethod(this.runtime.getCurrentContext(), "call", iRubyObject).asString();
                int n = (int)((RubyFixnum)iRubyObjectArray[1]).getLongValue();
                this.appendExt(n, rubyString.getByteList());
                return true;
            }
        }
        return false;
    }

    private void appendOther(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (!this.tryAppendWithExtTypeLookup(iRubyObject)) {
            this.appendCustom(iRubyObject, iRubyObject2);
        }
    }

    private void appendCustom(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 == null) {
            IRubyObject iRubyObject3 = iRubyObject.callMethod(this.runtime.getCurrentContext(), "to_msgpack");
            ByteList byteList = iRubyObject3.asString().getByteList();
            int n = byteList.length();
            this.ensureRemainingCapacity(n);
            this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n);
        } else {
            iRubyObject.callMethod(this.runtime.getCurrentContext(), "to_msgpack", iRubyObject2);
        }
    }

    private class HashVisitor
    extends RubyHash.Visitor {
        public int remain;

        public HashVisitor(int n) {
            this.remain = n;
        }

        public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (this.remain-- > 0) {
                Encoder.this.appendObject(iRubyObject);
                Encoder.this.appendObject(iRubyObject2);
            }
        }
    }
}

