/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zh_Hant extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u83ab\u65af\u79d1\u6a19\u6e96\u6642\u9593",
               "",
               "\u83ab\u65af\u79d1\u590f\u4ee4\u6642\u9593",
               "",
               "\u83ab\u65af\u79d1\u6642\u9593",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u5df4\u57fa\u65af\u5766\u6a19\u6e96\u6642\u9593",
               "",
               "\u5df4\u57fa\u65af\u5766\u590f\u4ee4\u6642\u9593",
               "",
               "\u5df4\u57fa\u65af\u5766\u6642\u9593",
               "",
            };
        final String[] Magadan = new String[] {
               "\u99ac\u52a0\u4e39\u6a19\u6e96\u6642\u9593",
               "",
               "\u99ac\u52a0\u4e39\u590f\u4ee4\u6642\u9593",
               "",
               "\u99ac\u52a0\u4e39\u6642\u9593",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u4e2d\u6b50\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e2d\u6b50\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e2d\u6b50\u6642\u9593",
               "",
            };
        final String[] Acre = new String[] {
               "\u827e\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u827e\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u827e\u514b\u6642\u9593",
               "",
            };
        final String[] America_Eastern = new String[] {
               "\u6771\u90e8\u6a19\u6e96\u6642\u9593",
               "EST",
               "\u6771\u90e8\u590f\u4ee4\u6642\u9593",
               "EDT",
               "\u6771\u90e8\u6642\u9593",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u8c6a\u52f3\u7235\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u8c6a\u52f3\u7235\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u8c6a\u52f3\u7235\u5cf6\u6642\u9593",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u7d10\u897f\u862d\u6a19\u6e96\u6642\u9593",
               "",
               "\u7d10\u897f\u862d\u590f\u4ee4\u6642\u9593",
               "",
               "\u7d10\u897f\u862d\u6642\u9593",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u5370\u5ea6\u6d0b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "\u96c5\u5eab\u6b21\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u96c5\u5eab\u6b21\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u96c5\u5eab\u6b21\u514b\u6642\u9593",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u6771\u5e1d\u6c76\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "\u79d1\u65af\u745e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "\u6771\u6b50\u6a19\u6e96\u6642\u9593",
               "",
               "\u6771\u6b50\u590f\u4ee4\u6642\u9593",
               "",
               "\u6771\u6b50\u6642\u9593",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "\u963f\u6839\u5ef7\u897f\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u963f\u6839\u5ef7\u897f\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u963f\u6839\u5ef7\u897f\u90e8\u6642\u9593",
               "",
            };
        final String[] Ponape = new String[] {
               "\u6ce2\u7d0d\u4f69\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u73bb\u5229\u7dad\u4e9e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u8056\u76ae\u57c3\u8207\u5bc6\u514b\u9686\u7fa4\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u8056\u76ae\u57c3\u8207\u5bc6\u514b\u9686\u7fa4\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u8056\u76ae\u57c3\u8207\u5bc6\u514b\u9686\u7fa4\u5cf6\u6642\u9593",
               "",
            };
        final String[] Indochina = new String[] {
               "\u5370\u5ea6\u652f\u90a3\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "\u8449\u5361\u6377\u7433\u5821\u6a19\u6e96\u6642\u9593",
               "",
               "\u8449\u5361\u6377\u7433\u5821\u590f\u4ee4\u6642\u9593",
               "",
               "\u8449\u5361\u6377\u7433\u5821\u6642\u9593",
               "",
            };
        final String[] Maldives = new String[] {
               "\u99ac\u723e\u5730\u592b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "\u5927\u6eaa\u5730\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u74e6\u5229\u65af\u548c\u5bcc\u5716\u7d0d\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "\u5357\u975e\u6a19\u6e96\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u662d\u548c\u57fa\u5730\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u840a\u6069\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u70cf\u8332\u5225\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u70cf\u8332\u5225\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u70cf\u8332\u5225\u514b\u6642\u9593",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u70cf\u862d\u5df4\u6258\u6a19\u6e96\u6642\u9593",
               "",
               "\u70cf\u862d\u5df4\u6258\u590f\u4ee4\u6642\u9593",
               "",
               "\u70cf\u862d\u5df4\u6258\u6642\u9593",
               "",
            };
        final String[] America_Central = new String[] {
               "\u4e2d\u90e8\u6a19\u6e96\u6642\u9593",
               "CST",
               "\u4e2d\u90e8\u590f\u4ee4\u6642\u9593",
               "CDT",
               "\u4e2d\u90e8\u6642\u9593",
               "CT",
            };
        final String[] Niue = new String[] {
               "\u7d10\u57c3\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u5a01\u514b\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "\u798f\u514b\u862d\u7fa4\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u798f\u514b\u862d\u7fa4\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u798f\u514b\u862d\u7fa4\u5cf6\u6642\u9593",
               "",
            };
        final String[] Apia = new String[] {
               "\u963f\u76ae\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u963f\u76ae\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u963f\u76ae\u4e9e\u6642\u9593",
               "",
            };
        final String[] Bhutan = new String[] {
               "\u4e0d\u4e39\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "\u8afe\u9b6f\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u897f\u54c8\u85a9\u514b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "\u8056\u8a95\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "\u7559\u5c3c\u65fa\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "\u79d1\u79d1\u65af\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u67e5\u5766\u7fa4\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u67e5\u5766\u7fa4\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u67e5\u5766\u7fa4\u5cf6\u6642\u9593",
               "",
            };
        final String[] Vostok = new String[] {
               "\u6c83\u65af\u6258\u514b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "\u963f\u6839\u5ef7\u6a19\u6e96\u6642\u9593",
               "",
               "\u963f\u6839\u5ef7\u590f\u4ee4\u6642\u9593",
               "",
               "\u963f\u6839\u5ef7\u6642\u9593",
               "",
            };
        final String[] Gambier = new String[] {
               "\u7518\u6bd4\u723e\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u52a0\u62c9\u5df4\u54e5\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u59d4\u5167\u745e\u62c9\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u9cf3\u51f0\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "\u7dad\u5fb7\u89d2\u6a19\u6e96\u6642\u9593",
               "",
               "\u7dad\u5fb7\u89d2\u590f\u4ee4\u6642\u9593",
               "",
               "\u7dad\u5fb7\u89d2\u6642\u9593",
               "",
            };
        final String[] Norfolk = new String[] {
               "\u8afe\u798f\u514b\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "\u85a9\u6469\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u85a9\u6469\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u85a9\u6469\u4e9e\u6642\u9593",
               "",
            };
        final String[] Davis = new String[] {
               "\u6234\u7dad\u65af\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "\u53e4\u5df4\u6a19\u6e96\u6642\u9593",
               "",
               "\u53e4\u5df4\u590f\u4ee4\u6642\u9593",
               "",
               "\u53e4\u5df4\u6642\u9593",
               "",
            };
        final String[] GMT = new String[] {
               "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "\u83f2\u5f8b\u8cd3\u6a19\u6e96\u6642\u9593",
               "",
               "\u83f2\u5f8b\u8cd3\u590f\u4ee4\u6642\u9593",
               "",
               "\u83f2\u5f8b\u8cd3\u6642\u9593",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u6cd5\u570b\u5357\u65b9\u53ca\u5357\u6975\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u7fa4\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9e\u6642\u9593",
               "",
            };
        final String[] Brunei = new String[] {
               "\u6c76\u840a\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "\u4f0a\u6717\u6a19\u6e96\u6642\u9593",
               "",
               "\u4f0a\u6717\u590f\u4ee4\u6642\u9593",
               "",
               "\u4f0a\u6717\u6642\u9593",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u5854\u5409\u514b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "\u6771\u52a0\u6a19\u6e96\u6642\u9593",
               "",
               "\u6771\u52a0\u590f\u4ee4\u6642\u9593",
               "",
               "\u6771\u52a0\u6642\u9593",
               "",
            };
        final String[] Bangladesh = new String[] {
               "\u5b5f\u52a0\u62c9\u6a19\u6e96\u6642\u9593",
               "",
               "\u5b5f\u52a0\u62c9\u590f\u4ee4\u6642\u9593",
               "",
               "\u5b5f\u52a0\u62c9\u6642\u9593",
               "",
            };
        final String[] Peru = new String[] {
               "\u79d8\u9b6f\u6a19\u6e96\u6642\u9593",
               "",
               "\u79d8\u9b6f\u590f\u4ee4\u6642\u9593",
               "",
               "\u79d8\u9b6f\u6642\u9593",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u683c\u9675\u862d\u6771\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u683c\u9675\u862d\u6771\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u683c\u9675\u862d\u6771\u90e8\u6642\u9593",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u5370\u5c3c\u6771\u90e8\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u5409\u723e\u5409\u65af\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "\u6fb3\u6d32\u6771\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u6fb3\u6d32\u6771\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u6fb3\u6d32\u6771\u90e8\u6642\u9593",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u6cd5\u5c6c\u572d\u4e9e\u90a3\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "\u54e5\u502b\u6bd4\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u54e5\u502b\u6bd4\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u54e5\u502b\u6bd4\u4e9e\u6642\u9593",
               "",
            };
        final String[] Chile = new String[] {
               "\u667a\u5229\u6a19\u6e96\u6642\u9593",
               "",
               "\u667a\u5229\u590f\u4ee4\u6642\u9593",
               "",
               "\u667a\u5229\u6642\u9593",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u5409\u723e\u4f2f\u7279\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "\u4f0a\u723e\u5eab\u6b21\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u4f0a\u723e\u5eab\u6b21\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u4f0a\u723e\u5eab\u6b21\u514b\u6642\u9593",
               "",
            };
        final String[] Georgia = new String[] {
               "\u55ac\u6cbb\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u55ac\u6cbb\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u55ac\u6cbb\u4e9e\u6642\u9593",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u55ac\u5df4\u5c71\u6a19\u6e96\u6642\u9593",
               "",
               "\u55ac\u5df4\u5c71\u590f\u4ee4\u6642\u9593",
               "",
               "\u55ac\u5df4\u5c71\u6642\u9593",
               "",
            };
        final String[] China = new String[] {
               "\u4e2d\u570b\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e2d\u570b\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e2d\u570b\u6642\u9593",
               "",
            };
        final String[] Armenia = new String[] {
               "\u4e9e\u7f8e\u5c3c\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e9e\u7f8e\u5c3c\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e9e\u7f8e\u5c3c\u4e9e\u6642\u9593",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u4e2d\u975e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "\u65e5\u672c\u6a19\u6e96\u6642\u9593",
               "",
               "\u65e5\u672c\u590f\u4ee4\u6642\u9593",
               "",
               "\u65e5\u672c\u6642\u9593",
               "",
            };
        final String[] Taipei = new String[] {
               "\u53f0\u5317\u6a19\u6e96\u6642\u9593",
               "",
               "\u53f0\u5317\u590f\u4ee4\u6642\u9593",
               "",
               "\u53f0\u5317\u6642\u9593",
               "",
            };
        final String[] Hovd = new String[] {
               "\u79d1\u5e03\u591a\u6a19\u6e96\u6642\u9593",
               "",
               "\u79d1\u5e03\u591a\u590f\u4ee4\u6642\u9593",
               "",
               "\u79d1\u5e03\u591a\u6642\u9593",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u6fb3\u6d32\u4e2d\u897f\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u6fb3\u6d32\u4e2d\u897f\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u6fb3\u6d32\u4e2d\u897f\u90e8\u6642\u9593",
               "",
            };
        final String[] Sakhalin = new String[] {
               "\u5eab\u9801\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u5eab\u9801\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u5eab\u9801\u5cf6\u6642\u9593",
               "",
            };
        final String[] Paraguay = new String[] {
               "\u5df4\u62c9\u572d\u6a19\u6e96\u6642\u9593",
               "",
               "\u5df4\u62c9\u572d\u590f\u4ee4\u6642\u9593",
               "",
               "\u5df4\u62c9\u572d\u6642\u9593",
               "",
            };
        final String[] Casey = new String[] {
               "\u51f1\u897f\u7ad9\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u99ac\u4f86\u897f\u4e9e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u4e16\u754c\u6a19\u6e96\u6642\u9593",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "\u6a21\u91cc\u897f\u65af\u6a19\u6e96\u6642\u9593",
               "",
               "\u6a21\u91cc\u897f\u65af\u590f\u4ee4\u6642\u9593",
               "",
               "\u6a21\u91cc\u897f\u65af\u6642\u9593",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "\u6771\u975e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u7d22\u7f85\u9580\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u99ac\u7d39\u723e\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u7d10\u82ac\u862d\u6a19\u6e96\u6642\u9593",
               "",
               "\u7d10\u82ac\u862d\u590f\u4ee4\u6642\u9593",
               "",
               "\u7d10\u82ac\u862d\u6642\u9593",
               "",
            };
        final String[] Afghanistan = new String[] {
               "\u963f\u5bcc\u6c57\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "\u9999\u6e2f\u6a19\u6e96\u6642\u9593",
               "",
               "\u9999\u6e2f\u590f\u4ee4\u6642\u9593",
               "",
               "\u9999\u6e2f\u6642\u9593",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u5927\u897f\u6d0b\u6a19\u6e96\u6642\u9593",
               "AST",
               "\u5927\u897f\u6d0b\u590f\u4ee4\u6642\u9593",
               "ADT",
               "\u5927\u897f\u6d0b\u6642\u9593",
               "AT",
            };
        final String[] Israel = new String[] {
               "\u4ee5\u8272\u5217\u6a19\u6e96\u6642\u9593",
               "",
               "\u4ee5\u8272\u5217\u590f\u4ee4\u6642\u9593",
               "",
               "\u4ee5\u8272\u5217\u6642\u9593",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "\u5370\u5c3c\u4e2d\u90e8\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "\u9102\u6728\u65af\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u9102\u6728\u65af\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u9102\u6728\u65af\u514b\u6642\u9593",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u585e\u5e2d\u723e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u70cf\u62c9\u572d\u6a19\u6e96\u6642\u9593",
               "",
               "\u70cf\u62c9\u572d\u590f\u4ee4\u6642\u9593",
               "",
               "\u70cf\u62c9\u572d\u6642\u9593",
               "",
            };
        final String[] Nepal = new String[] {
               "\u5c3c\u6cca\u723e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "\u695a\u514b\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "\u842c\u90a3\u675c\u6a19\u6e96\u6642\u9593",
               "",
               "\u842c\u90a3\u675c\u590f\u4ee4\u6642\u9593",
               "",
               "\u842c\u90a3\u675c\u6642\u9593",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "\u65b0\u897f\u4f2f\u5229\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u65b0\u897f\u4f2f\u5229\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u65b0\u897f\u4f2f\u5229\u4e9e\u6642\u9593",
               "",
            };
        final String[] Singapore = new String[] {
               "\u65b0\u52a0\u5761\u6a19\u6e96\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "\u4e9e\u901f\u723e\u7fa4\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e9e\u901f\u723e\u7fa4\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e9e\u901f\u723e\u7fa4\u5cf6\u6642\u9593",
               "",
            };
        final String[] Suriname = new String[] {
               "\u8607\u5229\u5357\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u514b\u62c9\u65af\u8afe\u4e9e\u723e\u65af\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u514b\u62c9\u65af\u8afe\u4e9e\u723e\u65af\u514b\u590f\u4ee4\u6642\u9593",
               "",
               "\u514b\u62c9\u65af\u8afe\u4e9e\u723e\u65af\u514b\u6642\u9593",
               "",
            };
        final String[] Myanmar = new String[] {
               "\u7dec\u7538\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "\u4e9e\u99ac\u905c\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e9e\u99ac\u905c\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e9e\u99ac\u905c\u6642\u9593",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u6771\u54c8\u85a9\u514b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "\u6590\u6fdf\u6a19\u6e96\u6642\u9593",
               "",
               "\u6590\u6fdf\u590f\u4ee4\u6642\u9593",
               "",
               "\u6590\u6fdf\u6642\u9593",
               "",
            };
        final String[] Kamchatka = new String[] {
               "\u5f7c\u5f97\u7f85\u5df4\u752b\u6d1b\u592b\u65af\u514b\u6a19\u6e96\u6642\u9593",
               "",
               "\u5f7c\u5f97\u7f85\u5df4\u752b\u6d1b\u592b\u65af\u514b\u65e5\u5149\u7bc0\u7d04\u6642\u9593",
               "",
               "\u5f7c\u5f97\u7f85\u5df4\u752b\u6d1b\u592b\u65af\u514b\u6642\u9593",
               "",
            };
        final String[] Tuvalu = new String[] {
               "\u5410\u74e6\u9b6f\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u9ea5\u89ba\u7406\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u590f\u5a01\u5937-\u963f\u7559\u7533\u6a19\u6e96\u6642\u9593",
               "HAST",
               "\u590f\u5a01\u5937-\u963f\u7559\u7533\u590f\u4ee4\u6642\u9593",
               "HADT",
               "\u590f\u5a01\u5937-\u963f\u7559\u7533\u6642\u9593",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u6fb3\u6d32\u4e2d\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u6fb3\u6d32\u4e2d\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u6fb3\u6d32\u4e2d\u90e8\u6642\u9593",
               "",
            };
        final String[] America_Pacific = new String[] {
               "\u592a\u5e73\u6d0b\u6a19\u6e96\u6642\u9593",
               "PST",
               "\u592a\u5e73\u6d0b\u590f\u4ee4\u6642\u9593",
               "PDT",
               "\u592a\u5e73\u6d0b\u6642\u9593",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "\u571f\u5eab\u66fc\u6a19\u6e96\u6642\u9593",
               "",
               "\u571f\u5eab\u66fc\u590f\u4ee4\u6642\u9593",
               "",
               "\u571f\u5eab\u66fc\u6642\u9593",
               "",
            };
        final String[] Europe_Western = new String[] {
               "\u897f\u6b50\u6a19\u6e96\u6642\u9593",
               "",
               "\u897f\u6b50\u590f\u4ee4\u6642\u9593",
               "",
               "\u897f\u6b50\u6642\u9593",
               "",
            };
        final String[] Guyana = new String[] {
               "\u84cb\u4e9e\u90a3\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u76ae\u7279\u80af\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u7f85\u745f\u62c9\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "\u5e1b\u7409\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "\u4e9e\u585e\u62dc\u7136\u6a19\u6e96\u6642\u9593",
               "",
               "\u4e9e\u585e\u62dc\u7136\u590f\u4ee4\u6642\u9593",
               "",
               "\u4e9e\u585e\u62dc\u7136\u6642\u9593",
               "",
            };
        final String[] Mawson = new String[] {
               "\u83ab\u68ee\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u58a8\u897f\u54e5\u592a\u5e73\u6d0b\u6a19\u6e96\u6642\u9593",
               "",
               "\u58a8\u897f\u54e5\u592a\u5e73\u6d0b\u590f\u4ee4\u6642\u9593",
               "",
               "\u58a8\u897f\u54e5\u592a\u5e73\u6d0b\u6642\u9593",
               "",
            };
        final String[] Africa_Western = new String[] {
               "\u897f\u975e\u6a19\u6e96\u6642\u9593",
               "",
               "\u897f\u975e\u590f\u4ee4\u6642\u9593",
               "",
               "\u897f\u975e\u6642\u9593",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u5357\u55ac\u6cbb\u4e9e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u5fa9\u6d3b\u7bc0\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u5fa9\u6d3b\u7bc0\u5cf6\u590f\u4ee4\u6642\u9593",
               "",
               "\u5fa9\u6d3b\u7bc0\u5cf6\u6642\u9593",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u58a8\u897f\u54e5\u897f\u5317\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u58a8\u897f\u54e5\u897f\u5317\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u58a8\u897f\u54e5\u897f\u5317\u90e8\u6642\u9593",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u675c\u8499\u675c\u6bd4\u723e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "\u683c\u9675\u862d\u897f\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u683c\u9675\u862d\u897f\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u683c\u9675\u862d\u897f\u90e8\u6642\u9593",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u5384\u74dc\u591a\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "\u6ce2\u65af\u7063\u6d77\u57df\u6a19\u6e96\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "\u97d3\u570b\u6a19\u6e96\u6642\u9593",
               "",
               "\u97d3\u570b\u590f\u4ee4\u6642\u9593",
               "",
               "\u97d3\u570b\u6642\u9593",
               "",
            };
        final String[] Australia_Western = new String[] {
               "\u6fb3\u6d32\u897f\u90e8\u6a19\u6e96\u6642\u9593",
               "",
               "\u6fb3\u6d32\u897f\u90e8\u590f\u4ee4\u6642\u9593",
               "",
               "\u6fb3\u6d32\u897f\u90e8\u6642\u9593",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "\u5370\u5c3c\u897f\u90e8\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "\u5c71\u5340\u6a19\u6e96\u6642\u9593",
               "MST",
               "\u5c71\u5340\u590f\u4ee4\u6642\u9593",
               "MDT",
               "\u5c71\u5340\u6642\u9593",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u99ac\u53ef\u85a9\u65af\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "\u963f\u62c9\u4f2f\u6a19\u6e96\u6642\u9593",
               "",
               "\u963f\u62c9\u4f2f\u590f\u4ee4\u6642\u9593",
               "",
               "\u963f\u62c9\u4f2f\u6642\u9593",
               "",
            };
        final String[] Alaska = new String[] {
               "\u963f\u62c9\u65af\u52a0\u6a19\u6e96\u6642\u9593",
               "AKST",
               "\u963f\u62c9\u65af\u52a0\u590f\u4ee4\u6642\u9593",
               "AKDT",
               "\u963f\u62c9\u65af\u52a0\u6642\u9593",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u6d77\u53c3\u5d34\u6a19\u6e96\u6642\u9593",
               "",
               "\u6d77\u53c3\u5d34\u590f\u4ee4\u6642\u9593",
               "",
               "\u6d77\u53c3\u5d34\u6642\u9593",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u67e5\u83ab\u6d1b\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u6258\u514b\u52de\u7fa4\u5cf6\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u5df4\u5e03\u4e9e\u7d10\u5e7e\u5167\u4e9e\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "\u8cbb\u723e\u5357\u591a - \u8fea\u8afe\u7f85\u5c3c\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u8cbb\u723e\u5357\u591a - \u8fea\u8afe\u7f85\u5c3c\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u8cbb\u723e\u5357\u591a - \u8fea\u8afe\u7f85\u5c3c\u4e9e\u6642\u9593",
               "",
            };
        final String[] Brasilia = new String[] {
               "\u5df4\u897f\u5229\u4e9e\u6a19\u6e96\u6642\u9593",
               "",
               "\u5df4\u897f\u5229\u4e9e\u590f\u4ee4\u6642\u9593",
               "",
               "\u5df4\u897f\u5229\u4e9e\u6642\u9593",
               "",
            };
        final String[] Anadyr = new String[] {
               "\u963f\u90a3\u5e95\u6cb3\u6a19\u6e96\u6642\u9593",
               "",
               "\u963f\u90a3\u5e95\u6cb3\u590f\u4ee4\u6642\u9593",
               "",
               "\u963f\u7d0d\u5fb7\u723e\u6642\u9593",
               "",
            };
        final String[] Samara = new String[] {
               "\u85a9\u99ac\u62c9\u6a19\u6e96\u6642\u9593",
               "",
               "\u85a9\u99ac\u62c9\u590f\u4ee4\u6642\u9593",
               "",
               "\u85a9\u99ac\u62c9\u6642\u9593",
               "",
            };
        final String[] Pyongyang = new String[] {
               "\u5e73\u58e4\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u5370\u5ea6\u6a19\u6e96\u6642\u9593",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "\u5eab\u514b\u7fa4\u5cf6\u6a19\u6e96\u6642\u9593",
               "",
               "\u5eab\u514b\u7fa4\u5cf6\u534a\u590f\u4ee4\u6642\u9593",
               "",
               "\u5eab\u514b\u7fa4\u5cf6\u6642\u9593",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "\u9cf3\u51f0\u57ce" },
            { "timezone.excity.Asia/Katmandu", "\u52a0\u5fb7\u6eff\u90fd" },
            { "timezone.excity.America/Antigua", "\u5b89\u5730\u5361" },
            { "timezone.excity.Europe/Ljubljana", "\u76e7\u6bd4\u5b89\u7d0d" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "\u99ac\u53ef\u85a9\u65af\u5cf6" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "\u5e03\u5b9c\u8afe\u65af\u827e\u5229\u65af" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "\u4e39\u99ac\u6c99\u6587" },
            { "timezone.excity.America/Anchorage", "\u5b89\u514b\u62c9\u6cbb" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",
                    "GMT",
                    "\u82f1\u570b\u590f\u4ee4\u6642\u9593",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "\u6c83\u65af\u6258\u514b" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "\u5317\u9054\u79d1\u4ed6\u5dde\u5e03\u7531\u62c9" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "\u6590\u6fdf" },
            { "timezone.excity.Europe/Gibraltar", "\u76f4\u5e03\u7f85\u9640" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "\u99ac\u62c9\u535a" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "\u81ea\u7531\u5e02" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "\u9054\u5580\u723e" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "\u963f\u8fea\u65af\u963f\u8c9d\u5df4" },
            { "timezone.excity.Africa/Kinshasa", "\u91d1\u590f\u6c99" },
            { "timezone.excity.Asia/Dushanbe", "\u675c\u6851\u8c9d" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "\u5854\u6797" },
            { "timezone.excity.Pacific/Truk", "\u695a\u514b" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "\u95dc\u5cf6" },
            { "timezone.excity.Europe/Vaduz", "\u74e6\u90fd\u8332" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "\u8056\u4f0a\u85a9\u8c9d\u723e" },
            { "timezone.excity.Asia/Barnaul", "\u5df4\u723e\u7459\u723e" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "\u99ac\u8cfd\u9b6f" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "\u502b\u6566" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "\u76ae\u7279\u80af\u7fa4\u5cf6" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "\u514b\u62c9\u65af\u8afe\u4e9e\u723e\u65af\u514b" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "\u8afe\u59c6" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "\u6eab\u54e5\u83ef" },
            { "timezone.excity.America/Matamoros", "\u99ac\u5854\u83ab\u7f85\u65af" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "\u55ac\u5df4\u5c71" },
            { "timezone.excity.America/Inuvik", "\u4f0a\u5974\u7dad\u514b" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "\u8056\u9732\u897f\u4e9e" },
            { "timezone.excity.Asia/Novokuznetsk", "\u65b0\u5eab\u8332\u6d85\u8328\u514b" },
            { "timezone.excity.Europe/Berlin", "\u67cf\u6797" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "\u4e2d\u9014\u5cf6" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "\u52aa\u514b" },
            { "timezone.excity.America/Martinique", "\u99ac\u4e01\u5c3c\u514b" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "\u4f2f\u65af" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Africa/Asmera", "\u963f\u65af\u746a\u62c9" },
            { "timezone.excity.Arctic/Longyearbyen", "\u9686\u610f\u8033\u62dc\u6069" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "\u5fb7\u53e4\u65af\u52a0\u5df4" },
            { "timezone.excity.Africa/Windhoek", "\u6eab\u5f97\u548c\u514b" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "\u99ac\u6731\u8afe" },
            { "timezone.excity.America/Lower_Princes", "\u4e0b\u592a\u5b50\u5340" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "\u73ed\u7af9" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "\u6797\u5fb7\u66fc" },
            { "timezone.excity.America/Miquelon", "\u5bc6\u555f\u5d19" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "\u80e1\u80e1\u4f0a" },
            { "timezone.excity.America/Argentina/Ushuaia", "\u70cf\u65af\u61f7\u4e9e" },
            { "timezone.excity.America/North_Dakota/Center", "\u5317\u9054\u79d1\u4ed6\u5dde\u4e2d\u5fc3" },
            { "timezone.excity.America/Cayenne", "\u958b\u96f2" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "\u8c9d\u91cc\u65af" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "\u66fc\u8c37" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "\u8499\u7279\u7dad\u591a" },
            { "timezone.excity.Pacific/Johnston", "\u5f37\u65af\u9813" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "\u6fa4\u897f\u5cf6" },
            { "timezone.excity.America/Pangnirtung", "\u6f58\u5c3c\u723e\u6771" },
            { "timezone.excity.Atlantic/South_Georgia", "\u5357\u55ac\u6cbb\u4e9e" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "\u6731\u5df4" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "\u54c8\u74e6\u90a3" },
            { "timezone.excity.Europe/Madrid", "\u99ac\u5fb7\u91cc" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "\u5e95\u7279\u5f8b" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "\u683c\u745e\u7d0d\u9054" },
            { "timezone.excity.Asia/Phnom_Penh", "\u91d1\u908a" },
            { "timezone.excity.Asia/Hebron", "\u8d6b\u5e03\u9686" },
            { "timezone.excity.Europe/Rome", "\u7f85\u99ac" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "\u83ab\u68ee" },
            { "timezone.excity.Asia/Karachi", "\u5580\u62c9\u86a9" },
            { "timezone.excity.America/Resolute", "\u7f85\u65af\u9b6f\u7279" },
            { "timezone.excity.Africa/Nouakchott", "\u8afe\u514b\u5c11" },
            { "timezone.excity.Africa/Bamako", "\u5df4\u99ac\u79d1" },
            { "timezone.excity.America/Argentina/Salta", "\u85a9\u723e\u5854" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "\u99ac\u65af\u958b\u7279" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "\u963f\u5c24\u6069" },
            { "timezone.excity.Australia/Hobart", "\u8377\u5df4\u7279" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "\u5229\u99ac" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u5317\u9054\u79d1\u4ed6\u5dde\u7d10\u6c99\u502b" },
            { "timezone.excity.Asia/Atyrau", "\u963f\u7279\u52de" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "\u6bd4\u4ec0\u51f1\u514b" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "\u5df4\u62c9\u99ac\u5229\u6ce2" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "\u5967\u5e0c\u7d0d\u52a0" },
            { "timezone.excity.Europe/Zurich", "\u8607\u9ece\u4e16" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "\u8056\u4fdd\u7f85" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "\u7d10\u7d04" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "\u963f\u514b\u62c9" },
            { "timezone.excity.Etc/Unknown", "\u672a\u77e5\u57ce\u5e02" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "\u675c\u91cc" },
            { "timezone.excity.America/Grand_Turk", "\u5927\u7279\u514b\u5cf6" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "\u5370\u7b2c\u5b89\u90a3\u5dde\u5f7c\u5f97\u5821" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "\u6eab\u5c3c\u4f2f" },
            { "timezone.excity.Antarctica/Macquarie", "\u9ea5\u89ba\u7406" },
            { "timezone.excity.Europe/Uzhgorod", "\u70cf\u8332\u54e5\u6d1b" },
            { "timezone.excity.America/Caracas", "\u5361\u62c9\u5361\u65af" },
            { "timezone.excity.America/Dawson_Creek", "\u9053\u68ee\u514b\u91cc\u514b" },
            { "timezone.excity.America/Bogota", "\u6ce2\u54e5\u5927" },
            { "timezone.excity.Asia/Baku", "\u5df4\u5eab" },
            { "timezone.excity.Asia/Hovd", "\u79d1\u5e03\u591a" },
            { "timezone.excity.Africa/Harare", "\u54c8\u62c9\u96f7" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "\u767d\u6717\u85a9\u5e03\u9686" },
            { "timezone.excity.Africa/Algiers", "\u963f\u723e\u53ca\u723e" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "\u5580\u571f\u7a46" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "\u582a\u5730\u52a0" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "\u52a0\u62c9\u5df4\u54e5\u7fa4\u5cf6" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "\u5410\u5eab\u66fc" },
            { "timezone.excity.America/Rio_Branco", "\u91cc\u7d04\u5e03\u862d" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "\u70cf\u91cc\u63da\u8afe\u592b\u65af\u514b" },
            { "timezone.excity.Africa/Niamey", "\u5c3c\u4e9e\u7f8e" },
            { "timezone.excity.Indian/Mayotte", "\u99ac\u7d04\u7279\u5cf6" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",
                    "GMT",
                    "\u611b\u723e\u862d\u6a19\u6e96\u6642\u9593",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "\u67ef\u90a3\u514b\u91cc" },
            { "timezone.excity.Asia/Jakarta", "\u96c5\u52a0\u9054" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "\u85a9\u62c9\u6258\u592b" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "\u57c3\u6cd5\u7279" },
            { "timezone.excity.Asia/Aqtobe", "\u963f\u514b\u6258\u6bd4" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "\u8056\u8d6b\u52d2\u62ff\u5cf6" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "\u62c9\u7f85\u6e6f\u52a0" },
            { "timezone.excity.Europe/Luxembourg", "\u76e7\u68ee\u5821" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "\u5df4\u6797" },
            { "timezone.excity.Indian/Mahe", "\u99ac\u57c3\u5cf6" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "\u66fc\u5cf6" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "\u5eab\u62c9\u7d22" },
            { "timezone.excity.Pacific/Nauru", "\u8afe\u9b6f" },
            { "timezone.excity.Pacific/Pago_Pago", "\u5df4\u54e5\u5df4\u54e5" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "\u84cb\u4e9e\u90a3" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "\u5df4\u9ece" },
            { "timezone.excity.Europe/Zagreb", "\u672d\u683c\u745e\u5e03" },
            { "timezone.excity.America/Scoresbysund", "\u4f0a\u6258\u79d1\u723e\u6258\u7c73\u7279" },
            { "timezone.excity.America/Indiana/Vevay", "\u5370\u7b2c\u5b89\u90a3\u5dde\u7dad\u5a01" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "\u65af\u5a01\u592b\u7279\u5361\u502b\u7279" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "\u6258\u723e\u6258\u62c9" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "\u5e03\u9054\u4f69\u65af" },
            { "timezone.excity.America/Catamarca", "\u5361\u5854\u99ac\u5361" },
            { "timezone.excity.America/Port_of_Spain", "\u897f\u73ed\u7259\u6e2f" },
            { "timezone.excity.Asia/Chita", "\u8d64\u5854" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "\u862d\u4eca\u7063" },
            { "timezone.excity.America/Santarem", "\u8056\u5854\u502b" },
            { "timezone.excity.Asia/Tomsk", "\u6258\u6728\u65af\u514b" },
            { "timezone.excity.Europe/Helsinki", "\u8d6b\u723e\u8f9b\u57fa" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "\u96c5\u5eab\u5854" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "\u963f\u90a3\u5e95" },
            { "timezone.excity.Asia/Urumqi", "\u70cf\u9b6f\u6728\u9f4a" },
            { "timezone.excity.America/Costa_Rica", "\u54e5\u65af\u5927\u9ece\u52a0" },
            { "timezone.excity.Africa/Lagos", "\u62c9\u54e5\u65af" },
            { "timezone.excity.Africa/Bissau", "\u6bd4\u7d39" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "\u675c\u963f\u62c9" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "\u6469\u52a0\u8fea\u4f11" },
            { "timezone.excity.America/Bahia_Banderas", "\u5df4\u4f0a\u4e9e\u73ed\u5fb7\u62c9\u65af" },
            { "timezone.excity.Asia/Jayapura", "\u52a0\u4e9e\u5e03\u62c9" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "\u74dc\u9054\u5eb7\u7d0d\u723e\u5cf6" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "\u6d1b\u7f8e" },
            { "timezone.excity.America/Nassau", "\u62ff\u7d22" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "\u79d1\u5a01\u7279" },
            { "timezone.excity.America/Santo_Domingo", "\u8056\u591a\u660e\u54e5" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "\u83ab\u65af\u79d1" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "\u53f0\u5317" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "\u683c\u6797\u5a01\u6cbb\u6a19\u6e96\u6642\u9593",
                    "GMT",
                    "\u82f1\u570b\u590f\u4ee4\u6642\u9593",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "\u9054\u5361" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "\u7d0d\u723e\u905c\u5821" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "\u6cd5\u99ac\u53e4\u65af\u5854" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "\u99ac\u91cc\u6208\u7279" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "\u80af\u5854\u57fa\u5dde\u8499\u5730\u537b\u7f85" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "\u76e7\u672c\u5df4\u5e0c" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "\u70cf\u862d\u5df4\u6258" },
            { "timezone.excity.Antarctica/McMurdo", "\u9ea5\u514b\u9ed8\u591a" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "\u65b0\u897f\u4f2f\u5229\u4e9e" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "\u4e2d\u79d1\u96f7\u59c6\u65af\u514b" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "\u5948\u6d1b\u6bd4" },
            { "Europe/Tallinn", Europe_Eastern },
            { "timezone.excity.America/Indiana/Marengo", "\u5370\u7b2c\u5b89\u90a3\u5dde\u99ac\u502b\u54e5" },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "\u6cd5\u8003\u798f" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "\u6771\u4eac" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "\u7d04\u7ff0\u5c3c\u65af\u5821" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "\u90fd\u67cf\u6797" },
            { "timezone.excity.Antarctica/Casey", "\u51f1\u897f" },
            { "timezone.excity.Atlantic/Cape_Verde", "\u7dad\u5fb7\u89d2" },
            { "timezone.excity.Africa/Maputo", "\u99ac\u666e\u6258" },
            { "timezone.excity.Africa/Luanda", "\u7f85\u5b89\u9054" },
            { "timezone.excity.America/Goose_Bay", "\u9d5d\u7063" },
            { "timezone.excity.America/Los_Angeles", "\u6d1b\u6749\u78ef" },
            { "timezone.excity.America/Eirunepe", "\u827e\u9b6f\u5167\u4f69" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "\u53e4\u96c5\u5df4" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "\u4e9e\u901f\u723e\u7fa4\u5cf6" },
            { "timezone.excity.Australia/Melbourne", "\u58a8\u723e\u672c" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "\u5b89\u594e\u62c9" },
            { "timezone.excity.Pacific/Honolulu", "\u6a80\u9999\u5c71" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "\u5e03\u5229\u65af\u73ed" },
            { "timezone.excity.Indian/Antananarivo", "\u5b89\u5854\u90a3\u90a3\u5229\u5f17" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "\u746a\u7459\u65af" },
            { "timezone.excity.Asia/Vientiane", "\u6c38\u73cd" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "\u8056\u8a95\u5cf6" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "\u963f\u514b\u5957" },
            { "timezone.excity.America/Regina", "\u91cc\u8cc8\u7d0d" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "\u73ca\u5fb7\u7063" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "\u8def\u6613\u65af\u7dad\u723e" },
            { "timezone.excity.America/Cancun", "\u574e\u6606" },
            { "timezone.excity.Australia/Broken_Hill", "\u5e03\u7f85\u80af\u5e0c\u723e" },
            { "timezone.excity.Europe/Kaliningrad", "\u52a0\u91cc\u5be7\u683c\u52d2" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "\u57fa\u91cc\u5730\u99ac\u5730\u5cf6" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "\u5730\u62c9\u90a3" },
            { "timezone.excity.Europe/Prague", "\u5e03\u62c9\u683c" },
            { "timezone.excity.Pacific/Tarawa", "\u5854\u62c9\u74e6" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "\u4e9e\u677e\u68ee" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "\u57fa\u897f\u7d10" },
            { "timezone.excity.America/Moncton", "\u8499\u514b\u9813" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "\u74dc\u5730\u99ac\u62c9" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "\u7dad\u723e\u7d10\u65af" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "\u829d\u52a0\u54e5" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "\u8056\u99ac\u5229\u8afe" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "\u6ce2\u7d0d\u4f69" },
            { "timezone.excity.Asia/Irkutsk", "\u4f0a\u723e\u5eab\u6b21\u514b" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.America/Chihuahua", "\u5947\u83ef\u83ef" },
            { "timezone.excity.Europe/Skopje", "\u53f2\u9ad8\u6bd4\u8036" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "\u5370\u7b2c\u5b89\u90a3\u5dde\u5a01\u7d0d\u99ac\u514b" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "\u96f7\u514b\u96c5\u7dad\u514b" },
            { "timezone.excity.Asia/Kamchatka", "\u582a\u5bdf\u52a0" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "\u96c5\u5eab\u6b21\u514b" },
            { "timezone.excity.Africa/Djibouti", "\u5409\u5e03\u5730" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "\u96f7\u897f\u975e" },
            { "timezone.excity.Pacific/Wallis", "\u74e6\u5229\u65af" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "\u6ce2\u591a\u8afe\u4f5b" },
            { "timezone.excity.Antarctica/Palmer", "\u5e15\u9ea5" },
            { "timezone.excity.Asia/Tashkent", "\u5854\u4ec0\u5e72" },
            { "timezone.excity.America/Argentina/San_Juan", "\u8056\u80e1\u5b89" },
            { "timezone.excity.Antarctica/Rothera", "\u7f85\u745f\u62c9" },
            { "timezone.excity.Asia/Shanghai", "\u4e0a\u6d77" },
            { "timezone.excity.America/Juneau", "\u6731\u8afe" },
            { "timezone.excity.Pacific/Bougainville", "\u5e03\u5e72\u7dad\u723e" },
            { "timezone.excity.Pacific/Apia", "\u963f\u76ae\u4e9e" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "\u85a9\u723e\u74e6\u591a" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "\u5fa9\u6d3b\u5cf6" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "\u7d10\u57c3\u5cf6" },
            { "timezone.excity.America/Menominee", "\u7f8e\u8afe\u7c73\u5c3c" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "\u8c6a\u52f3\u7235\u5cf6" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "\u99ac\u52a0\u4e39" },
            { "timezone.excity.Pacific/Wake", "\u5a01\u514b" },
            { "timezone.excity.Atlantic/Canary", "\u52a0\u7d0d\u5229" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "\u683c\u96f7\u65af\u8c9d" },
            { "timezone.excity.Africa/Casablanca", "\u5361\u85a9\u5e03\u862d\u5361" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "\u514b\u62c9\u502b\u4ee3\u514b" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "\u8449\u91cc\u6eab" },
            { "timezone.excity.Europe/Kirov", "\u57fa\u6d1b\u592b" },
            { "timezone.excity.America/Creston", "\u514b\u96f7\u65af\u9813" },
            { "timezone.excity.Africa/Cairo", "\u958b\u7f85" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "\u83ef\u6c99" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "\u5370\u7b2c\u5b89\u90a3\u5dde\u6cf0\u723e\u57ce" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "\u827e\u5fb7\u8499\u541e" },
            { "timezone.excity.Africa/Sao_Tome", "\u8056\u591a\u7f8e" },
            { "timezone.excity.Africa/Abidjan", "\u963f\u6bd4\u8b93" },
            { "timezone.excity.America/Dawson", "\u9053\u68ee" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "\u74dc\u5730\u6d1b\u666e" },
            { "timezone.excity.Africa/Freetown", "\u81ea\u7531\u57ce" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "\u798f\u5854\u529b\u838e" },
            { "timezone.excity.Europe/Vatican", "\u68b5\u8482\u5ca1" },
            { "timezone.excity.Asia/Almaty", "\u963f\u62c9\u6728\u5716" },
            { "timezone.excity.Asia/Tbilisi", "\u7b2c\u6bd4\u5229\u65af" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "\u5b89\u9053\u723e" },
            { "timezone.excity.Europe/Minsk", "\u660e\u65af\u514b" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "\u8499\u7f85\u7dad\u4e9e" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "\u58a8\u5df4\u672c" },
            { "timezone.excity.America/Rainy_River", "\u96e8\u6cb3\u93ae" },
            { "timezone.excity.America/Coral_Harbour", "\u963f\u8482\u79d1\u80af" },
            { "timezone.excity.Asia/Beirut", "\u8c9d\u9b6f\u7279" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "\u5764\u7538" },
            { "timezone.excity.America/Adak", "\u827e\u9054\u514b" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "\u591a\u502b\u591a" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "\u5df4\u683c\u9054" },
            { "timezone.excity.Antarctica/DumontDUrville", "\u675c\u8499\u675c\u6bd4\u723e" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "\u6885\u7279\u62c9\u5361\u7279\u62c9" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "\u99ac\u745f\u6b50" },
            { "timezone.excity.America/Guayaquil", "\u74dc\u4e9e\u57fa\u723e" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "\u8056\u6587\u68ee" },
            { "timezone.excity.America/Panama", "\u5df4\u62ff\u99ac" },
            { "timezone.excity.Europe/Simferopol", "\u8f9b\u975e\u6d1b\u6d66" },
            { "timezone.excity.Indian/Kerguelen", "\u51f1\u723e\u84cb\u6717\u5cf6" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "\u4f0f\u723e\u52a0\u683c\u52d2" },
            { "timezone.excity.Europe/Monaco", "\u6469\u7d0d\u54e5" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "\u62c9\u5df4\u65af" },
            { "timezone.excity.Africa/Tripoli", "\u7684\u9ece\u6ce2\u91cc" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "\u6069\u5f97\u4f2f\u7406\u5cf6" },
            { "timezone.excity.Asia/Pyongyang", "\u5e73\u58e4" },
            { "timezone.excity.Europe/Bucharest", "\u5e03\u52a0\u52d2\u65af\u7279" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "\u96c5\u5178" },
            { "Africa/Djibouti", Africa_Eastern },
            { "timezone.excity.America/Indiana/Knox", "\u5370\u7b2c\u5b89\u90a3\u5dde\u8afe\u514b\u65af" },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "\u7dad\u7559\u6e2f" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "\u99ac\u62ff\u74dc" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "\u8499\u54f2\u81d8" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "\u54e5\u672c\u54c8\u6839" },
            { "timezone.excity.Australia/Darwin", "\u9054\u723e\u6587" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "\u8036\u8def\u6492\u51b7" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "\u5229\u96c5\u5fb7" },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "\u73ed\u5409" },
            { "timezone.excity.Africa/Lusaka", "\u8def\u6c99\u5361" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "\u70cf\u65af\u5167\u62c9" },
            { "timezone.excity.Asia/Damascus", "\u5927\u99ac\u58eb\u9769" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "\u79d1\u65af\u745e" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "\u5e03\u62c9\u67f4\u7dad\u723e" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "\u91cc\u5967\u52a0\u8036\u6208\u65af" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "\u5df4\u4f0a\u963f" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "\u5fb7\u9ed1\u862d" },
            { "timezone.excity.Pacific/Tahiti", "\u5927\u6eaa\u5730" },
            { "timezone.excity.America/St_Kitts", "\u8056\u57fa\u8328" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "\u6c99\u862d\u6e2f" },
            { "timezone.excity.America/Monterrey", "\u8499\u7279\u745e" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "\u8c9d\u502b" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "\u80e1\u5fd7\u660e\u5e02" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "\u99ac\u5361\u6c99\u723e" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "\u8449\u5361\u6377\u6797\u5821" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "\u7d22\u83f2\u4e9e" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "\u963f\u65af\u7279\u62c9\u7f55" },
            { "timezone.excity.America/Yellowknife", "\u8036\u6d1b\u5948\u592b" },
            { "timezone.excity.Europe/Belgrade", "\u8c9d\u723e\u683c\u52d2" },
            { "timezone.excity.America/Puerto_Rico", "\u6ce2\u591a\u9ece\u5404" },
            { "timezone.excity.America/Denver", "\u4e39\u4f5b" },
            { "timezone.excity.Asia/Calcutta", "\u52a0\u723e\u5404\u7b54" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "\u52a0\u85a9" },
            { "timezone.excity.Africa/Ceuta", "\u4f11\u9054" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "\u7dbd\u723e" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "\u9999\u6e2f" },
            { "timezone.excity.America/Port-au-Prince", "\u592a\u5b50\u6e2f" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "\u5c24\u514b\u62c9" },
            { "timezone.excity.America/Mexico_City", "\u58a8\u897f\u54e5\u5e02" },
            { "timezone.excity.Pacific/Kwajalein", "\u74dc\u52a0\u6797\u5cf6" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "\u91cc\u65af\u672c" },
            { "timezone.excity.Pacific/Gambier", "\u7518\u6bd4\u723e\u7fa4\u5cf6" },
            { "timezone.excity.America/Boise", "\u6ce2\u5915" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "\u672d\u6ce2\u7f85\u7d50" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "\u591a\u7c73\u5c3c\u514b" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "\u574e\u5e15\u62c9" },
            { "timezone.excity.Pacific/Chatham", "\u67e5\u5766" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "\u53ef\u502b\u5761" },
            { "timezone.excity.Pacific/Port_Moresby", "\u83ab\u58eb\u6bd4\u6e2f" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "\u9580\u591a\u85a9" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "\u8afe\u502b\u54c8" },
            { "timezone.excity.Asia/Sakhalin", "\u5eab\u9801\u5cf6" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "\u5c3c\u76ae\u5ca1" },
            { "timezone.excity.Europe/Guernsey", "\u6839\u606f\u5cf6" },
            { "timezone.excity.America/Argentina/San_Luis", "\u8056\u8def\u6613" },
            { "timezone.excity.Europe/Riga", "\u91cc\u52a0" },
            { "timezone.excity.America/Araguaina", "\u963f\u62c9\u572d\u90a3" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "\u54e5\u591a\u83ef" },
            { "timezone.excity.America/Cambridge_Bay", "\u528d\u6a4b\u7063" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "\u683c\u862d\u5834" },
            { "timezone.excity.Africa/Blantyre", "\u5e03\u862d\u592a\u723e" },
            { "timezone.excity.Europe/Malta", "\u99ac\u723e\u4ed6" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "\u5361\u9054" },
            { "timezone.excity.Australia/Sydney", "\u96ea\u68a8" },
            { "timezone.excity.America/Sitka", "\u932b\u7279\u5361" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "\u6234\u7dad\u65af" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "\u8377\u5c6c\u963f\u9b6f\u5df4" },
            { "timezone.excity.Asia/Qyzylorda", "\u514b\u5b5c\u52d2\u5967\u723e\u9054" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "\u6a21\u91cc\u897f\u65af" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "\u62c9\u7565\u54c8" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "\u746a\u9e97\u6e2f" },
            { "timezone.excity.America/St_Johns", "\u8056\u7d04\u7ff0" },
            { "timezone.excity.America/St_Barthelemy", "\u8056\u5df4\u6258\u6d1b\u7e46\u5cf6" },
            { "timezone.excity.America/Santiago", "\u8056\u5730\u7259\u54e5" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "\u70cf\u62c9\u723e" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "\u99ac\u5c3c\u62c9" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "\u5370\u7b2c\u5b89\u90a3\u6ce2\u91cc\u65af" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "\u9996\u723e" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "\u8056\u6258\u99ac\u65af" },
            { "timezone.excity.Europe/Busingen", "\u5e03\u8f9b\u6839" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "\u4f0a\u65af\u5766\u5821" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "\u585e\u62c9\u8036\u4f5b" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "\u6069\u8cc8\u6885\u7d0d" },
            { "timezone.excity.America/Punta_Arenas", "\u84ec\u5854\u963f\u96f7\u7d0d\u65af" },
            { "timezone.excity.Africa/Kigali", "\u57fa\u52a0\u5229" },
            { "timezone.excity.Asia/Vladivostok", "\u6d77\u53c3\u5d34" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "\u7a81\u5c3c\u65af" },
            { "timezone.excity.Asia/Macau", "\u6fb3\u9580" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "\u6492\u99ac\u723e\u7f55" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Asia/Singapore", "\u65b0\u52a0\u5761" },
            { "timezone.excity.Australia/Adelaide", "\u963f\u5f97\u96f7\u5fb7" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "\u7dad\u4e5f\u7d0d" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "\u958b\u66fc\u7fa4\u5cf6" },
            { "timezone.excity.Europe/Bratislava", "\u5e03\u62c9\u63d0\u65af\u62c9\u74e6" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "\u5df4\u8c9d\u591a" },
            { "timezone.excity.Asia/Nicosia", "\u5c3c\u53e4\u897f\u4e9e" },
            { "timezone.excity.Europe/Kiev", "\u57fa\u8f14" },
            { "timezone.excity.Asia/Dili", "\u5e1d\u529b" },
            { "timezone.excity.Asia/Omsk", "\u9102\u6728\u65af\u514b" },
            { "timezone.excity.Africa/Bujumbura", "\u5e03\u677e\u5e03\u62c9" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "\u99ac\u85a9\u7279\u862d" },
            { "timezone.excity.Asia/Brunei", "\u6c76\u840a" },
            { "timezone.excity.Atlantic/Faeroe", "\u6cd5\u7f85\u7fa4\u5cf6" },
            { "timezone.excity.America/Whitehorse", "\u61f7\u7279\u970d\u65af" },
            { "timezone.excity.Asia/Kuching", "\u53e4\u6649" },
            { "timezone.excity.America/Halifax", "\u54c8\u91cc\u6cd5\u514b\u65af" },
            { "timezone.excity.America/Merida", "\u6885\u91cc\u9054" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "\u5e1b\u7409" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "\u5967\u514b\u862d" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "\u8afe\u798f\u514b" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "\u963f\u4ec0\u54c8\u5df4\u7279" },
            { "timezone.excity.Pacific/Tongatapu", "\u6771\u52a0\u5854\u5e03\u5cf6" },
            { "timezone.excity.Antarctica/Syowa", "\u662d\u548c\u57fa\u5730" },
            { "timezone.excity.America/Jamaica", "\u7259\u8cb7\u52a0" },
            { "timezone.excity.Pacific/Funafuti", "\u5bcc\u90a3\u5bcc\u63d0" },
            { "timezone.excity.America/Hermosillo", "\u57c3\u83ab\u897f\u7d04" },
            { "timezone.excity.Europe/Podgorica", "\u6ce2\u591a\u91cc\u5bdf" },
            { "timezone.excity.Indian/Reunion", "\u7559\u5c3c\u65fa\u5cf6" },
            { "timezone.excity.Pacific/Noumea", "\u8afe\u7f8e\u4e9e" },
            { "timezone.excity.Asia/Aden", "\u4e9e\u4e01" },
            { "timezone.excity.Europe/Oslo", "\u5967\u65af\u9678" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "\u53f2\u5766\u5229" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "\u4ef0\u5149" },
            { "timezone.excity.Asia/Thimphu", "\u5ef7\u5e03" },
            { "timezone.excity.Asia/Dubai", "\u675c\u62dc" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "\u5409\u9686\u5761" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "\u74e6\u52a0\u675c\u53e4" },
            { "timezone.excity.Africa/Gaborone", "\u5609\u67cf\u9686\u91cc" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "\u67e5\u6208\u65af" },
            { "timezone.excity.America/Iqaluit", "\u4f0a\u9b41\u7279" },
            { "timezone.excity.Asia/Kabul", "\u5580\u5e03\u723e" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "\u963f\u59c6\u65af\u7279\u4e39" },
            { "timezone.excity.Atlantic/Bermuda", "\u767e\u6155\u9054" },
            { "timezone.excity.Pacific/Saipan", "\u585e\u73ed" },
            { "timezone.excity.Indian/Cocos", "\u79d1\u79d1\u65af\u7fa4\u5cf6" },
            { "timezone.excity.Australia/Currie", "\u514b\u9ece" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "\u5b89\u66fc" },
            { "timezone.excity.America/Indiana/Vincennes", "\u5370\u7b2c\u5b89\u90a3\u5dde\u6eab\u68ee\u65af" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "\u5e03\u9b6f\u585e\u723e" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "\u99ac\u5f97\u62c9\u7fa4\u5cf6" },
            { "timezone.excity.Indian/Comoro", "\u79d1\u6469\u7f85\u7fa4\u5cf6" },
            { "timezone.excity.America/Boa_Vista", "\u4fdd\u7dad\u65af\u5854" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "\u65af\u5fb7\u54e5\u723e\u6469" },
            { "timezone.excity.Europe/Samara", "\u6c99\u99ac\u62c9" },
            { "timezone.excity.America/Tijuana", "\u63d0\u83ef\u7d0d" },
            { "timezone.excity.Indian/Maldives", "\u99ac\u723e\u5730\u592b" },
        };
        return data;
    }
}
