/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Shorts;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext tlsContext) {
        this.context = tlsContext;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    private DeferredHash(TlsContext tlsContext, Hashtable hashtable) {
        this.context = tlsContext;
        this.buf = null;
        this.hashes = hashtable;
        this.forceBuffering = false;
        this.sealed = true;
    }

    public void copyBufferTo(OutputStream outputStream) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyTo(outputStream);
    }

    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    public void notifyPRFDetermined() {
        int n = this.context.getSecurityParametersHandshake().getPrfAlgorithm();
        switch (n) {
            case 0: 
            case 1: {
                this.checkTrackingHash(Shorts.valueOf((short)1));
                this.checkTrackingHash(Shorts.valueOf((short)2));
                break;
            }
            default: {
                this.checkTrackingHash(Shorts.valueOf((short)TlsUtils.getHashAlgorithmForPRFAlgorithm(n)));
            }
        }
    }

    public void trackHashAlgorithm(short s) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf((short)s));
    }

    public void sealHashAlgorithms() {
        if (!this.sealed) {
            this.sealed = true;
            this.checkStopBuffering();
        }
    }

    public TlsHandshakeHash stopTracking() {
        Hashtable hashtable = new Hashtable();
        int n = this.context.getSecurityParametersHandshake().getPrfAlgorithm();
        switch (n) {
            case 0: 
            case 1: {
                this.cloneHash(hashtable, (short)1);
                this.cloneHash(hashtable, (short)2);
                break;
            }
            default: {
                this.cloneHash(hashtable, TlsUtils.getHashAlgorithmForPRFAlgorithm(n));
            }
        }
        return new DeferredHash(this.context, hashtable);
    }

    public TlsHash forkPRFHash() {
        TlsHash tlsHash;
        this.checkStopBuffering();
        int n = this.context.getSecurityParametersHandshake().getPrfAlgorithm();
        switch (n) {
            case 0: 
            case 1: {
                tlsHash = new CombinedHash(this.context, this.cloneHash((short)1), this.cloneHash((short)2));
                break;
            }
            default: {
                tlsHash = this.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(n));
            }
        }
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash;
    }

    public byte[] getFinalHash(short s) {
        TlsHash tlsHash = (TlsHash)this.hashes.get(Shorts.valueOf((short)s));
        if (tlsHash == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(s) + " is not being tracked");
        }
        this.checkStopBuffering();
        tlsHash = (TlsHash)tlsHash.clone();
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash.calculateHash();
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.buf != null) {
            this.buf.write(byArray, n, n2);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.update(byArray, n, n2);
        }
    }

    public byte[] calculateHash() {
        throw new IllegalStateException("Use fork() to get a definite hash");
    }

    public Object clone() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.reset();
        }
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration enumeration = this.hashes.elements();
            while (enumeration.hasMoreElements()) {
                TlsHash tlsHash = (TlsHash)enumeration.nextElement();
                this.buf.updateDigest(tlsHash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short s) {
        if (!this.hashes.containsKey(s)) {
            TlsHash tlsHash = this.context.getCrypto().createHash(s);
            this.hashes.put(s, tlsHash);
        }
    }

    protected TlsHash cloneHash(short s) {
        return this.cloneHash(Shorts.valueOf((short)s));
    }

    protected TlsHash cloneHash(Short s) {
        return (TlsHash)((TlsHash)this.hashes.get(s)).clone();
    }

    protected void cloneHash(Hashtable hashtable, short s) {
        this.cloneHash(hashtable, Shorts.valueOf((short)s));
    }

    protected void cloneHash(Hashtable hashtable, Short s) {
        TlsHash tlsHash = this.cloneHash(s);
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        hashtable.put(s, tlsHash);
    }
}

