/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.tcp.Decoder;

public final class InputLoop
implements Runnable,
Closeable {
    private static final Logger logger = LogManager.getLogger("logstash.inputs.tcp");
    private final EventLoopGroup boss;
    private final EventLoopGroup worker;
    private final ServerBootstrap serverBootstrap;
    private final SslContext sslContext;
    private final int port;
    private final String host;

    public InputLoop(String host, int port, Decoder decoder, boolean keepAlive, SslContext sslContext) {
        this.sslContext = sslContext;
        this.host = host;
        this.port = port;
        this.worker = new NioEventLoopGroup();
        this.boss = new NioEventLoopGroup(1);
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.boss, this.worker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).childOption(ChannelOption.SO_KEEPALIVE, keepAlive).childHandler(new InputHandler(decoder, sslContext));
    }

    @Override
    public void run() {
        try {
            this.serverBootstrap.bind(this.host, this.port).sync().channel().closeFuture().sync();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.boss.shutdownGracefully().sync();
            this.worker.shutdownGracefully().sync();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String remoteChannelInfo(Channel channel) {
        InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
        if (remote != null) {
            return remote.getAddress() + ":" + remote.getPort();
        }
        return null;
    }

    private static final class InputHandler
    extends ChannelInitializer<SocketChannel> {
        private final Decoder decoder;
        private final SslContext sslContext;

        InputHandler(Decoder decoder, SslContext sslContext) {
            this.decoder = decoder;
            this.sslContext = sslContext;
        }

        @Override
        protected void initChannel(SocketChannel channel) throws Exception {
            Decoder localCopy = this.decoder.copy();
            if (this.sslContext != null) {
                channel.pipeline().addLast(this.sslContext.newHandler(channel.alloc()));
            }
            channel.pipeline().addLast(new DecoderAdapter(localCopy, logger));
            channel.closeFuture().addListener(new FlushOnCloseListener(localCopy));
            if (logger.isDebugEnabled()) {
                logger.debug(InputLoop.remoteChannelInfo(channel) + ": initialized channel");
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.error("Error in Netty input handler: " + cause);
            super.exceptionCaught(ctx, cause);
        }

        private static final class DecoderAdapter
        extends ChannelInboundHandlerAdapter {
            private final Decoder decoder;
            private final Logger logger;

            DecoderAdapter(Decoder decoder, Logger logger) {
                this.logger = logger;
                this.decoder = decoder;
            }

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.decoder.decode(ctx.channel().remoteAddress(), (ByteBuf)msg);
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                String channelInfo = InputLoop.remoteChannelInfo(ctx.channel());
                if (this.silentException(cause)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(channelInfo + ": closing", cause);
                    } else {
                        this.logger.info("{}: closing ({})", (Object)channelInfo, (Object)cause.getMessage());
                    }
                } else {
                    this.logger.error(channelInfo + ": closing due:", cause);
                }
                ctx.close();
            }

            private boolean silentException(Throwable ex) {
                String message;
                return ex instanceof IOException && "Connection reset by peer".equals(message = ex.getMessage());
            }
        }

        private static final class FlushOnCloseListener
        implements GenericFutureListener<Future<Void>> {
            private final Decoder decoder;

            FlushOnCloseListener(Decoder decoder) {
                this.decoder = decoder;
            }

            @Override
            public void operationComplete(Future future) throws Exception {
                this.decoder.flush();
            }
        }
    }
}

