/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.util.SafePropertyAccessor;

public abstract class X509Utils {
    public static final String OPENSSLDIR;
    public static final String X509_CERT_AREA;
    public static final String X509_CERT_DIR;
    public static final String X509_CERT_FILE;
    public static final String X509_PRIVATE_DIR;
    public static final String X509_CERT_DIR_EVP = "SSL_CERT_DIR";
    public static final String X509_CERT_FILE_EVP = "SSL_CERT_FILE";
    public static final int X509_LU_RETRY = -1;
    public static final int X509_LU_FAIL = 0;
    public static final int X509_LU_X509 = 1;
    public static final int X509_LU_CRL = 2;
    public static final int X509_LU_PKEY = 3;
    public static final int X509_FILETYPE_PEM = 1;
    public static final int X509_FILETYPE_ASN1 = 2;
    public static final int X509_FILETYPE_DEFAULT = 3;
    public static final int X509_L_FILE_LOAD = 1;
    public static final int X509_L_ADD_DIR = 2;
    public static final int V_OK = 0;
    public static final int V_ERR_UNSPECIFIED = 1;
    public static final int V_ERR_UNABLE_TO_GET_ISSUER_CERT = 2;
    public static final int V_ERR_UNABLE_TO_GET_CRL = 3;
    public static final int V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE = 4;
    public static final int V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE = 5;
    public static final int V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY = 6;
    public static final int V_ERR_CERT_SIGNATURE_FAILURE = 7;
    public static final int V_ERR_CRL_SIGNATURE_FAILURE = 8;
    public static final int V_ERR_CERT_NOT_YET_VALID = 9;
    public static final int V_ERR_CERT_HAS_EXPIRED = 10;
    public static final int V_ERR_CRL_NOT_YET_VALID = 11;
    public static final int V_ERR_CRL_HAS_EXPIRED = 12;
    public static final int V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD = 13;
    public static final int V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD = 14;
    public static final int V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD = 15;
    public static final int V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD = 16;
    public static final int V_ERR_OUT_OF_MEM = 17;
    public static final int V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT = 18;
    public static final int V_ERR_SELF_SIGNED_CERT_IN_CHAIN = 19;
    public static final int V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY = 20;
    public static final int V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE = 21;
    public static final int V_ERR_CERT_CHAIN_TOO_LONG = 22;
    public static final int V_ERR_CERT_REVOKED = 23;
    public static final int V_ERR_INVALID_CA = 24;
    public static final int V_ERR_PATH_LENGTH_EXCEEDED = 25;
    public static final int V_ERR_INVALID_PURPOSE = 26;
    public static final int V_ERR_CERT_UNTRUSTED = 27;
    public static final int V_ERR_CERT_REJECTED = 28;
    public static final int V_ERR_SUBJECT_ISSUER_MISMATCH = 29;
    public static final int V_ERR_AKID_SKID_MISMATCH = 30;
    public static final int V_ERR_AKID_ISSUER_SERIAL_MISMATCH = 31;
    public static final int V_ERR_KEYUSAGE_NO_CERTSIGN = 32;
    public static final int V_ERR_UNABLE_TO_GET_CRL_ISSUER = 33;
    public static final int V_ERR_UNHANDLED_CRITICAL_EXTENSION = 34;
    public static final int V_ERR_KEYUSAGE_NO_CRL_SIGN = 35;
    public static final int V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION = 36;
    public static final int V_ERR_INVALID_NON_CA = 37;
    public static final int V_ERR_PROXY_PATH_LENGTH_EXCEEDED = 38;
    public static final int V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE = 39;
    public static final int V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED = 40;
    public static final int V_ERR_INVALID_EXTENSION = 41;
    public static final int V_ERR_INVALID_POLICY_EXTENSION = 42;
    public static final int V_ERR_NO_EXPLICIT_POLICY = 43;
    public static final int V_ERR_APPLICATION_VERIFICATION = 50;
    public static final int V_ERR_INVALID_CALL = 69;
    public static final int V_ERR_STORE_LOOKUP = 70;
    public static final int V_FLAG_CB_ISSUER_CHECK = 0;
    public static final int V_FLAG_USE_CHECK_TIME = 2;
    public static final int V_FLAG_CRL_CHECK = 4;
    public static final int V_FLAG_CRL_CHECK_ALL = 8;
    public static final int V_FLAG_IGNORE_CRITICAL = 16;
    public static final int V_FLAG_X509_STRICT = 32;
    public static final int V_FLAG_ALLOW_PROXY_CERTS = 64;
    public static final int V_FLAG_POLICY_CHECK = 128;
    public static final int V_FLAG_EXPLICIT_POLICY = 256;
    public static final int V_FLAG_INHIBIT_ANY = 512;
    public static final int V_FLAG_INHIBIT_MAP = 1024;
    public static final int V_FLAG_NOTIFY_POLICY = 2048;
    public static final int V_FLAG_CHECK_SS_SIGNATURE = 16384;
    public static final int V_FLAG_TRUSTED_FIRST = 32768;
    public static final int V_FLAG_PARTIAL_CHAIN = 524288;
    public static final int V_FLAG_NO_ALT_CHAINS = 0x100000;
    public static final int V_FLAG_NO_CHECK_TIME = 0x200000;
    public static final int V_FLAG_POLICY_MASK = 1920;
    public static final int X509_R_BAD_X509_FILETYPE = 100;
    public static final int X509_R_BASE64_DECODE_ERROR = 118;
    public static final int X509_R_CANT_CHECK_DH_KEY = 114;
    public static final int X509_R_CERT_ALREADY_IN_HASH_TABLE = 101;
    public static final int X509_R_ERR_ASN1_LIB = 102;
    public static final int X509_R_INVALID_DIRECTORY = 113;
    public static final int X509_R_INVALID_FIELD_NAME = 119;
    public static final int X509_R_INVALID_TRUST = 123;
    public static final int X509_R_KEY_TYPE_MISMATCH = 115;
    public static final int X509_R_KEY_VALUES_MISMATCH = 116;
    public static final int X509_R_LOADING_CERT_DIR = 103;
    public static final int X509_R_LOADING_DEFAULTS = 104;
    public static final int X509_R_NO_CERT_SET_FOR_US_TO_VERIFY = 105;
    public static final int X509_R_SHOULD_RETRY = 106;
    public static final int X509_R_UNABLE_TO_FIND_PARAMETERS_IN_CHAIN = 107;
    public static final int X509_R_UNABLE_TO_GET_CERTS_PUBLIC_KEY = 108;
    public static final int X509_R_UNKNOWN_KEY_TYPE = 117;
    public static final int X509_R_UNKNOWN_NID = 109;
    public static final int X509_R_UNKNOWN_PURPOSE_ID = 121;
    public static final int X509_R_UNKNOWN_TRUST_ID = 120;
    public static final int X509_R_UNSUPPORTED_ALGORITHM = 111;
    public static final int X509_R_WRONG_LOOKUP_TYPE = 112;
    public static final int X509_R_WRONG_TYPE = 122;
    public static final int X509_R_METHOD_NOT_SUPPORTED = 124;
    public static final int X509_R_PUBLIC_KEY_DECODE_ERROR = 125;
    public static final int X509_R_PUBLIC_KEY_ENCODE_ERROR = 126;
    public static final int X509_VP_FLAG_DEFAULT = 1;
    public static final int X509_VP_FLAG_OVERWRITE = 2;
    public static final int X509_VP_FLAG_RESET_FLAGS = 4;
    public static final int X509_VP_FLAG_LOCKED = 8;
    public static final int X509_VP_FLAG_ONCE = 16;
    public static final int X509_PURPOSE_SSL_CLIENT = 1;
    public static final int X509_PURPOSE_SSL_SERVER = 2;
    public static final int X509_PURPOSE_NS_SSL_SERVER = 3;
    public static final int X509_PURPOSE_SMIME_SIGN = 4;
    public static final int X509_PURPOSE_SMIME_ENCRYPT = 5;
    public static final int X509_PURPOSE_CRL_SIGN = 6;
    public static final int X509_PURPOSE_ANY = 7;
    public static final int X509_PURPOSE_OCSP_HELPER = 8;
    public static final int X509_PURPOSE_DYNAMIC = 1;
    public static final int X509_PURPOSE_DYNAMIC_NAME = 2;
    public static final int X509_PURPOSE_MIN = 1;
    public static final int X509_PURPOSE_MAX = 8;
    public static final int X509_TRUST_DEFAULT = 0;
    public static final int X509_TRUST_COMPAT = 1;
    public static final int X509_TRUST_SSL_CLIENT = 2;
    public static final int X509_TRUST_SSL_SERVER = 3;
    public static final int X509_TRUST_EMAIL = 4;
    public static final int X509_TRUST_OBJECT_SIGN = 5;
    public static final int X509_TRUST_OCSP_SIGN = 6;
    public static final int X509_TRUST_OCSP_REQUEST = 7;
    public static final int X509_TRUST_TSA = 8;
    public static final int X509_TRUST_MIN = 1;
    public static final int X509_TRUST_MAX = 8;
    public static final int X509_TRUST_DYNAMIC = 1;
    public static final int X509_TRUST_DYNAMIC_NAME = 2;
    public static final int X509_TRUST_NO_SS_COMPAT = 4;
    public static final int X509_TRUST_DO_SS_COMPAT = 8;
    public static final int X509_TRUST_OK_ANY_EKU = 16;
    public static final int X509_TRUST_TRUSTED = 1;
    public static final int X509_TRUST_REJECTED = 2;
    public static final int X509_TRUST_UNTRUSTED = 3;
    public static final int NS_SSL_CLIENT = 128;
    public static final int NS_SSL_SERVER = 64;
    public static final int NS_SMIME = 32;
    public static final int NS_OBJSIGN = 16;
    public static final int NS_SSL_CA = 4;
    public static final int NS_SMIME_CA = 2;
    public static final int NS_OBJSIGN_CA = 1;
    public static final int NS_ANY_CA = 7;
    public static final int X509V3_R_BAD_IP_ADDRESS = 118;
    public static final int X509V3_R_BAD_OBJECT = 119;
    public static final int X509V3_R_BN_DEC2BN_ERROR = 100;
    public static final int X509V3_R_BN_TO_ASN1_INTEGER_ERROR = 101;
    public static final int X509V3_R_DIRNAME_ERROR = 149;
    public static final int X509V3_R_DUPLICATE_ZONE_ID = 133;
    public static final int X509V3_R_ERROR_CONVERTING_ZONE = 131;
    public static final int X509V3_R_ERROR_CREATING_EXTENSION = 144;
    public static final int X509V3_R_ERROR_IN_EXTENSION = 128;
    public static final int X509V3_R_EXPECTED_A_SECTION_NAME = 137;
    public static final int X509V3_R_EXTENSION_EXISTS = 145;
    public static final int X509V3_R_EXTENSION_NAME_ERROR = 115;
    public static final int X509V3_R_EXTENSION_NOT_FOUND = 102;
    public static final int X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED = 103;
    public static final int X509V3_R_EXTENSION_VALUE_ERROR = 116;
    public static final int X509V3_R_ILLEGAL_EMPTY_EXTENSION = 151;
    public static final int X509V3_R_ILLEGAL_HEX_DIGIT = 113;
    public static final int X509V3_R_INCORRECT_POLICY_SYNTAX_TAG = 152;
    public static final int X509V3_R_INVALID_BOOLEAN_STRING = 104;
    public static final int X509V3_R_INVALID_EXTENSION_STRING = 105;
    public static final int X509V3_R_INVALID_NAME = 106;
    public static final int X509V3_R_INVALID_NULL_ARGUMENT = 107;
    public static final int X509V3_R_INVALID_NULL_NAME = 108;
    public static final int X509V3_R_INVALID_NULL_VALUE = 109;
    public static final int X509V3_R_INVALID_NUMBER = 140;
    public static final int X509V3_R_INVALID_NUMBERS = 141;
    public static final int X509V3_R_INVALID_OBJECT_IDENTIFIER = 110;
    public static final int X509V3_R_INVALID_OPTION = 138;
    public static final int X509V3_R_INVALID_POLICY_IDENTIFIER = 134;
    public static final int X509V3_R_INVALID_PROXY_POLICY_SETTING = 153;
    public static final int X509V3_R_INVALID_PURPOSE = 146;
    public static final int X509V3_R_INVALID_SECTION = 135;
    public static final int X509V3_R_INVALID_SYNTAX = 143;
    public static final int X509V3_R_ISSUER_DECODE_ERROR = 126;
    public static final int X509V3_R_MISSING_VALUE = 124;
    public static final int X509V3_R_NEED_ORGANIZATION_AND_NUMBERS = 142;
    public static final int X509V3_R_NO_CONFIG_DATABASE = 136;
    public static final int X509V3_R_NO_ISSUER_CERTIFICATE = 121;
    public static final int X509V3_R_NO_ISSUER_DETAILS = 127;
    public static final int X509V3_R_NO_POLICY_IDENTIFIER = 139;
    public static final int X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED = 154;
    public static final int X509V3_R_NO_PUBLIC_KEY = 114;
    public static final int X509V3_R_NO_SUBJECT_DETAILS = 125;
    public static final int X509V3_R_ODD_NUMBER_OF_DIGITS = 112;
    public static final int X509V3_R_OPERATION_NOT_DEFINED = 148;
    public static final int X509V3_R_OTHERNAME_ERROR = 147;
    public static final int X509V3_R_POLICY_LANGUAGE_ALREADTY_DEFINED = 155;
    public static final int X509V3_R_POLICY_PATH_LENGTH = 156;
    public static final int X509V3_R_POLICY_PATH_LENGTH_ALREADTY_DEFINED = 157;
    public static final int X509V3_R_POLICY_SYNTAX_NOT_CURRENTLY_SUPPORTED = 158;
    public static final int X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY = 159;
    public static final int X509V3_R_SECTION_NOT_FOUND = 150;
    public static final int X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS = 122;
    public static final int X509V3_R_UNABLE_TO_GET_ISSUER_KEYID = 123;
    public static final int X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT = 111;
    public static final int X509V3_R_UNKNOWN_EXTENSION = 129;
    public static final int X509V3_R_UNKNOWN_EXTENSION_NAME = 130;
    public static final int X509V3_R_UNKNOWN_OPTION = 120;
    public static final int X509V3_R_UNSUPPORTED_OPTION = 117;
    public static final int X509V3_R_USER_TOO_LONG = 132;
    public static final int ERR_R_FATAL = 64;
    public static final int ERR_R_MALLOC_FAILURE = 65;
    public static final int ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED = 66;
    public static final int ERR_R_PASSED_NULL_PARAMETER = 67;
    public static final int ERR_R_INTERNAL_ERROR = 68;
    public static final int ERR_R_DISABLED = 69;
    public static final int EXFLAG_BCONS = 1;
    public static final int EXFLAG_XKUSAGE = 4;
    public static final int EXFLAG_CA = 16;
    public static final int EXFLAG_SI = 32;
    public static final int EXFLAG_V1 = 64;
    public static final int EXFLAG_PROXY = 1024;
    public static final int EXFLAG_SS = 8192;
    public static final int XKU_SSL_SERVER = 1;
    public static final int XKU_SSL_CLIENT = 2;
    public static final int XKU_SMIME = 4;
    public static final int XKU_CODE_SIGN = 8;
    public static final int XKU_SGC = 8;
    public static final int XKU_OCSP_SIGN = 32;
    public static final int XKU_TIMESTAMP = 64;
    public static final int XKU_DVCS = 128;
    public static final int XKU_ANYEKU = 256;
    public static final int POLICY_FLAG_ANY_POLICY = 2;

    private X509Utils() {
    }

    public static String getDefaultPrivateDir() {
        return X509_PRIVATE_DIR;
    }

    public static String getDefaultCertificateArea() {
        return X509_CERT_AREA;
    }

    public static String getDefaultCertificateDirectory() {
        return X509_CERT_DIR;
    }

    public static String getDefaultCertificateFile() {
        return X509_CERT_FILE;
    }

    public static String getDefaultCertificateDirectoryEnvironment() {
        return X509_CERT_DIR_EVP;
    }

    public static String getDefaultCertificateFileEnvironment() {
        return X509_CERT_FILE_EVP;
    }

    public static String verifyCertificateErrorString(int error2) {
        switch (error2) {
            case 0: {
                return "ok";
            }
            case 2: {
                return "unable to get issuer certificate";
            }
            case 3: {
                return "unable to get certificate CRL";
            }
            case 4: {
                return "unable to decrypt certificate's signature";
            }
            case 5: {
                return "unable to decrypt CRL's signature";
            }
            case 6: {
                return "unable to decode issuer public key";
            }
            case 7: {
                return "certificate signature failure";
            }
            case 8: {
                return "CRL signature failure";
            }
            case 9: {
                return "certificate is not yet valid";
            }
            case 11: {
                return "CRL is not yet valid";
            }
            case 10: {
                return "certificate has expired";
            }
            case 12: {
                return "CRL has expired";
            }
            case 13: {
                return "format error in certificate's notBefore field";
            }
            case 14: {
                return "format error in certificate's notAfter field";
            }
            case 15: {
                return "format error in CRL's lastUpdate field";
            }
            case 16: {
                return "format error in CRL's nextUpdate field";
            }
            case 17: {
                return "out of memory";
            }
            case 18: {
                return "self signed certificate";
            }
            case 19: {
                return "self signed certificate in certificate chain";
            }
            case 20: {
                return "unable to get local issuer certificate";
            }
            case 21: {
                return "unable to verify the first certificate";
            }
            case 22: {
                return "certificate chain too long";
            }
            case 23: {
                return "certificate revoked";
            }
            case 24: {
                return "invalid CA certificate";
            }
            case 25: {
                return "path length constraint exceeded";
            }
            case 26: {
                return "unsupported certificate purpose";
            }
            case 27: {
                return "certificate not trusted";
            }
            case 28: {
                return "certificate rejected";
            }
            case 29: {
                return "subject issuer mismatch";
            }
            case 30: {
                return "authority and subject key identifier mismatch";
            }
            case 31: {
                return "authority and issuer serial number mismatch";
            }
            case 32: {
                return "key usage does not include certificate signing";
            }
            case 33: {
                return "unable to get CRL issuer certificate";
            }
            case 34: {
                return "unhandled critical extension";
            }
            case 35: {
                return "key usage does not include CRL signing";
            }
            case 36: {
                return "unhandled critical CRL extension";
            }
            case 37: {
                return "invalid non-CA certificate (has CA markings)";
            }
            case 38: {
                return "proxy path length constraint exceeded";
            }
            case 39: {
                return "key usage does not include digital signature";
            }
            case 40: {
                return "proxy cerificates not allowed, please set the appropriate flag";
            }
            case 41: {
                return "invalid or inconsistent certificate extension";
            }
            case 42: {
                return "invalid or inconsistent certificate policy extension";
            }
            case 43: {
                return "no explicit policy";
            }
            case 50: {
                return "application verification failure";
            }
        }
        return "error number " + error2;
    }

    static ASN1Primitive get(DEROctetString str) throws IOException {
        return X509Utils.get(str.getOctets());
    }

    static ASN1Primitive get(byte[] input) throws IOException {
        return new ASN1InputStream(input).readObject();
    }

    static int checkIfIssuedBy(X509AuxCertificate issuer2, X509AuxCertificate subject2) throws IOException {
        if (!issuer2.getSubjectX500Principal().equals(subject2.getIssuerX500Principal())) {
            return 29;
        }
        if (subject2.getExtensionValue("2.5.29.35") != null) {
            DEROctetString der;
            SubjectKeyIdentifier iskid;
            ASN1Sequence seq;
            AuthorityKeyIdentifier sakid;
            ASN1Primitive key = X509Utils.get(subject2.getExtensionValue("2.5.29.35"));
            if (!(key instanceof ASN1Sequence)) {
                key = X509Utils.get((DEROctetString)key);
            }
            if ((sakid = (seq = (ASN1Sequence)key).size() == 1 && seq.getObjectAt(0) instanceof ASN1OctetString ? AuthorityKeyIdentifier.getInstance((Object)new DLSequence((ASN1Encodable)new DERTaggedObject(0, seq.getObjectAt(0)))) : AuthorityKeyIdentifier.getInstance((Object)seq)).getKeyIdentifier() != null && issuer2.getExtensionValue("2.5.29.14") != null && (iskid = SubjectKeyIdentifier.getInstance((Object)X509Utils.get((der = (DEROctetString)X509Utils.get(issuer2.getExtensionValue("2.5.29.14"))).getOctets()))).getKeyIdentifier() != null && !Arrays.equals(sakid.getKeyIdentifier(), iskid.getKeyIdentifier())) {
                return 30;
            }
            BigInteger serialNumber = sakid.getAuthorityCertSerialNumber();
            if (serialNumber != null && !serialNumber.equals(issuer2.getSerialNumber())) {
                return 31;
            }
            if (sakid.getAuthorityCertIssuer() != null) {
                GeneralName[] gens = sakid.getAuthorityCertIssuer().getNames();
                X500Name x500Name = null;
                for (int i2 = 0; i2 < gens.length; ++i2) {
                    if (gens[i2].getTagNo() != 4) continue;
                    ASN1Encodable name2 = gens[i2].getName();
                    if (name2 instanceof X500Name) {
                        x500Name = (X500Name)name2;
                        break;
                    }
                    if (name2 instanceof ASN1Sequence) {
                        x500Name = X500Name.getInstance((Object)((ASN1Sequence)name2));
                        break;
                    }
                    throw new RuntimeException("unknown name type: " + name2);
                }
                if (x500Name != null && !new Name(x500Name).equalTo(issuer2.getIssuerX500Principal())) {
                    return 31;
                }
            }
        }
        boolean[] keyUsage = issuer2.getKeyUsage();
        if (subject2.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
            if (keyUsage != null && !keyUsage[0]) {
                return 39;
            }
        } else if (keyUsage != null && !keyUsage[5]) {
            return 32;
        }
        return 0;
    }

    static {
        String maybeCertFile;
        String privateDir;
        String certDir;
        String certArea;
        String JAVA_HOME = SafePropertyAccessor.getProperty((String)"java.home", (String)"");
        String LINUX_CERT_AREA = "/etc/ssl";
        String MACOS_CERT_AREA = "/System/Library/OpenSSL";
        String maybePkiCertFile = "/etc/pki/tls/certs/ca-bundle.crt";
        try {
            if (new File("/etc/ssl").exists()) {
                certArea = "/etc/ssl";
                certDir = certArea + "/certs";
                privateDir = certArea + "/private";
                maybeCertFile = certDir + "/cert.pem";
            } else if (new File("/System/Library/OpenSSL").exists()) {
                certArea = "/System/Library/OpenSSL";
                certDir = certArea + "/certs";
                privateDir = certArea + "/private";
                maybeCertFile = certArea + "/cert.pem";
            } else {
                certDir = certArea = JAVA_HOME + "/lib/security";
                privateDir = certArea;
                maybeCertFile = maybePkiCertFile;
            }
        }
        catch (SecurityException e) {
            maybeCertFile = null;
            maybePkiCertFile = null;
            certDir = certArea = JAVA_HOME + "/lib/security";
            privateDir = certArea;
        }
        X509_CERT_AREA = certArea;
        X509_CERT_DIR = certDir;
        X509_PRIVATE_DIR = privateDir;
        X509_CERT_FILE = maybePkiCertFile != null && new File(maybePkiCertFile).exists() ? maybePkiCertFile : (maybeCertFile != null && new File(maybeCertFile).exists() ? maybeCertFile : JAVA_HOME + "/lib/security/cacerts");
        OPENSSLDIR = X509_CERT_AREA;
    }
}

