/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nokogiri.XmlNamespace;
import nokogiri.internals.NokogiriHelpers;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NokogiriNamespaceCache {
    private final Map<CacheKey, CacheEntry> cache;
    private XmlNamespace defaultNamespace = null;

    public NokogiriNamespaceCache() {
        this.cache = new LinkedHashMap<CacheKey, CacheEntry>(4);
    }

    public NokogiriNamespaceCache(NokogiriNamespaceCache nokogiriNamespaceCache) {
        this.cache = new LinkedHashMap<CacheKey, CacheEntry>(nokogiriNamespaceCache.size() + 2);
        this.cache.putAll(nokogiriNamespaceCache.cache);
    }

    public XmlNamespace getDefault() {
        return this.defaultNamespace;
    }

    public XmlNamespace get(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        CacheEntry cacheEntry = this.cache.get(new CacheKey(string, string2));
        return cacheEntry == null ? null : cacheEntry.namespace;
    }

    public XmlNamespace get(Node node, String string) {
        if (string == null) {
            return this.defaultNamespace;
        }
        for (Map.Entry<CacheKey, CacheEntry> entry : this.cache.entrySet()) {
            if (!entry.getKey().prefix.equals(string) || !entry.getValue().isOwner(node)) continue;
            return entry.getValue().namespace;
        }
        return null;
    }

    public List<XmlNamespace> get(String string) {
        ArrayList<XmlNamespace> arrayList = new ArrayList<XmlNamespace>();
        if (string == null) {
            arrayList.add(this.defaultNamespace);
            return arrayList;
        }
        for (Map.Entry<CacheKey, CacheEntry> entry : this.cache.entrySet()) {
            if (!entry.getKey().prefix.equals(string)) continue;
            arrayList.add(entry.getValue().namespace);
        }
        return arrayList;
    }

    public List<XmlNamespace> get(Node node) {
        ArrayList<XmlNamespace> arrayList = new ArrayList<XmlNamespace>();
        for (Map.Entry<CacheKey, CacheEntry> entry : this.cache.entrySet()) {
            if (!entry.getValue().isOwner(node)) continue;
            arrayList.add(entry.getValue().namespace);
        }
        return arrayList;
    }

    public void put(XmlNamespace xmlNamespace, Node node) {
        String string = xmlNamespace.getPrefix();
        String string2 = xmlNamespace.getHref();
        if (string2 == null) {
            return;
        }
        CacheKey cacheKey = new CacheKey(string, string2);
        if (this.cache.get(cacheKey) != null) {
            return;
        }
        this.cache.put(cacheKey, new CacheEntry(xmlNamespace, node));
        if ("".equals(string)) {
            this.defaultNamespace = xmlNamespace;
        }
    }

    public void remove(Node node) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        if (string2 == null) {
            return;
        }
        this.cache.remove(new CacheKey(string, string2));
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        for (CacheEntry cacheEntry : this.cache.values()) {
            NamedNodeMap namedNodeMap = cacheEntry.ownerNode.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string = ((Attr)namedNodeMap.item(i)).getName();
                if (!NokogiriHelpers.isNamespace(string)) continue;
                namedNodeMap.removeNamedItem(string);
            }
        }
        this.cache.clear();
        this.defaultNamespace = null;
    }

    public void replaceNode(Node node, Node node2) {
        for (Map.Entry<CacheKey, CacheEntry> entry : this.cache.entrySet()) {
            if (!entry.getValue().isOwner(node)) continue;
            entry.getValue().replaceOwner(node2);
        }
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + '(' + this.cache + "default=" + (Object)((Object)this.defaultNamespace) + ')';
    }

    private static class CacheKey {
        final String prefix;
        final String href;

        CacheKey(String string, String string2) {
            this.prefix = string;
            this.href = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return this.prefix == null ? cacheKey.prefix == null : this.prefix.equals(cacheKey.prefix) && this.href.equals(cacheKey.href);
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix == null ? 0 : this.prefix.hashCode()) + 37 * this.href.hashCode();
        }

        public String toString() {
            return '[' + this.prefix + ']' + this.href;
        }
    }

    private static class CacheEntry {
        final XmlNamespace namespace;
        private Node ownerNode;

        CacheEntry(XmlNamespace xmlNamespace, Node node) {
            this.namespace = xmlNamespace;
            this.ownerNode = node;
        }

        boolean isOwner(Node node) {
            return this.ownerNode.isSameNode(node);
        }

        void replaceOwner(Node node) {
            this.ownerNode = node;
        }

        public String toString() {
            return this.namespace.toString();
        }
    }
}

