/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.List;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public abstract class AbstractTarget
implements Target {
    private Address address;
    private int version = 3;
    private int retries = 0;
    private long timeout = 1000L;
    private int maxSizeRequestPDU = 65535;
    private List<TransportMapping<? extends Address>> preferredTransports;
    protected int securityLevel = 1;
    protected int securityModel = 3;
    protected OctetString securityName = new OctetString();

    protected AbstractTarget() {
    }

    protected AbstractTarget(Address address) {
        this.address = address;
    }

    protected AbstractTarget(Address address, OctetString securityName) {
        this(address);
        this.securityName = securityName;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(Address address) {
        this.address = address;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Number of retries < 0");
        }
        this.retries = retries;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaxSizeRequestPDU() {
        return this.maxSizeRequestPDU;
    }

    @Override
    public void setMaxSizeRequestPDU(int maxSizeRequestPDU) {
        if (maxSizeRequestPDU < 484) {
            throw new IllegalArgumentException("The minimum PDU length is: 484");
        }
        this.maxSizeRequestPDU = maxSizeRequestPDU;
    }

    @Override
    public List<TransportMapping<? extends Address>> getPreferredTransports() {
        return this.preferredTransports;
    }

    public void setPreferredTransports(List<TransportMapping<? extends Address>> preferredTransports) {
        this.preferredTransports = preferredTransports;
    }

    protected String toStringAbstractTarget() {
        return "address=" + this.getAddress() + ",version=" + this.version + ",timeout=" + this.timeout + ",retries=" + this.retries + ",securityLevel=" + this.securityLevel + ",securityModel=" + this.securityModel + ",securityName=" + this.securityName + ",preferredTransports=" + this.preferredTransports;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toStringAbstractTarget() + "]";
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public int getSecurityModel() {
        return this.securityModel;
    }

    @Override
    public final OctetString getSecurityName() {
        return this.securityName;
    }

    @Override
    public int getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Override
    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    @Override
    public final void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTarget that = (AbstractTarget)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.retries != that.retries) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.maxSizeRequestPDU != that.maxSizeRequestPDU) {
            return false;
        }
        if (this.securityLevel != that.securityLevel) {
            return false;
        }
        if (this.securityModel != that.securityModel) {
            return false;
        }
        if (!this.address.equals(that.address)) {
            return false;
        }
        if (this.preferredTransports != null ? !this.preferredTransports.equals(that.preferredTransports) : that.preferredTransports != null) {
            return false;
        }
        return this.securityName.equals(that.securityName);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.securityName.hashCode();
        return result;
    }
}

