/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlNode;
import nokogiri.XmlRelaxng;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import nokogiri.internals.SchemaErrorHandler;
import nokogiri.internals.XmlDomParserContext;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@JRubyClass(name={"Nokogiri::XML::Schema"})
public class XmlSchema
extends RubyObject {
    private Validator validator;

    public XmlSchema(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private Schema getSchema(Source source, String string, String string2, SchemaErrorHandler schemaErrorHandler, long l) throws SAXException {
        boolean bl = new ParserContext.Options((long)l).noNet;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SchemaResourceResolver schemaResourceResolver = new SchemaResourceResolver(string, string2, null, schemaErrorHandler, bl);
        schemaFactory.setResourceResolver(schemaResourceResolver);
        schemaFactory.setErrorHandler(schemaErrorHandler);
        return schemaFactory.newSchema(source);
    }

    private void setValidator(Validator validator) {
        this.validator = validator;
    }

    static XmlSchema createSchemaInstance(ThreadContext threadContext, RubyClass rubyClass, Source source, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        XmlSchema xmlSchema = (XmlSchema)NokogiriService.XML_SCHEMA_ALLOCATOR.allocate(ruby, rubyClass);
        if (iRubyObject == null) {
            iRubyObject = XmlSchema.defaultParseOptions(threadContext.getRuntime());
        }
        long l = RubyFixnum.fix2long((IRubyObject)Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"to_i"));
        xmlSchema.setInstanceVariable("@errors", (IRubyObject)ruby.newEmptyArray());
        xmlSchema.setInstanceVariable("@parse_options", iRubyObject);
        try {
            SchemaErrorHandler schemaErrorHandler = new SchemaErrorHandler(threadContext.getRuntime(), (RubyArray)xmlSchema.getInstanceVariable("@errors"));
            Schema schema = xmlSchema.getSchema(source, threadContext.getRuntime().getCurrentDirectory(), threadContext.getRuntime().getInstanceConfig().getScriptFileName(), schemaErrorHandler, l);
            xmlSchema.setValidator(schema.newValidator());
            return xmlSchema;
        }
        catch (SAXException sAXException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + sAXException.getMessage());
        }
    }

    protected static IRubyObject defaultParseOptions(Ruby ruby) {
        return ((RubyClass)ruby.getClassFromPath("Nokogiri::XML::ParseOptions")).getConstant("DEFAULT_SCHEMA");
    }

    @JRubyMethod(meta=true, required=1, optional=1)
    public static IRubyObject from_document(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument;
        RubyArray rubyArray;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = null;
        if (iRubyObjectArray.length > 1) {
            iRubyObject3 = iRubyObjectArray[1];
        }
        if (!(rubyArray = (RubyArray)(xmlDocument = (XmlDocument)((XmlNode)iRubyObject2).document(threadContext)).getInstanceVariable("@errors")).isEmpty()) {
            throw ((XmlSyntaxError)rubyArray.first()).toThrowable();
        }
        DOMSource dOMSource = new DOMSource(xmlDocument.getDocument());
        IRubyObject iRubyObject4 = xmlDocument.url(threadContext);
        if (!iRubyObject4.isNil()) {
            dOMSource.setSystemId(iRubyObject4.convertToString().asJavaString());
        }
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, dOMSource, iRubyObject3);
    }

    @JRubyMethod(meta=true, required=1, optional=1)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = null;
        if (iRubyObjectArray.length > 1) {
            iRubyObject3 = iRubyObjectArray[1];
        }
        String string = iRubyObject2.convertToString().asJavaString();
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, new StreamSource(new StringReader(string)), iRubyObject3);
    }

    private static IRubyObject getSchema(ThreadContext threadContext, RubyClass rubyClass, Source source, IRubyObject iRubyObject) {
        String string = rubyClass.getName();
        if ("Nokogiri::XML::Schema".equals(string)) {
            return XmlSchema.createSchemaInstance(threadContext, rubyClass, source, iRubyObject);
        }
        if ("Nokogiri::XML::RelaxNG".equals(string)) {
            return XmlRelaxng.createSchemaInstance(threadContext, rubyClass, source, iRubyObject);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_document(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.validate_document_or_file(threadContext, (XmlDocument)iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_file(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(ruby, (IRubyObject)RubyFixnum.newFixnum((Ruby)ruby, (long)1L));
        xmlDomParserContext.setInputSourceFile(threadContext, iRubyObject);
        XmlDocument xmlDocument = xmlDomParserContext.parse(threadContext, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), threadContext.nil);
        return this.validate_document_or_file(threadContext, xmlDocument);
    }

    IRubyObject validate_document_or_file(ThreadContext threadContext, XmlDocument xmlDocument) {
        RubyArray rubyArray = (RubyArray)this.getInstanceVariable("@errors");
        SchemaErrorHandler schemaErrorHandler = new SchemaErrorHandler(threadContext.runtime, rubyArray);
        this.setErrorHandler(schemaErrorHandler);
        try {
            this.validate(xmlDocument.getDocument());
        }
        catch (SAXException sAXException) {
            XmlSyntaxError xmlSyntaxError = XmlSyntaxError.createXMLSyntaxError(threadContext.runtime);
            xmlSyntaxError.setException(sAXException);
            rubyArray.append((IRubyObject)xmlSyntaxError);
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOError(iOException.getMessage());
        }
        return rubyArray;
    }

    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.validator.setErrorHandler(errorHandler);
    }

    protected void validate(Document document) throws SAXException, IOException {
        DOMSource dOMSource = new DOMSource(document);
        this.validator.validate(dOMSource);
    }

    private class SchemaResourceResolver
    implements LSResourceResolver {
        SchemaLSInput lsInput;
        String currentDir;
        String scriptFileName;
        SchemaErrorHandler errorHandler;
        boolean noNet;

        SchemaResourceResolver(String string, String string2, Object object, SchemaErrorHandler schemaErrorHandler, boolean bl) {
            this.lsInput = new SchemaLSInput();
            this.currentDir = string;
            this.scriptFileName = string2;
            this.errorHandler = schemaErrorHandler;
            this.noNet = bl;
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                this.lsInput.setStringData((String)object);
            } else if (object instanceof Reader) {
                this.lsInput.setCharacterStream((Reader)object);
            } else if (object instanceof InputStream) {
                this.lsInput.setByteStream((InputStream)object);
            }
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            if (this.noNet && (string4.startsWith("http://") || string4.startsWith("ftp://"))) {
                if (string4.startsWith("http://www.w3.org/2001/XMLSchema")) {
                    return null;
                }
                try {
                    this.errorHandler.warning(new SAXParseException(String.format("Attempt to load network entity '%s'", string4), null));
                }
                catch (SAXException sAXException) {}
            } else {
                String string6 = NokogiriHelpers.adjustSystemIdIfNecessary(this.currentDir, this.scriptFileName, string5, string4);
                this.lsInput.setPublicId(string3);
                this.lsInput.setSystemId(string6 != null ? string6 : string4);
                this.lsInput.setBaseURI(string5);
            }
            return this.lsInput;
        }
    }

    private class SchemaLSInput
    implements LSInput {
        protected String fPublicId;
        protected String fSystemId;
        protected String fBaseSystemId;
        protected InputStream fByteStream;
        protected Reader fCharStream;
        protected String fData;
        protected String fEncoding;
        protected boolean fCertifiedText = false;

        private SchemaLSInput() {
        }

        @Override
        public String getBaseURI() {
            return this.fBaseSystemId;
        }

        @Override
        public InputStream getByteStream() {
            return this.fByteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return this.fCertifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.fCharStream;
        }

        @Override
        public String getEncoding() {
            return this.fEncoding;
        }

        @Override
        public String getPublicId() {
            return this.fPublicId;
        }

        @Override
        public String getStringData() {
            return this.fData;
        }

        @Override
        public String getSystemId() {
            return this.fSystemId;
        }

        @Override
        public void setBaseURI(String string) {
            this.fBaseSystemId = string;
        }

        @Override
        public void setByteStream(InputStream inputStream) {
            this.fByteStream = inputStream;
        }

        @Override
        public void setCertifiedText(boolean bl) {
            this.fCertifiedText = bl;
        }

        @Override
        public void setCharacterStream(Reader reader) {
            this.fCharStream = reader;
        }

        @Override
        public void setEncoding(String string) {
            this.fEncoding = string;
        }

        @Override
        public void setPublicId(String string) {
            this.fPublicId = string;
        }

        @Override
        public void setStringData(String string) {
            this.fData = string;
        }

        @Override
        public void setSystemId(String string) {
            this.fSystemId = string;
        }
    }
}

