/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.internals.HtmlDomParserContext;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::HTML::Document"}, parent="Nokogiri::XML::Document")
public class HtmlDocument
extends XmlDocument {
    private static final String DEFAULT_CONTENT_TYPE = "html";
    private static final String DEFAULT_PUBLIC_ID = "-//W3C//DTD HTML 4.01//EN";
    private static final String DEFAULT_SYTEM_ID = "http://www.w3.org/TR/html4/strict.dtd";
    private String parsed_encoding = null;

    public HtmlDocument(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public HtmlDocument(Ruby ruby, Document document) {
        this(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"), document);
    }

    public HtmlDocument(Ruby ruby, RubyClass rubyClass, Document document) {
        super(ruby, rubyClass, document);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDocument htmlDocument;
        Ruby ruby = threadContext.runtime;
        try {
            Document document = HtmlDocument.createNewDocument(ruby);
            htmlDocument = (HtmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(ruby, (RubyClass)iRubyObject);
            htmlDocument.setDocumentNode(threadContext.runtime, document);
        }
        catch (Exception exception) {
            throw HtmlDocument.asRuntimeError(ruby, "couldn't create document: ", exception);
        }
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)htmlDocument, (String)"initialize", (IRubyObject[])iRubyObjectArray);
        return htmlDocument;
    }

    @Override
    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        Object object = super.getInternalSubset(threadContext);
        if (object.isNil()) {
            object = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_CONTENT_TYPE), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_PUBLIC_ID), (IRubyObject)threadContext.getRuntime().newString(DEFAULT_SYTEM_ID));
            this.setInternalSubset((IRubyObject)object);
        }
        return object;
    }

    @Override
    void init(Ruby ruby, Document document) {
        HtmlDocument.stabilizeTextContent(document);
        document.normalize();
        this.setInstanceVariable("@decorators", ruby.getNil());
        if (document.getDocumentElement() != null) {
            HtmlDocument.stabilizeAttrs(document.getDocumentElement());
        }
    }

    private static void stabilizeAttrs(Node node) {
        int n;
        Object object;
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                HtmlDocument.stabilizeAttr((Attr)node2);
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            HtmlDocument.stabilizeAttrs(object.item(n));
        }
    }

    public void setParsedEncoding(String string) {
        this.parsed_encoding = string;
    }

    public String getPraedEncoding() {
        return this.parsed_encoding;
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDomParserContext htmlDomParserContext = new HtmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        htmlDomParserContext.setIOInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return htmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(meta=true, required=4)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        HtmlDomParserContext htmlDomParserContext = new HtmlDomParserContext(threadContext.runtime, iRubyObjectArray[2], iRubyObjectArray[3]);
        htmlDomParserContext.setStringInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return htmlDomParserContext.parse(threadContext, (RubyClass)iRubyObject, iRubyObjectArray[1]);
    }
}

