/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySystemExit;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

public final class Logstash
implements Runnable,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(Logstash.class);
    private final Ruby ruby;
    private static final String UNCLEAN_SHUTDOWN_PREFIX = "Logstash stopped processing because of an error: ";

    public static void main(String ... args) {
        String lsHome = System.getenv("LS_HOME");
        if (lsHome == null) {
            throw new IllegalStateException("LS_HOME environment variable must be set. This is likely a bug that should be reported.");
        }
        Logstash.configureNashornDeprecationSwitchForJavaAbove11();
        Logstash.installGlobalUncaughtExceptionHandler();
        Path home = Paths.get(lsHome, new String[0]).toAbsolutePath();
        try (Logstash logstash = new Logstash(home, args, System.out, System.err, System.in);){
            logstash.run();
        }
        catch (IllegalStateException e) {
            Throwable t = e;
            String message = e.getMessage();
            if (message != null) {
                if (message.startsWith(UNCLEAN_SHUTDOWN_PREFIX)) {
                    t = e.getCause();
                } else if (message.contains("Could not load FFI Provider")) {
                    message = "Error accessing temp directory: " + System.getProperty("java.io.tmpdir") + " this often occurs because the temp directory has been mounted with NOEXEC or the Logstash user has insufficient permissions on the directory. \nPossible workarounds include setting the -Djava.io.tmpdir property in the jvm.optionsfile to an alternate directory or correcting the Logstash user's permissions.";
                }
            }
            Logstash.handleFatalError(message, t);
        }
        catch (Throwable t) {
            Logstash.handleFatalError("", t);
        }
        System.exit(0);
    }

    private static void configureNashornDeprecationSwitchForJavaAbove11() {
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.matches("^1\\.\\d\\..*") && !javaVersion.matches("^(9|10)\\.\\d\\..*")) {
            System.setProperty("nashorn.args", "--no-deprecation-warning");
        }
    }

    private static void installGlobalUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> {
            if (e instanceof Error) {
                Logstash.handleFatalError("uncaught error (in thread " + thread.getName() + ")", e);
            } else {
                LOGGER.error("uncaught exception (in thread " + thread.getName() + ")", e);
            }
        });
    }

    private static void handleFatalError(String message, Throwable t) {
        LOGGER.fatal(message, t);
        if (t instanceof InternalError) {
            Logstash.halt(128);
        } else if (t instanceof OutOfMemoryError) {
            Logstash.halt(127);
        } else if (t instanceof StackOverflowError) {
            Logstash.halt(126);
        } else if (t instanceof UnknownError) {
            Logstash.halt(125);
        } else if (t instanceof IOError) {
            Logstash.halt(124);
        } else if (t instanceof LinkageError) {
            Logstash.halt(123);
        } else if (t instanceof Error) {
            Logstash.halt(120);
        }
        System.exit(1);
    }

    private static void halt(int status) {
        AccessController.doPrivileged(new PrivilegedHaltAction(status));
    }

    Logstash(Path home, String[] args, PrintStream output, PrintStream error, InputStream input) {
        RubyInstanceConfig config = Logstash.buildConfig(home, args);
        config.setOutput(output);
        config.setError(error);
        config.setInput(input);
        this.ruby = Ruby.newInstance((RubyInstanceConfig)config);
    }

    @Override
    public void run() {
        if (RubyUtil.RUBY != this.ruby) {
            throw new IllegalStateException("More than one JRuby Runtime detected in the current JVM!");
        }
        RubyInstanceConfig config = this.ruby.getInstanceConfig();
        try (InputStream script = config.getScriptSource();){
            Thread.currentThread().setContextClassLoader((ClassLoader)this.ruby.getJRubyClassLoader());
            this.ruby.runFromMain(script, config.displayedFileName());
        }
        catch (RaiseException ex) {
            RubyException re = ex.getException();
            if (re instanceof RubySystemExit) {
                IRubyObject success = ((RubySystemExit)re).success_p();
                if (!success.isTrue()) {
                    Logstash.uncleanShutdown((Exception)((Object)ex));
                }
            } else {
                Logstash.uncleanShutdown((Exception)((Object)ex));
            }
        }
        catch (IOException ex) {
            Logstash.uncleanShutdown(ex);
        }
    }

    @Override
    public void close() {
        this.ruby.tearDown(false);
    }

    private static RubyInstanceConfig buildConfig(Path home, String[] args) {
        String[] arguments = new String[args.length + 2];
        System.arraycopy(args, 0, arguments, 2, args.length);
        arguments[0] = Logstash.safePath(home, "lib", "bootstrap", "environment.rb");
        arguments[1] = Logstash.safePath(home, "logstash-core", "lib", "logstash", "runner.rb");
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.processArguments(arguments);
        return config;
    }

    private static String safePath(Path home, String ... subs) {
        Path resolved = home;
        for (String element : subs) {
            resolved = resolved.resolve(element);
        }
        if (!resolved.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Missing: %s.", resolved));
        }
        return resolved.toString();
    }

    private static void uncleanShutdown(Exception ex) {
        throw new IllegalStateException(UNCLEAN_SHUTDOWN_PREFIX + ex.getMessage(), ex);
    }

    private static class PrivilegedHaltAction
    implements PrivilegedAction<Void> {
        private final int status;

        private PrivilegedHaltAction(int status) {
            this.status = status;
        }

        @Override
        public Void run() {
            Runtime.getRuntime().halt(this.status);
            return null;
        }
    }
}

