/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.configuration.ConfigWitness;
import org.logstash.instrument.witness.pipeline.DeadLetterQueueWitness;
import org.logstash.instrument.witness.pipeline.EventsWitness;
import org.logstash.instrument.witness.pipeline.PluginWitness;
import org.logstash.instrument.witness.pipeline.PluginsWitness;
import org.logstash.instrument.witness.pipeline.QueueWitness;
import org.logstash.instrument.witness.pipeline.ReloadWitness;

@JsonSerialize(using=Serializer.class)
public final class PipelineWitness
implements SerializableWitness {
    private final ReloadWitness reloadWitness;
    private final EventsWitness eventsWitness;
    private final ConfigWitness configWitness;
    private final PluginsWitness pluginsWitness;
    private final QueueWitness queueWitness;
    private final DeadLetterQueueWitness deadLetterQueueWitness;
    private final String KEY;

    public PipelineWitness(String pipelineName) {
        this.KEY = pipelineName;
        this.reloadWitness = new ReloadWitness();
        this.eventsWitness = new EventsWitness();
        this.configWitness = new ConfigWitness();
        this.pluginsWitness = new PluginsWitness();
        this.queueWitness = new QueueWitness();
        this.deadLetterQueueWitness = new DeadLetterQueueWitness();
    }

    public ConfigWitness config() {
        return this.configWitness;
    }

    public DeadLetterQueueWitness dlq() {
        return this.deadLetterQueueWitness;
    }

    public EventsWitness events() {
        return this.eventsWitness;
    }

    public PluginWitness filters(String id) {
        return this.pluginsWitness.filters(id);
    }

    public void forgetEvents() {
        this.events().forgetAll();
    }

    public void forgetPlugins() {
        this.plugins().forgetAll();
    }

    public PluginWitness inputs(String id) {
        return this.pluginsWitness.inputs(id);
    }

    public PluginWitness outputs(String id) {
        return this.pluginsWitness.outputs(id);
    }

    public PluginsWitness plugins() {
        return this.pluginsWitness;
    }

    public ReloadWitness reloads() {
        return this.reloadWitness;
    }

    public QueueWitness queue() {
        return this.queueWitness;
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static final class Serializer
    extends StdSerializer<PipelineWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(PipelineWitness.class);
        }

        private Serializer(Class<PipelineWitness> t) {
            super(t);
        }

        public void serialize(PipelineWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(PipelineWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObjectFieldStart(witness.KEY);
            witness.events().genJson(gen, provider);
            witness.plugins().genJson(gen, provider);
            witness.reloads().genJson(gen, provider);
            witness.queue().genJson(gen, provider);
            if (witness.config().snitch().deadLetterQueueEnabled()) {
                witness.dlq().genJson(gen, provider);
            }
            gen.writeEndObject();
        }
    }
}

