/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.nio.ByteBufferOutputStream;
import com.rabbitmq.client.impl.nio.FrameBuilder;
import com.rabbitmq.client.impl.nio.FrameWriteRequest;
import com.rabbitmq.client.impl.nio.HeaderWriteRequest;
import com.rabbitmq.client.impl.nio.NioHelper;
import com.rabbitmq.client.impl.nio.NioLoopContext;
import com.rabbitmq.client.impl.nio.NioParams;
import com.rabbitmq.client.impl.nio.SelectorHolder;
import com.rabbitmq.client.impl.nio.SslEngineByteBufferOutputStream;
import com.rabbitmq.client.impl.nio.SslEngineFrameBuilder;
import com.rabbitmq.client.impl.nio.SslEngineHelper;
import com.rabbitmq.client.impl.nio.WriteRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelFrameHandlerState {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelFrameHandlerState.class);
    private static final int SOCKET_CLOSING_TIMEOUT = 1;
    private final SocketChannel channel;
    private final BlockingQueue<WriteRequest> writeQueue;
    private volatile AMQConnection connection;
    private long lastActivity;
    private final SelectorHolder writeSelectorState;
    private final SelectorHolder readSelectorState;
    private final int writeEnqueuingTimeoutInMs;
    final boolean ssl;
    final SSLEngine sslEngine;
    final ByteBuffer plainOut;
    final ByteBuffer plainIn;
    final ByteBuffer cipherOut;
    final ByteBuffer cipherIn;
    final DataOutputStream outputStream;
    final FrameBuilder frameBuilder;

    public SocketChannelFrameHandlerState(SocketChannel channel, NioLoopContext nioLoopsState, NioParams nioParams, SSLEngine sslEngine) {
        this.channel = channel;
        this.readSelectorState = nioLoopsState.readSelectorState;
        this.writeSelectorState = nioLoopsState.writeSelectorState;
        this.writeQueue = new ArrayBlockingQueue<WriteRequest>(nioParams.getWriteQueueCapacity(), true);
        this.writeEnqueuingTimeoutInMs = nioParams.getWriteEnqueuingTimeoutInMs();
        this.sslEngine = sslEngine;
        if (this.sslEngine == null) {
            this.ssl = false;
            this.plainOut = nioLoopsState.writeBuffer;
            this.cipherOut = null;
            this.plainIn = nioLoopsState.readBuffer;
            this.cipherIn = null;
            this.outputStream = new DataOutputStream(new ByteBufferOutputStream(channel, this.plainOut));
            this.frameBuilder = new FrameBuilder(channel, this.plainIn);
        } else {
            this.ssl = true;
            this.plainOut = ByteBuffer.allocate(sslEngine.getSession().getApplicationBufferSize());
            this.cipherOut = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
            this.plainIn = ByteBuffer.allocate(sslEngine.getSession().getApplicationBufferSize());
            this.cipherIn = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
            this.outputStream = new DataOutputStream(new SslEngineByteBufferOutputStream(sslEngine, this.plainOut, this.cipherOut, channel));
            this.frameBuilder = new SslEngineFrameBuilder(sslEngine, this.plainIn, this.cipherIn, channel);
        }
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public Queue<WriteRequest> getWriteQueue() {
        return this.writeQueue;
    }

    public void sendHeader() throws IOException {
        this.sendWriteRequest(HeaderWriteRequest.SINGLETON);
    }

    public void write(Frame frame) throws IOException {
        this.sendWriteRequest(new FrameWriteRequest(frame));
    }

    private void sendWriteRequest(WriteRequest writeRequest) throws IOException {
        try {
            boolean offered = this.writeQueue.offer(writeRequest, this.writeEnqueuingTimeoutInMs, TimeUnit.MILLISECONDS);
            if (!offered) {
                throw new IOException("Frame enqueuing failed");
            }
            this.writeSelectorState.registerFrameHandlerState(this, 4);
            this.readSelectorState.selector.wakeup();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted during enqueuing frame in write queue");
        }
    }

    public void startReading() {
        this.readSelectorState.registerFrameHandlerState(this, 1);
    }

    public AMQConnection getConnection() {
        return this.connection;
    }

    public void setConnection(AMQConnection connection) {
        this.connection = connection;
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    void prepareForWriteSequence() {
        if (this.ssl) {
            this.plainOut.clear();
            this.cipherOut.clear();
        }
    }

    void endWriteSequence() {
        if (!this.ssl) {
            this.plainOut.clear();
        }
    }

    void prepareForReadSequence() throws IOException {
        if (this.ssl) {
            this.cipherIn.clear();
            this.plainIn.clear();
            this.cipherIn.flip();
            this.plainIn.flip();
        } else {
            NioHelper.read(this.channel, this.plainIn);
            this.plainIn.flip();
        }
    }

    boolean continueReading() throws IOException {
        if (this.ssl) {
            if (!this.plainIn.hasRemaining() && !this.cipherIn.hasRemaining()) {
                this.cipherIn.clear();
                int bytesRead = NioHelper.read(this.channel, this.cipherIn);
                if (bytesRead == 0) {
                    return false;
                }
                this.cipherIn.flip();
                return true;
            }
            return true;
        }
        if (!this.plainIn.hasRemaining()) {
            this.plainIn.clear();
            NioHelper.read(this.channel, this.plainIn);
            this.plainIn.flip();
        }
        return this.plainIn.hasRemaining();
    }

    void close() throws IOException {
        if (this.ssl) {
            SslEngineHelper.close(this.channel, this.sslEngine);
        }
        if (this.channel.isOpen()) {
            this.channel.socket().setSoLinger(true, 1);
            this.channel.close();
        }
    }
}

